/*
 * Copyright (c) 2018, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#ifndef AOM_AV1_ENCODER_PARTITION_MODEL_WEIGHTS_H_
#define AOM_AV1_ENCODER_PARTITION_MODEL_WEIGHTS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "av1/encoder/ml.h"

#define FEATURE_SIZE 10
#define LABEL_SIZE 16
// nn model for ab partition pruning, 128x128.
static const float av1_ab_partition_nn_weights_128_layer0[FEATURE_SIZE * 64] = {
  -0.715251f, -0.015767f, -0.667353f, -0.345255f, 0.177887f,  -0.469759f,
  0.426152f,  0.489798f,  0.469865f,  0.773821f,  0.088517f,  0.074585f,
  0.838754f,  0.048449f,  -0.007584f, 0.638968f,  0.233305f,  -0.319236f,
  -0.257124f, -0.170869f, 0.137180f,  0.114852f,  -0.721241f, -0.947962f,
  -0.411298f, 0.494306f,  -0.060435f, -0.648421f, -0.126624f, 0.072686f,
  -0.143904f, -0.115839f, -0.175527f, -0.117728f, 0.040686f,  -0.189925f,
  0.134361f,  -0.258070f, -0.177558f, 0.158049f,  0.168668f,  -0.062919f,
  0.341986f,  0.038100f,  -0.435577f, -0.321255f, 0.203213f,  0.213061f,
  0.533304f,  0.359296f,  -0.079558f, 0.004637f,  0.663904f,  0.043779f,
  0.383018f,  1.136559f,  -0.084155f, 0.333057f,  -0.199011f, 0.152059f,
  -0.078419f, -0.167752f, -0.093651f, 0.083171f,  -0.190143f, 0.086195f,
  -0.280632f, -0.160663f, -0.017298f, 0.122628f,  -0.138116f, 0.062927f,
  0.222462f,  0.626979f,  0.426928f,  0.117170f,  -0.240457f, 0.053750f,
  0.038017f,  0.007359f,  -0.017595f, 0.101407f,  0.332891f,  0.074933f,
  0.306498f,  0.219380f,  -0.151638f, -0.247976f, 0.343405f,  0.121256f,
  0.049173f,  0.171474f,  -0.139608f, -1.016599f, -0.345553f, -0.901138f,
  0.243401f,  0.059928f,  -0.089396f, -0.195565f, 0.364705f,  -0.020400f,
  -1.383672f, 0.413018f,  0.536950f,  -0.020904f, -1.335306f, -0.732290f,
  0.102885f,  0.315290f,  -0.208521f, -0.081811f, 0.182300f,  0.125712f,
  -0.593833f, -0.220639f, -0.314155f, 0.188327f,  0.118503f,  0.524427f,
  -1.083859f, -1.130640f, 0.390352f,  -0.045591f, 0.113160f,  -0.009149f,
  -0.096183f, 0.115829f,  0.377752f,  0.318396f,  -0.591983f, 0.004797f,
  -0.497377f, -0.342248f, 0.079546f,  -0.025249f, -0.295972f, 0.615501f,
  -0.464372f, 0.418315f,  -0.173556f, 0.105217f,  0.298073f,  0.082478f,
  0.033223f,  0.977341f,  -0.372982f, -0.052337f, 0.154124f,  0.396787f,
  0.536654f,  -0.139061f, -0.223702f, 0.229666f,  -0.846766f, 0.107723f,
  0.563839f,  -0.483141f, 0.304813f,  -0.765283f, 0.070964f,  0.151101f,
  0.275188f,  0.490303f,  1.175892f,  0.085377f,  -0.191200f, 0.544532f,
  -0.365075f, 0.167546f,  0.052183f,  -0.220529f, -0.212227f, -0.144988f,
  -0.273356f, -0.062023f, 0.103993f,  -0.238493f, -0.161204f, -0.054611f,
  -0.166672f, 0.128327f,  0.461751f,  -0.545822f, 0.739798f,  0.594386f,
  -0.163192f, -0.332501f, 0.363834f,  -0.065043f, 0.474812f,  -0.138811f,
  0.170924f,  -0.778142f, -0.316474f, -0.508065f, -0.039986f, -0.478001f,
  0.340591f,  0.041783f,  0.055419f,  0.015155f,  -0.981830f, -1.355237f,
  0.347516f,  1.155327f,  0.081319f,  0.274163f,  -0.327230f, -0.113478f,
  0.556552f,  -0.055986f, 0.217318f,  -0.445351f, 0.325759f,  0.526547f,
  -0.657434f, -0.572214f, -0.037087f, 0.081384f,  0.064518f,  0.014892f,
  0.215279f,  1.834504f,  -0.242107f, 0.079810f,  0.129558f,  0.079588f,
  -0.035189f, -0.221745f, -0.163414f, 0.043978f,  -1.028662f, -0.623609f,
  1.130336f,  0.664661f,  -0.063975f, -0.415863f, 0.018581f,  0.157758f,
  0.200570f,  0.063420f,  0.901039f,  -0.746286f, 0.196230f,  -0.290592f,
  0.042373f,  -0.502500f, 0.183638f,  0.103394f,  -0.298858f, 0.145436f,
  0.196916f,  0.108319f,  -0.448572f, -0.881385f, 0.302497f,  0.121679f,
  -0.021327f, 0.025150f,  0.481306f,  -0.359634f, 0.350257f,  -0.228647f,
  -0.669860f, 0.260025f,  -0.034182f, 0.619247f,  -0.158826f, -0.405864f,
  0.674112f,  -0.027885f, -0.325274f, -0.241492f, 0.036024f,  -0.437685f,
  -0.091458f, -0.109295f, -0.350676f, 0.044706f,  0.297059f,  0.016290f,
  1.121203f,  1.289062f,  -1.299476f, -1.129221f, 0.103752f,  0.131302f,
  -0.263265f, 0.222155f,  -0.229908f, 0.013922f,  -0.226001f, -0.248383f,
  -0.004415f, -0.020958f, 0.055634f,  0.086200f,  0.114556f,  -0.184061f,
  -0.096210f, -0.146466f, -0.249618f, -0.195998f, 0.088758f,  0.023781f,
  -0.264460f, 0.157026f,  -0.235228f, -0.102564f, 0.043463f,  -0.187823f,
  -0.257500f, -0.199049f, -0.242210f, 0.030448f,  0.221604f,  0.151804f,
  -0.100404f, -0.073931f, 0.144749f,  -0.001572f, -1.438079f, -0.233716f,
  0.733422f,  1.727080f,  -0.036397f, 0.027551f,  0.425321f,  0.085703f,
  0.031186f,  0.032333f,  -0.675130f, 1.437733f,  -0.202392f, -0.525003f,
  0.087048f,  0.328194f,  -0.079989f, -0.391088f, -0.238732f, -0.120660f,
  -0.139600f, 0.154665f,  0.026202f,  -0.233501f, -0.009046f, -0.149187f,
  -0.199646f, 0.115375f,  0.209762f,  -0.014875f, 0.124038f,  -0.119985f,
  1.079625f,  -0.461513f, 0.614114f,  0.021003f,  0.439449f,  -0.824834f,
  -0.299701f, 0.193817f,  -0.870551f, -1.262313f, -0.079517f, 0.341570f,
  0.305310f,  -0.089721f, -0.317314f, -0.075631f, 0.127172f,  -0.208635f,
  1.191922f,  0.163141f,  0.564285f,  0.286352f,  0.480865f,  0.173094f,
  -0.094034f, -0.071339f, -0.328992f, -0.006382f, 0.314705f,  0.090258f,
  -0.016099f, 0.193230f,  0.188061f,  0.398144f,  0.722781f,  0.769949f,
  0.025442f,  -0.162016f, 0.070192f,  -0.056946f, -0.100957f, -0.219934f,
  -0.203492f, -0.015454f, -0.013272f, -0.098008f, 0.051707f,  -0.017493f,
  0.527446f,  0.083605f,  0.588318f,  0.878215f,  0.028747f,  -0.146479f,
  -0.345170f, -0.136059f, -0.152005f, -0.203634f, 0.232702f,  -0.101340f,
  -0.027733f, -0.282611f, 0.265366f,  0.082362f,  -0.265420f, -0.131124f,
  0.166303f,  0.040194f,  -0.100710f, 0.579151f,  -0.530136f, 0.163422f,
  -0.998821f, -1.565311f, -1.774785f, -2.493372f, 0.116970f,  -0.090302f,
  1.723272f,  0.552370f,  -0.295954f, -0.439095f, -0.266730f, 0.027936f,
  0.539616f,  -0.234902f, -0.167601f, -0.149877f, -0.242983f, 0.122353f,
  -0.121620f, -0.205517f, -0.180144f, -0.264208f, 0.151500f,  -0.159378f,
  0.029145f,  -0.050892f, -0.223407f, -0.246239f, 0.043152f,  -0.018460f,
  0.169972f,  -0.187769f, -0.034670f, -0.238330f, 0.288070f,  -0.093243f,
  -0.437105f, -0.573376f, 0.660073f,  0.285727f,  0.408470f,  0.158475f,
  0.032699f,  0.056280f,  -0.237176f, -0.083003f, 0.105598f,  -0.169522f,
  -0.260420f, -0.121100f, -0.173983f, -0.195693f, -0.232028f, 0.224940f,
  0.029124f,  0.009580f,  -0.252034f, 0.103087f,  1.156561f,  0.603848f,
  -0.562805f, -1.652742f, -0.568288f, -1.829395f, 0.046169f,  0.076095f,
  1.490819f,  0.415893f,  -0.277788f, -0.115787f, 0.093750f,  0.270726f,
  -0.395983f, -0.353742f, 0.034605f,  0.005342f,  0.184537f,  0.086445f,
  0.156417f,  1.476367f,  0.122587f,  0.002145f,  0.431057f,  -0.381184f,
  -1.646457f, -0.014009f, -0.671224f, 0.193726f,  -0.019247f, -0.031267f,
  -0.046208f, 0.298733f,  0.064734f,  0.616984f,  0.039381f,  0.182722f,
  -0.116670f, 0.233093f,  -1.214374f, -0.817970f, -0.064394f, -0.584783f,
  0.077697f,  -0.266720f, 0.130875f,  -0.235295f, -0.265754f, -0.159999f,
  -0.250114f, -0.183017f, 0.194403f,  -0.105808f, -0.169215f, -0.240866f,
  -0.026662f, -0.045123f, -0.036175f, -0.167471f, -0.192908f, -0.232602f,
  -0.267036f, -0.112500f, -0.257944f, -0.111909f, -0.802226f, -0.008800f,
  0.881460f,  -0.678603f, 0.008666f,  -0.252053f, -0.341035f, -0.175290f,
  0.183012f,  0.385991f,  0.079888f,  -0.014039f, -0.148653f, 0.671778f,
  -0.130219f, 1.086467f,  0.129267f,  -0.040400f, -0.201221f, -0.077005f,
  0.015890f,  0.000781f,  0.137764f,  1.389546f,  0.172152f,  0.047279f,
  -0.042783f, 0.127740f,  0.141467f,  -0.335738f, -1.396392f, 0.031496f,
  0.357385f,  0.343602f,  -0.714553f, 0.311014f,  0.132845f,  0.061149f,
  0.006796f,  0.568106f,  -0.255949f, 0.104134f,  -0.993447f, 0.298135f,
  -0.406590f, -0.049228f, -0.578570f, -0.188561f, -0.107046f, 0.374095f,
  0.068481f,  0.036240f,  -0.495801f, 0.180574f,  -0.766129f, 0.886967f,
  -0.568868f, -0.936062f, -0.418886f, -0.058735f, -0.511964f, -0.438596f,
  0.019016f,  -0.015837f, 0.600197f,  0.429773f,  0.315026f,  0.319667f,
  0.214617f,  -0.017316f, 0.270257f,  -0.040524f, 0.695803f,  -0.015223f,
  -1.554965f, 0.356997f,  -1.472428f, 0.024637f,  -0.562958f, 0.870351f,
  0.193635f,  0.036063f,  0.328638f,  0.200274f,  -1.634707f, 0.110534f,
  0.420104f,  -0.072042f, -0.006404f, 0.171680f,
};

static const float av1_ab_partition_nn_bias_128_layer0[64] = {
  0.643147f,  -1.348826f, 0.431627f,  0.000000f,  0.102717f,  -0.772628f,
  -0.034351f, -0.761977f, -0.638397f, 0.541969f,  -0.391311f, 0.563076f,
  0.148553f,  0.267217f,  -0.788092f, 0.544573f,  -0.546280f, 0.000000f,
  -0.446945f, 0.127732f,  0.270624f,  -0.219435f, -1.220203f, 0.324584f,
  0.110885f,  0.276547f,  0.179726f,  -0.375160f, 0.026401f,  -0.032595f,
  0.000000f,  -0.047932f, -0.648602f, -0.512637f, -0.031661f, -0.236761f,
  0.476453f,  -0.028021f, -0.013673f, -0.015578f, -0.920077f, 0.000000f,
  0.915351f,  -0.209962f, 0.000000f,  -0.025731f, 0.218288f,  0.000000f,
  0.047726f,  -0.813077f, -1.263281f, 0.239087f,  0.278614f,  -0.030753f,
  0.000000f,  0.346744f,  -0.948543f, -1.174211f, 0.216377f,  0.498913f,
  0.853918f,  0.002504f,  -0.190403f, 0.452050f,
};

static const float av1_ab_partition_nn_weights_128_layer1[64 * LABEL_SIZE] = {
  0.179769f,  1.499417f,  -0.445135f, -0.142278f, -0.337661f, 0.682064f,
  -0.203213f, 0.302171f,  0.226877f,  -0.422169f, 1.687586f,  0.783773f,
  0.220995f,  0.253482f,  0.370435f,  -1.342775f, 0.337229f,  -0.271473f,
  0.291796f,  1.362227f,  -1.751397f, -0.086178f, 0.725496f,  -0.118597f,
  0.227963f,  -0.501577f, 0.223849f,  -0.122421f, -0.123437f, -0.051045f,
  -0.020115f, 0.212711f,  0.246025f,  0.088120f,  -0.168995f, 1.740190f,
  -0.195098f, 0.680339f,  -0.589572f, -0.075244f, 0.878766f,  0.064092f,
  -3.548527f, 0.001660f,  0.107926f,  -0.169501f, -0.455212f, 0.123045f,
  -1.836998f, 0.330365f,  1.301475f,  0.454761f,  -0.576552f, -0.190761f,
  0.208459f,  0.618483f,  1.383364f,  0.970718f,  0.390174f,  0.406252f,
  -0.564519f, -0.312062f, 1.345712f,  -0.151873f, 0.109290f,  0.408847f,
  0.391243f,  0.152024f,  0.181764f,  -0.036263f, -0.160466f, 0.153595f,
  0.049163f,  -0.753012f, -1.804062f, 0.347475f,  -2.746580f, 0.575618f,
  0.261799f,  0.210505f,  -0.302054f, -0.109872f, 0.199506f,  -1.182971f,
  0.723668f,  0.177758f,  -0.338202f, 0.254396f,  -0.220023f, 0.043504f,
  0.669866f,  -0.040816f, -0.402730f, 0.017990f,  0.215523f,  -0.216816f,
  0.454826f,  -0.726067f, -0.018750f, -0.928679f, 0.154315f,  -0.465641f,
  0.144566f,  -0.030064f, -0.054667f, -0.154055f, 0.625384f,  1.323795f,
  -0.159496f, 0.097072f,  -0.463197f, -0.057938f, 0.750290f,  -0.233061f,
  0.412631f,  -0.535223f, -0.151423f, -0.154583f, 0.024721f,  -0.494448f,
  0.230594f,  -0.980138f, -0.653968f, 0.126079f,  0.051814f,  -0.053219f,
  -0.421708f, -0.228853f, 0.237885f,  0.888157f,  0.059655f,  0.241295f,
  0.210443f,  0.228238f,  0.119127f,  -0.051989f, -0.355408f, 0.182215f,
  0.244277f,  -0.104577f, -0.558035f, -0.023270f, 0.054571f,  0.700646f,
  -0.223006f, 0.115523f,  0.023391f,  0.437264f,  0.709477f,  -0.531212f,
  -0.094731f, 0.328161f,  -0.105418f, -0.133511f, 0.497168f,  -0.030948f,
  -0.407132f, -0.043943f, 0.155505f,  0.251945f,  0.205010f,  0.167160f,
  0.083654f,  -0.636810f, 0.401315f,  -0.398414f, 0.290046f,  0.206846f,
  0.042218f,  0.168150f,  0.843181f,  -0.671242f, -0.202392f, -0.073301f,
  0.142895f,  0.237466f,  0.212145f,  -0.091828f, 0.187038f,  -0.720841f,
  -0.616069f, -0.238021f, 0.065365f,  0.434119f,  0.179023f,  -0.040107f,
  -0.430734f, -0.297368f, 0.575954f,  0.382619f,  -0.709787f, -0.320810f,
  0.242342f,  -0.047614f, 0.705216f,  0.098077f,  0.357179f,  0.046017f,
  0.115074f,  -0.412305f, -0.272304f, 0.048096f,  -0.803811f, 0.275000f,
  0.642198f,  0.180286f,  -0.087178f, -0.112707f, -0.394443f, 0.201989f,
  0.241759f,  -1.038870f, 0.728124f,  0.800559f,  -1.296268f, 0.198612f,
  -0.053478f, 0.414344f,  -0.510529f, 0.124179f,  -2.219115f, -0.074583f,
  -0.143055f, 0.001697f,  0.810811f,  -0.657140f, 0.186818f,  -0.936414f,
  0.539578f,  -0.308244f, -0.126624f, -0.204767f, 0.091145f,  -0.049340f,
  0.252014f,  0.394582f,  0.018764f,  -0.060377f, -0.019133f, 0.064083f,
  0.069211f,  -0.526693f, 0.209850f,  -0.481466f, -0.468302f, -0.100407f,
  0.241018f,  -1.037781f, 0.038539f,  -2.113840f, -0.974895f, 0.163187f,
  0.425132f,  -0.772546f, -1.261254f, -0.217488f, -0.971748f, -0.805640f,
  -0.745175f, -0.177077f, 0.217658f,  0.381431f,  -0.052338f, 0.087176f,
  -0.165972f, 0.085937f,  0.472564f,  -0.796627f, -2.453307f, 0.569664f,
  -0.233010f, -0.192134f, 0.064339f,  -0.111411f, -0.262469f, -0.410022f,
  0.519993f,  -0.684620f, 0.393460f,  -0.277753f, -0.153624f, 0.528984f,
  -0.415558f, -0.445863f, 0.588512f,  -0.142439f, -0.132127f, 0.199776f,
  -0.579284f, 0.119488f,  -0.033590f, -0.503846f, -0.674979f, 0.335125f,
  0.020519f,  0.233973f,  -0.297998f, -0.051511f, 0.518626f,  -0.412782f,
  -0.074045f, 0.130523f,  0.465751f,  -0.117795f, 2.535813f,  0.352108f,
  -0.499228f, 0.379784f,  0.056699f,  0.173142f,  -0.076519f, -0.026666f,
  0.017834f,  0.492333f,  0.093364f,  0.037867f,  -0.165420f, -0.356429f,
  -0.562334f, 0.057656f,  -0.307544f, 0.085857f,  -0.559851f, 0.107230f,
  -0.398633f, 0.152618f,  -0.216835f, -0.024539f, 0.026044f,  -0.249519f,
  -0.563594f, -0.746025f, 0.025265f,  -0.298888f, -0.185243f, 0.058794f,
  0.233696f,  -0.115223f, 0.144617f,  -0.864390f, 0.619944f,  -0.023980f,
  0.019481f,  0.225252f,  0.416552f,  -0.115993f, 0.935387f,  0.744386f,
  0.053353f,  -0.052582f, -0.065650f, 0.228488f,  -0.032042f, -0.371252f,
  -0.003638f, -0.736984f, -0.203776f, 0.030922f,  -0.065577f, -0.031643f,
  -0.049253f, -0.054640f, 0.787134f,  0.545414f,  -0.140297f, -0.124274f,
  -0.110011f, -0.029552f, 0.657005f,  0.214973f,  -0.374300f, 0.251642f,
  0.276591f,  0.030566f,  -0.145470f, 0.350579f,  -0.356436f, -0.052694f,
  -0.063966f, -0.751008f, -1.042392f, 0.328892f,  -0.425058f, -0.421571f,
  -0.571889f, -1.141472f, -0.125216f, 0.212713f,  -0.485170f, -0.088791f,
  0.124589f,  0.023237f,  0.077635f,  0.020901f,  -0.271402f, -0.321424f,
  -0.513946f, -0.867872f, -0.284593f, 0.106276f,  0.220192f,  -0.143532f,
  -0.014648f, 0.073402f,  0.327256f,  -0.139803f, 0.168763f,  0.048199f,
  -0.122526f, 0.111713f,  -0.134257f, 0.810364f,  -0.085222f, -0.259221f,
  -0.239349f, 0.044448f,  0.205031f,  0.413113f,  -0.107720f, -0.018816f,
  -0.247741f, -0.004963f, 0.041170f,  -0.158019f, 0.134839f,  0.129502f,
  0.800488f,  -1.041584f, -0.129336f, 0.170834f,  0.566586f,  -0.230443f,
  0.437937f,  -0.149922f, -0.046665f, -0.094646f, 0.200070f,  0.072943f,
  -0.076943f, -0.084971f, -0.515843f, -0.146720f, 0.472869f,  -0.444731f,
  -0.100877f, 0.545196f,  -1.786626f, -0.482946f, 0.500509f,  -0.843257f,
  0.200374f,  0.045103f,  -0.575718f, -0.164335f, -0.232522f, -0.021825f,
  -0.139490f, 0.356058f,  -0.352075f, 0.061751f,  -0.200616f, -1.180921f,
  -0.181355f, -0.137459f, 0.247574f,  0.181541f,  0.184314f,  -0.961482f,
  0.493615f,  0.910261f,  -2.279238f, 0.648631f,  -0.055526f, -0.037137f,
  0.038643f,  0.136609f,  -0.819373f, -0.040840f, -0.265989f, 0.006877f,
  0.454651f,  -0.595323f, -0.099500f, -0.263717f, 0.150456f,  0.245077f,
  -0.268666f, 0.162232f,  -0.516451f, -0.024501f, 0.188046f,  -0.002262f,
  0.261319f,  0.004173f,  0.746982f,  0.174761f,  0.470447f,  -0.159558f,
  -0.385240f, 0.023084f,  -0.133520f, -0.220607f, -0.018731f, -0.373558f,
  -0.707763f, -1.850150f, -0.807404f, -0.168063f, -0.071435f, -0.160740f,
  -0.478789f, -1.070674f, -0.489740f, -0.255796f, 0.100486f,  -0.153361f,
  0.334394f,  -0.569472f, -0.198118f, 0.255922f,  0.104717f,  -0.065179f,
  0.111879f,  -0.447237f, 1.373623f,  -0.190191f, -0.063311f, 0.337529f,
  -0.138800f, 0.057009f,  -0.137006f, 0.641378f,  0.883147f,  -0.679655f,
  0.267717f,  -0.351602f, -0.135225f, 0.229398f,  -0.513225f, -1.120345f,
  0.528786f,  -0.051081f, 0.086653f,  0.140141f,  -0.563969f, 0.333402f,
  -0.174745f, 0.321093f,  -0.438641f, -0.005131f, 0.247415f,  0.110120f,
  -0.076308f, -0.083244f, 0.838944f,  -0.113043f, -0.013258f, -0.175028f,
  -0.179941f, 0.272676f,  -0.047946f, -0.088076f, -0.450031f, 0.053929f,
  -0.083549f, -0.089952f, -0.186253f, 0.257483f,  0.011019f,  0.586435f,
  0.060580f,  -0.052078f, 0.090277f,  -0.780869f, 0.969811f,  -0.025349f,
  -0.281917f, 0.014857f,  0.231863f,  -0.228601f, -0.003861f, 0.226550f,
  0.141825f,  -0.102171f, -0.010387f, 0.220378f,  -2.561975f, -0.497071f,
  -0.315117f, 0.371981f,  0.138247f,  0.625031f,  -0.308133f, -0.217876f,
  0.005615f,  -0.860179f, 0.747491f,  0.006356f,  -0.057024f, -0.483189f,
  0.055592f,  -0.316834f, 0.069858f,  0.218788f,  -0.200044f, 0.227588f,
  0.215496f,  -0.055324f, -0.393147f, -0.394062f, -0.253264f, -0.075619f,
  -0.152512f, -0.332995f, 0.129053f,  0.178668f,  -0.302694f, 0.030678f,
  0.925896f,  0.964375f,  0.169021f,  -0.218657f, -0.627204f, 0.206437f,
  -0.521336f, 0.176206f,  0.142733f,  0.139248f,  0.411682f,  0.181544f,
  0.224850f,  -0.935547f, -0.558208f, 0.348096f,  0.342129f,  -0.389340f,
  -0.236308f, -0.132099f, 0.073642f,  0.089391f,  -0.306901f, -0.397842f,
  0.444282f,  0.074623f,  -0.051075f, -0.106617f, -0.184037f, -0.239046f,
  -0.138761f, 0.120794f,  -0.647577f, -0.336471f, 0.527899f,  -0.164234f,
  -0.028354f, 1.083678f,  -0.251534f, -0.145903f, -0.182783f, 0.070976f,
  -0.199590f, -0.400306f, -0.029763f, -0.548042f, -0.266270f, -0.118084f,
  -1.152632f, 0.383685f,  -0.105895f, -0.096829f, 0.118382f,  0.047447f,
  -0.019051f, 0.310180f,  -0.162793f, -0.029574f, 0.058054f,  -0.636017f,
  0.490639f,  0.158347f,  -0.385701f, -0.147057f, 1.285825f,  -1.276083f,
  -0.021795f, -0.101600f, 0.163254f,  0.267160f,  -2.317864f, -0.098598f,
  -0.296337f, -0.309017f, 0.164127f,  -0.270012f, -0.071187f, -0.262270f,
  0.075415f,  -0.368328f, 0.186728f,  -0.158031f, 0.481663f,  0.515950f,
  -0.162551f, 0.497981f,  0.262196f,  0.168479f,  0.726066f,  -0.243856f,
  -0.058998f, 0.140168f,  0.053242f,  -0.624623f, -0.249480f, 0.055197f,
  -1.376804f, 0.417571f,  0.203784f,  0.174370f,  -0.155531f, -0.029400f,
  -0.491473f, 0.079811f,  -0.080123f, 1.345900f,  0.637077f,  0.434862f,
  -1.787438f, 0.005756f,  -0.362706f, 0.179458f,  -0.288263f, 0.516788f,
  -0.921248f, 0.043794f,  -0.137729f, -0.196171f, -0.046295f, -0.793781f,
  -0.156532f, -0.132566f, 0.517989f,  -0.154321f, -0.054174f, -0.077900f,
  -0.373316f, -0.117718f, 0.188986f,  -0.476188f, -0.245312f, 0.181439f,
  -0.161024f, -0.229059f, -3.079907f, -0.225452f, -0.594355f, -0.558027f,
  -0.135429f, 0.125766f,  -0.081314f, -0.350894f, -0.163165f, -1.936507f,
  -0.205966f, 0.031472f,  0.744446f,  -0.006680f, -0.837551f, 0.605862f,
  -0.854929f, -1.543750f, -0.307704f, -0.240517f, 0.178240f,  -0.183586f,
  -0.010307f, 0.099373f,  -0.228278f, 0.175236f,  -0.000133f, 0.104491f,
  -1.540545f, -0.570971f, -0.252885f, 0.483036f,  0.052531f,  0.260214f,
  -0.515016f, -0.602081f, -0.485690f, -0.730710f, 0.163719f,  -1.775975f,
  -0.298634f, 0.323626f,  -0.373579f, -0.872977f, 0.619574f,  0.026862f,
  -0.122531f, -0.084698f, -2.436297f, 0.483996f,  -0.203640f, -0.302157f,
  -0.150666f, -0.238320f, 0.089250f,  0.236485f,  -0.668654f, -0.122863f,
  0.491152f,  -0.226444f, -0.181248f, 0.120158f,  0.294027f,  0.250056f,
  0.307601f,  0.357875f,  -1.746455f, -0.175670f, 0.385447f,  -0.108808f,
  -0.090235f, -0.642504f, -0.486004f, -0.055160f, -0.068692f, 0.009736f,
  0.607555f,  -0.489426f, 0.150624f,  0.598114f,  -0.128816f, -0.445793f,
  -0.066524f, -0.254380f, 0.227106f,  -0.406495f, -0.121632f, -0.275960f,
  -0.136494f, 0.339457f,  -1.318132f, -0.417572f, -2.614077f, 0.324603f,
  -0.001211f, 0.375192f,  -0.473448f, -0.162510f, 0.099329f,  -0.277965f,
  0.101221f,  -0.060263f, 0.121867f,  -1.042140f, 0.440851f,  0.078898f,
  -0.209007f, -0.243699f, 0.715197f,  -0.093997f, 0.086022f,  -0.178203f,
  -2.275496f, -0.098413f, 0.199352f,  -0.526791f, -0.162086f, -0.197806f,
  -0.231657f, -0.269202f, -0.794294f, -0.223461f, 0.503584f,  0.416236f,
  0.064082f,  0.197655f,  0.340871f,  -0.186645f, -0.291498f, 0.433938f,
  -1.110063f, 0.003751f,  0.392738f,  0.069360f,  0.102088f,  -0.302128f,
  -1.518457f, 0.106939f,  0.404527f,  -0.306868f, -0.286928f, 0.729276f,
  -0.531710f, 0.745048f,  -0.168837f, -1.953886f, -0.258828f, -0.190252f,
  0.241877f,  -0.916744f, -0.030326f, -0.070541f, -0.271037f, 0.211303f,
  -0.489957f, 0.100850f,  0.323999f,  -0.802837f, -0.462408f, -0.079350f,
  -0.029374f, 0.131213f,  -0.825032f, 0.040202f,  0.351821f,  0.002869f,
  -0.132516f, -0.471264f, -0.297002f, 0.263913f,  0.033478f,  0.146161f,
  0.533229f,  -0.228608f, -0.200639f, -0.170955f, -0.915037f, 0.724491f,
  0.005151f,  0.018584f,  -0.029771f, -0.396038f, -0.159236f, 0.038691f,
  -1.197056f, 0.146302f,  0.226840f,  -0.852126f, 0.031214f,  0.108880f,
  0.562000f,  -0.134633f, -0.713343f, -0.342252f, -1.764521f, -0.114653f,
  0.515073f,  -0.080515f, -0.121155f, -0.865139f, -0.833694f, -0.368553f,
  0.347673f,  0.623379f,  0.722067f,  -0.492458f, -0.513263f, 0.585167f,
  0.721518f,  -0.693499f, 0.343725f,  -0.273861f, -0.040230f, -0.785664f,
  -0.157500f, -0.308445f, 0.054062f,  0.600131f,  -0.860887f, 0.434470f,
  -0.191382f, -0.306150f, -0.243965f, 0.705444f,  0.007789f,  -0.146154f,
  -0.054499f, -0.073500f, -1.067364f, 0.404936f,  -2.864590f, 0.182323f,
  0.326126f,  0.102405f,  -0.135800f, 1.128095f,  -0.012267f, -0.023996f,
  -0.264834f, -0.108967f, -1.176746f, -0.926666f, 0.082999f,  -0.498361f,
  0.083560f,  -0.210074f, 0.019225f,  -0.201614f, -0.904760f, 0.181421f,
  0.586384f,  -0.177706f, 0.065471f,  0.168552f,  0.054705f,  0.045241f,
  0.048057f,  -0.410957f, -2.188854f, -0.169812f, 0.015521f,  0.176856f,
  -0.179331f, -0.352640f, -0.491735f, -1.743206f, 0.044227f,  0.010454f,
  0.823643f,  -0.119781f, -0.098359f, 0.093119f,
};

static const float av1_ab_partition_nn_bias_128_layer1[LABEL_SIZE] = {
  -0.433195f, -0.120488f, -0.116721f, 0.112134f,  0.118170f, -0.259769f,
  -0.077530f, 0.394044f,  0.279167f,  -0.317988f, 0.189538f, 0.314776f,
  0.325655f,  -0.107123f, 0.591049f,  0.358744f,
};

static const NN_CONFIG av1_ab_partition_nnconfig_128 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      64,  // num_hidden_nodes
  },
  {
      av1_ab_partition_nn_weights_128_layer0,
      av1_ab_partition_nn_weights_128_layer1,
  },
  {
      av1_ab_partition_nn_bias_128_layer0,
      av1_ab_partition_nn_bias_128_layer1,
  },
};

// nn model for ab partition pruning, 64x64.
static const float av1_ab_partition_nn_weights_64_layer0[FEATURE_SIZE * 64] = {
  -0.495347f, -0.049498f, -0.026804f, 0.030474f,  -0.289308f, -0.264193f,
  -0.141121f, -0.072562f, -0.391665f, -0.051491f, -0.234761f, 0.027155f,
  -0.038217f, 0.014872f,  -0.289728f, -0.233577f, -0.415875f, -0.343615f,
  -0.442543f, -0.482492f, 0.073510f,  0.007503f,  2.162329f,  -0.362849f,
  2.145915f,  -0.883135f, 0.185636f,  -0.062859f, -0.465574f, -0.486205f,
  -0.056710f, -0.330642f, -0.321860f, 0.042321f,  -0.348965f, 0.003542f,
  -0.291365f, -0.078164f, -0.345093f, -0.220272f, -0.471270f, -0.763853f,
  0.246622f,  0.199651f,  -0.663420f, -0.154152f, -1.220383f, 0.047138f,
  0.816811f,  0.083247f,  -0.218839f, 0.038143f,  -0.063436f, 0.015517f,
  -0.307320f, -0.166956f, -0.169499f, -0.399005f, -0.234638f, -0.162266f,
  0.050425f,  -0.221723f, -0.256942f, -0.287285f, 0.144011f,  -0.033245f,
  0.083649f,  0.119428f,  -0.056706f, -0.117805f, 0.021866f,  -0.257300f,
  -0.201378f, -0.217484f, -0.413780f, -0.145793f, 0.082792f,  -0.347247f,
  0.042539f,  -0.302697f, 1.652316f,  0.000701f,  -0.482843f, -0.160332f,
  -0.450099f, 0.212399f,  -4.715360f, -5.336774f, -5.375758f, -6.048339f,
  0.085956f,  -0.037767f, 1.052409f,  -0.931924f, -2.221907f, 0.268946f,
  0.015512f,  1.237094f,  -1.092185f, 0.418247f,  -0.082143f, -0.076914f,
  -0.060749f, -0.325440f, -0.296960f, -0.066815f, -0.158477f, -0.373945f,
  -0.122322f, -0.113495f, -0.097978f, -0.192816f, -0.270418f, 0.035840f,
  -0.015458f, -0.121071f, -0.279582f, -0.067683f, 0.097855f,  0.019839f,
  0.451127f,  0.004376f,  1.410392f,  3.255835f,  -0.344815f, 0.145202f,
  0.204132f,  0.171948f,  -0.527736f, -0.110353f, 0.901448f,  0.003238f,
  -3.822090f, 0.235462f,  1.024823f,  -0.821244f, 0.876056f,  2.553762f,
  -3.478597f, -2.076582f, -0.265515f, -0.055923f, -0.156980f, -0.164097f,
  -0.246040f, 0.039430f,  -0.071769f, -0.118847f, -0.304053f, -0.281541f,
  -0.226021f, -0.263091f, -0.127359f, -0.249410f, -0.051023f, 0.083911f,
  0.084721f,  0.168089f,  -0.272169f, -0.204998f, -0.008303f, -0.173998f,
  0.079376f,  -0.197426f, -0.199052f, -0.118794f, -0.063753f, -0.094769f,
  0.066176f,  -0.175832f, -0.238752f, -0.287960f, -0.134307f, -0.185953f,
  -0.385845f, 0.119769f,  -0.006567f, -0.382126f, -0.214221f, 0.038449f,
  -0.253484f, -0.282766f, -0.020249f, -0.193929f, 0.016281f,  -0.114423f,
  -0.145940f, -0.281621f, -0.007588f, -0.131470f, -0.189012f, -0.185699f,
  -0.279011f, -0.008132f, 0.208463f,  0.020569f,  -0.206803f, -0.213408f,
  -0.206131f, -0.290245f, 0.069701f,  -0.000371f, -0.307572f, -0.451785f,
  -0.300838f, -0.453186f, -0.301691f, 0.046327f,  -0.312668f, 0.058272f,
  -0.303131f, -0.376252f, 0.108384f,  -0.086623f, -0.100630f, -0.027330f,
  -0.003969f, 0.089502f,  -0.200722f, -0.107889f, 0.061843f,  -0.008478f,
  -0.265057f, -0.271132f, -0.073562f, 0.129337f,  -0.283698f, -0.353414f,
  0.076420f,  -0.244280f, -0.119537f, -0.105366f, -0.184692f, -0.038817f,
  -0.478507f, -0.118808f, -0.472979f, -0.305884f, -0.462813f, -0.189581f,
  -0.011932f, -0.585700f, 0.253212f,  -1.061900f, -0.205116f, -0.336407f,
  -0.762199f, 0.577737f,  0.230832f,  0.434440f,  -0.096713f, 0.038552f,
  -0.147800f, -0.213553f, 0.041740f,  -0.281907f, -0.026154f, -0.082356f,
  -0.331871f, -0.408247f, -0.129022f, -0.037550f, -0.310233f, -0.320883f,
  -0.391963f, -0.467392f, 0.027453f,  -0.394761f, -0.045544f, 0.076052f,
  0.483985f,  0.067093f,  0.141361f,  0.576772f,  0.859718f,  2.566515f,
  -0.025476f, 0.769738f,  -0.680235f, -1.683309f, -2.394131f, -0.000714f,
  -0.615021f, -0.195856f, -0.434035f, -0.295010f, -0.668659f, -0.245959f,
  0.551148f,  1.777227f,  -0.461630f, 0.043093f,  0.012293f,  -0.255841f,
  -0.097070f, -0.371156f, -0.146323f, -0.015508f, -0.103873f, -0.087476f,
  -0.297266f, -0.128699f, -0.149555f, 0.016534f,  -0.375498f, -0.346759f,
  -0.455156f, -0.147509f, -0.427076f, -0.354431f, -0.158025f, -0.164604f,
  -0.237038f, -0.010314f, -0.092884f, -0.397084f, -0.217980f, -0.127184f,
  -0.048421f, -0.144133f, 0.889073f,  0.012606f,  3.007608f,  -0.602584f,
  -1.849480f, -0.373159f, -1.890695f, -3.609938f, 0.811923f,  -1.867208f,
  -0.244326f, -0.018012f, -0.211192f, -0.220196f, 0.169363f,  0.119141f,
  -0.230715f, 0.083247f,  0.020367f,  -0.128629f, -0.217455f, -0.159640f,
  1.815952f,  -0.369238f, -1.186447f, -0.658753f, -0.511026f, -0.096934f,
  0.662971f,  0.486475f,  0.159746f,  -0.018932f, 3.692397f,  1.384353f,
  -0.401984f, -0.248380f, -0.140861f, 0.215248f,  -0.023711f, 0.059679f,
  -0.072260f, 0.004271f,  0.039545f,  -0.347971f, -0.081851f, -0.474896f,
  -0.181572f, 0.066736f,  -0.157822f, -0.163760f, -0.171113f, -0.089935f,
  -0.338281f, -0.421444f, -0.306687f, -0.085283f, -0.377953f, -0.138750f,
  -0.102701f, -0.312336f, 0.149831f,  0.007229f,  -0.155700f, -0.173611f,
  4.074261f,  1.342306f,  -1.272712f, 1.570899f,  -0.545093f, -0.317605f,
  -0.189440f, -0.133910f, -0.273190f, -0.108020f, -0.166107f, 0.021413f,
  -0.239130f, -0.067211f, 0.041957f,  -0.039234f, -1.003587f, -0.094412f,
  0.532512f,  -0.870538f, -1.118023f, -1.160983f, -0.736307f, -0.418752f,
  0.419466f,  0.492122f,  -0.004368f, -0.022096f, -1.115132f, 0.150886f,
  2.396852f,  2.660000f,  -0.376537f, 0.468628f,  0.149413f,  -0.074898f,
  -0.067154f, 0.021245f,  0.127857f,  0.294189f,  0.508056f,  0.390232f,
  -3.899177f, -3.414681f, -3.929195f, -4.160545f, -0.274323f, -0.052583f,
  -0.003545f, -0.433084f, -0.404891f, -0.145051f, -0.312367f, 0.004579f,
  -0.398724f, -0.372068f, -0.234279f, 0.017799f,  -0.424760f, -0.646717f,
  -0.047568f, 2.924664f,  -0.644165f, 0.359349f,  -0.294800f, 0.591746f,
  -0.404710f, -0.092358f, -0.250729f, 0.030829f,  -0.147149f, -0.476023f,
  -0.071803f, -0.482516f, -0.293117f, -0.215923f, -0.373122f, -0.085315f,
  -0.377052f, -0.449899f, -0.056452f, 0.138081f,  -0.085350f, -0.308391f,
  0.106661f,  0.176234f,  0.258869f,  -0.230172f, -0.233029f, -0.241208f,
  -0.067509f, -0.223172f, -0.118353f, -0.302478f, -0.579632f, -0.561326f,
  -0.158114f, -0.223167f, -0.026689f, 0.051863f,  0.212834f,  -0.304714f,
  -0.169071f, -0.193695f, -0.075682f, -0.170860f, -0.241008f, -0.044648f,
  0.280815f,  -0.002585f, -0.283552f, -0.037701f, -0.681169f, -0.274535f,
  -0.380595f, 0.109504f,  -0.111141f, -0.437685f, -0.094459f, 0.144206f,
  -0.106139f, -0.211832f, -0.054742f, -0.172813f, -0.295905f, -0.071907f,
  -0.418429f, -0.183240f, 0.031319f,  -0.095785f, -0.315447f, 0.069404f,
  -0.422910f, -0.029867f, -0.357321f, -0.199976f, -0.337707f, -0.070188f,
  -0.178198f, 0.177208f,  0.134688f,  -0.081933f, -0.229452f, -0.208872f,
  0.026287f,  -0.364040f, -0.063696f, -0.227443f, -0.234401f, -0.205699f,
  -0.267238f, -0.494125f, -0.056255f, 0.053715f,  -0.487754f, 0.014818f,
  0.087383f,  -0.077556f, -0.168085f, -0.436851f, -0.276286f, -0.137845f,
  -0.107606f, -0.103653f, -0.233766f, -0.419083f, 0.169185f,  0.010186f,
  -0.001587f, 0.086735f,  -2.465718f, 1.482185f,  1.621193f,  -2.081680f,
  1.386553f,  -3.204335f, -0.267111f, -0.004508f, 0.164712f,  0.274147f,
  1.724306f,  -2.273659f, 0.749574f,  -0.891905f, 0.105965f,  -0.030428f,
  -0.416018f, -0.300762f, 0.122911f,  -0.316908f, -0.292504f, 0.138666f,
  -0.161327f, -0.042143f, -0.249128f, 0.149210f,  -0.088987f, -0.654101f,
  -1.501843f, 0.216777f,  0.955914f,  0.524158f,  -1.642561f, -1.643626f,
  0.864797f,  -0.425451f, -2.115764f, -0.012502f, 0.065172f,  1.297270f,
  0.018845f,  1.167276f,  -0.470970f, -0.244995f, 0.374782f,  -1.811056f,
  -0.055430f, -0.024102f, -0.376519f, -0.339640f, -0.119177f, -0.277995f,
  -0.290095f, -0.081362f, -0.144139f, -0.118037f, -0.180357f, -0.217559f,
  -0.370683f, 0.172816f,  -0.265069f, 0.194321f,  -0.273478f, 0.037442f,
  -0.235552f, -0.078625f, -0.447541f, 0.016836f,  -0.271123f, -0.171481f,
  -0.321477f, -0.184826f, -0.442981f, -0.227273f, -0.370666f, -0.237232f,
  -0.257493f, -0.225714f, -0.153716f, -0.283487f, -0.155399f, 0.067697f,
  0.230343f,  -0.034318f, -0.022687f, -0.047090f,
};

static const float av1_ab_partition_nn_bias_64_layer0[64] = {
  -0.212182f, -0.233725f, -0.758846f, -0.158162f, 0.614743f,  -0.150944f,
  -0.075727f, -0.208414f, 1.054996f,  0.713758f,  -0.300051f, -0.151482f,
  -2.443570f, 0.430590f,  -0.129001f, -0.160733f, -0.230547f, -0.143228f,
  -0.140577f, -0.086812f, -0.212298f, -0.159557f, -0.055647f, -0.211423f,
  0.578161f,  -0.220318f, -0.210107f, -3.111584f, 0.604419f,  -0.232622f,
  -0.209924f, -0.130794f, -0.084097f, -0.036005f, 0.294594f,  -2.535531f,
  -0.209783f, -0.211189f, -2.766337f, 0.000000f,  0.450177f,  -1.754884f,
  3.262664f,  -0.209691f, -0.614886f, -0.211257f, -0.109096f, -0.190492f,
  -0.109007f, -0.026910f, -0.136035f, -0.212321f, -0.139320f, -0.212233f,
  -0.305430f, 0.739171f,  0.991277f,  -0.088150f, 0.086313f,  -0.023379f,
  -0.125366f, -0.063576f, -0.212169f, -0.047463f,
};

static const float av1_ab_partition_nn_weights_64_layer1[64 * LABEL_SIZE] = {
  -0.036800f, 0.528721f,  0.490767f,   0.144409f,  1.103640f,  0.361910f,
  -0.180069f, 0.068033f,  -14.868382f, 0.359013f,  0.322567f,  -0.199212f,
  0.906164f,  -0.488254f, 0.149653f,   -0.216394f, -0.099347f, 0.004936f,
  -0.111391f, 0.074848f,  -0.041709f,  0.147627f,  -0.018905f, 0.096116f,
  0.184817f,  -0.016241f, 0.115739f,   2.376754f,  0.637097f,  0.052954f,
  0.136428f,  0.225267f,  -0.181873f,  -0.142876f, 0.684048f,  0.658791f,
  0.105795f,  0.241705f,  1.381114f,   -0.209379f, 1.145949f,  0.795293f,
  -9.361877f, 0.198302f,  0.539600f,   0.092317f,  -0.081695f, 0.200777f,
  0.102334f,  0.081583f,  0.060948f,   -0.025110f, 0.160951f,  -0.020170f,
  0.234006f,  -0.029369f, 0.375036f,   0.270209f,  -0.556529f, 1.402949f,
  0.101777f,  -0.027331f, 0.004502f,   -0.153166f, -0.116651f, 0.151573f,
  -0.022187f, 0.144044f,  -0.108719f,  -0.129942f, -0.270321f, 0.227363f,
  1.892330f,  -0.661052f, -0.219398f,  -0.229417f, -0.856438f, -1.196988f,
  -0.081774f, 0.078847f,  -0.207057f,  -0.048947f, 0.152073f,  -0.243056f,
  -0.233329f, -0.288689f, -0.158333f,  -0.141177f, -0.715436f, 0.016947f,
  -0.093752f, 0.204984f,  -1.209782f,  0.155683f,  0.092239f,  0.146495f,
  0.813146f,  -0.027757f, 0.330982f,   2.173948f,  -0.028867f, -0.141815f,
  0.292708f,  -0.204794f, 0.014496f,   1.032799f,  1.312155f,  0.107020f,
  0.824752f,  -0.013945f, 0.184829f,   -0.041633f, 0.215300f,  -0.476088f,
  -0.053213f, 0.126862f,  -0.020777f,  0.082893f,  -0.223727f, -0.923063f,
  0.466529f,  0.082140f,  -0.845758f,  -1.140791f, -0.262033f, 0.138491f,
  0.151717f,  -0.182479f, -0.131128f,  0.055411f,  0.106771f,  0.125552f,
  0.297184f,  -0.257403f, -0.059884f,  -0.274903f, 2.694357f,  -0.108244f,
  0.025377f,  0.043092f,  -0.558317f,  3.517159f,  -0.270833f, -0.240676f,
  0.205100f,  -0.057068f, -0.140445f,  -0.193449f, -0.030061f, -0.286762f,
  -0.467523f, -0.012647f, 0.190564f,   0.022394f,  -0.101479f, 0.339684f,
  -0.902743f, -0.169578f, -0.178029f,  -0.041836f, -3.952108f, -0.028298f,
  -0.221137f, -0.733895f, -0.223895f,  0.039012f,  0.687867f,  0.021423f,
  0.113063f,  0.676087f,  -0.961000f,  -0.064847f, 0.712856f,  -0.192765f,
  -0.001132f, 0.016689f,  -0.236020f,  -0.766186f, -0.175729f, 0.012879f,
  -0.251064f, -0.105523f, -0.039212f,  -0.347584f, 0.304352f,  -0.034174f,
  -0.364258f, -0.685252f, -0.266115f,  -0.247345f, -0.155905f, 0.152283f,
  -0.156315f, 0.174082f,  -0.757654f,  0.102303f,  -2.192316f, -0.245815f,
  0.119882f,  -0.086542f, 1.987246f,   -1.353163f, -0.374813f, -0.233504f,
  -1.980895f, 0.692093f,  -0.168351f,  0.172700f,  -0.009052f, -0.015734f,
  0.106679f,  -0.060472f, -0.256813f,  -0.074874f, -0.207488f, -0.329515f,
  -0.418268f, -0.017940f, -0.036081f,  0.064719f,  -1.488016f, 0.020591f,
  -0.176325f, -0.141074f, 0.944494f,   0.150237f,  -0.249805f, -0.277280f,
  0.012686f,  0.132483f,  0.116123f,   0.013737f,  -0.116091f, 0.750340f,
  3.251343f,  -0.188864f, 1.096992f,   0.058467f,  -0.041433f, -0.037937f,
  -0.133294f, -0.137908f, -0.171132f,  0.106362f,  0.069383f,  -0.052662f,
  -0.177883f, -0.408049f, 0.680221f,   -0.117035f, -0.904240f, -1.395228f,
  0.154527f,  0.134427f,  0.022767f,   -0.158886f, -0.230316f, 0.161096f,
  0.362213f,  -0.235060f, -0.941620f,  0.055912f,  -0.049458f, -0.166632f,
  0.481418f,  0.930146f,  0.041108f,   0.033674f,  1.372066f,  -1.847709f,
  0.003324f,  0.259534f,  0.177014f,   -0.202761f, -0.262017f, -0.190852f,
  -0.102839f, 0.028338f,  0.187193f,   -0.041684f, 0.123973f,  -0.198576f,
  -0.110369f, -1.431400f, 0.208369f,   -0.302370f, -0.248549f, 0.062985f,
  0.673409f,  0.036662f,  -0.711340f,  -0.120584f, -0.189789f, 0.098812f,
  2.947819f,  0.216567f,  -0.414472f,  -0.181742f, 1.873779f,  -0.222726f,
  -0.782870f, 0.007889f,  0.015062f,   -0.554328f, 0.182928f,  -0.191430f,
  0.123636f,  -0.215460f, -0.225245f,  0.251516f,  -0.013025f, -1.359595f,
  -0.750602f, 0.342667f,  -0.141899f,  -0.687493f, -0.072639f, 0.048018f,
  -0.242107f, -0.031917f, -0.287472f,  -0.046088f, 0.832197f,  -0.016576f,
  -1.553349f, -0.216341f, 0.023077f,   -0.410867f, 4.243743f,  -0.514878f,
  -0.066007f, -0.160696f, -0.262678f,  -0.648790f, -0.430586f, 0.199940f,
  -0.202496f, -0.222241f, -0.016406f,  -0.121473f, 0.000828f,  -0.081584f,
  -0.152641f, -0.190166f, 0.644400f,   0.040196f,  -0.302104f, -1.143654f,
  -0.160327f, -0.320780f, -0.187006f,  0.037311f,  0.440618f,  -0.070733f,
  -0.117785f, 1.527539f,  -0.419310f,  0.001300f,  1.389956f,  -0.036366f,
  -0.269203f, 0.612265f,  2.721897f,   -0.086836f, -0.446999f, 0.012525f,
  -0.078317f, -0.287052f, -0.111188f,  -0.085181f, -0.164667f, -0.010466f,
  -0.569722f, -0.018888f, -0.101663f,  -1.147130f, -0.465204f, 0.114524f,
  -2.192402f, -0.221325f, 0.375748f,   0.206284f,  -0.261548f, -0.246257f,
  -0.143004f, -0.069981f, -0.057306f,  -0.116481f, -0.435903f, -0.314970f,
  0.013210f,  -0.010175f, 4.630571f,   -0.473226f, -0.197199f, -0.028204f,
  0.122907f,  2.475548f,  0.025011f,   -0.092603f, -0.127561f, -0.151330f,
  -0.077295f, 0.245016f,  -0.045005f,  0.183396f,  -0.330556f, -0.384887f,
  0.356374f,  -0.016618f, -0.463353f,  -1.291546f, -0.071986f, -0.311599f,
  0.072385f,  -0.430786f, -2.094788f,  0.202733f,  -0.910109f, -1.336543f,
  -0.086800f, -0.096413f, 1.544383f,   0.031860f,  -0.796211f, 0.762786f,
  3.250022f,  -0.441798f, -0.698537f,  0.062839f,  0.033525f,  -0.362996f,
  0.027022f,  -1.131264f, -0.228926f,  0.053885f,  -0.338628f, 0.155037f,
  -0.046844f, -0.888172f, -0.241767f,  0.084965f,  -0.617743f, -0.049896f,
  -0.036894f, -0.304783f, -0.002639f,  0.137957f,  0.052121f,  -0.131161f,
  -0.117200f, -0.253380f, -0.205561f,  -0.302450f, -0.047397f, -0.330518f,
  3.613420f,  -1.525951f, -0.026738f,  0.209150f,  -2.103534f, 2.019689f,
  -0.366199f, -0.095260f, 0.027417f,   -0.242512f, 0.162579f,  0.052113f,
  -0.293851f, -0.068138f, -0.005799f,  -0.344696f, -0.114824f, -0.431107f,
  -0.120058f, -1.139926f, -1.048379f,  0.036446f,  -0.323020f, -0.432945f,
  0.454151f,  -0.140058f, 0.050649f,   -0.094900f, -0.017278f, -0.238719f,
  1.193153f,  0.120447f,  -0.496061f,  0.917431f,  2.936126f,  -0.115521f,
  -0.347397f, -0.435325f, -0.004383f,  -0.211864f, 0.162383f,  -1.040726f,
  0.089537f,  -0.128579f, -0.133505f,  0.107129f,  -0.435657f, -0.180388f,
  0.043650f,  0.018709f,  -0.773242f,  -0.687192f, -0.120633f, -0.063626f,
  0.029912f,  0.113972f,  -0.403502f,  -0.127640f, -0.269625f, 0.129794f,
  -0.188539f, 0.041641f,  0.029769f,   -0.198374f, 1.401407f,  0.353887f,
  -0.219925f, 0.260515f,  1.157034f,   -2.992044f, -0.097618f, -0.064417f,
  -0.203626f, -0.008217f, -0.112339f,  -0.227407f, -0.155118f, 0.247705f,
  -0.012304f, -0.248447f, -0.913463f,  -0.064788f, -0.214619f, -0.251761f,
  -0.386861f, -0.040574f, -0.163219f,  -0.100700f, 1.488274f,  -0.071684f,
  -0.033626f, -0.006497f, -0.246945f,  -0.145221f, -3.747390f, 0.149609f,
  -0.263326f, -0.297385f, -1.039896f,  -0.083174f, -0.025473f, -0.235586f,
  -0.001087f, 0.254286f,  0.265106f,   0.007325f,  0.199239f,  0.134103f,
  -0.578211f, -0.259801f, -0.062373f,  2.368348f,  0.560556f,  -0.252260f,
  0.889997f,  -0.447872f, -0.059218f,  -0.095315f, -0.061667f, 0.183580f,
  -0.157479f, 0.055387f,  -0.831734f,  0.007606f,  -1.104906f, 0.301180f,
  -0.117115f, 0.212959f,  4.727223f,   -0.243833f, -0.397495f, -0.025021f,
  -0.367587f, -2.082058f, -0.217699f,  0.148111f,  0.252430f,  0.111088f,
  -0.260692f, 0.095124f,  -0.407774f,  -0.322169f, 0.002927f,  0.126169f,
  -1.272325f, -0.279772f, -0.373680f,  -0.485177f, -0.605458f, 0.021225f,
  -0.092031f, -0.226585f, 1.895162f,   0.037866f,  -0.275475f, 1.614360f,
  -0.014972f, -0.277679f, -3.449082f,  -0.092060f, -0.747873f, 0.020716f,
  2.776178f,  -0.049963f, 0.183999f,   -0.295259f, -0.028868f, 0.221895f,
  0.001265f,  0.336823f,  0.219372f,   0.112824f,  0.408132f,  -0.017940f,
  -0.311666f, 1.489606f,  -0.058093f,  -0.305659f, -0.491933f, -0.143847f,
  0.166115f,  0.042867f,  -0.123447f,  -0.087099f, -0.305395f, -0.365079f,
  -0.755801f, -0.160649f, 0.736260f,   -0.008611f, 0.095836f,  -0.017345f,
  5.697515f,  -0.498971f, -0.125280f,  0.199907f,  0.300053f,  0.605026f,
  -0.228225f, -0.259523f, 0.016384f,   0.146973f,  0.210258f,  0.226766f,
  -0.075178f, -0.050924f, 0.188496f,   -0.415266f, -0.484880f, -0.236384f,
  0.071931f,  -0.331863f, -0.601243f,  -0.232479f, -0.285272f, 0.123789f,
  -1.341333f, 0.037082f,  -0.315202f,  -1.587215f, -0.271576f, 0.003216f,
  -4.437186f, -0.256205f, -0.576589f,  -0.114147f, 2.153916f,  -0.369618f,
  0.271415f,  0.145036f,  -0.158731f,  -0.240938f, -0.187369f, 0.036325f,
  0.254771f,  0.211488f,  -0.240297f,  0.098417f,  -0.415011f, 2.334793f,
  -0.127252f, 0.020069f,  -0.168755f,  -0.448922f, -0.219207f, 0.016232f,
  -0.221935f, -0.269500f, -0.100636f,  0.102545f,  -0.809376f, -0.054979f,
  0.360713f,  -0.326541f, 0.112933f,   0.138073f,  4.229404f,  -0.763801f,
  -0.305429f, 0.199955f,  -1.787713f,  0.272866f,  0.109895f,  0.138466f,
  -0.250259f, -0.167162f, -0.212588f,  -0.217589f, -0.067125f, -0.077490f,
  -0.208970f, -0.006863f, -0.671146f,  -0.298320f, -0.165509f, 0.044597f,
  -1.408624f, -0.213957f, -0.220947f,  0.129718f,  1.316777f,  -0.098928f,
  -0.008121f, -0.558293f, -0.297290f,  -0.218873f, -4.346638f, -0.228174f,
  -0.204710f, -0.388864f, 2.697919f,   0.025260f,  0.857020f,  0.009921f,
  0.036915f,  -0.320275f, -0.087937f,  0.022636f,  0.236667f,  0.135496f,
  -0.059616f, -0.192955f, 0.009470f,   2.139589f,  -0.200449f, 0.129818f,
  1.017444f,  -0.608299f, 0.257914f,   -0.134306f, -0.033327f, 0.002855f,
  -0.338598f, 0.015559f,  0.117362f,   -0.166760f, 0.086903f,  -0.167666f,
  0.193523f,  0.033852f,  -1.147686f,  0.489468f,  -0.006969f, 0.125630f,
  1.557907f,  -1.604449f, -0.071114f,  0.096178f,  0.007065f,  0.200013f,
  0.213393f,  0.168466f,  -0.100568f,  -0.117861f, -0.161542f, -0.072561f,
  -1.069871f, -0.470138f, -0.352578f,  -1.503513f, -0.001394f, -0.380109f,
  0.065089f,  -0.281668f, 0.988953f,   -0.002778f, -0.659026f, -0.470692f,
  -0.407292f, 0.011710f,  -1.362085f,  0.184738f,  -0.135786f, -1.374241f,
  4.487930f,  -0.067274f, -0.956404f,  -0.233995f, 0.224527f,  -0.454556f,
  0.037900f,  -0.281658f, 0.208224f,   -0.254753f, 0.045740f,  0.051444f,
  -0.388281f, 0.257112f,  -0.485030f,  -0.082659f, 0.148103f,  -1.007456f,
  -0.022295f, 0.036984f,  -0.369401f,  -0.076943f, -0.007636f, -0.293022f,
  0.470466f,  0.199012f,  -2.158182f,  0.036577f,  -0.014725f, -0.229516f,
  2.236929f,  0.030945f,  -0.400045f,  0.109348f,  0.214691f,  -0.891516f,
  -0.251379f, -0.217358f, 0.013733f,   0.205573f,  -0.151725f, -0.191782f,
  -0.339630f, -0.163905f, -0.119191f,  -0.032516f, 0.503015f,  0.025772f,
  0.029094f,  -1.146153f, 0.216723f,   -0.330023f, 0.064695f,  -0.262521f,
  0.425612f,  -0.093080f, -0.489648f,  1.051293f,  -0.092332f, 0.095557f,
  -0.874132f, 0.218483f,  -0.127648f,  -1.605802f, 2.763617f,  -0.186734f,
  -1.243166f, -0.193514f, -0.173748f,  0.337822f,  0.183873f,  -0.251594f,
  -0.211582f, 0.144081f,  0.029620f,   -0.024853f, -0.385140f, 0.467341f,
  -0.928316f, -0.195442f, 0.917783f,   0.357084f,  0.174445f,  -0.073659f,
  -0.012811f, -0.115420f, -0.181147f,  -0.364449f, -0.567395f, -0.012969f,
  -1.680714f, 0.065323f,  0.198063f,   -0.244201f, 1.428545f,  -0.432539f,
  -0.208931f, -0.091205f, 0.957125f,   0.813519f,  -0.262677f, 0.246852f,
  0.015536f,  0.055026f,  0.067054f,   0.262103f,  -0.358115f, -0.095206f,
  -0.267522f, -0.402710f, -0.680397f,  -0.123627f, -0.385590f, -1.504680f,
  -0.169513f, -0.215338f, 0.043633f,   -0.079052f, -0.464410f, 0.122894f,
  -0.278231f, -2.456445f, -0.159917f,  -0.015597f, -0.735449f, -0.078854f,
  -0.400290f, -1.153870f, 3.657228f,   -0.287093f, -1.174355f, -0.102001f,
  -0.288281f, 0.185209f,  -0.145228f,  -0.200449f, -0.099914f, -0.138354f,
  0.254428f,  -0.161751f, -0.118206f,  0.296043f,  -0.482613f, 0.080932f,
  1.097605f,  -0.010190f, 0.232439f,   0.447617f,  -0.133508f, 0.115763f,
  -0.388589f, 0.174695f,  -0.236014f,  0.006284f,  -1.374129f, 0.092015f,
  -0.241419f, -0.231667f, 2.763950f,   -0.922932f, -0.061605f, 0.208740f,
  -1.597190f, 1.353325f,  -0.198528f,  0.250498f,  -0.013950f, -0.203861f,
  -0.254563f, 0.081931f,  -0.413369f,  0.011844f,  0.080961f,  -0.231161f,
  -1.234909f, -0.440843f, -0.174980f,  -0.315283f, -0.337474f, -0.123243f,
  -0.310001f, -0.271028f, 0.364179f,   0.022845f,  -0.535517f, -0.772936f,
  -0.188435f, 0.039667f,  -0.807463f,  0.266550f,  -0.288857f, -1.630789f,
  1.280155f,  0.065712f,  -0.279960f,  -0.300056f, 0.258440f,  -0.073781f,
  0.213878f,  0.042196f,  0.021360f,   0.211698f,  -0.003751f, -0.192673f,
  -0.137008f, 0.247878f,  -0.470604f,  0.073164f,  1.523241f,  0.734755f,
  -0.114126f, -0.193834f, -0.025759f,  0.263183f,
};

static const float av1_ab_partition_nn_bias_64_layer1[LABEL_SIZE] = {
  -0.343508f, -0.706936f, -0.160676f, -0.877101f, -0.517567f, -0.253254f,
  -0.148074f, 0.923430f,  -0.364770f, 0.203550f,  0.401216f,  0.938246f,
  -0.872737f, 0.718723f,  0.703398f,  2.560015f,
};

static const NN_CONFIG av1_ab_partition_nnconfig_64 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      64,  // num_hidden_nodes
  },
  {
      av1_ab_partition_nn_weights_64_layer0,
      av1_ab_partition_nn_weights_64_layer1,
  },
  {
      av1_ab_partition_nn_bias_64_layer0,
      av1_ab_partition_nn_bias_64_layer1,
  },
};

// nn model for ab partition pruning, 32x32.
static const float av1_ab_partition_nn_weights_32_layer0[FEATURE_SIZE * 64] = {
  -0.323723f, -0.214013f, -0.007772f, -0.458851f, -0.125542f, -0.123860f,
  -0.410973f, -0.209389f, -0.087580f, -0.272881f, -0.168500f, -1.130845f,
  0.344916f,  -0.475017f, -0.362262f, -0.195662f, -0.566124f, 0.782163f,
  0.411575f,  -0.013378f, -0.318650f, -0.124678f, -0.612909f, -0.315788f,
  -0.263990f, -0.508783f, -0.048938f, -0.416407f, -0.402648f, -0.156644f,
  0.225887f,  -0.000493f, 2.682241f,  0.871204f,  0.059014f,  0.803542f,
  -1.407028f, -1.154669f, 1.388148f,  -0.293348f, -0.003669f, -0.009607f,
  1.330030f,  -0.337841f, 2.118617f,  1.033059f,  -0.084788f, 0.212904f,
  0.082405f,  -0.070579f, -0.494005f, -0.173392f, 0.039546f,  -0.463865f,
  0.077163f,  -0.434066f, 0.030835f,  -0.427139f, -0.560520f, -0.031606f,
  -0.368541f, -0.027458f, 0.370574f,  0.461418f,  1.087682f,  -0.572137f,
  -1.509596f, -0.765697f, -0.499383f, -0.277998f, -0.106492f, -0.129564f,
  -0.169133f, -0.269834f, -0.114270f, -0.275431f, 0.016339f,  -0.156744f,
  -0.267922f, 0.171216f,  0.110556f,  0.002954f,  -0.200327f, -0.187663f,
  3.691601f,  1.234152f,  0.186315f,  -0.125370f, -0.211235f, -0.554432f,
  -0.131072f, -0.124982f, -0.130339f, -0.235350f, 0.018903f,  0.012896f,
  -0.159372f, -0.269571f, -0.025709f, -0.221251f, 0.061919f,  0.016307f,
  0.384673f,  -0.134525f, -1.599126f, -0.416459f, -0.743052f, 0.670249f,
  -0.169709f, 0.421681f,  -0.033360f, -0.072817f, 0.003647f,  -0.110632f,
  -0.158651f, -0.095136f, 0.223759f,  0.165767f,  -0.269129f, -0.196075f,
  -0.023183f, -0.293420f, 0.014875f,  0.018688f,  -0.153407f, -0.172009f,
  -0.259947f, -0.124015f, 0.173653f,  -0.089103f, -0.021001f, -0.334230f,
  0.027177f,  0.103371f,  -0.183860f, -0.204051f, -0.023721f, -0.192297f,
  -0.143771f, -0.247106f, 0.218116f,  -0.013240f, 2.831783f,  1.483928f,
  -0.877025f, -0.313462f, -0.411320f, -0.447825f, 0.605977f,  0.234684f,
  -0.119150f, -0.075182f, -0.330463f, 0.071503f,  -0.254924f, -0.360071f,
  -0.037022f, 0.063261f,  -0.148759f, -0.238254f, -0.462018f, -0.027166f,
  0.065318f,  -0.235743f, -0.257194f, -0.094784f, 0.022423f,  0.055925f,
  0.086672f,  -0.021010f, 0.009965f,  -0.001648f, -0.104917f, -0.387443f,
  -0.102673f, -0.281706f, 0.145923f,  -0.233391f, -0.378365f, -0.145584f,
  -0.077751f, -0.121166f, 1.134565f,  -0.097500f, -0.749202f, -0.544566f,
  -1.361374f, -0.102494f, 1.089275f,  0.375299f,  -0.105091f, 0.037641f,
  -0.054248f, -0.282691f, -0.377797f, -0.066427f, -0.253815f, -0.329677f,
  -0.339326f, -0.128217f, -0.282905f, 0.014937f,  1.067185f,  -0.171764f,
  0.484458f,  0.396706f,  -0.557055f, -0.891596f, -0.257839f, -0.720879f,
  -0.218449f, -0.004755f, 1.572857f,  0.006229f,  1.962895f,  -0.029746f,
  -4.137691f, -2.185991f, -2.763477f, -0.520437f, -0.208708f, 0.006444f,
  -1.263078f, -0.304560f, 1.072374f,  2.556429f,  0.312850f,  0.257488f,
  -0.634264f, 0.156769f,  -0.188943f, 0.040295f,  -0.389915f, 0.085250f,
  -0.248525f, 0.045667f,  -0.776115f, -0.274680f, -0.448145f, -0.566161f,
  -1.285316f, 0.079060f,  0.389124f,  -0.510401f, -0.015299f, -0.664661f,
  0.099901f,  -0.470694f, -0.051593f, -1.076381f, -0.442104f, -0.197867f,
  -0.330011f, -0.448523f, -0.301018f, -0.442093f, -0.491953f, -0.582091f,
  -0.064569f, -0.156516f, 0.543522f,  -0.005924f, 0.161432f,  0.974793f,
  0.273712f,  1.104850f,  -0.290312f, 0.313417f,  -0.125370f, 0.136234f,
  -0.191227f, -0.165054f, 0.011872f,  -0.298871f, 0.095740f,  0.142760f,
  -0.215771f, -0.031437f, 0.101041f,  -0.085620f, 0.435387f,  0.002786f,
  1.971375f,  0.018392f,  -1.771940f, -0.401433f, 0.808263f,  -3.350013f,
  2.296952f,  -1.024403f, -0.041645f, -0.034799f, -0.024078f, -0.347301f,
  -0.276088f, -0.455907f, 0.266021f,  0.087348f,  -0.146566f, 0.040492f,
  -0.539866f, -0.206851f, -0.387874f, -0.125508f, -0.496676f, -0.373845f,
  -0.472356f, -0.357082f, -0.081254f, -0.456466f, 0.554713f,  0.002185f,
  -4.225019f, 0.344025f,  0.728796f,  -0.262936f, 1.383924f,  1.577300f,
  -2.653320f, -2.516156f, -0.301604f, -0.204105f, -0.138252f, -0.587536f,
  -0.097889f, -0.352414f, -0.288276f, -0.184340f, -0.122741f, -0.243376f,
  0.031970f,  -0.373402f, -0.396079f, 0.045566f,  0.072595f,  -0.222681f,
  -0.243802f, -0.340129f, -0.258494f, -0.192041f, -0.386112f, -0.240940f,
  -0.047268f, -0.555802f, -0.032514f, -0.241341f, -0.167463f, -0.478308f,
  -0.205936f, -0.316275f, 0.103729f,  -0.197893f, -0.128029f, -0.218796f,
  -0.167362f, -0.111814f, -0.126062f, -0.394260f, -0.025357f, -0.402697f,
  -0.587395f, -0.400385f, -0.259664f, -0.415588f, -0.338503f, -0.399166f,
  -0.270504f, 0.234505f,  0.272144f,  0.266938f,  -0.392395f, -0.011717f,
  -0.384221f, -0.473446f, -0.038420f, -0.241101f, -0.234402f, -0.275567f,
  -0.410454f, -0.377599f, -0.179099f, -0.138432f, -0.248083f, -0.543026f,
  -0.428043f, -0.239895f, -0.333193f, -0.103346f, -0.039038f, -0.171109f,
  -0.119432f, -0.222351f, 0.000450f,  0.208724f,  -0.510526f, -0.144656f,
  -0.316721f, -0.344846f, -0.244794f, -0.129134f, -0.045634f, -0.400183f,
  0.043714f,  -0.235414f, 0.115594f,  -0.195616f, -0.106693f, -0.124242f,
  0.083990f,  0.049110f,  -0.196130f, -0.059860f, -0.464235f, -0.516443f,
  -0.101521f, -0.422379f, -0.413955f, -0.042991f, -0.345263f, -0.129264f,
  -0.106911f, -0.140156f, -0.457841f, -0.199848f, -0.218954f, -0.329850f,
  -0.364097f, -0.335262f, -0.312254f, -0.299331f, -0.052710f, -0.251019f,
  -0.023459f, -0.222538f, 0.028849f,  -0.088038f, -0.301550f, -0.273566f,
  0.067295f,  -0.174608f, -0.445784f, -0.158366f, -0.567275f, -0.557652f,
  -0.353503f, -0.302092f, -0.302049f, -0.551793f, -0.034535f, -0.225190f,
  -0.210733f, -0.219377f, -0.057197f, -0.430933f, -0.025185f, -0.388150f,
  -0.086147f, -0.430088f, 0.058466f,  -0.152129f, -0.058411f, -0.236392f,
  -0.547669f, -0.613849f, -0.893774f, -0.351715f, -0.399227f, -0.454909f,
  -0.324501f, 0.000490f,  -0.282167f, -0.073163f, -0.281452f, 0.047932f,
  -0.175500f, 0.165220f,  -0.276212f, 0.062153f,  -0.217054f, -0.255487f,
  -0.146416f, -0.097718f, -0.173809f, -0.559328f, -0.055695f, -0.391193f,
  -0.132020f, -0.561184f, -0.308666f, -0.474053f, -0.219149f, -0.246558f,
  -0.158325f, 0.151907f,  -0.266835f, -0.144697f, -0.193960f, -0.046587f,
  -0.220028f, -0.247355f, 0.135584f,  0.016511f,  0.367705f,  -1.855877f,
  0.435622f,  0.444710f,  -3.372301f, -3.030489f, 1.013267f,  0.380951f,
  -0.170011f, -0.111415f, -0.456146f, -0.107254f, -0.095220f, -0.053078f,
  -0.135864f, -0.591949f, -0.252810f, -0.324799f, -0.094796f, -0.260969f,
  -0.391981f, -0.063170f, -0.336130f, -0.470127f, -0.405168f, -0.433219f,
  -0.309563f, -0.295462f, -0.552270f, -0.012300f, -0.057793f, -0.034494f,
  -0.446843f, -0.640160f, -1.188681f, -0.791361f, 0.543271f,  1.189112f,
  1.458468f,  -0.005876f, -0.927475f, 0.062038f,  -1.170818f, 0.338227f,
  -3.007096f, -4.559296f, -4.045457f, -5.953635f, -0.228386f, -0.266890f,
  -0.092595f, -0.377440f, -0.044534f, -0.053565f, -0.349268f, -0.415030f,
  -0.310094f, 0.062721f,  0.251422f,  -0.014350f, -1.282910f, 1.619560f,
  1.180566f,  -0.032163f, -1.322951f, -0.603601f, 1.443710f,  0.654650f,
  -0.393227f, 0.003536f,  0.029725f,  -0.108925f, -0.053911f, 0.133977f,
  -0.036145f, -0.168438f, 0.046989f,  -0.331463f, -0.176983f, -0.311922f,
  -0.272389f, -0.379592f, -0.399993f, -0.297873f, -0.193425f, -0.177524f,
  -0.258309f, -0.567312f, -0.260217f, -0.241869f, 0.024010f,  -0.032867f,
  -0.039424f, -0.063670f, 0.193808f,  -0.303514f, -0.013376f, -0.057761f,
  0.187922f,  0.006938f,  0.031810f,  0.180594f,  -1.198427f, 2.820662f,
  0.154986f,  -0.375518f, 0.116925f,  -0.795782f, -0.085139f, -0.079365f,
  -0.197936f, -0.321468f, -0.205271f, -0.558203f, -0.296235f, -0.151193f,
  -0.158282f, -0.245402f, -0.208504f, -0.042335f, -0.087426f, -0.557129f,
  -0.381427f, -0.441551f, -0.541011f, -0.060567f, -0.469305f, -0.032326f,
  -2.453587f, -0.045568f, -0.296932f, 0.613061f,  -0.320284f, 0.191620f,
  -0.827145f, -0.225277f, 0.275800f,  1.696635f,
};

static const float av1_ab_partition_nn_bias_32_layer0[64] = {
  -0.176206f, 0.660189f,  -0.186156f, -2.481963f, -1.564218f, -0.280424f,
  0.732684f,  -0.135581f, -2.193132f, -0.172771f, 0.605001f,  -0.060392f,
  -0.067190f, -0.132969f, -1.410812f, -0.298701f, -0.105963f, -0.086173f,
  0.632779f,  0.005585f,  1.310169f,  1.392136f,  -0.563860f, -0.051053f,
  0.660998f,  -0.214726f, -1.894342f, -0.128288f, -0.330721f, -0.053988f,
  -0.177726f, 1.200859f,  -0.178902f, -0.172620f, -0.184476f, -0.175559f,
  0.538503f,  -0.322158f, -0.219080f, -0.058208f, -0.171347f, -0.216060f,
  -0.174950f, -0.295740f, -0.184820f, -0.213896f, 1.317728f,  -0.020116f,
  -0.208096f, 0.000000f,  1.246166f,  -0.225421f, -0.181555f, 0.861761f,
  1.172429f,  -0.172892f, -0.737092f, -0.189904f, -0.179385f, -0.114618f,
  -1.384604f, -0.201713f, -0.271948f, 0.372351f,
};

static const float av1_ab_partition_nn_weights_32_layer1[64 * 16] = {
  -0.037828f,  1.529029f,  0.004927f,  1.475763f,  0.627172f,  0.325872f,
  -0.990757f,  0.129476f,  0.889958f,  -0.082031f, 0.332133f,  0.074422f,
  -0.176212f,  -0.074355f, 0.774378f,  0.110987f,  -0.155469f, 0.253310f,
  0.882538f,   0.253605f,  0.332436f,  -5.389474f, 0.278470f,  0.168644f,
  0.914611f,   0.154165f,  0.809262f,  -0.174734f, 0.923673f,  0.064716f,
  -0.070228f,  -0.228735f, 0.002312f,  0.112222f,  -0.045502f, -0.046004f,
  0.514101f,   0.306480f,  0.021232f,  -0.015955f, -0.288260f, 0.189177f,
  -0.104158f,  0.103273f,  0.096910f,  -0.086328f, 1.327289f,  -0.154247f,
  0.056676f,   -0.243327f, -0.646676f, 0.177221f,  -0.086761f, 0.729729f,
  -14.710893f, -0.044881f, 0.339003f,  -0.134737f, 0.073621f,  -0.162913f,
  1.215237f,   0.140723f,  0.138630f,  1.241719f,  0.204092f,  -0.463080f,
  -0.176086f,  1.125868f,  1.034814f,  0.225455f,  -0.203421f, -0.078787f,
  -0.527498f,  0.012491f,  -0.563307f, -0.170792f, 0.002679f,  0.116153f,
  0.211348f,   -0.191900f, -0.212505f, 0.263445f,  -0.074679f, -0.081441f,
  -0.815405f,  2.448215f,  0.781299f,  0.149542f,  -1.045162f, 0.043014f,
  0.217381f,   -0.094500f, -0.090427f, 0.025784f,  -0.228906f, -2.741798f,
  0.230475f,   -0.256112f, -0.103297f, 0.159121f,  -0.229793f, -0.014883f,
  -0.104131f,  -0.123816f, 0.164148f,  -0.052279f, -0.071845f, -0.041197f,
  0.208527f,   -0.234197f, -0.542336f, 0.020053f,  0.088870f,  0.014346f,
  2.502164f,   -0.010244f, -0.267792f, 0.844394f,  2.711486f,  -0.015262f,
  -0.868053f,  -0.295704f, 0.222289f,  -0.000286f, -0.352098f, -0.079000f,
  0.021267f,   -0.721739f, -0.240558f, -0.384775f, 0.065974f,  -2.161058f,
  0.195889f,   0.268966f,  -0.009329f, 0.014949f,  0.314943f,  0.235885f,
  0.072591f,   -0.127120f, 0.150784f,  0.105697f,  -1.297403f, -0.207509f,
  -0.217688f,  -0.076752f, 0.170952f,  -0.294235f, 0.449973f,  -1.712690f,
  0.860989f,   0.054757f,  -0.812627f, -0.105316f, -0.736230f, -0.133192f,
  -3.741608f,  0.495660f,  -0.288936f, 4.654852f,  -0.021305f, -0.308916f,
  0.049205f,   -0.259996f, 0.114248f,  -0.252647f, -0.253180f, -0.449314f,
  0.022979f,   0.063281f,  -0.196154f, 0.078295f,  -0.322317f, -0.145142f,
  0.300573f,   0.048385f,  -0.254787f, 0.123939f,  -1.263088f, -0.228565f,
  -0.389061f,  0.391084f,  2.322438f,  0.075009f,  0.225743f,  -0.198808f,
  -0.280538f,  -0.173939f, -0.120543f, -0.070792f, -0.417187f, -0.781056f,
  -0.102756f,  -1.760965f, 0.019149f,  -0.867342f, 0.347141f,  0.031588f,
  0.302572f,   -0.203573f, -0.357320f, -0.096078f, -0.527528f, 0.046699f,
  -0.108561f,  -0.167077f, -2.851509f, -0.307116f, 0.202720f,  -0.160280f,
  -0.215525f,  0.064355f,  -0.427220f, 1.516230f,  0.634453f,  0.099400f,
  -1.013887f,  -0.029740f, -0.093426f, -0.044272f, -1.297636f, -0.237614f,
  -0.160953f,  0.399036f,  -0.030685f, -0.113619f, -0.184704f, 0.040519f,
  -0.588252f,  -0.210235f, -0.067623f, -0.031841f, -0.107261f, -0.192582f,
  -0.253959f,  -0.430821f, -0.103184f, -0.280185f, -0.357723f, 0.197761f,
  -0.175087f,  -0.055171f, 1.642014f,  -0.192559f, -0.288147f, 0.610311f,
  4.688195f,   -0.128728f, -0.914869f, -0.108286f, 0.013789f,  0.092125f,
  0.019770f,   -0.178386f, 0.074164f,  -1.152658f, -0.216738f, -0.277286f,
  0.012381f,   0.418259f,  -0.680727f, -0.221917f, -0.485946f, 0.101672f,
  2.009457f,   0.054302f,  1.019838f,  -0.116170f, 0.165134f,  -0.112567f,
  0.852632f,   -0.385796f, -0.108666f, 0.053181f,  -0.311797f, -0.372875f,
  -0.675717f,  2.409268f,  -0.514720f, -0.214245f, -0.646596f, 0.009756f,
  0.203993f,   0.093617f,  -0.301290f, 0.253551f,  -0.128909f, -1.448442f,
  -0.186823f,  -0.278001f, -0.294993f, -0.176928f, -0.473605f, 0.062049f,
  -0.212084f,  -0.137326f, 0.012505f,  0.087850f,  -0.200413f, -0.394119f,
  -0.132224f,  0.146917f,  0.155746f,  0.198725f,  -0.322541f, 0.196391f,
  -0.945500f,  0.036736f,  -0.155646f, -0.677341f, 1.130545f,  -0.339554f,
  0.411628f,   -0.355813f, -0.249843f, 0.213694f,  -2.035607f, 0.055694f,
  -0.111669f,  0.408696f,  -0.067043f, -0.048182f, 0.398110f,  -0.067542f,
  1.459801f,   0.236833f,  -0.178806f, 0.168758f,  0.492387f,  0.099691f,
  -0.776680f,  -0.172865f, 0.204225f,  0.193982f,  0.575685f,  -0.062248f,
  0.011486f,   0.058571f,  -0.493391f, 0.026893f,  -0.900467f, 3.793129f,
  -0.634613f,  -0.064660f, -0.048262f, 0.361905f,  0.033641f,  0.245171f,
  -0.064671f,  0.034954f,  0.204358f,  -0.904023f, -0.052714f, -0.250134f,
  0.136700f,   0.000734f,  -0.371720f, 0.226483f,  0.217958f,  0.060559f,
  0.180111f,   0.000970f,  0.079556f,  -0.096775f, 0.093855f,  -0.026224f,
  -0.243664f,  0.004290f,  0.123281f,  -0.239476f, 1.230374f,  -0.107826f,
  -0.101982f,  -0.153917f, 5.464427f,  0.304375f,  -0.809957f, 0.090564f,
  -0.278416f,  -0.245555f, -2.078421f, 0.243093f,  -0.127666f, 0.052451f,
  -0.126662f,  -0.783505f, 0.025149f,  -1.422675f, -0.207769f, -0.362547f,
  0.115310f,   0.133390f,  1.264754f,  -0.027055f, -0.485312f, -0.240717f,
  -0.239722f,  0.146818f,  -1.265043f, -0.235553f, 0.267104f,  -0.021357f,
  -0.435949f,  -0.309371f, 0.049920f,  1.302721f,  -0.233978f, -0.097551f,
  -0.240631f,  -0.287821f, -0.378380f, -0.273131f, -3.075169f, 0.226404f,
  -0.029361f,  2.703590f,  -0.430659f, 0.067927f,  -0.387520f, -0.370630f,
  -0.229236f,  0.085653f,  -0.370956f, -0.065556f, -0.187859f, 0.068309f,
  -0.109299f,  -0.259898f, -0.103644f, -0.271199f, -0.209350f, 0.140993f,
  -0.196713f,  -0.135508f, -1.423209f, -0.406385f, -0.019956f, -0.864694f,
  5.963707f,   -0.201157f, 0.726377f,  -0.011076f, 0.010553f,  -0.102918f,
  -2.230088f,  -0.258098f, -0.039547f, -0.029262f, -0.082324f, -0.860222f,
  -0.094735f,  -1.381839f, 0.587298f,  -0.173048f, 0.721360f,  0.241900f,
  0.764302f,   -0.023609f, -1.173755f, 0.103912f,  -0.185363f, 0.078435f,
  -2.245062f,  -0.127269f, 0.202234f,  0.158975f,  -0.260909f, 0.098608f,
  -0.348247f,  1.732502f,  -0.412298f, -0.269602f, -0.425771f, -0.146243f,
  -0.530730f,  0.125716f,  -1.004419f, 0.145109f,  -0.059289f, 1.096304f,
  0.012891f,   0.045033f,  -0.306875f, 0.003514f,  -0.176110f, 0.037544f,
  -0.441537f,  -0.518921f, -0.262149f, -0.060407f, -0.379419f, -0.141245f,
  -0.128894f,  -0.176537f, -1.161318f, -0.249100f, -0.118330f, 0.042816f,
  1.173404f,   0.088312f,  -0.393568f, -0.175134f, 6.529819f,  -0.326652f,
  -0.631917f,  -0.393476f, 0.057781f,  -0.217748f, -1.781139f, -0.012614f,
  -0.212621f,  -0.720322f, -0.218498f, -0.388556f, -0.254796f, -0.248399f,
  -0.608744f,  -0.265146f, 0.238517f,  0.066882f,  -2.916806f, 0.054642f,
  0.282590f,   0.075248f,  0.010188f,  -0.133486f, 0.985945f,  -0.045849f,
  -0.347564f,  0.057320f,  -0.417920f, 0.063664f,  0.387062f,  -2.692059f,
  -0.535549f,  0.263736f,  0.327889f,  -0.070273f, -0.775254f, 0.147250f,
  3.309425f,   -0.212191f, -0.067204f, -2.912663f, -0.061496f, 0.084233f,
  0.022907f,   0.138421f,  -0.112159f, -0.288447f, -0.010799f, 0.056049f,
  -0.036527f,  0.021525f,  0.106649f,  -0.291883f, 0.088424f,  -0.057773f,
  -0.086031f,  0.015277f,  -0.318505f, -0.269049f, -1.008913f, -0.224785f,
  -0.025820f,  -0.649037f, 0.706381f,  0.096410f,  0.643776f,  -0.046743f,
  -0.009654f,  -0.024246f, 1.469255f,  -0.183536f, -0.370046f, -0.048442f,
  -0.376527f,  -0.431264f, -0.245109f, -0.093951f, 0.203683f,  -0.099872f,
  0.087210f,   0.160692f,  -3.527694f, -0.068891f, -0.228994f, -0.231817f,
  -0.241949f,  0.193613f,  0.979597f,  -0.091259f, 0.414424f,  -0.047341f,
  -0.209582f,  -0.295134f, -0.016824f, 0.460327f,  -0.072671f, 0.246234f,
  0.235896f,   0.127238f,  -1.068683f, 0.035648f,  2.254888f,  0.180105f,
  -0.260098f,  -2.322120f, -0.184249f, -0.314801f, -0.099969f, -0.272117f,
  -0.237916f,  0.031103f,  -0.274063f, -0.049384f, -0.044917f, 0.102477f,
  -0.342148f,  -0.257558f, -0.346300f, 0.115333f,  -0.115456f, 0.208354f,
  -0.359301f,  -0.167395f, 1.146514f,  -0.177861f, -0.098658f, -0.444570f,
  6.759993f,   -0.369772f, -0.831118f, 0.001866f,  -0.073298f, -0.072095f,
  0.811902f,   -0.431997f, -0.286587f, -0.269500f, 0.111492f,  -0.525364f,
  -0.351785f,  -2.463474f, -1.852659f, 0.135325f,  0.138267f,  0.100643f,
  -2.373278f,  -0.285514f, -0.395388f, -0.185016f, -0.030249f, -0.005767f,
  -0.716424f,  -0.031674f, 0.011147f,  0.057405f,  -0.215873f, -0.094401f,
  0.573528f,   -1.223820f, 0.414852f,  -0.059053f, -0.076488f, -0.287168f,
  -0.842640f,  0.174084f,  -0.567186f, 0.336629f,  -0.062514f, 2.075448f,
  -0.061680f,  -0.131529f, -0.098994f, -0.204111f, -0.347865f, 0.108516f,
  -0.049616f,  -0.069212f, -0.273935f, -0.096545f, -0.210784f, -0.284698f,
  0.141501f,   -0.176924f, -0.361341f, -0.251197f, -0.286694f, 0.245569f,
  -1.521661f,  -0.122639f, -0.015760f, -0.718912f, 5.877828f,  0.146916f,
  0.151767f,   0.220785f,  -0.032298f, 0.230902f,  0.663943f,  -0.252613f,
  0.057718f,   -0.436038f, -0.323994f, -1.139787f, -0.042489f, -1.326298f,
  -1.031206f,  -0.104136f, 0.389897f,  0.127602f,  -2.667789f, -0.212366f,
  -0.506262f,  -0.009115f, -0.213202f, 0.076167f,  -1.629405f, 0.055129f,
  0.375393f,   -0.150272f, -0.241515f, -0.326497f, 0.100069f,  0.410703f,
  0.340622f,   0.042437f,  -0.349945f, 0.041176f,  -1.178950f, 0.030992f,
  0.933908f,   -0.035844f, -0.098660f, 1.030584f,  -0.092043f, -0.355739f,
  -0.305562f,  0.036161f,  -0.049558f, -0.033225f, -0.403856f, -0.088276f,
  0.215493f,   -0.149105f, -0.013363f, 0.025886f,  -0.101306f, -0.205781f,
  -1.072487f,  -0.076019f, 0.077555f,  0.131003f,  1.267763f,  -0.008954f,
  -0.327617f,  -0.246539f, 6.664081f,  -0.404403f, -1.442489f, 0.191301f,
  -0.336361f,  0.181156f,  0.833108f,  0.007879f,  -0.194464f, -1.029408f,
  -0.036268f,  -0.927110f, -0.379190f, -0.293443f, -1.848579f, -0.242548f,
  -0.065990f,  0.203160f,  -0.291788f, 0.000680f,  0.587011f,  -0.241289f,
  0.037034f,   0.000552f,  1.072308f,  -0.387230f, -0.230050f, 0.292322f,
  -0.720001f,  0.034109f,  -0.467260f, 2.211644f,  -1.839191f, -0.048797f,
  -0.083469f,  -0.334686f, -0.269056f, 0.051295f,  1.319904f,  -0.035603f,
  -0.018457f,  -0.824915f, -0.212285f, -0.230516f, -0.035093f, -0.400843f,
  -0.305469f,  -0.099011f, 0.014225f,  -0.452772f, 0.170331f,  -0.389312f,
  -0.115084f,  -0.014770f, -0.429387f, -0.155961f, -0.568200f, -0.037853f,
  -0.125137f,  0.067228f,  -1.329271f, -0.117874f, -0.132499f, -0.218376f,
  -0.588325f,  -0.320024f, 0.085695f,  -0.235047f, -0.217790f, 0.103015f,
  -0.698644f,  0.017766f,  -0.058299f, 0.199411f,  -0.122485f, -0.563949f,
  -0.349011f,  -0.557045f, -0.131165f, 0.002281f,  0.118559f,  -0.210302f,
  -1.153815f,  0.116738f,  -0.236007f, -0.003487f, -0.006885f, -0.244816f,
  0.953222f,   0.093748f,  0.266869f,  0.241869f,  -0.860832f, -0.387012f,
  -0.338986f,  2.097515f,  -1.942512f, -0.298021f, 0.543911f,  -0.043214f,
  0.082125f,   -0.120242f, 0.712231f,  0.213327f,  -0.301687f, -0.544011f,
  -0.392131f,  0.004302f,  0.004825f,  -0.317440f, -0.107518f, -0.293407f,
  -0.159111f,  -0.080367f, 0.132663f,  -0.017726f, -0.237521f, -0.190297f,
  -0.361633f,  0.200518f,  -0.538296f, -0.027975f, -0.381704f, -0.016963f,
  0.630105f,   -0.190997f, -0.287840f, -0.603488f, 3.605598f,  -0.276614f,
  -1.346383f,  0.186912f,  -0.047575f, -0.189232f, -1.519072f, 0.097816f,
  -0.223722f,  0.304924f,  -0.213022f, -1.052433f, -0.322283f, -1.706734f,
  -2.458027f,  0.237976f,  0.171050f,  -0.103139f, -0.278689f, 0.329824f,
  -0.262448f,  -0.122916f, -0.236398f, -0.013848f, -0.969160f, -0.374907f,
  0.091018f,   -0.386471f, -0.723940f, 0.064956f,  -0.057652f, 1.321024f,
  -1.397418f,  -0.143136f, 0.272468f,  -0.030749f, 0.037324f,  0.069316f,
  -0.904925f,  -0.333693f, -0.117709f, 2.279598f,  -0.428065f, -0.131157f,
  -0.014288f,  -0.402862f, -0.666090f, 0.017070f,  -0.028333f, 0.002481f,
  0.197156f,   -0.038120f, -0.271062f, -0.188275f, -0.021370f, -0.070849f,
  -0.905007f,  -0.095886f, -0.093055f, -0.121821f, -1.239812f, -0.411799f,
  -0.089948f,  -0.936827f, 1.437569f,  -0.388908f, 0.126170f,  0.186162f,
  -0.018819f,  -0.138364f, -1.066412f, -0.138222f, -0.022186f, 0.107331f,
  -0.230436f,  -1.352605f, -0.161323f, -1.081810f, -0.933825f, -0.136675f,
  0.378157f,   0.113377f,  -0.850610f, 0.080245f,  -0.087305f, -0.002852f,
  0.044408f,   -0.188172f, -1.891998f, 0.092189f,  0.125325f,  -0.105090f,
  -0.848510f,  -0.396308f, -0.384130f, 2.007509f,  -1.480787f, -0.126946f,
  0.314767f,   0.000195f,  -0.285628f, -0.110442f, -0.293948f, 0.258559f,
  -0.417603f,  1.570705f,  0.092459f,  -0.340974f, -0.284754f, -0.007801f,
  -0.324610f,  -0.004734f, -0.207716f, -0.057175f, 0.055467f,  -0.210830f,
  -0.113005f,  -0.299177f, 0.068074f,  0.017929f,  -2.897598f, -0.260074f,
  -0.014422f,  -0.206467f, 1.246997f,  -0.372863f, -0.214160f, -0.114035f,
  5.805862f,   0.003611f,  -1.340990f, -0.021085f, -0.260431f, -0.002720f,
  -1.251640f,  -0.353531f, -0.304009f, -0.153376f,
};

static const float av1_ab_partition_nn_bias_32_layer1[LABEL_SIZE] = {
  -0.521497f, -1.061572f, -0.078756f, -0.660662f, -0.403741f, -0.960163f,
  0.001427f,  0.523607f,  0.225068f,  -0.055273f, 1.019519f,  1.181880f,
  -0.010198f, 0.130597f,  1.276752f,  2.028188f,
};

static const NN_CONFIG av1_ab_partition_nnconfig_32 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      64,  // num_hidden_nodes
  },
  {
      av1_ab_partition_nn_weights_32_layer0,
      av1_ab_partition_nn_weights_32_layer1,
  },
  {
      av1_ab_partition_nn_bias_32_layer0,
      av1_ab_partition_nn_bias_32_layer1,
  },
};

// nn model for ab partition pruning, 16x16.
static const float av1_ab_partition_nn_weights_16_layer0[FEATURE_SIZE * 64] = {
  0.151902f,  0.007947f,  -1.788454f, 0.431869f,  -2.971387f, 0.923566f,
  1.632542f,  -1.665136f, -0.338632f, -5.075884f, 0.398267f,  0.030467f,
  2.263534f,  -0.045532f, -1.066128f, 0.915139f,  -0.560500f, -3.293125f,
  2.072793f,  -1.011414f, 0.122716f,  -0.060169f, -0.388860f, 0.031019f,
  -0.381861f, 0.001551f,  -0.328472f, 0.038296f,  -0.060398f, -0.375556f,
  0.209226f,  0.014764f,  -1.443469f, -0.345486f, 2.409269f,  1.524846f,
  -0.640666f, 1.322139f,  -2.074771f, -0.580944f, -0.203960f, -0.072893f,
  0.329701f,  0.115339f,  -1.339542f, 0.249024f,  -0.421545f, -0.409151f,
  -0.258293f, 0.836288f,  -0.073685f, -0.009624f, 0.895712f,  0.320639f,
  0.451002f,  -1.544558f, 0.193709f,  -1.389012f, 1.305451f,  0.089795f,
  0.050338f,  -0.017433f, -0.304667f, 0.500729f,  0.504346f,  0.073757f,
  0.582649f,  -0.993623f, 1.766766f,  -3.067265f, -0.415774f, -0.006036f,
  -1.245281f, 0.253205f,  -0.591245f, -0.626238f, 0.551852f,  0.593755f,
  0.491023f,  1.099384f,  -0.348448f, 0.054564f,  -0.451422f, -0.375781f,
  -0.248390f, -0.052548f, -0.380069f, -0.165391f, -0.297968f, -0.052142f,
  -0.316381f, -0.045246f, -0.243905f, -0.034169f, -0.247523f, -0.180773f,
  0.068066f,  -0.374920f, 0.057536f,  -0.189748f, 0.058375f,  -0.267749f,
  -0.147286f, -0.246153f, 0.006183f,  -0.202029f, -0.059128f, 0.116852f,
  0.134719f,  -0.126900f, -0.064646f, -0.196458f, -0.182331f, 0.108029f,
  -0.264499f, 0.155816f,  -0.107255f, -0.056983f, -0.209771f, -0.099070f,
  0.007313f,  -0.254124f, -0.231964f, -0.275972f, 0.032098f,  -0.264564f,
  -0.208743f, 0.155599f,  -0.121511f, -0.156145f, -0.162315f, -0.059788f,
  -0.257073f, -0.076654f, -0.110616f, -0.321675f, -0.051952f, 0.006301f,
  -0.154114f, 0.017032f,  -0.017364f, -0.233247f, 0.009918f,  -0.179289f,
  -0.190722f, 0.147106f,  -0.063910f, -0.396872f, -0.263123f, -0.003850f,
  -0.040718f, -0.324699f, 0.118660f,  -0.170727f, -0.316788f, 0.100886f,
  -0.202842f, 0.045371f,  0.150561f,  -0.057054f, -0.308150f, 0.028346f,
  -0.381473f, -0.195365f, 0.026221f,  -0.281795f, 0.087204f,  0.047689f,
  -0.027643f, -0.104724f, -0.089030f, -0.117661f, -0.349160f, 0.056982f,
  -0.340273f, 0.048086f,  0.046103f,  -0.121527f, 0.021697f,  0.054109f,
  -0.002768f, -0.008461f, -2.297240f, 0.124651f,  3.621661f,  -0.057120f,
  -1.151656f, 2.296894f,  -3.678720f, -0.290240f, 0.087683f,  -0.186389f,
  0.007656f,  -0.090236f, -0.245217f, 0.110389f,  -0.251719f, -0.029084f,
  -0.128203f, -0.100005f, -0.032779f, 0.007281f,  -0.366596f, -0.267870f,
  -0.215620f, 0.047687f,  0.010303f,  0.097980f,  -0.191569f, -0.341162f,
  0.119249f,  0.026279f,  -2.161546f, 0.459591f,  1.290566f,  1.791797f,
  -0.409835f, 0.127081f,  -1.156367f, 0.198286f,  0.099561f,  -0.067445f,
  -0.034352f, 0.017966f,  -0.277380f, -0.057220f, -0.174198f, -0.014164f,
  0.146090f,  -0.357530f, 0.097644f,  -0.000932f, 0.446603f,  -0.066793f,
  2.448620f,  0.937617f,  -1.232922f, 0.313183f,  0.816827f,  -0.275115f,
  -0.245205f, -0.126895f, 0.156668f,  -0.186977f, -0.273505f, 0.013315f,
  0.168629f,  -0.089084f, 0.006166f,  -0.116107f, -0.199316f, -0.024010f,
  -0.242303f, 0.011612f,  -0.218485f, -0.229661f, -0.123922f, 0.136699f,
  0.006732f,  -0.148718f, -0.164225f, 0.116063f,  1.587898f,  0.690519f,
  0.360566f,  0.009739f,  -0.678702f, -0.046003f, 0.126984f,  0.605212f,
  1.240663f,  -0.000228f, -1.119369f, -0.415589f, -0.721003f, 0.097936f,
  -1.410586f, -2.358833f, -2.773129f, -3.983361f, -0.087144f, -0.050029f,
  -0.242255f, 0.137424f,  -0.307490f, -0.084637f, -0.023812f, -0.196582f,
  -0.078695f, 0.038257f,  -0.012110f, -0.263521f, 0.009839f,  -0.109125f,
  -0.226036f, 0.060712f,  0.093671f,  0.153143f,  0.039116f,  -0.290891f,
  0.227057f,  -0.204633f, -0.207539f, -0.148242f, 0.046204f,  -0.231268f,
  -0.209315f, -0.307579f, -0.436556f, 0.023475f,  0.131793f,  -0.038301f,
  1.650584f,  0.392570f,  1.446576f,  1.254380f,  -0.516867f, -0.057116f,
  0.149320f,  0.414424f,  -0.246309f, 0.003877f,  -0.480238f, -1.037035f,
  -0.830779f, -1.122244f, -0.408267f, -0.253956f, 0.382005f,  0.940609f,
  -1.113370f, -0.018554f, 0.141064f,  -0.182504f, 1.270707f,  0.414904f,
  -0.216036f, 0.203831f,  0.450716f,  -0.452909f, 0.139358f,  -0.027143f,
  1.956892f,  1.643732f,  -0.867839f, -0.620520f, -0.334607f, -0.519982f,
  0.205023f,  0.661159f,  -0.000809f, 0.049033f,  -0.348579f, -0.200338f,
  -0.362144f, -0.346590f, -0.230096f, 0.180746f,  -0.149954f, -0.253429f,
  -0.378170f, -0.040724f, -0.041597f, 0.243659f,  -0.472181f, 0.015401f,
  -0.180376f, 0.153139f,  -0.247738f, -0.010485f, -0.157158f, 0.016825f,
  -0.238925f, -0.265798f, -0.318374f, 0.142352f,  -0.210520f, 0.051928f,
  -0.352190f, -0.179052f, -0.185498f, 0.025540f,  -0.111667f, -0.235187f,
  -0.215454f, 0.010931f,  -0.238372f, -0.126659f, 0.075691f,  -0.091167f,
  -2.462379f, -0.007950f, -0.637990f, 0.285554f,  -0.051275f, 0.282279f,
  -0.744083f, -0.570646f, 0.592198f,  1.421332f,  -0.256027f, -0.140315f,
  0.160247f,  -0.063185f, -0.055895f, -0.199864f, -0.287353f, -0.074561f,
  -0.071228f, 0.055864f,  -1.084764f, -0.263409f, 0.779266f,  0.228187f,
  0.375013f,  0.121204f,  -0.656948f, 0.533561f,  0.272671f,  -0.015423f,
  -0.124180f, -0.009127f, 2.934838f,  -0.150998f, 1.163152f,  0.081997f,
  -4.715939f, -3.676595f, -1.524886f, -0.167593f, 0.281186f,  0.024046f,
  -1.451709f, 0.332558f,  0.990504f,  0.376290f,  -1.466773f, -0.448439f,
  -2.929108f, -4.255188f, 0.065238f,  0.019950f,  1.372393f,  0.444052f,
  -2.538772f, 1.579767f,  -0.464911f, -1.866114f, 1.053958f,  0.434467f,
  -0.125964f, 0.034671f,  0.077116f,  -0.138466f, -0.413395f, -0.223453f,
  -0.172127f, -0.251265f, -0.048239f, -0.395519f, 0.023141f,  0.037459f,
  -0.249593f, -0.062215f, -0.047209f, -0.435189f, -0.164155f, -0.077590f,
  -0.241164f, -0.126128f, -0.038243f, -0.180888f, 0.198840f,  -0.328036f,
  -0.169790f, 0.036506f,  0.052572f,  -0.183570f, -0.073617f, -0.244959f,
  0.266498f,  0.032846f,  -1.902106f, 0.486078f,  2.414993f,  0.975182f,
  -0.382875f, 1.647810f,  -2.197017f, -0.890107f, 0.221287f,  0.010889f,
  3.817042f,  0.572728f,  0.092466f,  0.473337f,  -1.634659f, -1.069455f,
  1.486776f,  -1.023850f, 0.088184f,  0.008842f,  0.518202f,  0.270259f,
  1.757191f,  -0.121839f, -2.912229f, -1.250866f, -2.381808f, 0.335309f,
  -0.120079f, -0.061294f, -0.058725f, -0.315169f, -0.262443f, 0.072434f,
  -0.267836f, -0.319354f, -0.274975f, 0.068970f,  -0.406467f, 0.044074f,
  -0.152311f, -0.333656f, -0.228355f, -0.185613f, 0.017346f,  -0.177674f,
  -0.090675f, -0.102047f, -0.011768f, -0.025280f, -0.271661f, 0.098099f,
  -0.312272f, -0.222217f, -0.100548f, 0.106260f,  -0.034655f, 0.135109f,
  -0.021276f, 0.018177f,  -0.353097f, -0.011128f, 0.061136f,  -0.511662f,
  -0.223236f, -0.308841f, 0.118789f,  -0.154628f, -0.053178f, -0.055973f,
  0.013175f,  -0.368337f, -0.090863f, -0.116920f, 0.178990f,  -0.025278f,
  -0.190553f, -0.238092f, 0.303943f,  -0.024944f, 0.719373f,  0.384332f,
  -0.378480f, -0.423316f, 0.709922f,  0.758514f,  -1.559023f, -2.503173f,
  0.068652f,  -0.234741f, -0.182932f, 0.037878f,  0.020684f,  -0.174142f,
  -0.182300f, -0.052796f, -0.219145f, 0.113028f,  -1.041826f, 0.035317f,
  0.919904f,  -0.676011f, 0.652297f,  1.456447f,  -0.166904f, -0.861823f,
  0.895827f,  0.429821f,  -0.180376f, -0.076587f, -0.273945f, -0.288990f,
  -0.206692f, -0.080745f, -0.085444f, 0.186953f,  -0.050135f, 0.044243f,
  -0.391706f, -0.160498f, -0.292268f, 0.164060f,  0.412649f,  0.211611f,
  -0.327294f, -0.919399f, 0.320297f,  0.385284f,  -0.088848f, -0.072556f,
  -0.384813f, -0.176267f, -0.065918f, 0.134724f,  -0.231104f, -0.337707f,
  -0.195442f, -0.263569f, 0.098090f,  -0.341411f, -0.189211f, -0.439276f,
  -0.404046f, 0.262491f,  -0.311093f, -0.086454f, -0.013400f, -0.061447f,
  -0.026945f, -0.112036f, -0.322985f, 0.078500f,  -0.230205f, -0.344535f,
  -0.021087f, 0.110220f,  -0.128671f, 0.044219f,
};

static const float av1_ab_partition_nn_bias_16_layer0[64] = {
  2.936406f,  -0.396539f, -0.110456f, -1.254954f, 0.785350f,  0.516290f,
  -0.172341f, 0.254386f,  -0.192465f, -0.106751f, -0.055518f, -0.094994f,
  0.000000f,  -0.065018f, -0.004908f, -0.130483f, -0.119580f, -0.142072f,
  0.457446f,  -0.125051f, -0.107712f, 0.714607f,  -0.140809f, -1.788650f,
  -0.087199f, 0.000000f,  -1.290050f, 0.443930f,  -0.110634f, -0.109380f,
  -0.188213f, -1.414179f, 1.193579f,  0.388775f,  -0.873193f, -0.110050f,
  -0.072565f, -0.117050f, -0.119132f, 0.456959f,  -0.132069f, 0.131974f,
  1.160474f,  1.746465f,  0.442628f,  -0.188849f, -0.207794f, -0.108364f,
  -0.856655f, -2.141620f, 0.335476f,  -0.105508f, -0.212162f, -0.109319f,
  -0.237213f, -0.109980f, -0.291044f, -0.137877f, 0.470191f,  -0.023908f,
  0.123809f,  -0.109797f, 0.200510f,  -0.147542f,
};

static const float av1_ab_partition_nn_weights_16_layer1[64 * LABEL_SIZE] = {
  -6.823716f, 1.406568f,  -0.144009f, 2.228765f,  0.838336f,  0.738107f,
  -0.319014f, -0.148756f, 0.240862f,  -0.111089f, -0.004241f, 0.025758f,
  -0.193820f, -0.246362f, -0.181363f, -0.201556f, 0.024268f,  0.252994f,
  -0.289443f, 0.194932f,  0.057467f,  0.724735f,  0.014063f,  1.361352f,
  0.025191f,  0.024274f,  0.231462f,  -7.227959f, -0.094515f, 0.039946f,
  0.412719f,  0.812318f,  3.038903f,  -0.286289f, 0.647482f,  -0.115114f,
  0.053590f,  0.066069f,  0.153134f,  0.996250f,  -0.125700f, 0.951365f,
  -6.243494f, -4.827697f, 0.566320f,  0.239515f,  -0.099702f, 0.054546f,
  1.847330f,  3.680076f,  -3.049829f, -0.127709f, 0.068469f,  -0.017794f,
  0.223864f,  -0.106778f, -0.020425f, -0.040226f, -0.251890f, -0.168673f,
  -0.552073f, 0.043311f,  0.218668f,  0.033209f,  -3.199210f, 0.193079f,
  0.321406f,  0.718307f,  -0.181418f, -0.459612f, -1.981170f, 0.968496f,
  -0.029757f, -0.130065f, 0.043782f,  0.072394f,  -0.088686f, 0.025322f,
  0.129882f,  0.101324f,  0.335707f,  0.072714f,  -2.079774f, 0.203997f,
  0.239321f,  -0.301757f, 0.257845f,  1.288382f,  -0.031275f, -0.234194f,
  0.310722f,  2.045469f,  0.034716f,  0.135638f,  -0.251388f, 0.320071f,
  -1.065301f, -0.322731f, -0.545028f, 0.226276f,  0.090799f,  0.019289f,
  0.048950f,  -1.079300f, 0.231938f,  0.083683f,  4.762127f,  0.145037f,
  -0.145549f, 0.075592f,  0.172336f,  0.108175f,  0.333751f,  1.090501f,
  1.056114f,  0.047073f,  0.182052f,  -0.081587f, 0.089900f,  0.339286f,
  2.049988f,  0.073585f,  0.537355f,  -0.243322f, -0.010179f, -0.052601f,
  -0.174915f, 0.117793f,  2.222990f,  -2.520837f, -0.092699f, 1.199887f,
  0.138720f,  0.679918f,  -0.463155f, -0.659496f, -0.109913f, -0.003398f,
  0.114633f,  -0.128377f, 0.092970f,  -0.107489f, -0.191078f, 0.185182f,
  0.216980f,  -0.019343f, 3.443133f,  0.287953f,  0.099314f,  0.985958f,
  0.157268f,  -0.606516f, 0.049418f,  -0.221809f, -0.453081f, -0.344796f,
  -0.003735f, -0.107269f, -0.128541f, -0.259543f, -0.934806f, -0.542456f,
  -1.011192f, 0.022795f,  0.186363f,  -0.076356f, -0.050932f, -0.165098f,
  0.168177f,  -0.101596f, -5.270886f, 2.553943f,  -0.440870f, -0.017494f,
  0.215208f,  -0.017032f, 1.495915f,  -4.304677f, 0.762211f,  0.182937f,
  0.254406f,  -0.029433f, -0.088364f, -0.110160f, -0.108257f, -0.036538f,
  0.737697f,  -0.234989f, 0.168095f,  0.245118f,  -0.077262f, 0.195718f,
  0.753302f,  -1.637869f, 0.126227f,  0.982129f,  -0.121444f, -0.295570f,
  -1.215799f, 0.147867f,  -0.068496f, 0.132726f,  -0.005772f, -0.181774f,
  0.126513f,  0.204723f,  -0.366123f, 0.103906f,  -0.148053f, -0.075272f,
  0.243884f,  -0.104828f, 0.198988f,  0.501034f,  -0.112671f, 0.111421f,
  0.167508f,  -0.117803f, -0.738624f, 2.046292f,  0.124011f,  0.057983f,
  -0.359154f, -0.648883f, -0.259462f, -0.459041f, -2.501223f, -0.065138f,
  0.122417f,  0.060291f,  -0.129033f, -0.843086f, 0.268241f,  -0.399927f,
  1.585888f,  1.816393f,  -0.631427f, 0.127826f,  0.088105f,  0.073488f,
  0.717694f,  -1.497362f, 2.608528f,  0.066896f,  -0.079230f, 0.223436f,
  -0.010530f, 0.175310f,  1.120365f,  0.034391f,  0.835312f,  0.071652f,
  -0.080615f, 0.111395f,  0.162742f,  0.079927f,  -3.859582f, -0.638431f,
  -0.167880f, -0.992659f, -0.885355f, -1.276197f, 1.334344f,  0.931940f,
  -0.078244f, -0.149030f, -0.070974f, -0.133566f, 0.200034f,  0.102793f,
  -0.048546f, 0.063545f,  0.023864f,  -0.190863f, 1.934257f,  -0.136286f,
  -0.107916f, -0.637468f, 0.066449f,  1.089693f,  -0.214047f, -0.265780f,
  0.899660f,  -0.130333f, 0.288311f,  -0.049024f, 0.090202f,  0.487969f,
  0.339704f,  0.858479f,  0.841253f,  -0.184100f, -0.637070f, -0.125071f,
  -0.077650f, -0.087877f, 0.202268f,  -0.027300f, 2.842862f,  -0.100698f,
  -0.259080f, 0.260556f,  0.157912f,  -0.070364f, 0.467190f,  1.200037f,
  1.419317f,  -0.033588f, -0.227824f, 0.292617f,  0.228574f,  0.213839f,
  -1.091099f, -0.022258f, -1.294681f, 0.136118f,  0.081652f,  -0.185359f,
  -0.039706f, 0.191407f,  -2.053219f, -0.261934f, 0.047812f,  -0.029536f,
  -0.823869f, -1.090534f, -0.755890f, 0.441035f,  -0.167945f, 0.231441f,
  -0.135013f, -0.260762f, 0.256872f,  0.130339f,  -0.243751f, 0.189760f,
  -0.288454f, 0.145363f,  0.338490f,  0.403898f,  -0.022814f, -1.263598f,
  -0.101315f, 0.860135f,  0.136511f,  0.028942f,  0.574047f,  2.656370f,
  0.037587f,  -0.188690f, -0.125312f, 1.100435f,  -1.080402f, 0.380905f,
  0.004635f,  0.097144f,  -0.214309f, 0.085552f,  -0.285066f, -0.705134f,
  -0.054704f, -0.319951f, 5.486626f,  0.958158f,  -1.380585f, 0.223340f,
  -0.169167f, -0.170697f, -0.216748f, 0.324232f,  2.684204f,  -0.008490f,
  -0.211052f, -0.201190f, 0.123466f,  -0.000234f, 0.579907f,  0.096938f,
  -0.042745f, 0.201855f,  0.157195f,  -0.261440f, 0.029699f,  -0.046599f,
  1.618216f,  -2.596280f, -0.377420f, -0.526725f, -0.493592f, -0.579615f,
  0.579699f,  -0.100392f, 0.150694f,  0.061794f,  0.200425f,  -0.062515f,
  -0.179122f, 0.250112f,  -0.344675f, -0.118359f, -0.095670f, 0.152311f,
  3.662276f,  -0.154921f, -0.312991f, 0.972008f,  -0.308596f, -0.190426f,
  0.133889f,  -0.238673f, -0.094726f, 1.683835f,  -0.215629f, -0.198890f,
  -0.035278f, -0.367973f, -0.822435f, 0.240848f,  -0.194656f, 0.034655f,
  -0.079424f, 0.146670f,  0.026646f,  -0.034507f, 0.059467f,  -0.153109f,
  -0.431033f, 2.552991f,  -1.894091f, -0.180462f, -0.306839f, -0.025648f,
  1.026326f,  -3.096230f, 1.346935f,  0.033633f,  -0.181827f, 0.094376f,
  0.001696f,  -0.379264f, -1.069503f, -0.140972f, -0.208769f, -0.195239f,
  0.281795f,  -0.127251f, 0.180776f,  0.067763f,  0.697124f,  -1.040779f,
  0.111280f,  0.188351f,  -0.340234f, -0.207790f, -0.720075f, -0.137409f,
  -0.070310f, -0.032918f, -0.060787f, 0.131484f,  -0.077845f, -0.258652f,
  0.056911f,  -0.062034f, 0.007663f,  -0.185100f, 1.340361f,  0.014096f,
  -0.124602f, 0.194241f,  0.128383f,  0.360465f,  0.082979f,  -0.050475f,
  -0.519294f, 3.323262f,  0.067014f,  0.221203f,  -0.085082f, -0.228606f,
  -0.916668f, -0.022643f, -1.386737f, -0.131902f, -0.349952f, -0.032874f,
  -0.189190f, -0.898790f, -0.102394f, -1.017387f, 2.214050f,  1.790253f,
  -1.913561f, -0.043716f, -0.214924f, -0.194598f, -0.064723f, -1.671793f,
  2.251166f,  -0.146007f, 0.138527f,  -0.003134f, 0.103665f,  0.006928f,
  -0.240253f, -0.227464f, 0.578437f,  -0.214724f, 0.503085f,  0.158093f,
  0.033091f,  0.008061f,  4.815371f,  2.132264f,  0.281850f,  -2.288560f,
  -0.145012f, 1.296832f,  -0.362401f, -0.403252f, 0.109873f,  0.185746f,
  0.244764f,  0.172367f,  -0.185588f, 0.139801f,  -0.178254f, 0.068629f,
  0.358488f,  -0.153969f, -6.433524f, 0.225983f,  -0.138123f, -0.095971f,
  -0.036089f, -1.400083f, 0.265908f,  0.257787f,  0.181144f,  -1.647228f,
  -0.136289f, -0.074206f, 0.122988f,  -0.088895f, -1.266717f, 0.006010f,
  0.536681f,  0.263061f,  -0.032207f, -0.155136f, 0.086431f,  0.441950f,
  -0.060755f, -0.280683f, -0.783475f, -2.567033f, 1.093221f,  0.117667f,
  -0.000408f, 0.225719f,  -2.199698f, 0.141447f,  -1.459051f, 0.051315f,
  0.203228f,  0.354432f,  -0.005775f, -0.028073f, -0.965817f, 0.231083f,
  -0.666884f, 0.026283f,  -0.317486f, 0.210754f,  0.123897f,  0.223827f,
  4.214405f,  1.457334f,  -0.253945f, -1.306733f, -0.391235f, 0.451154f,
  -1.553888f, -0.353429f, 0.069533f,  0.159278f,  -0.173836f, -0.004952f,
  -0.137033f, 0.127012f,  0.143600f,  0.051587f,  -0.070549f, 0.066509f,
  -5.776547f, 0.180021f,  -0.189183f, -1.288504f, -0.233575f, -1.473873f,
  0.140940f,  0.144451f,  -0.104534f, 2.089873f,  -0.168168f, 0.110726f,
  0.132134f,  -0.215223f, -1.682754f, 0.157757f,  -0.146163f, 0.064882f,
  0.117313f,  -0.038780f, -0.124720f, -0.501697f, 0.092047f,  -0.233992f,
  3.324976f,  0.516601f,  1.294202f,  0.119989f,  0.061055f,  0.043420f,
  -2.750727f, -0.382812f, -0.648496f, -0.115353f, -0.334205f, 0.024354f,
  -0.282998f, -0.282705f, 0.073798f,  0.169851f,  0.135651f,  0.182677f,
  -0.040220f, 0.132462f,  -0.303120f, -0.230113f, 6.165739f,  -0.258596f,
  0.024127f,  -1.388283f, -0.006042f, 0.572600f,  0.348411f,  -0.387376f,
  -0.075845f, 0.122319f,  -0.029616f, 0.077873f,  0.154763f,  0.049073f,
  0.018597f,  0.102688f,  -0.204165f, 0.020734f,  -1.389133f, -0.032854f,
  -0.147561f, 0.853944f,  0.132100f,  -3.259659f, 0.243745f,  0.181529f,
  -0.738414f, 1.509994f,  0.023470f,  -0.005329f, 0.066115f,  -1.345081f,
  -1.455402f, -0.172023f, -0.194625f, 0.071885f,  -0.201742f, -0.262402f,
  0.077601f,  -0.048938f, 0.257993f,  -0.504029f, -2.032415f, 1.158880f,
  0.448647f,  -0.025633f, 0.117586f,  -0.072275f, -0.673744f, -3.854342f,
  -0.983843f, 0.047766f,  -0.017193f, -0.215775f, -0.158743f, -0.232042f,
  -0.509112f, 0.148812f,  0.130122f,  0.006486f,  -0.099016f, 0.022514f,
  -0.486850f, -0.059623f, 4.012731f,  0.025454f,  0.029059f,  -0.783546f,
  -0.295260f, 0.322521f,  -0.473201f, -0.172100f, -0.100087f, -0.076516f,
  -0.258367f, -0.112897f, 0.269364f,  -0.065912f, 0.169022f,  -0.178783f,
  -0.095114f, 0.122089f,  -2.790099f, -0.100431f, -0.087963f, -0.009431f,
  -0.087819f, -2.774399f, -0.100757f, 0.013005f,  -0.964533f, 3.236665f,
  -0.354903f, -0.144169f, -0.166869f, -1.396513f, -0.931271f, -0.046261f,
  -1.799262f, -0.365269f, 0.108611f,  0.037994f,  0.024747f,  -1.073639f,
  -0.203158f, -0.935006f, 1.880891f,  1.578385f,  0.726272f,  -0.024546f,
  -0.011626f, -0.151363f, -1.121716f, -1.787484f, 0.232806f,  0.075451f,
  0.182899f,  0.092215f,  -0.207347f, -0.030111f, 0.054316f,  0.192481f,
  0.594639f,  -0.247694f, 0.547471f,  -0.032094f, -0.065000f, 0.007198f,
  1.605377f,  -0.155945f, -0.066200f, -2.343716f, -1.016283f, -0.079321f,
  0.919365f,  0.599980f,  0.125545f,  0.265813f,  0.246884f,  0.095385f,
  -0.260374f, -0.202916f, -0.042770f, 0.234967f,  -0.233139f, -0.326994f,
  -1.375256f, 0.121766f,  0.077433f,  -1.103569f, 0.019497f,  -1.029185f,
  0.253905f,  0.206569f,  0.187334f,  -0.237089f, -0.294351f, 0.164137f,
  0.149696f,  -0.749787f, -0.413433f, 0.976587f,  1.027976f,  -0.285264f,
  0.209273f,  -0.124762f, 0.050884f,  0.250764f,  -0.082031f, -0.646520f,
  4.116680f,  0.437336f,  0.671684f,  0.129509f,  -0.078462f, 0.014072f,
  -0.678232f, 0.094831f,  1.125624f,  0.207070f,  -0.154750f, -0.025780f,
  -0.103030f, 0.118019f,  -0.908186f, -0.263546f, -1.555324f, -0.236887f,
  -0.217854f, -0.051790f, 0.017915f,  0.171001f,  1.355562f,  0.094603f,
  -0.233929f, -1.282169f, -0.773183f, -0.161682f, -0.834565f, -0.286776f,
  -0.298901f, 0.038162f,  0.251899f,  0.039612f,  -0.022935f, -0.232308f,
  -0.043855f, -0.192892f, -0.279009f, -0.182234f, -1.272808f, -0.070344f,
  -0.092432f, -1.915946f, -0.134373f, -1.405496f, -0.067071f, -0.131922f,
  0.185269f,  1.465082f,  0.040240f,  0.112665f,  0.144329f,  -0.286112f,
  -0.617649f, 0.916177f,  0.221044f,  -0.079867f, 0.170251f,  -0.093638f,
  -0.212620f, -0.305945f, -0.234356f, -0.482501f, 3.928472f,  1.241179f,
  0.355922f,  -0.170848f, -0.189168f, 0.080225f,  -1.357793f, 0.190890f,
  0.976800f,  -0.068070f, -0.016295f, -0.088623f, -0.129560f, -0.212267f,
  -0.071537f, -0.219501f, -0.655198f, -0.225188f, -0.116024f, 0.224174f,
  -0.049715f, -0.178005f, 3.029985f,  -1.141546f, 0.080066f,  -1.932316f,
  -0.641137f, -0.189564f, 0.935080f,  0.136119f,  0.015558f,  -0.179331f,
  0.204571f,  0.020350f,  0.009362f,  0.108478f,  0.037076f,  -0.049009f,
  0.081090f,  -0.180202f, 1.455561f,  -0.081559f, 0.059361f,  0.484971f,
  0.160923f,  -2.170744f, -0.013204f, 0.126561f,  -0.407122f, 1.223661f,
  0.044262f,  0.118044f,  0.058274f,  -1.747100f, -0.171318f, 0.971374f,
  0.306995f,  -0.103268f, -0.319443f, -0.333176f, -0.038608f, 0.119674f,
  -0.106479f, -0.907933f, 1.121231f,  1.673840f,  -0.421458f, -0.021146f,
  -0.254838f, 0.097632f,  0.235109f,  -2.901782f, 0.289518f,  -0.355459f,
  -0.068264f, -0.179121f, 0.068560f,  -0.047570f, -0.522523f, -0.228963f,
  -1.037158f, -0.163723f, 0.280563f,  -0.000868f, -0.197220f, -0.239329f,
  1.985274f,  -0.256181f, -0.064341f, -0.822417f, -0.465140f, -0.010942f,
  -0.792024f, -0.114290f, 0.060969f,  0.104106f,  -0.252123f, -0.150400f,
  -0.133277f, 0.267147f,  0.274413f,  0.223744f,  -0.180223f, -0.345415f,
  -0.104883f, 0.119210f,  -0.095041f, -0.301635f, 0.013175f,  -2.128121f,
  -0.147208f, -0.151509f, -0.692013f, 3.418555f,  -0.016541f, 0.171511f,
  0.107159f,  -1.516672f, 0.127408f,  0.687035f,  -0.906486f, -0.145463f,
  -0.169382f, -0.143906f, 0.125091f,  -0.960645f, -0.180869f, -0.716908f,
  2.840951f,  1.904919f,  -0.416268f, -0.425181f, -0.194697f, -0.075932f,
  -0.950604f, -1.599800f, 0.943671f,  -0.022744f, -0.270492f, 0.080843f,
  -0.372916f, 0.047838f,  -0.100300f, -0.026600f, 0.011733f,  -0.226051f,
  0.172790f,  -0.172982f, 0.041258f,  -0.299379f,
};

static const float av1_ab_partition_nn_bias_16_layer1[LABEL_SIZE] = {
  -0.053805f, -1.248639f, 0.520965f, -0.904962f, -0.126425f, -0.118798f,
  0.748430f,  0.203096f,  0.059317f, 0.418219f,  0.841294f,  0.402693f,
  -0.658522f, 0.723479f,  0.544264f, 1.035225f,
};

static const NN_CONFIG av1_ab_partition_nnconfig_16 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      64,  // num_hidden_nodes
  },
  {
      av1_ab_partition_nn_weights_16_layer0,
      av1_ab_partition_nn_weights_16_layer1,
  },
  {
      av1_ab_partition_nn_bias_16_layer0,
      av1_ab_partition_nn_bias_16_layer1,
  },
};

#undef FEATURE_SIZE
#undef LABEL_SIZE

#define FEATURE_SIZE 18
#define LABEL_SIZE 4

static const float av1_4_partition_nn_weights_16_layer0[FEATURE_SIZE * 24] = {
  -2.032866f, 0.056691f,  0.495960f,  0.778785f,  0.548153f,  -0.806942f,
  0.481155f,  0.282298f,  0.584980f,  0.504688f,  0.209648f,  0.234616f,
  0.213484f,  0.221969f,  0.205862f,  0.235054f,  0.317863f,  0.257139f,
  0.529478f,  0.098122f,  -0.657532f, 0.036296f,  0.327728f,  1.323180f,
  -0.813082f, 0.160216f,  -0.702030f, 0.722733f,  -0.270576f, -0.347416f,
  -0.264700f, -0.254248f, 0.159820f,  0.087995f,  -0.184163f, 0.117357f,
  0.074194f,  -0.667369f, 0.498246f,  0.420506f,  0.072409f,  -0.121581f,
  0.315788f,  0.000525f,  0.414986f,  0.678166f,  -0.011230f, 0.188131f,
  -0.227749f, 0.009564f,  0.108672f,  0.106923f,  -0.080695f, -0.279382f,
  -0.061339f, -0.297835f, -0.134707f, 0.145865f,  -0.009655f, -0.000842f,
  -0.047436f, -0.159149f, -0.320353f, -0.089646f, -0.344765f, 0.313416f,
  -0.143413f, 0.279668f,  0.000885f,  -0.022380f, -0.140194f, -0.310473f,
  0.252699f,  0.066204f,  0.477568f,  0.994609f,  -0.276000f, 1.213182f,
  0.277028f,  -0.411570f, -0.211559f, 0.377815f,  0.121488f,  -0.100559f,
  -0.317082f, -0.251039f, -0.335181f, -0.154114f, -0.052726f, -0.332558f,
  -0.143196f, -0.334035f, 0.162305f,  0.142279f,  -0.001210f, -0.135252f,
  -0.033562f, 0.204307f,  -0.039757f, -0.394174f, 0.126617f,  -0.128648f,
  -0.410979f, 0.107641f,  -0.117573f, -0.326512f, 0.235166f,  0.084959f,
  0.290063f,  -0.005838f, 0.459894f,  1.023709f,  -0.196145f, 1.100137f,
  -0.319815f, -0.308526f, -0.443389f, -0.272769f, -0.035259f, -0.026932f,
  -0.029743f, 0.125113f,  -0.131024f, -0.321458f, -0.143996f, 0.008714f,
  -0.101234f, 0.079706f,  -1.128615f, -0.467381f, 0.220563f,  -0.409900f,
  -0.435353f, 0.759499f,  -0.465799f, -0.394309f, 0.176282f,  -0.086275f,
  -0.161225f, -0.354814f, 0.562871f,  0.418253f,  0.414361f,  0.445480f,
  -0.995903f, -0.086632f, -0.230645f, 0.354656f,  -0.317576f, 0.079926f,
  0.424369f,  0.997232f,  -0.304388f, 1.071667f,  -0.023540f, 0.029677f,
  0.108564f,  0.183581f,  -0.201395f, -0.054854f, -0.193039f, -0.049899f,
  -0.271949f, -0.358483f, 0.304930f,  0.023823f,  -0.009319f, -0.214247f,
  0.100712f,  -0.050162f, 0.327103f,  -0.212999f, -0.030496f, 0.316380f,
  -0.439589f, -0.249959f, 0.229777f,  -0.353664f, -0.384559f, 0.114236f,
  0.023119f,  0.007927f,  0.618368f,  0.957759f,  -0.019780f, -1.002389f,
  0.564277f,  -0.839531f, 1.040445f,  0.054340f,  0.031908f,  -0.032893f,
  -0.019170f, -0.042011f, 0.568928f,  0.362567f,  -0.559999f, -0.605344f,
  -0.586146f, -0.290778f, 0.195943f,  -0.109580f, -0.088898f, -0.113054f,
  0.293282f,  0.429019f,  0.306136f,  0.863025f,  0.021234f,  0.125770f,
  -0.097108f, -0.072659f, -0.137053f, -0.191631f, 0.106281f,  0.064151f,
  0.029883f,  0.076287f,  0.757543f,  0.276713f,  -2.529775f, -0.351727f,
  -1.832316f, 0.544780f,  -0.944529f, 0.509705f,  -0.010236f, -0.016181f,
  0.021520f,  0.086417f,  0.041312f,  0.296853f,  -0.372378f, 0.354446f,
  -1.366762f, 0.048875f,  0.464918f,  -0.007450f, 0.750013f,  -0.360261f,
  0.518532f,  0.753776f,  0.641448f,  0.710746f,  0.250866f,  0.257063f,
  0.283421f,  0.253585f,  0.170303f,  0.210426f,  0.208842f,  0.158000f,
  -0.033144f, 0.130748f,  0.907147f,  0.409248f,  -0.854301f, -0.981307f,
  0.294427f,  -0.507137f, 1.079967f,  0.203203f,  0.383890f,  0.368278f,
  0.305122f,  0.449288f,  -0.044507f, -0.547263f, -0.298245f, -0.497834f,
  0.007016f,  -0.101982f, -0.073488f, -0.096111f, -0.479418f, -0.045497f,
  0.033502f,  -0.018578f, -0.231531f, 0.177949f,  0.099564f,  -0.010233f,
  -0.333055f, -0.078586f, -0.417867f, 0.171271f,  0.013662f,  -0.143599f,
  -0.117296f, 0.135382f,  0.048321f,  0.000924f,  -0.055024f, -0.405595f,
  -0.068260f, -0.271011f, -0.436425f, 0.206751f,  -0.899890f, 0.605510f,
  0.535649f,  -0.238919f, -0.037619f, -0.213734f, -0.391360f, -0.132344f,
  0.004660f,  0.176644f,  -1.008475f, -0.038895f, 0.155429f,  -0.095229f,
  -0.680124f, -0.258063f, -0.261901f, 0.110380f,  -0.337649f, -0.505870f,
  -1.428536f, 0.610629f,  0.254905f,  0.045098f,  0.044109f,  0.172329f,
  0.060001f,  -0.234009f, -0.184855f, -0.153028f, -0.140897f, -0.152006f,
  -0.312134f, 0.081261f,  0.160166f,  0.112690f,  0.266081f,  0.030175f,
  -0.242746f, 0.000754f,  -0.341811f, -0.149774f, -0.017484f, -0.301342f,
  -0.121466f, 0.067300f,  0.342176f,  0.474538f,  0.085441f,  -0.263935f,
  0.479235f,  -0.003713f, -0.784840f, 0.119480f,  0.456632f,  -0.640082f,
  -0.080575f, -0.744403f, 0.259970f,  0.034667f,  -0.274641f, -0.257594f,
  -1.121124f, -0.003745f, -0.420693f, 0.300441f,  -0.100976f, -1.049016f,
  0.201960f,  0.113054f,  0.187010f,  1.237427f,  0.054803f,  -0.028673f,
  0.003596f,  -0.034724f, 0.117246f,  0.190977f,  0.278915f,  0.224307f,
  0.017852f,  -0.336233f, -0.372311f, -0.182284f, -0.143510f, 0.331466f,
  0.045698f,  -0.301095f, 0.184447f,  0.348240f,  -0.017021f, -0.145064f,
  -0.000221f, -0.382256f, -0.302683f, -0.083927f, -0.008070f, 0.217907f,
  0.647597f,  -0.050490f, -0.572736f, -0.985748f, -0.289943f, 0.041391f,
  -0.795464f, -0.186680f, -0.354062f, -0.617400f, -0.282783f, -0.170450f,
  -0.197197f, -0.146496f, -0.173692f, -0.106277f, -0.071004f, -0.124405f,
  -0.971412f, 0.038542f,  0.705204f,  0.887113f,  0.150430f,  -0.243676f,
  0.638410f,  0.320953f,  0.776676f,  0.527584f,  0.070389f,  0.051554f,
  0.177519f,  0.140451f,  0.128892f,  0.087771f,  0.197660f,  0.194764f,
};

static const float av1_4_partition_nn_bias_16_layer0[24] = {
  0.614063f,  -0.384872f, 0.084884f,  -0.023980f, -0.378765f, -0.082312f,
  -0.458271f, 0.189578f,  -0.046169f, -0.073308f, -0.372322f, 0.162793f,
  0.148803f,  0.829214f,  -0.221162f, -0.111157f, -0.017484f, -0.280596f,
  -0.031905f, -0.143459f, 0.078823f,  -0.021940f, 0.026834f,  0.257472f,
};

static const float av1_4_partition_nn_weights_16_layer1[24 * LABEL_SIZE] = {
  -0.985391f, 0.587616f,  0.740683f,  0.192066f,  0.447080f,  -0.016585f,
  0.680449f,  0.028983f,  0.643111f,  0.234338f,  0.107148f,  0.328456f,
  -0.216394f, 1.106838f,  -0.179062f, -0.129108f, -0.121655f, -0.151340f,
  -0.306017f, -0.350989f, 0.859284f,  -0.372831f, -0.954419f, 0.250495f,
  1.046732f,  0.287923f,  -0.421088f, 0.326613f,  -0.314396f, -0.084757f,
  -0.474228f, 0.687999f,  0.052334f,  0.441708f,  -0.630698f, -0.350348f,
  -0.602067f, -0.434161f, -0.489824f, -0.313193f, 0.315568f,  0.603119f,
  0.120245f,  0.182920f,  -1.117797f, -0.239594f, -0.296296f, -0.718093f,
  0.489497f,  -0.527019f, 0.102453f,  0.426731f,  0.034606f,  0.311461f,
  -0.012723f, -0.229877f, -0.284290f, 0.383227f,  0.065696f,  -0.222400f,
  1.279248f,  -0.862190f, 0.629766f,  -0.250011f, -0.325060f, -0.360115f,
  -0.159540f, -0.291856f, -0.038348f, 0.224639f,  0.600934f,  0.030205f,
  1.337615f,  -0.286409f, -0.473710f, -0.418995f, -1.035249f, 0.004359f,
  -0.481860f, 0.563625f,  -0.154709f, -0.101198f, -0.758796f, -0.507616f,
  -0.095253f, -0.711135f, 0.207759f,  0.076313f,  -0.056087f, -0.162719f,
  -0.232918f, -0.128402f, -0.444620f, -0.447344f, 1.126012f,  -1.504446f,
};

static const float av1_4_partition_nn_bias_16_layer1[LABEL_SIZE] = {
  -0.462133f,
  0.465060f,
  0.062211f,
  0.401786f,
};

static const NN_CONFIG av1_4_partition_nnconfig_16 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      24,  // num_hidden_nodes
  },
  {
      av1_4_partition_nn_weights_16_layer0,
      av1_4_partition_nn_weights_16_layer1,
  },
  {
      av1_4_partition_nn_bias_16_layer0,
      av1_4_partition_nn_bias_16_layer1,
  },
};

static const float av1_4_partition_nn_weights_32_layer0[FEATURE_SIZE * 32] = {
  -0.219494f, -0.428273f, 0.471006f,  0.448210f,  -0.152935f, 0.440435f,
  0.922857f,  -0.074436f, 1.002195f,  0.414176f,  -0.327202f, -0.380066f,
  -0.212346f, 0.061868f,  -0.056620f, 0.594134f,  0.617995f,  0.308358f,
  0.232484f,  0.129849f,  1.483593f,  -0.071460f, 1.984515f,  1.116422f,
  -1.141762f, -0.306220f, 0.089075f,  -0.271845f, 0.187524f,  0.050396f,
  -0.061025f, 0.030809f,  0.172799f,  -0.458151f, -0.318357f, 0.122052f,
  -0.414329f, 0.089366f,  0.118898f,  -0.376213f, -0.206151f, -0.519946f,
  -0.463252f, -0.206694f, -0.254383f, -0.379487f, 0.093059f,  -0.245280f,
  -0.205044f, -0.280060f, -0.171229f, -0.045389f, -0.179481f, -0.306245f,
  -0.500856f, 0.003388f,  -0.527397f, -0.449330f, -0.174272f, 0.123769f,
  0.023005f,  0.157273f,  0.073400f,  0.019099f,  -0.113848f, -0.098601f,
  -0.290946f, -0.046770f, -0.314592f, -0.179914f, -0.391411f, -0.235631f,
  -1.282604f, 0.048505f,  -0.746382f, 0.093740f,  -0.706583f, -0.085729f,
  0.947382f,  -0.002961f, 1.175362f,  1.007309f,  0.141638f,  -0.037608f,
  -0.118807f, -0.021474f, -0.146763f, 0.069363f,  -0.074372f, -0.215713f,
  -0.004134f, -0.114110f, -0.330438f, -0.031136f, 0.111821f,  -0.534598f,
  -0.357759f, -0.455950f, 0.139469f,  0.036582f,  -0.384743f, -0.168828f,
  -0.239250f, 0.003520f,  -0.049003f, 0.075702f,  -0.025809f, -0.225972f,
  -0.228905f, -0.412489f, 0.060570f,  -0.328819f, -0.206446f, -0.080231f,
  -0.372008f, -0.218118f, -0.011954f, 0.024155f,  0.156014f,  0.020679f,
  0.194398f,  -0.283491f, -0.024463f, -0.275099f, 0.028031f,  0.026340f,
  -0.254668f, 0.103637f,  2.178693f,  0.552284f,  0.109366f,  -0.474806f,
  -0.379286f, -0.026315f, 2.487924f,  -0.089466f, 0.206428f,  0.114578f,
  0.152248f,  0.184050f,  -0.631948f, -0.014793f, -0.283782f, -0.830353f,
  0.009343f,  -0.021029f, -0.060534f, -0.025164f, 1.841311f,  1.842748f,
  -1.979708f, 0.450985f,  -1.606357f, -0.785454f, -0.212679f, -0.344342f,
  0.198991f,  -0.258070f, 0.055974f,  0.224069f,  0.453051f,  0.408053f,
  0.027873f,  -0.180538f, 0.056609f,  0.207654f,  0.104086f,  -0.194426f,
  -0.359789f, -0.381143f, -0.331212f, -0.203973f, -0.324313f, -0.160825f,
  -0.160439f, -0.044856f, -0.346647f, 0.044859f,  0.231398f,  -0.023643f,
  -0.140316f, -0.260177f, 0.206965f,  -0.425386f, -0.420268f, -0.409748f,
  0.006971f,  0.066186f,  -0.034950f, -0.345518f, 0.018633f,  -0.122489f,
  -0.038506f, -0.330942f, 0.161236f,  -0.314119f, -0.050202f, -0.179597f,
  0.731897f,  -0.184481f, 0.153598f,  -0.539501f, -0.301493f, -0.184967f,
  -0.883754f, -0.586959f, -0.136292f, -1.772065f, -0.196276f, -0.053272f,
  -0.101083f, -0.064142f, 0.161190f,  0.430826f,  0.355647f,  0.138266f,
  0.051114f,  -0.028893f, -0.477673f, -0.238663f, -0.354117f, -0.056747f,
  -0.334273f, -0.497688f, -0.486004f, -0.092033f, -0.241304f, -0.373250f,
  0.120193f,  0.011360f,  -0.010475f, -0.092739f, -0.159650f, -0.033129f,
  -0.259893f, -0.073217f, 0.200128f,  0.103407f,  -0.229233f, 0.128831f,
  -0.063450f, -0.241732f, -0.408428f, -0.342239f, -0.264326f, -0.105403f,
  -0.442879f, -0.310456f, -0.112881f, 0.263696f,  -0.205014f, -0.497936f,
  -0.261734f, -0.382312f, -0.426807f, -0.021995f, -0.152794f, -0.301494f,
  0.117232f,  -0.577809f, 0.154596f,  -0.409522f, -0.413113f, -0.359199f,
  0.307294f,  -0.008746f, -0.310522f, 0.347620f,  -0.384845f, -0.451398f,
  -0.226199f, 0.054154f,  -0.167608f, 0.046836f,  -0.013285f, -0.408119f,
  -0.177973f, -0.248293f, -0.465830f, 0.035827f,  -0.222208f, -0.221717f,
  0.066392f,  -0.349769f, -0.428029f, -0.516692f, 0.022398f,  -0.251682f,
  0.134746f,  0.011167f,  -2.078787f, 0.173592f,  -1.948348f, 0.330060f,
  1.993785f,  -0.052859f, -0.004795f, -3.703177f, 0.013450f,  -0.011687f,
  0.073079f,  0.034803f,  0.025515f,  0.005994f,  0.101731f,  0.074303f,
  -0.109962f, -0.270825f, -0.068273f, -0.163268f, -0.252826f, 0.137190f,
  0.007667f,  -0.358453f, 0.027412f,  0.033492f,  0.021197f,  -0.049991f,
  0.104468f,  -0.012157f, -0.056252f, -0.380756f, -0.338483f, 0.233235f,
  -0.048631f, -0.441209f, -0.158482f, -0.148108f, -0.263453f, 0.138847f,
  -0.304073f, -0.336312f, -0.017941f, -0.135563f, 0.075137f,  -0.246475f,
  -0.229144f, -0.087744f, -0.346909f, 0.172611f,  0.004377f,  -0.009386f,
  -0.023104f, 0.008000f,  -0.029390f, -0.317842f, 0.549674f,  -0.195337f,
  -0.863979f, 0.160889f,  -0.269014f, -0.442104f, -1.799191f, 1.396533f,
  -0.112837f, 0.881303f,  0.000764f,  -0.035415f, -0.141877f, 0.184831f,
  -0.363566f, -0.178569f, 0.254134f,  -0.326893f, 0.127325f,  0.310620f,
  -0.384621f, 0.146058f,  -0.287682f, -0.373447f, 0.026930f,  0.251650f,
  0.053817f,  0.227509f,  0.121396f,  0.396514f,  -0.278381f, -0.038969f,
  -1.538756f, -0.002856f, -0.892900f, 0.363426f,  -1.257922f, 0.743795f,
  0.941177f,  0.219345f,  0.684189f,  1.396858f,  0.026299f,  -0.093433f,
  -0.066182f, 0.057868f,  -0.089278f, -0.159680f, -0.262035f, -0.236656f,
  0.005349f,  -0.031314f, 0.027917f,  -0.182113f, -0.212086f, -0.160774f,
  0.051468f,  0.036787f,  0.183881f,  -0.288205f, -0.349691f, 0.162511f,
  0.117878f,  -0.294534f, -0.365037f, -0.246313f, 0.073977f,  -0.072378f,
  -0.173579f, -0.584560f, 0.547194f,  0.259853f,  -0.405287f, -0.421146f,
  0.165788f,  -0.146964f, 0.257415f,  0.772394f,  -0.475302f, -0.310906f,
  0.058723f,  0.276833f,  0.586842f,  0.248998f,  -0.061135f, 0.255779f,
  0.152158f,  -0.024781f, 2.821834f,  1.365141f,  0.914744f,  0.165752f,
  -1.048304f, -0.333891f, 1.804087f,  -0.437028f, -0.120211f, -0.020443f,
  0.040077f,  0.258600f,  -0.598893f, -0.494579f, -0.281054f, -0.517041f,
  0.005258f,  0.053986f,  0.322755f,  0.429495f,  -1.992364f, -0.717192f,
  -1.774802f, 2.047362f,  -0.016194f, 0.312606f,  0.019331f,  0.060950f,
  0.116428f,  0.168458f,  -0.307001f, -0.420734f, 0.475843f,  0.425346f,
  -0.107119f, 0.049892f,  -1.168619f, 0.010878f,  0.354872f,  0.902717f,
  -0.391407f, 0.332772f,  -1.335037f, -0.447100f, 0.481719f,  -0.101069f,
  -1.806565f, 0.925280f,  0.346999f,  0.093809f,  0.006275f,  0.270814f,
  -0.691123f, 0.230748f,  0.137033f,  0.068228f,  1.555975f,  -0.271637f,
  -0.370403f, 0.236131f,  0.367464f,  -0.136562f, 0.428838f,  0.181750f,
  0.338762f,  0.292449f,  -0.748204f, -0.922731f, -0.959445f, -0.806418f,
  -0.140501f, 0.070525f,  1.248748f,  0.637990f,  -1.307246f, -0.514055f,
  0.393858f,  -1.858727f, 0.713591f,  -0.141044f, 0.080723f,  0.120220f,
  -0.031175f, 0.224488f,  0.753818f,  -0.833351f, -1.099132f, 0.651100f,
  -0.135061f, -0.043820f, 0.026983f,  -0.059259f, 0.001345f,  -0.281775f,
  0.006958f,  0.046103f,  -0.246539f, 0.057630f,  -0.360778f, -0.160681f,
  -0.414870f, -0.301979f, 0.000683f,  0.132957f,  -0.477609f, 0.106110f,
  -0.637769f, -0.078374f, -0.229494f, 0.583108f,  -0.822973f, -0.107540f,
  1.063426f,  -0.268346f, 1.105787f,  2.587550f,  -0.020314f, -0.002161f,
  -0.063836f, -0.099990f, -0.103975f, -0.114078f, -0.094199f, -0.065181f,
  -0.019870f, -0.018920f, -0.219732f, 0.035608f,  -1.789450f, 0.483032f,
  -0.464729f, 1.563277f,  -1.054195f, 0.359991f,  0.065204f,  0.135623f,
  0.158380f,  -0.103815f, -1.398726f, -1.436666f, -0.356311f, 0.507752f,
};

static const float av1_4_partition_nn_bias_32_layer0[32] = {
  0.421645f,  -0.620548f, -0.187819f, -0.189414f, -0.204975f, -0.189600f,
  -0.174917f, -0.651928f, -0.799655f, -0.086105f, -0.163449f, -0.089212f,
  -0.214495f, -0.108500f, -0.065777f, -0.127704f, 1.544948f,  -0.032831f,
  -0.165621f, 0.145844f,  -0.032104f, -0.453246f, -0.113444f, 0.321589f,
  -0.862375f, -0.108826f, -0.486259f, 0.685325f,  0.072569f,  -0.187961f,
  0.109579f,  -0.082685f,
};

static const float av1_4_partition_nn_weights_32_layer1[32 * LABEL_SIZE] = {
  0.255012f,  0.658860f,  0.216907f,  0.165947f,  0.241182f,  0.340854f,
  0.409445f,  0.165220f,  0.553373f,  -0.242385f, -0.209571f, 0.255515f,
  0.222500f,  0.037032f,  0.238590f,  0.061624f,  -2.038693f, 0.264167f,
  -0.230144f, 0.129952f,  -0.027979f, 0.847761f,  0.438922f,  0.462323f,
  0.555345f,  0.030689f,  0.336357f,  -0.357326f, -0.113137f, 0.272631f,
  0.421022f,  0.367776f,  -0.197094f, 0.157117f,  -0.015008f, -0.056123f,
  -0.283913f, 0.186417f,  0.178561f,  -0.763041f, 0.602038f,  0.341092f,
  0.320453f,  -0.312776f, -0.371240f, -0.356279f, 0.220117f,  -0.131871f,
  1.517429f,  0.162223f,  -0.255069f, 0.451861f,  0.045071f,  -0.223257f,
  0.003257f,  0.015734f,  -0.630447f, -0.672588f, 0.670164f,  0.571031f,
  -0.657948f, 0.034506f,  -0.249076f, 0.790293f,  0.066491f,  -0.131245f,
  0.355173f,  0.564622f,  0.374048f,  0.033974f,  0.253970f,  0.495498f,
  -0.556321f, -0.104651f, 0.276947f,  0.057148f,  -0.039126f, -0.170050f,
  -0.141542f, 0.158541f,  0.582763f,  -0.100992f, 0.096705f,  -0.209029f,
  0.008449f,  0.255865f,  0.103565f,  0.317719f,  0.479499f,  0.599126f,
  -0.065613f, -0.268614f, 0.508736f,  0.180813f,  -0.815868f, 0.051238f,
  0.001223f,  -0.305423f, -0.270079f, 0.036180f,  0.304342f,  0.202634f,
  0.218348f,  -0.304304f, -0.438297f, 0.241123f,  0.200230f,  0.151804f,
  0.051944f,  0.160422f,  -0.262981f, -0.417412f, 1.845729f,  -0.086183f,
  0.403517f,  0.059667f,  0.564543f,  -0.081752f, 0.114907f,  -0.284489f,
  -0.673943f, 0.056965f,  0.362221f,  0.403224f,  -0.000233f, -0.209552f,
  -0.800926f, -0.134132f,
};

static const float av1_4_partition_nn_bias_32_layer1[LABEL_SIZE] = {
  -0.019518f,
  0.198546f,
  0.339015f,
  -0.261961f,
};

static const NN_CONFIG av1_4_partition_nnconfig_32 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      32,  // num_hidden_nodes
  },
  {
      av1_4_partition_nn_weights_32_layer0,
      av1_4_partition_nn_weights_32_layer1,
  },
  {
      av1_4_partition_nn_bias_32_layer0,
      av1_4_partition_nn_bias_32_layer1,
  },
};

static const float av1_4_partition_nn_weights_64_layer0[FEATURE_SIZE * 24] = {
  -0.152649f, 0.074509f,  1.000136f,  0.601661f,  -1.416694f, -1.932396f,
  -1.163850f, 0.640931f,  -0.888625f, -0.345711f, 0.161799f,  0.103165f,
  0.147513f,  0.089956f,  0.204329f,  0.196922f,  0.014927f,  0.283714f,
  -0.110422f, 0.062005f,  -0.531870f, -0.075287f, -0.448349f, -0.218881f,
  -0.005592f, -0.130490f, -0.015779f, 0.093521f,  -0.158487f, 0.072241f,
  0.066879f,  -0.418566f, -0.206281f, 0.025634f,  0.048334f,  -0.534750f,
  0.302081f,  0.028707f,  -1.543248f, 0.103799f,  -1.214052f, 0.395870f,
  0.394754f,  -0.272170f, -0.702953f, -4.057464f, -0.033497f, -0.042142f,
  0.014742f,  0.065263f,  0.000879f,  -0.019768f, 0.101275f,  0.163059f,
  -0.371392f, -0.283484f, 0.241915f,  0.012684f,  -0.210101f, -0.166534f,
  -0.024894f, 0.274696f,  0.098993f,  0.104086f,  0.055044f,  -0.289378f,
  0.146571f,  -0.147441f, 0.004056f,  0.112244f,  -0.416162f, -0.033176f,
  -0.214836f, -0.213787f, 0.023197f,  -0.339043f, 0.301109f,  -0.408551f,
  0.284922f,  -0.344418f, -0.039255f, 0.158748f,  -0.344169f, 0.078286f,
  -0.043957f, -0.302162f, -0.310826f, 0.063425f,  0.198166f,  -0.285324f,
  -0.108252f, 0.038992f,  -1.053110f, -1.663290f, -0.417185f, 1.504443f,
  0.643206f,  -0.850240f, 0.889641f,  -0.733214f, 0.147302f,  0.060291f,
  -0.052954f, 0.167453f,  0.111870f,  0.085471f,  0.035107f,  0.064361f,
  0.176053f,  0.184373f,  0.676576f,  0.066164f,  1.455569f,  0.925111f,
  -0.640845f, 0.803795f,  -0.653782f, -0.201038f, 0.060033f,  0.016964f,
  -0.047590f, 0.045908f,  0.354162f,  0.014812f,  0.156978f,  0.058792f,
  -0.238119f, 0.002450f,  -0.094388f, -0.155229f, 0.194858f,  -0.355429f,
  -0.187098f, -0.119264f, -0.088694f, -0.102845f, 0.184905f,  -0.425339f,
  -0.157808f, -0.104599f, -0.393248f, -0.379842f, 0.027741f,  -0.185816f,
  -0.317294f, 0.002453f,  -0.498241f, -0.204302f, -0.079093f, 0.020646f,
  -0.412850f, -0.426039f, -0.177050f, -0.419304f, -0.064478f, -0.191802f,
  -0.146812f, 0.171111f,  0.090261f,  -0.367033f, -0.299051f, -0.322132f,
  0.428192f,  -0.252613f, 0.488498f,  -0.559682f, 0.486720f,  -0.511084f,
  0.992506f,  0.346765f,  -0.118697f, -0.065127f, -0.376612f, -0.345137f,
  -0.426517f, -0.516836f, 0.307083f,  0.609362f,  0.369555f,  0.093775f,
  -0.375664f, -0.221595f, -0.025465f, 0.134374f,  -0.387031f, 0.096236f,
  0.337465f,  -0.124029f, -0.157340f, -0.368790f, -0.104490f, -0.279507f,
  -0.247705f, 0.146559f,  -0.236206f, -0.036073f, 0.064206f,  -0.330919f,
  0.516591f,  -0.013492f, 1.269568f,  1.182530f,  -0.455390f, -1.328091f,
  -0.200950f, -0.380513f, -0.195532f, -0.341479f, 0.016064f,  0.021176f,
  0.169119f,  0.103707f,  -0.174504f, -0.462719f, -0.079445f, -0.247128f,
  0.459111f,  0.036129f,  0.769570f,  -0.080405f, 1.667107f,  0.355567f,
  -2.433896f, 0.627572f,  -0.600090f, -0.651872f, -0.059769f, -0.041945f,
  -0.009933f, 0.014864f,  -0.049378f, -0.041561f, 0.075180f,  0.138307f,
  0.122366f,  -0.160756f, 0.215327f,  0.013572f,  0.198194f,  -0.762650f,
  0.054466f,  1.110332f,  1.692853f,  0.658654f,  -0.409549f, 0.506085f,
  0.330962f,  -0.223008f, 0.007448f,  -0.289062f, -0.476231f, -0.228359f,
  0.013977f,  -0.000609f, -0.673604f, 0.275996f,  0.405291f,  1.693561f,
  -1.079768f, 1.122516f,  -0.203227f, 0.099265f,  -0.165207f, -0.323899f,
  -0.269973f, -0.080122f, 0.127700f,  0.190201f,  0.219527f,  0.306194f,
  0.026049f,  -0.003779f, 1.107357f,  1.720315f,  1.017908f,  0.078664f,
  -1.599813f, -0.482636f, -0.117450f, 0.122249f,  0.030220f,  0.039794f,
  0.176350f,  0.129715f,  -0.305755f, -0.274044f, -0.299640f, -0.187335f,
  -0.073616f, -0.564507f, -0.127758f, 0.044855f,  -0.191090f, 0.039095f,
  0.115378f,  0.969352f,  -0.088360f, 0.301443f,  0.065726f,  -0.019740f,
  -0.102350f, -0.084913f, -0.194615f, 0.118582f,  0.920789f,  -0.171615f,
  -1.436553f, -0.026419f, -0.730864f, 0.615697f,  -0.795079f, 0.119701f,
  0.601782f,  0.792902f,  0.184920f,  1.635090f,  -0.085860f, -0.033187f,
  -0.166883f, 0.008487f,  -0.128300f, -0.089923f, -0.108781f, -0.133719f,
  -0.011988f, -0.239816f, -0.092563f, -0.238471f, -0.339722f, 0.177432f,
  -0.063101f, -0.121002f, 0.058072f,  -0.031166f, 0.086413f,  -0.016203f,
  -0.305075f, -0.005420f, -0.168796f, 0.148745f,  -0.116737f, -0.050222f,
  -0.287952f, -0.290982f, -0.090449f, 0.076098f,  -0.345632f, -0.061309f,
  0.142218f,  0.035692f,  0.304517f,  -0.228031f, 0.119608f,  -0.120350f,
  0.163404f,  -0.105605f, -0.305462f, -0.176657f, 0.210070f,  -0.227600f,
  -0.081965f, -0.464027f, -0.053782f, -0.018367f, 0.119159f,  0.017162f,
  -0.069792f, 0.305768f,  -0.421095f, 0.187740f,  -0.032059f, 0.575115f,
  -0.064283f, -0.091828f, 0.772648f,  -0.393189f, -0.297098f, 0.141420f,
  0.826389f,  -0.071586f, -0.893968f, -0.346793f, -1.151655f, 0.039393f,
  1.546000f,  -0.094029f, -0.005786f, -0.195764f, -0.169724f, -0.133167f,
  -0.129312f, -0.418860f, -0.026553f, -0.053667f, -0.091976f, -0.106275f,
  -0.492625f, 0.025350f,  -0.332075f, -0.475638f, -0.076667f, -0.065779f,
  0.108957f,  0.246298f,  -0.289007f, -0.442552f, -0.206692f, -0.257453f,
  0.073806f,  -0.458606f, -0.410390f, -0.312674f, -0.144813f, 0.170128f,
  0.018810f,  -0.098241f, 1.027369f,  0.479328f,  1.129707f,  0.484813f,
  -0.085207f, 0.621873f,  -0.520981f, 0.236175f,  0.273487f,  0.061426f,
  0.306085f,  0.161487f,  0.220991f,  0.223783f,  -0.091826f, 0.391031f,
};

static const float av1_4_partition_nn_bias_64_layer0[24] = {
  0.580225f,  -0.191304f, 1.091767f,  -0.134522f, -0.089361f, 0.398750f,
  -0.882708f, -0.213102f, -0.119981f, 0.378296f,  -0.075719f, 0.426598f,
  -2.015505f, 0.202534f,  -1.044792f, -0.841519f, 0.266421f,  -0.047115f,
  -0.131147f, -0.075066f, -0.009441f, 0.853007f,  -0.175606f, -0.868306f,
};

static const float av1_4_partition_nn_weights_64_layer1[24 * LABEL_SIZE] = {
  -0.851937f, -0.211148f, -2.289513f, -0.275071f, 0.251340f,  -0.340847f,
  0.498032f,  0.308652f,  -0.051574f, 0.323146f,  -0.097547f, -0.040269f,
  1.909655f,  0.098348f,  0.588136f,  0.568112f,  0.313297f,  0.920848f,
  -0.014486f, 0.386014f,  0.029199f,  -0.537330f, -0.021502f, 0.349073f,
  -0.524715f, -0.351848f, 1.565454f,  -0.297148f, 0.020177f,  0.648369f,
  0.027321f,  -0.096052f, -0.363163f, -0.132642f, 0.024292f,  -0.734176f,
  -0.782700f, 0.408299f,  0.476945f,  -0.489512f, -0.728318f, -0.632042f,
  0.405417f,  0.184086f,  -0.400730f, 0.359032f,  0.019710f,  -0.217409f,
  0.519159f,  -0.136316f, 0.993592f,  -0.147128f, 0.097495f,  0.426189f,
  -0.295233f, 0.278799f,  0.080667f,  -0.025052f, -0.307757f, 0.418716f,
  -0.853388f, -0.374878f, -0.322725f, 0.696335f,  -0.380649f, -0.160356f,
  -0.140060f, 0.502455f,  0.656728f,  -0.095023f, -0.184198f, -0.347069f,
  0.456372f,  -0.029754f, 0.907923f,  0.265710f,  -0.065505f, 0.226763f,
  -0.277798f, 0.413292f,  -0.593899f, -0.060740f, -0.313358f, -0.249944f,
  -0.627329f, -0.327151f, -0.853788f, -1.163807f, -0.388944f, -0.228788f,
  -0.057382f, 0.334741f,  -0.283083f, 0.368280f,  -0.407197f, -0.441849f,
};

static const float av1_4_partition_nn_bias_64_layer1[LABEL_SIZE] = {
  -0.478735f,
  0.292948f,
  0.293172f,
  0.040013f,
};

static const NN_CONFIG av1_4_partition_nnconfig_64 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      24,  // num_hidden_nodes
  },
  {
      av1_4_partition_nn_weights_64_layer0,
      av1_4_partition_nn_weights_64_layer1,
  },
  {
      av1_4_partition_nn_bias_64_layer0,
      av1_4_partition_nn_bias_64_layer1,
  },
};

#undef FEATURE_SIZE
#undef LABEL_SIZE

#define FEATURE_SIZE 4
static const float
    av1_partition_breakout_nn_weights_128_layer0[FEATURE_SIZE * 32] = {
      -0.331785f,  0.068675f,  -0.323814f,  0.033714f,  -0.237835f, 0.166316f,
      -0.498766f,  -0.545634f, -0.266173f,  -0.476957f, -0.120409f, -0.021042f,
      0.124056f,   -0.278750f, -0.110120f,  -0.372812f, 4.547939f,  0.097618f,
      -0.002710f,  -0.064169f, -1.841173f,  -0.403833f, 0.005536f,  0.067188f,
      -0.434935f,  -0.227421f, -0.000011f,  -0.139961f, -0.174056f, -0.652384f,
      -0.000015f,  -0.262847f, -3.319706f,  -0.947693f, 0.002981f,  0.016717f,
      -10.408850f, -0.014568f, -0.000018f,  0.019084f,  1.523383f,  0.074525f,
      -0.002076f,  -0.020734f, 4.881495f,   0.002799f,  0.000342f,  -0.019623f,
      1.786154f,   0.037462f,  -0.019037f,  0.052833f,  11.408153f, -0.044602f,
      0.026155f,   -0.518627f, -0.474499f,  -0.427430f, -0.442733f, -0.011116f,
      -22.379410f, -0.000549f, -0.001418f,  0.008090f,  -0.295090f, -0.230268f,
      -0.337278f,  -0.001127f, -0.644282f,  -0.598783f, -0.539417f, -0.003303f,
      9.189824f,   0.038066f,  -0.004097f,  -0.460045f, -0.308858f, -0.242691f,
      -0.230835f,  -0.273057f, 0.152226f,   0.179239f,  -0.146382f, -0.004655f,
      -0.242940f,  -0.718862f, -0.001685f,  -0.214736f, 3.263186f,  0.079463f,
      -0.003854f,  -0.187461f, -0.599144f,  -0.419808f, -0.000597f, -0.136980f,
      0.184813f,   -0.319525f, -0.007246f,  0.079709f,  -0.883229f, -0.343748f,
      -0.000077f,  -0.172214f, -0.548759f,  -0.194674f, -0.144786f, 0.043896f,
      -0.176364f,  -0.248394f, -0.090215f,  -0.294743f, -0.280980f, -0.181436f,
      -0.115681f,  -0.071915f, -13.035494f, -0.075623f, 0.017052f,  -0.171152f,
      5.910803f,   0.128344f,  0.010256f,   -1.073301f, 2.387826f,  0.166183f,
      -0.007193f,  -0.257836f,
    };

static const float av1_partition_breakout_nn_bias_128_layer0[32] = {
  0.115591f,  -0.100178f, -0.165523f, -0.122997f, 11.045759f,  1.034761f,
  -0.323672f, -0.189087f, 2.850950f,  7.010029f,  -21.447067f, 1.877031f,
  0.437442f,  5.929414f,  -0.117274f, 4.462253f,  -0.135198f,  -0.145927f,
  8.727211f,  0.000000f,  -3.532987f, -0.405898f, 11.364439f,  -0.141728f,
  -5.994947f, -0.362574f, 1.857687f,  -0.100400f, -0.130312f,  0.006080f,
  0.429660f,  -8.439470f,
};

static const float av1_partition_breakout_nn_weights_128_layer1[32] = {
  -0.013738f, 0.022052f,  -0.074437f, -0.211377f, -0.080433f, 0.015543f,
  0.002091f,  0.014252f,  0.134834f,  0.190263f,  0.244175f,  -0.031747f,
  0.020068f,  -0.068326f, 0.185471f,  0.660268f,  -0.134898f, -0.010376f,
  -0.276023f, -0.282921f, -0.022769f, 0.007070f,  -0.186235f, 0.024407f,
  -0.024837f, 0.005764f,  0.016599f,  -0.040077f, 0.020990f,  0.095054f,
  -0.039662f, 0.131499f,
};

static const float av1_partition_breakout_nn_bias_128_layer1[1] = {
  0.86678213f,
};

static const NN_CONFIG av1_partition_breakout_nnconfig_128 = {
  FEATURE_SIZE,  // num_inputs
  1,             // num_outputs
  1,             // num_hidden_layers
  {
      32,  // num_hidden_nodes
  },
  {
      av1_partition_breakout_nn_weights_128_layer0,
      av1_partition_breakout_nn_weights_128_layer1,
  },
  {
      av1_partition_breakout_nn_bias_128_layer0,
      av1_partition_breakout_nn_bias_128_layer1,
  },
};

static const float
    av1_partition_breakout_nn_weights_64_layer0[FEATURE_SIZE * 16] = {
      0.872892f,  -0.235539f, -0.412159f, -0.142533f, -2.251479f, -0.057073f,
      -0.001373f, 0.112147f,  5.281734f,  0.060704f,  0.000838f,  -0.961554f,
      0.244995f,  0.154515f,  -0.292654f, -0.167177f, -3.759112f, -0.486347f,
      0.003208f,  -0.418226f, 2.618152f,  0.026832f,  0.003988f,  -0.404406f,
      -0.405434f, 0.102791f,  -0.033406f, -0.029820f, -4.492342f, -0.154291f,
      0.012947f,  -0.195075f, 0.009311f,  -0.411410f, -0.010986f, -0.554822f,
      0.160576f,  0.020796f,  -0.457230f, -0.191111f, -7.759542f, -0.065039f,
      -0.001322f, 0.055691f,  0.291924f,  -0.053076f, -0.148379f, -0.298383f,
      1.022023f,  -0.033668f, -0.000804f, -0.825778f, -3.902254f, -0.085812f,
      -0.052520f, -0.035012f, -0.465468f, -0.319231f, -0.497529f, -0.183068f,
      -2.407131f, -0.062304f, 0.000874f,  0.108786f,
    };

static const float av1_partition_breakout_nn_bias_64_layer0[16] = {
  0.081425f,  -14.404084f, 11.511393f, -0.930053f, 1.841889f,  15.020920f,
  -1.872288f, 5.392535f,   -0.329335f, -0.005358f, 12.600776f, 0.000000f,
  -0.337413f, 4.492778f,   0.000000f,  17.043072f,
};

static const float av1_partition_breakout_nn_weights_64_layer1[16] = {
  -0.465338f, -0.103023f, -0.174808f, -0.005156f, -0.016366f, -0.172494f,
  0.014185f,  0.067030f,  -0.001939f, -0.175049f, 0.245992f,  -0.181660f,
  -0.038572f, 0.307899f,  -0.294283f, 0.118323f,
};

static const float av1_partition_breakout_nn_bias_64_layer1[1] = {
  -1.33438122f,
};

static const NN_CONFIG av1_partition_breakout_nnconfig_64 = {
  FEATURE_SIZE,  // num_inputs
  1,             // num_outputs
  1,             // num_hidden_layers
  {
      16,  // num_hidden_nodes
  },
  {
      av1_partition_breakout_nn_weights_64_layer0,
      av1_partition_breakout_nn_weights_64_layer1,
  },
  {
      av1_partition_breakout_nn_bias_64_layer0,
      av1_partition_breakout_nn_bias_64_layer1,
  },
};

static const float
    av1_partition_breakout_nn_weights_32_layer0[FEATURE_SIZE * 16] = {
      -4.825528f, -0.145737f, 0.001907f,  0.145415f,  -1.858153f, -0.080744f,
      0.000601f,  0.211991f,  0.384265f,  -0.043945f, -0.521332f, -0.170622f,
      -0.046866f, -0.600506f, -0.001216f, -0.332760f, -0.447677f, -0.605844f,
      -0.121008f, -0.119936f, -0.215739f, -0.269665f, -0.668587f, 0.071318f,
      -1.202551f, -0.729727f, -0.370084f, 0.088215f,  -1.926800f, -0.086519f,
      0.000359f,  0.215120f,  0.718749f,  0.022942f,  0.003840f,  -0.176518f,
      1.213451f,  0.080786f,  0.001557f,  -1.053430f, 0.202698f,  -0.583919f,
      -0.535512f, -0.239927f, -0.110151f, -0.128832f, -0.441087f, -0.145575f,
      -0.178518f, -0.585784f, 0.000029f,  -0.833014f, -0.331358f, -0.520297f,
      -0.088676f, -0.178487f, -1.430755f, 0.022981f,  -0.106931f, 0.015573f,
      -0.520814f, -0.045386f, -0.443123f, -0.484209f,
    };

static const float av1_partition_breakout_nn_bias_32_layer0[16] = {
  11.747026f, -9.337718f, 0.341648f, -0.155847f, -0.104005f, 4.666283f,
  6.669584f,  16.625504f, 9.885626f, 15.439183f, -0.346080f, 0.000000f,
  -0.423808f, 0.000000f,  6.352258f, -0.155787f,
};

static const float av1_partition_breakout_nn_weights_32_layer1[16] = {
  0.168561f,  -0.122519f, 0.524667f,  0.032474f,  0.059097f,  0.011900f,
  0.166445f,  0.127256f,  -0.034838f, -0.212586f, -0.317973f, 0.348419f,
  -0.004171f, 0.157694f,  0.117845f,  0.272115f,
};

static const float av1_partition_breakout_nn_bias_32_layer1[1] = {
  0.09049262f,
};

static const NN_CONFIG av1_partition_breakout_nnconfig_32 = {
  FEATURE_SIZE,  // num_inputs
  1,             // num_outputs
  1,             // num_hidden_layers
  {
      16,  // num_hidden_nodes
  },
  {
      av1_partition_breakout_nn_weights_32_layer0,
      av1_partition_breakout_nn_weights_32_layer1,
  },
  {
      av1_partition_breakout_nn_bias_32_layer0,
      av1_partition_breakout_nn_bias_32_layer1,
  },
};

static const float
    av1_partition_breakout_nn_weights_16_layer0[FEATURE_SIZE * 16] = {
      0.209371f,  0.028758f,  0.005764f,  -0.384401f, -0.625777f, -0.005647f,
      -0.316867f, 0.042985f,  0.127344f,  0.025461f,  0.011465f,  -0.071043f,
      -0.295977f, -0.076093f, -0.209681f, -0.311653f, -0.147538f, 0.009910f,
      -0.130997f, -0.012326f, 0.024124f,  -0.323578f, -0.005790f, -0.085664f,
      -1.575066f, -0.119221f, 0.015018f,  0.187204f,  0.238117f,  0.084924f,
      -0.004444f, -1.271538f, -0.709860f, -0.006226f, -0.903111f, 0.090573f,
      -0.278642f, -0.011114f, 0.021162f,  0.081290f,  -0.467486f, -0.040771f,
      -0.224069f, -0.714390f, -0.281905f, -0.001336f, -0.761212f, -0.060385f,
      -0.814479f, -0.050450f, -0.003666f, 0.085668f,  -0.272589f, 0.057330f,
      -0.206540f, -0.303418f, 0.075335f,  -0.180468f, -0.064872f, -0.755948f,
      -0.509287f, -0.048877f, -0.001512f, 0.077086f,
    };

static const float av1_partition_breakout_nn_bias_16_layer0[16] = {
  16.421495f, 4.012273f,  -1.828571f, 0.000000f,  -0.263564f, -0.201972f,
  6.564987f,  14.651000f, -3.227779f, 2.241833f,  -0.137116f, 0.762876f,
  5.625762f,  0.615822f,  0.040057f,  16.668884f,
};

static const float av1_partition_breakout_nn_weights_16_layer1[16] = {
  -0.096440f, 0.184316f,  -0.021148f, 0.424974f, 0.003743f,  0.006310f,
  0.046266f,  -0.219224f, -0.087004f, 0.024623f, -0.275798f, 0.120164f,
  0.269773f,  -0.021105f, -0.146698f, 0.188764f,
};

static const float av1_partition_breakout_nn_bias_16_layer1[1] = {
  1.60751927f,
};

static const NN_CONFIG av1_partition_breakout_nnconfig_16 = {
  FEATURE_SIZE,  // num_inputs
  1,             // num_outputs
  1,             // num_hidden_layers
  {
      16,  // num_hidden_nodes
  },
  {
      av1_partition_breakout_nn_weights_16_layer0,
      av1_partition_breakout_nn_weights_16_layer1,
  },
  {
      av1_partition_breakout_nn_bias_16_layer0,
      av1_partition_breakout_nn_bias_16_layer1,
  },
};

static const float
    av1_partition_breakout_nn_weights_8_layer0[FEATURE_SIZE * 16] = {
      -0.255885f, 0.109548f,  -0.111054f, -0.476119f, -1.083031f, -0.342003f,
      0.048241f,  -0.356013f, -0.085054f, 0.124908f,  0.000084f,  -0.149906f,
      -0.729829f, 0.133535f,  -0.002125f, 0.207516f,  -0.210163f, -0.567365f,
      -0.590103f, 0.045308f,  -0.539406f, 0.130550f,  -0.663879f, -0.170549f,
      0.017587f,  -0.054187f, 0.000550f,  0.038297f,  -0.112891f, -0.012751f,
      -0.048067f, 0.095564f,  0.079892f,  0.077285f,  -0.749708f, -0.286312f,
      -0.054334f, 0.132242f,  -0.004152f, -0.209758f, -0.073407f, 0.082306f,
      -0.001034f, -0.090990f, 0.122823f,  -0.109794f, -0.230066f, -0.391155f,
      -0.262245f, -0.004744f, -0.232246f, 0.099290f,  -0.637484f, 0.111937f,
      -0.548556f, -0.598344f, 0.123265f,  -0.281395f, -0.399711f, -0.525671f,
      -0.596269f, 0.098494f,  -0.005765f, 0.173652f,
    };

static const float av1_partition_breakout_nn_bias_8_layer0[16] = {
  0.194141f, -0.111223f, 2.503733f, -7.155602f, -0.695068f, 0.114874f,
  2.056990f, 5.284306f,  0.639643f, -2.792049f, -2.232339f, -0.232209f,
  2.336705f, -0.278834f, 0.231905f, 7.954366f,
};

static const float av1_partition_breakout_nn_weights_8_layer1[16] = {
  -0.014439f, 0.010171f, 0.048116f,  -0.090659f, -0.081235f, -0.021840f,
  -0.017360f, 0.031063f, -0.031737f, -0.023439f, -0.037725f, 0.021954f,
  0.055858f,  0.230970f, -0.056466f, 0.119780f,
};

static const float av1_partition_breakout_nn_bias_8_layer1[1] = {
  1.27784479f,
};

static const NN_CONFIG av1_partition_breakout_nnconfig_8 = {
  FEATURE_SIZE,  // num_inputs
  1,             // num_outputs
  1,             // num_hidden_layers
  {
      16,  // num_hidden_nodes
  },
  {
      av1_partition_breakout_nn_weights_8_layer0,
      av1_partition_breakout_nn_weights_8_layer1,
  },
  {
      av1_partition_breakout_nn_bias_8_layer0,
      av1_partition_breakout_nn_bias_8_layer1,
  },
};
#undef FEATURE_SIZE

#define FEATURE_SIZE 9  // Input layer size
#define NUM_NODES 32    // Hidden layer size
#define LABEL_SIZE 3    // Output layer size

static const float av1_rect_partition_nn_weights_8_layer0[FEATURE_SIZE *
                                                          NUM_NODES] = {
  0.22151f,  0.99424f,  0.23415f,  -1.13841f, -0.11277f, 0.09530f,  0.14769f,
  -1.18895f, -0.96640f, -0.21421f, -0.13974f, 0.03236f,  0.15777f,  -0.03176f,
  0.02729f,  -0.37344f, -0.01727f, -0.05469f, 0.19402f,  -3.45508f, 0.90106f,
  -2.91557f, 0.19379f,  0.14356f,  -0.13291f, 0.05734f,  -0.03032f, -0.13060f,
  0.35744f,  1.31630f,  -1.54493f, -0.20749f, -0.24413f, -0.04524f, -0.12400f,
  1.08305f,  -0.21596f, 0.76244f,  1.10616f,  -1.71706f, 0.05768f,  0.10966f,
  0.00949f,  -0.12680f, 0.00699f,  -0.11522f, -0.38566f, 0.34283f,  -0.35266f,
  -0.40643f, -0.22462f, 0.32300f,  -0.39737f, -0.20587f, -0.16096f, 1.07543f,
  0.30314f,  -1.35659f, -0.38212f, 0.45857f,  0.76615f,  0.16819f,  -1.24459f,
  0.39677f,  0.87436f,  -2.33757f, 1.27471f,  0.27488f,  0.01019f,  -0.01221f,
  -0.07461f, -0.14577f, -0.01231f, -0.64426f, -1.02733f, -1.96242f, 0.95143f,
  -0.06777f, -1.13868f, 0.01354f,  -0.75590f, -0.78222f, -0.07453f, 0.61788f,
  0.56899f,  1.17144f,  0.70899f,  0.48568f,  0.11266f,  0.81579f,  -0.03929f,
  0.01088f,  0.33599f,  -0.22401f, -0.49654f, -0.02598f, 0.04509f,  -0.08217f,
  -0.30687f, 0.19851f,  -2.96860f, -2.30698f, 0.01848f,  0.11801f,  0.06614f,
  0.01673f,  -0.11002f, -0.08168f, 0.09204f,  -0.06379f, 0.27972f,  -0.31716f,
  -0.00566f, -0.13651f, -0.37276f, 0.01511f,  -0.23697f, 0.21696f,  -0.19480f,
  0.60758f,  -0.43506f, -0.02247f, -1.45073f, 0.84442f,  -0.94018f, 0.32550f,
  0.03985f,  -0.06581f, 0.21665f,  0.79472f,  -2.41080f, 0.04788f,  -0.09492f,
  -0.10677f, 0.07250f,  0.14329f,  -0.37319f, 0.53043f,  -0.49108f, 0.25792f,
  -0.36569f, -0.28669f, -0.18416f, -0.52385f, -1.17081f, -1.32153f, -1.13403f,
  -0.26196f, 0.93379f,  0.72115f,  0.54464f,  0.27642f,  0.04757f,  2.01629f,
  1.55787f,  -0.11665f, 1.00722f,  -0.24352f, 0.53308f,  0.57719f,  0.39344f,
  0.19174f,  0.06339f,  -0.02530f, 0.07724f,  -0.32416f, -0.26992f, -0.35887f,
  -0.35285f, -0.33379f, -0.37475f, -0.77335f, 1.70027f,  -1.52153f, -0.26503f,
  0.97552f,  -2.96705f, -0.91220f, -0.11827f, 0.00406f,  -0.14514f, 0.18417f,
  -0.20874f, 0.27293f,  -0.34072f, -0.34838f, -0.19054f, -0.29806f, -0.27960f,
  -0.19293f, -0.18275f, -0.05902f, 0.58625f,  -0.05470f, -0.48814f, -0.45382f,
  -0.05959f, 2.01250f,  -0.30014f, 0.69546f,  -1.24180f, 1.34923f,  0.20337f,
  0.16850f,  0.07187f,  0.72630f,  -0.15380f, -2.40973f, -2.73561f, -1.71375f,
  -1.61695f, 0.50052f,  0.09730f,  0.00579f,  0.06133f,  -0.06512f, -0.61439f,
  -1.16173f, -0.58716f, 1.60438f,  0.23242f,  0.91847f,  0.49041f,  -0.16277f,
  -0.02574f, -0.64593f, 1.17028f,  0.46852f,  0.14926f,  0.73853f,  -0.78521f,
  0.05959f,  -0.35590f, 0.02039f,  0.10812f,  -0.28650f, 1.34038f,  -0.72188f,
  0.62385f,  -0.35271f, -0.39599f, 0.41543f,  0.53124f,  -0.23510f, -0.15480f,
  -0.05066f, -0.33529f, 0.05238f,  -0.35311f, -0.26983f, -0.39764f, 0.01085f,
  0.26593f,  -0.18411f, -0.29945f, 0.50090f,  -0.03397f, 0.78562f,  -0.33068f,
  1.21308f,  -2.23273f, -0.33366f, -0.15164f, -1.13270f, 0.17394f,  0.65567f,
  0.76496f,  0.44325f,  0.01368f,  -0.33619f, -0.64256f, 0.64478f,  0.84553f,
  1.74183f,  0.22563f,  -0.14550f, -0.16258f, 0.03010f,  0.49922f,  0.64575f,
  -0.29187f, -0.10348f, -1.43619f, -0.56540f, -0.14779f, 0.04616f,  0.87411f,
  -1.08228f,
};

static const float av1_rect_partition_nn_bias_8_layer0[NUM_NODES] = {
  0.33919f,  -0.03003f, 0.79073f,  -0.18508f, 0.00668f,  -0.12017f, 0.35362f,
  -0.51642f, 0.06536f,  0.41668f,  -0.06509f, 0.94606f,  -0.15385f, 0.14936f,
  1.46274f,  -0.06961f, 2.82537f,  -1.95576f, -0.09457f, 0.02042f,  -0.07480f,
  -0.55083f, 0.26170f,  4.39883f,  0.33999f,  -0.10502f, 0.70884f,  -0.06992f,
  -0.22638f, 1.40940f,  -0.09309f, 0.05828f,
};

static const float av1_rect_partition_nn_weights_8_layer1[NUM_NODES *
                                                          LABEL_SIZE] = {
  0.09209f,  0.26236f,  0.62136f,  0.76324f,  -1.14678f, 0.42289f,  -0.08895f,
  -0.97267f, 2.05958f,  0.00843f,  0.35335f,  1.12096f,  -0.11679f, 0.07350f,
  -1.23231f, -0.61990f, 1.51379f,  -1.99450f, 0.22441f,  2.41974f,  -0.30488f,
  -0.37869f, 0.47168f,  -3.70132f, 0.00061f,  0.19432f,  0.11512f,  0.26200f,
  -0.35285f, 0.37985f,  0.90571f,  0.27344f,  0.74840f,  -0.17965f, -2.51433f,
  0.59235f,  1.16670f,  -0.53446f, 0.67897f,  0.04505f,  -0.86874f, 0.45361f,
  -0.35033f, 1.21283f,  0.31426f,  -0.20841f, 0.56757f,  0.45909f,  -1.23683f,
  0.09835f,  -0.17214f, -0.96323f, 0.01138f,  -0.50233f, 0.30104f,  2.01814f,
  1.15821f,  -0.11947f, 0.74574f,  -0.30714f, -0.39646f, -1.30086f, -0.88541f,
  -0.12259f, -0.54977f, 0.30069f,  1.84299f,  -0.95141f, -0.65887f, -0.25888f,
  -0.63265f, 1.29531f,  -0.56672f, 0.10837f,  -0.21297f, -2.19131f, 0.01156f,
  0.51912f,  0.46704f,  0.42810f,  -0.59271f, 0.98469f,  -0.17914f, -1.91163f,
  -0.32807f, 0.48199f,  -0.99525f, 1.67108f,  -0.87631f, -0.60258f, -0.78731f,
  -0.32877f, 0.44237f,  0.01087f,  0.07489f,  -0.28224f,
};

static const float av1_rect_partition_nn_bias_8_layer1[LABEL_SIZE] = {
  1.70665f,
  -0.77954f,
  -0.92709f,
};

static const NN_CONFIG av1_rect_partition_nnconfig_8 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      NUM_NODES,
  },  // num_hidden_nodes
  { av1_rect_partition_nn_weights_8_layer0,
    av1_rect_partition_nn_weights_8_layer1 },
  { av1_rect_partition_nn_bias_8_layer0, av1_rect_partition_nn_bias_8_layer1 }
};

static const float av1_rect_partition_nn_weights_16_layer0[FEATURE_SIZE *
                                                           NUM_NODES] = {
  -0.18480f, -0.05410f, -0.18957f, 0.15451f,  -0.38649f, -0.26162f, -0.22727f,
  -0.38555f, -0.36738f, 0.74384f,  -1.85999f, 0.98491f,  -0.72119f, 1.77321f,
  0.39983f,  0.96314f,  0.23695f,  0.30200f,  0.30629f,  -0.47617f, -1.43320f,
  -1.81730f, 0.36554f,  -0.07142f, -1.27242f, -1.27697f, 0.00110f,  -0.32179f,
  0.27460f,  0.45428f,  0.15308f,  -0.73906f, -0.28577f, -0.01238f, -0.16958f,
  -0.85390f, 1.05484f,  -1.62812f, 0.77632f,  -0.27327f, -0.32527f, 0.32726f,
  1.73255f,  0.53763f,  0.59121f,  -0.39068f, -0.32451f, -0.31869f, 0.17777f,
  0.07519f,  -0.18066f, -0.11250f, -0.14616f, -0.16882f, -0.04099f, -0.67959f,
  0.39674f,  -0.08596f, 0.18587f,  -2.04097f, -1.73993f, 1.57212f,  1.42410f,
  -1.36762f, -0.41485f, -1.12103f, 0.56959f,  0.11500f,  0.48945f,  -0.13585f,
  1.22125f,  0.67071f,  -1.11812f, -0.20660f, -0.52856f, 0.70663f,  0.74382f,
  0.61114f,  -0.11454f, 1.14687f,  0.80322f,  -0.45965f, -0.44466f, -0.05830f,
  0.13206f,  -0.53750f, -0.11324f, -0.37971f, -0.13491f, -0.21268f, 1.93407f,
  1.34433f,  2.49427f,  2.91955f,  1.71730f,  0.03295f,  0.03587f,  -0.14550f,
  0.08189f,  -0.38655f, -0.35432f, -0.62706f, -0.01849f, -0.57882f, -0.60438f,
  -1.01334f, -0.57302f, 0.22592f,  0.05916f,  -0.05305f, -0.89824f, -0.52969f,
  -0.24542f, 0.27029f,  -0.40924f, -0.82452f, -0.60665f, -5.03025f, 0.83302f,
  1.83695f,  2.19716f,  2.31001f,  0.03657f,  0.00063f,  -0.04379f, 0.05835f,
  -0.08623f, 0.20557f,  -0.17791f, 0.07874f,  -0.25456f, -0.19513f, -0.27753f,
  -0.31982f, 0.00245f,  -0.33183f, 0.26059f,  -0.22165f, 0.37582f,  -0.30411f,
  -0.22639f, -0.14739f, -0.20201f, -0.37507f, -1.30653f, 0.49570f,  1.03673f,
  0.66139f,  0.44941f,  -0.44461f, -0.50376f, -0.49664f, 0.18608f,  -0.26175f,
  0.14844f,  0.78715f,  -0.70344f, -0.87624f, -0.98535f, -0.35346f, 0.37094f,
  -0.43135f, -0.22571f, 3.46263f,  3.13580f,  -1.33203f, -0.15247f, -0.15866f,
  -0.11214f, 0.12211f,  0.03964f,  -1.87597f, -4.81597f, -4.80195f, -4.98096f,
  -5.62336f, -0.05337f, -0.00943f, 0.00792f,  0.02742f,  1.05679f,  2.41455f,
  0.85382f,  1.42504f,  0.58096f,  0.21443f,  1.02694f,  1.06746f,  1.20242f,
  0.60767f,  1.98667f,  -0.80879f, -0.63495f, 1.95508f,  0.23952f,  -0.15019f,
  -0.16097f, 0.30155f,  -3.42407f, -1.34998f, 9.07689f,  -2.22559f, 2.22562f,
  -0.03348f, -0.05229f, 0.05931f,  0.03042f,  -0.18068f, -0.05732f, -0.33010f,
  -0.32279f, -0.26607f, -0.02723f, -0.04067f, 0.08700f,  -0.16366f, -0.24935f,
  -0.69124f, 0.58508f,  0.50654f,  0.04492f,  1.38340f,  -1.51487f, 1.72889f,
  -1.95618f, -3.65013f, -1.38525f, -3.05516f, -2.40448f, 2.47467f,  0.03784f,
  0.08052f,  -0.01971f, -0.08918f, -0.84997f, -0.55302f, -1.07861f, -0.62626f,
  0.61751f,  -0.11012f, -0.24185f, -0.39201f, -1.85390f, -0.31261f, -0.11927f,
  0.15671f,  -0.23450f, -0.14916f, -0.31715f, -0.19350f, 0.01795f,  -0.11533f,
  -0.05799f, -0.03142f, 0.20218f,  -0.39499f, -0.33859f, -0.13201f, -0.19527f,
  -0.28459f, -0.20346f, 0.89457f,  -2.22103f, -2.37455f, -2.00221f, 2.44553f,
  0.33915f,  0.50047f,  -0.34625f, -0.19667f, -0.56333f, -0.84328f, 1.25767f,
  -1.70297f, 1.00482f,  -0.00103f, -1.40813f, 0.21311f,  0.39230f,  -0.07302f,
  -3.49100f, 1.60675f,  -2.90692f, 0.11022f,  0.13507f,  -0.13308f, 0.15201f,
  -0.05573f,
};

static const float av1_rect_partition_nn_bias_16_layer0[NUM_NODES] = {
  -0.16783f, -0.16023f, 0.52215f,  -0.04109f, 2.00122f,  -0.11633f, 0.25535f,
  1.80638f,  1.69273f,  -0.25998f, -6.83550f, -0.79682f, -1.03466f, 1.42721f,
  0.00000f,  -0.00000f, -0.11665f, -0.12047f, -1.01497f, 7.27181f,  -0.78548f,
  -1.39335f, -5.42248f, -0.10388f, 0.07634f,  2.81012f,  -0.57429f, -0.15629f,
  -0.12044f, 1.65478f,  -0.75153f, 1.18441f,
};

static const float av1_rect_partition_nn_weights_16_layer1[NUM_NODES *
                                                           LABEL_SIZE] = {
  -0.26407f, 0.06322f,  0.87932f,  0.17772f,  0.71686f,  -0.12283f, 0.08454f,
  0.20098f,  -0.31763f, -0.33178f, -4.59535f, -0.04367f, 0.17099f,  3.80486f,
  0.16750f,  0.29218f,  0.57234f,  -0.96550f, -0.10599f, -4.91130f, -0.14658f,
  0.95803f,  -4.13925f, 0.24567f,  0.25708f,  1.60547f,  -1.03251f, -0.31053f,
  -0.05659f, -0.94121f, -0.68926f, -0.24738f, -0.38019f, 0.98950f,  0.13689f,
  0.24504f,  0.49623f,  0.19980f,  0.38349f,  0.37481f,  0.54540f,  -0.02198f,
  3.43385f,  1.02543f,  -0.40921f, -3.07235f, 0.02996f,  0.00323f,  -0.35414f,
  0.71099f,  1.39334f,  2.43741f,  -1.11007f, -0.22739f, -4.21757f, 0.11905f,
  0.00353f,  -1.69637f, 0.45944f,  -0.19884f, 0.03624f,  0.25729f,  0.23659f,
  -2.08405f, 0.08573f,  -0.53393f, -1.28103f, -0.53970f, -0.65465f, 0.31821f,
  -0.09884f, -0.69026f, -0.37284f, 0.04622f,  1.32973f,  -0.15414f, 0.19138f,
  -0.67927f, -0.17658f, 0.36008f,  -0.51832f, 0.09887f,  -1.94414f, 2.95227f,
  1.76937f,  -0.26687f, 8.50976f,  0.26247f,  0.60262f,  -0.27910f, 0.30061f,
  -0.05117f, 0.16018f,  0.71195f,  0.57871f,  1.57794f,
};

static const float av1_rect_partition_nn_bias_16_layer1[3] = {
  2.68750f,
  -1.31894f,
  -1.36768f,
};

static const NN_CONFIG av1_rect_partition_nnconfig_16 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      NUM_NODES,
  },  // num_hidden_nodes
  { av1_rect_partition_nn_weights_16_layer0,
    av1_rect_partition_nn_weights_16_layer1 },
  { av1_rect_partition_nn_bias_16_layer0, av1_rect_partition_nn_bias_16_layer1 }
};

static const float av1_rect_partition_nn_weights_32_layer0[FEATURE_SIZE *
                                                           NUM_NODES] = {
  -0.54654f, -0.43537f, -0.10620f, -0.48051f, -0.43543f, -0.22737f, -0.15429f,
  -0.09858f, -0.09438f, 0.37306f,  0.23934f,  -1.86375f, -1.18307f, -0.32995f,
  -0.09745f, 0.05431f,  -0.13799f, 0.14734f,  -0.33219f, 0.18057f,  -0.23792f,
  -0.28126f, 0.02977f,  -0.07431f, 0.07860f,  0.00067f,  -0.01927f, 1.01841f,
  -0.57739f, 0.08412f,  -1.33843f, -1.05563f, -0.28693f, -0.39425f, -0.69572f,
  -0.16703f, 0.02808f,  0.11994f,  -0.26267f, 0.19706f,  -0.29707f, -0.25305f,
  -0.07050f, -0.02704f, -0.31528f, -0.42301f, 0.22496f,  -0.37001f, -0.23319f,
  -0.11139f, -0.30513f, 0.04213f,  -0.12550f, 0.02504f,  0.33245f,  0.01102f,
  -0.35950f, -0.05949f, -0.19590f, -0.27457f, -0.28339f, -0.15676f, -0.21538f,
  0.65066f,  0.28443f,  -1.24943f, -3.00246f, -1.01897f, 0.09304f,  0.70052f,
  -0.12877f, 0.21120f,  -0.37476f, 0.23261f,  -0.28401f, 0.09837f,  0.00020f,
  -0.12106f, -0.32354f, -0.02472f, -0.19772f, 1.01886f,  0.16596f,  -0.06532f,
  1.72938f,  1.57754f,  0.55963f,  0.33246f,  -0.20023f, 0.30715f,  0.08629f,
  0.18945f,  -0.45988f, -1.22610f, -0.05152f, -0.48859f, -1.02104f, -0.27315f,
  -0.57698f, 0.04157f,  -0.92428f, -1.31268f, 1.78210f,  0.10291f,  1.55042f,
  -1.26793f, 1.39042f,  -1.43729f, 0.25600f,  5.21263f,  5.31955f,  5.19316f,
  5.43430f,  0.00294f,  -0.00970f, -0.02333f, 0.00250f,  1.17672f,  6.27544f,
  4.95973f,  3.54009f,  4.51269f,  0.30750f,  0.78780f,  -0.44741f, -0.76442f,
  0.75050f,  0.58799f,  0.03400f,  -2.09859f, 1.67313f,  0.12503f,  0.28609f,
  1.15809f,  2.46530f,  -0.04898f, 0.23072f,  -0.12635f, -0.82097f, -0.63827f,
  2.16779f,  1.77132f,  0.15434f,  -1.06427f, 0.06206f,  -0.87732f, -0.61897f,
  -0.44593f, -0.77131f, -0.15979f, -0.02282f, -0.74381f, 0.66052f,  -0.22992f,
  1.74638f,  1.29199f,  -0.55464f, 0.98316f,  0.06665f,  0.50254f,  -0.66292f,
  0.17113f,  -0.32633f, -1.85803f, -0.92759f, 4.44965f,  1.33057f,  0.02135f,
  -0.27446f, -0.26018f, -0.12613f, -0.14470f, -0.23355f, -0.09717f, -0.24123f,
  -0.05535f, -0.19146f, -0.36222f, -0.30458f, -0.40323f, 0.21779f,  0.14248f,
  -0.48630f, 0.18840f,  0.11040f,  0.17287f,  -0.51880f, 1.12466f,  -0.38888f,
  -0.16421f, -0.31784f, -0.36112f, -0.25386f, -0.01636f, 0.10029f,  -0.26881f,
  -0.17051f, -0.30903f, -0.08573f, -0.28774f, -0.01173f, -0.09706f, -0.23089f,
  -0.12922f, -0.17463f, -0.12433f, -0.23074f, 0.15220f,  1.29826f,  0.23788f,
  0.04189f,  2.66416f,  0.48815f,  -0.06803f, 0.96742f,  1.27165f,  -0.70348f,
  -0.09941f, -0.42948f, -0.20243f, -0.02364f, -0.26689f, -0.40629f, -0.68217f,
  -0.48073f, 2.43657f,  -2.60191f, -1.82837f, 0.50440f,  0.71829f,  0.76491f,
  0.28293f,  0.20568f,  0.92642f,  -0.02496f, 1.43637f,  -0.24474f, -1.21030f,
  0.54084f,  1.05130f,  1.29572f,  0.03750f,  -0.36894f, 0.74548f,  -1.33857f,
  -0.84858f, 1.35230f,  0.80175f,  0.66136f,  1.06473f,  0.18701f,  1.42413f,
  0.04661f,  -0.07820f, 0.64990f,  -0.43595f, 1.18304f,  -0.11437f, -0.06365f,
  0.03558f,  0.78260f,  -1.74890f, 1.56217f,  -1.23424f, 4.59193f,  -3.35072f,
  0.01180f,  -0.18296f, -0.20870f, 0.04510f,  1.52595f,  -1.37402f, -0.33123f,
  -0.85957f, 0.80598f,  0.03743f,  0.02354f,  0.37707f,  1.62095f,  -0.29627f,
  -0.31778f, -0.45789f, -0.14906f, 0.25315f,  -0.10817f, -0.32610f, -0.40890f,
  0.33984f,
};

static const float av1_rect_partition_nn_bias_32_layer0[NUM_NODES] = {
  -0.17482f, 0.39042f,  0.00000f,  1.69677f,  0.08792f,  -0.09301f, 0.13809f,
  4.84061f,  0.00000f,  0.40515f,  0.46246f,  0.20644f,  -5.77478f, -1.54510f,
  0.05660f,  -0.32013f, 0.23649f,  0.03778f,  -2.53710f, -0.27869f, 0.45623f,
  -0.04155f, -0.18445f, -0.73405f, -0.50243f, 2.23191f,  1.93272f,  -1.07032f,
  -0.27602f, -1.98063f, 0.20816f,  -0.01315f,
};

static const float av1_rect_partition_nn_weights_32_layer1[NUM_NODES *
                                                           LABEL_SIZE] = {
  0.02827f,  1.02560f,  -0.07137f, -0.31911f, 0.11365f,  0.13684f,  -0.07816f,
  -5.23036f, -0.34340f, 0.84526f,  -1.51845f, 0.07017f,  -8.12570f, 6.24061f,
  0.35739f,  -0.09937f, -0.30978f, 0.22032f,  0.74968f,  -0.34557f, 0.45547f,
  -0.16512f, 0.07118f,  1.66415f,  0.41320f,  -1.81533f, -1.96004f, 1.04666f,
  0.84049f,  4.31009f,  0.68850f,  0.26322f,  -0.24634f, -1.25889f, 0.31952f,
  0.63632f,  0.05801f,  -0.10664f, -0.21992f, 2.44386f,  0.19526f,  -0.09838f,
  1.53049f,  -0.26630f, 3.54126f,  -3.40574f, 0.72730f,  0.04557f,  0.92652f,
  0.15522f,  2.35895f,  -0.13347f, 0.56907f,  0.15352f,  0.01823f,  -0.73939f,
  0.43104f,  1.90321f,  0.31267f,  -0.51972f, 0.50094f,  -3.98372f, -3.41518f,
  -0.48183f, 0.26661f,  0.64146f,  0.14500f,  -0.01695f, 0.16653f,  -0.37846f,
  0.08412f,  2.69714f,  -0.20258f, -0.75786f, 0.11201f,  0.61878f,  4.22231f,
  -3.55330f, -1.14137f, -0.37722f, -0.28000f, -0.72581f, -2.62827f, -0.19448f,
  -0.59398f, -0.30136f, -0.17725f, -0.69630f, -0.41132f, 0.12208f,  2.11441f,
  -1.08794f, -1.41694f, 0.02620f,  2.18792f,  0.04271f,
};

static const float av1_rect_partition_nn_bias_32_layer1[3] = {
  2.47332f,
  -1.65756f,
  -0.81573f,
};

static const NN_CONFIG av1_rect_partition_nnconfig_32 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      NUM_NODES,
  },  // num_hidden_nodes
  { av1_rect_partition_nn_weights_32_layer0,
    av1_rect_partition_nn_weights_32_layer1 },
  { av1_rect_partition_nn_bias_32_layer0, av1_rect_partition_nn_bias_32_layer1 }
};

static const float av1_rect_partition_nn_weights_64_layer0[FEATURE_SIZE *
                                                           NUM_NODES] = {
  0.08972f,  4.09095f,  -0.31398f, -2.43631f, -0.74767f, 1.42471f,  1.60926f,
  1.44721f,  1.88259f,  2.35375f,  1.88299f,  2.01109f,  0.98679f,  2.24131f,
  0.06279f,  -0.08315f, 0.32107f,  0.91334f,  -0.36569f, 5.55049f,  5.44943f,
  5.20471f,  5.39099f,  -0.01943f, -0.00284f, 0.02203f,  -0.01309f, 1.41917f,
  6.68460f,  -6.15986f, 6.41341f,  -3.20630f, -0.00567f, -0.00038f, 0.05960f,
  0.04308f,  0.95366f,  3.48535f,  2.98266f,  4.11784f,  3.44255f,  0.61630f,
  0.71405f,  0.63945f,  -0.00713f, 0.39193f,  1.91621f,  3.32755f,  0.71674f,
  -0.11647f, 2.07090f,  2.64191f,  0.07949f,  -0.05023f, 0.99935f,  0.83145f,
  0.75898f,  -0.98764f, -0.58731f, 1.21734f,  -0.08076f, -3.26780f, 1.66278f,
  0.04189f,  -0.33177f, -1.58648f, 1.00883f,  -0.56132f, -2.34877f, 0.67056f,
  -2.32297f, -0.91641f, -1.02909f, 4.19781f,  3.87484f,  4.32778f,  -1.97171f,
  -0.24734f, 0.00822f,  0.05892f,  0.12697f,  -3.62915f, -2.93127f, 7.94856f,
  -3.29311f, 3.26001f,  -0.02231f, 0.02741f,  0.05919f,  0.08190f,  -1.49344f,
  -0.64475f, -0.24627f, 4.03324f,  -1.14799f, -0.18465f, -0.17829f, 0.10394f,
  0.08580f,  -5.74721f, 4.42467f,  3.63964f,  3.00258f,  -1.22744f, -0.29408f,
  0.00767f,  0.12305f,  0.05249f,  -0.17166f, -0.20120f, -0.32941f, -0.31901f,
  0.04628f,  -0.35249f, -0.18272f, 0.03956f,  -0.19329f, -0.33564f, 0.09856f,
  -0.00173f, -0.31751f, -0.05702f, -0.20558f, -0.31464f, -0.02488f, -0.00729f,
  -0.35854f, -0.14762f, -0.34897f, -0.12746f, 0.04011f,  -0.24918f, -0.53516f,
  -0.28440f, -0.36789f, -1.34889f, -9.10044f, -9.19238f, 4.48042f,  6.54429f,
  -0.00226f, 0.00430f,  0.00321f,  0.00442f,  0.87551f,  -0.16224f, -0.22832f,
  -0.60640f, -0.28738f, 0.18062f,  0.22008f,  -0.47406f, 0.80302f,  0.12149f,
  1.49530f,  1.05069f,  -2.02985f, -0.92833f, 0.25616f,  0.12852f,  3.51840f,
  0.25226f,  -2.63283f, -4.04386f, 8.46300f,  -2.93408f, 0.44069f,  0.08276f,
  0.34482f,  -0.22615f, 0.28666f,  3.02962f,  -1.20055f, -1.04832f, -0.97632f,
  -0.99530f, 1.44196f,  1.68550f,  0.49360f,  1.08155f,  -0.26059f, -0.02876f,
  -0.27492f, -0.06205f, -0.09496f, -0.12314f, -0.30228f, -0.07453f, -0.38857f,
  1.17443f,  2.41497f,  1.90537f,  2.37716f,  2.91495f,  -0.44455f, -0.51176f,
  0.48195f,  0.53032f,  0.23696f,  -1.06211f, 1.47459f,  -0.89029f, 0.29521f,
  0.66291f,  -0.42653f, 1.82308f,  -1.30372f, -0.36192f, -3.40388f, -1.61476f,
  -2.29745f, -0.66886f, -2.08252f, -0.54552f, -4.06849f, 0.02948f,  0.27297f,
  -4.81472f, 4.60404f,  -0.11053f, 0.14765f,  0.02826f,  -0.14688f, -0.07066f,
  -0.01224f, 1.20377f,  7.02725f,  -6.02627f, 6.87255f,  -3.14257f, 0.01074f,
  0.02397f,  -0.02359f, 0.01901f,  0.14956f,  -1.67671f, 2.26714f,  2.57043f,
  -0.45888f, -1.60265f, -2.11475f, -2.74029f, -2.74658f, -0.35630f, -2.63013f,
  -2.14814f, -0.67266f, -1.56850f, 0.57137f,  -1.14428f, -0.34265f, -0.12521f,
  0.01220f,  -0.74906f, -0.19270f, 0.68110f,  -0.24737f, -0.70568f, -1.64826f,
  -0.35847f, -0.15984f, -1.17932f, -8.72306f, -8.72834f, 3.93701f,  6.17812f,
  -0.03191f, -0.00104f, 0.01402f,  -0.00046f, -0.94517f, 1.51266f,  -0.56318f,
  0.72260f,  -0.09253f, -0.09069f, -2.16695f, -0.23653f, 0.24418f,  2.21148f,
  -1.47954f, -1.01439f, 0.31536f,  0.77238f,  -0.85083f, -0.15758f, -0.50886f,
  0.09101f,
};

static const float av1_rect_partition_nn_bias_64_layer0[NUM_NODES] = {
  0.91706f,  -1.31328f, -5.16196f, 1.13191f,  -0.98044f, -1.61122f, 1.03039f,
  -0.98537f, -4.45568f, -4.34802f, -0.92116f, 0.66836f,  -0.10752f, -0.13065f,
  -0.35567f, -0.35693f, 1.74941f,  1.17379f,  -3.45555f, 5.66321f,  -0.24917f,
  -1.11940f, -0.73656f, -0.19299f, -0.04181f, 1.11010f,  -2.97859f, -0.16774f,
  0.59835f,  -0.31269f, -0.30585f, -1.66212f,
};

static const float av1_rect_partition_nn_weights_64_layer1[NUM_NODES *
                                                           LABEL_SIZE] = {
  0.58963f,  4.20320f,  -8.62465f, -6.54014f, 5.41108f,  2.33581f,   -0.10354f,
  -1.17753f, -3.45909f, -2.24722f, 2.20881f,  3.21971f,  -0.09087f,  -0.21624f,
  0.16529f,  -8.40985f, -1.60205f, -1.41538f, 4.41826f,  -4.63069f,  -0.27742f,
  4.08710f,  0.26439f,  -1.46028f, 0.51234f,  6.25212f,  -3.35650f,  -1.21348f,
  1.37201f,  8.89151f,  0.28859f,  -0.97328f, -0.36196f, -2.71701f,  4.54196f,
  -0.62476f, -2.43814f, -1.34209f, 0.12850f,  1.73859f,  3.09809f,   -4.42434f,
  -1.82552f, -3.66420f, -0.31535f, 0.00968f,  -0.02019f, 9.66824f,   0.58835f,
  1.50425f,  2.84487f,  2.55522f,  0.01409f,  -2.27594f, -0.31800f,  0.91076f,
  -0.66808f, 0.33120f,  -0.12460f, 0.64457f,  -0.36416f, -10.30843f, 1.51013f,
  2.06861f,  -0.20989f, -0.87119f, 3.68642f,  7.33662f,  -2.88037f,  -0.52414f,
  -0.35036f, -0.45947f, -0.07406f, 6.46346f,  -0.16031f, 0.27071f,   0.38845f,
  -0.21940f, 0.08583f,  -1.39526f, 0.50554f,  0.45279f,  -6.61856f,  1.84069f,
  -0.19149f, -1.77235f, 0.75136f,  1.11797f,  0.32677f,  -7.10427f,  3.82908f,
  1.04238f,  -0.91435f, 1.93317f,  -1.84946f, -0.48909f,
};

static const float av1_rect_partition_nn_bias_64_layer1[3] = {
  0.32215f,
  -0.57522f,
  0.25314f,
};

static const NN_CONFIG av1_rect_partition_nnconfig_64 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      NUM_NODES,
  },  // num_hidden_nodes
  { av1_rect_partition_nn_weights_64_layer0,
    av1_rect_partition_nn_weights_64_layer1 },
  { av1_rect_partition_nn_bias_64_layer0, av1_rect_partition_nn_bias_64_layer1 }
};

static const float av1_rect_partition_nn_weights_128_layer0[FEATURE_SIZE *
                                                            NUM_NODES] = {
  -0.70901f, -3.03481f, 3.30604f,  -1.28803f,  -0.08610f, -0.33320f, -0.30716f,
  0.25100f,  0.14323f,  -0.98422f, -0.89084f,  -0.24508f, -1.10785f, -0.82524f,
  0.11766f,  -0.42777f, 1.08965f,  4.35125f,   -1.19388f, 4.22042f,  4.96306f,
  6.32406f,  3.29899f,  -0.90768f, 0.05203f,   0.38467f,  1.74257f,  -0.19918f,
  -0.11335f, 0.00140f,  -0.42303f, -0.04419f,  0.03583f,  -0.05441f, -0.19586f,
  0.01484f,  -1.19964f, 0.25497f,  3.04502f,   0.05446f,  -0.23253f, 0.00266f,
  0.07117f,  -2.78986f, -4.62953f, 1.45331f,   0.43923f,  0.92298f,  -0.47736f,
  1.49165f,  0.45942f,  -1.99787f, 3.33510f,   0.17234f,  0.04024f,  -1.42780f,
  0.23566f,  -0.90970f, 1.18041f,  -1.45865f,  2.30878f,  -1.28507f, 1.87290f,
  1.91186f,  4.74826f,  -3.70735f, 4.49808f,   -4.72275f, -0.02696f, -0.02642f,
  -0.06093f, -0.01121f, -0.70683f, 2.69737f,   -1.88563f, 2.48637f,  1.10922f,
  0.74624f,  0.40308f,  2.06396f,  1.39289f,   0.00909f,  -2.05271f, -1.53539f,
  -1.38323f, 0.83303f,  -0.32250f, 0.51172f,   3.91249f,  1.66373f,  1.13184f,
  -2.22874f, -1.13448f, -0.11185f, 0.19387f,   0.36770f,  -0.58933f, 0.22789f,
  1.17307f,  0.77461f,  0.20817f,  0.33417f,   0.54037f,  0.32961f,  -0.18456f,
  -9.78171f, -0.17216f, -3.44703f, -2.42158f,  0.51946f,  4.35949f,  -0.73335f,
  -1.61515f, -0.29622f, -0.37617f, -0.42316f,  0.74922f,  1.44386f,  3.92704f,
  -3.76274f, 4.19775f,  -3.86958f, 0.00074f,   -0.02418f, -0.12944f, 0.05857f,
  -0.85507f, 5.42546f,  5.40338f,  5.54347f,   5.59791f,  -0.01611f, 0.01618f,
  -0.01654f, -0.00270f, -0.39608f, -0.40410f,  -0.24551f, 0.09124f,  -0.34413f,
  -0.11504f, 0.12793f,  -0.31523f, 0.09148f,   -0.08567f, -0.05140f, -0.13310f,
  -0.81200f, 0.06882f,  -0.52537f, -12.74048f, -0.45395f, -4.04775f, -1.84887f,
  -1.02573f, 0.32788f,  1.06828f,  -1.25503f,  -0.42693f, 2.01413f,  -2.29103f,
  0.62271f,  1.11764f,  -1.83113f, -1.32325f,  -1.65651f, -2.87826f, 1.46910f,
  0.60885f,  0.16079f,  0.00171f,  -0.25658f,  -0.25465f, -0.14149f, 0.19497f,
  -0.07866f, -0.37080f, -0.05778f, -0.08870f,  -0.20491f, 0.84521f,  -0.18214f,
  -1.38441f, -1.08932f, -1.76627f, 0.73172f,   0.05967f,  1.28057f,  3.42722f,
  1.69287f,  0.77169f,  0.44528f,  1.85513f,   0.07840f,  1.31252f,  2.89948f,
  1.49489f,  0.15281f,  0.54708f,  -1.14185f,  -2.51063f, 0.36618f,  -0.55322f,
  0.96671f,  1.59470f,  1.38252f,  1.99697f,   0.03266f,  -0.23200f, -0.01127f,
  -0.18918f, -0.37598f, -0.03119f, -0.36039f,  -0.21192f, -0.11565f, -4.22635f,
  1.41252f,  0.56608f,  -0.08867f, 3.11924f,   -0.54597f, -0.12504f, -0.05289f,
  -0.28665f, -0.58297f, -1.18362f, -0.76201f,  -1.22011f, -0.58756f, 0.14740f,
  1.43971f,  0.98381f,  -0.02998f, -0.40678f,  -0.23047f, -0.12979f, 0.04003f,
  -0.22081f, -0.09294f, -0.15955f, -0.10379f,  -0.10192f, -1.51316f, 2.39482f,
  -1.69975f, 3.58976f,  -0.91032f, -0.03498f,  0.48982f,  -0.13418f, 0.76256f,
  1.61003f,  -2.01676f, -1.24430f, -3.25763f,  1.12314f,  2.00740f,  0.04613f,
  -0.14746f, -0.57374f, 3.44511f,  -0.56767f,  -4.08432f, -2.04894f, 2.35951f,
  -0.00458f, 0.18512f,  0.09916f,  -0.04084f,  -1.56207f, 1.38034f,  4.17302f,
  -1.47326f, -2.03530f, -0.00210f, 0.27469f,   -0.17423f, 0.86860f,  2.76195f,
  2.43269f,  -3.57331f, 2.08715f,  -1.44171f,  -0.17389f, 2.26157f,  -0.07852f,
  2.02519f,
};

static const float av1_rect_partition_nn_bias_128_layer0[NUM_NODES] = {
  2.53427f,  1.66678f,  -0.84914f, -0.15070f, -1.74769f, 0.45218f,  -0.26067f,
  2.05916f,  0.08978f,  5.30984f,  2.66243f,  -1.62740f, 0.70018f,  1.96403f,
  -4.97152f, -0.05425f, -3.84474f, -1.28006f, 3.47490f,  -0.08373f, 0.00225f,
  -1.40692f, -0.27569f, -0.30253f, 0.77377f,  -0.67636f, -0.26379f, 1.82348f,
  0.66120f,  0.61119f,  -1.42293f, 0.32676f,
};

static const float av1_rect_partition_nn_weights_128_layer1[NUM_NODES *
                                                            LABEL_SIZE] = {
  1.53453f,  -0.23707f, 7.88368f,  0.33340f,  0.97523f,  1.38538f,  -0.16746f,
  4.42070f,  3.18678f,  -5.03545f, -2.27029f, -3.75719f, -0.26850f, -4.93432f,
  -8.75673f, 0.27398f,  -5.77882f, -0.91616f, -2.62725f, -0.23961f, 0.31249f,
  3.32134f,  0.25375f,  -0.00394f, 2.30213f,  -0.14183f, 0.14544f,  -1.42830f,
  1.31101f,  3.99389f,  -0.00017f, -2.90184f, -2.11444f, 2.16734f,  -3.05133f,
  0.39206f,  4.61489f,  -2.88181f, -0.47745f, 2.86649f,  -1.20621f, 3.70550f,
  1.58029f,  -4.58731f, -2.29350f, -0.76930f, 5.19135f,  -0.22521f, -5.08782f,
  2.17316f,  1.30563f,  0.16777f,  -2.17767f, -2.09904f, 1.37001f,  0.25091f,
  -1.76743f, 1.57940f,  0.30544f,  -2.39895f, -0.08532f, -1.77122f, 1.84010f,
  -0.88449f, 0.79299f,  -1.35368f, -4.54110f, 0.02244f,  -5.11580f, 1.60883f,
  0.29352f,  -6.47042f, -1.81426f, 1.24013f,  0.90980f,  7.93977f,  2.12555f,
  5.24720f,  4.19508f,  0.21499f,  11.06045f, -0.74752f, 0.89396f,  0.26422f,
  1.72332f,  -1.25113f, -1.71136f, 0.13676f,  -0.07867f, -0.96929f, 0.19911f,
  3.58233f,  -0.76470f, -2.24162f, -2.87465f, 3.18736f,
};

static const float av1_rect_partition_nn_bias_128_layer1[3] = {
  1.09014f,
  -0.53317f,
  -0.55668f,
};

static const NN_CONFIG av1_rect_partition_nnconfig_128 = {
  FEATURE_SIZE,  // num_inputs
  LABEL_SIZE,    // num_outputs
  1,             // num_hidden_layers
  {
      NUM_NODES,
  },  // num_hidden_nodes
  { av1_rect_partition_nn_weights_128_layer0,
    av1_rect_partition_nn_weights_128_layer1 },
  { av1_rect_partition_nn_bias_128_layer0,
    av1_rect_partition_nn_bias_128_layer1 }
};
#undef FEATURE_SIZE
#undef NUM_NODES
#undef LABEL_SIZE

#if CONFIG_ONE_PASS_SVM
#define FEATURE_SIZE 24
static const float av1_op_svm_early_term_weights_128[FEATURE_SIZE + 1] = {
  -4.5893036051f, 6.9065208136f,  -9.1579514692f, 0.1353151366f,
  -1.0271889653f, -0.0020988254f, -0.0094355949f, 0.0040209656f,
  0.0073014747f,  0.7939705382f,  0.0254545714f,  0.0557559708f,
  -0.0339662064f, -0.0496818300f, 0.3053600283f,  0.3699486845f,
  0.0848271391f,  0.4091075988f,  0.1196729398f,  -0.0038137193f,
  -0.0773495909f, -0.0651630642f, -0.0123704995f, -0.0036697401f,
  -4.1930227095f,
};

static const float av1_op_svm_early_term_weights_64[FEATURE_SIZE + 1] = {
  -2.7600454480f, 5.6822046712f,  -6.7576830133f, 0.1326457117f,
  -1.0541818372f, 0.0107782654f,  0.0050469147f,  -0.0021362631f,
  -0.0135151040f, -0.1020115005f, -0.0283409957f, -0.0176311233f,
  0.0250648204f,  0.0196228570f,  0.5441528594f,  0.2767320141f,
  0.1261231351f,  0.2998476408f,  0.1336215695f,  -0.1107823946f,
  -0.0697279598f, -0.0577520545f, -0.0558441075f, -0.0699750617f,
  -2.6995991503f,
};

static const float av1_op_svm_early_term_weights_32[FEATURE_SIZE + 1] = {
  -0.8950734172f, 1.3559565008f,  -2.6733642653f, 0.2661361319f,
  -0.0314731140f, 0.0044943456f,  0.0006438044f,  -0.0029066686f,
  -0.0021903213f, 0.5845049496f,  -0.0003629350f, 0.0006982840f,
  0.0014157386f,  -0.0017427528f, 0.7078456733f,  0.1600998068f,
  0.0933852747f,  0.2822125876f,  0.1923826165f,  -0.0905903459f,
  -0.0564717590f, -0.0591007486f, -0.0692268554f, -0.0677411981f,
  -0.7101853206f,
};

static const float av1_op_svm_early_term_weights_16[FEATURE_SIZE + 1] = {
  -0.1719124013f, -0.3192305362f, -1.1714597182f, 0.4437770294f,
  -0.0042344643f, 0.0000027764f,  0.0018827450f,  -0.0015555613f,
  -0.0003250050f, 0.9413693294f,  0.0076188418f,  -0.0067870352f,
  0.0006329246f,  -0.0013059613f, 0.8596697254f,  0.0635558018f,
  0.0447224598f,  0.0915706321f,  0.0741662273f,  -0.0269096547f,
  -0.0244610614f, -0.0281113318f, -0.0326108845f, -0.0350908892f,
  -0.0307521675f,
};

static const float av1_op_svm_early_term_mean_128[FEATURE_SIZE] = {
  940540.3259649610f,    3988285.5905584921f, 575475302.3545289040f,
  0.5775348803f,         866.9828469502f,     0.2503762393f,
  0.2501466215f,         0.2513213770f,       0.2481557622f,
  521994448.3219169378f, 0.2666920631f,       0.2535864361f,
  0.2481589186f,         0.2315625823f,       100519.1049708007f,
  12.1299754840f,        0.8279971004f,       12.6664603305f,
  0.7313258998f,         935.8233056680f,     0.7436563032f,
  0.7710055018f,         0.7376516970f,       0.6859818720f,
};

static const float av1_op_svm_early_term_mean_64[FEATURE_SIZE] = {
  420419.7529613562f,    839754.4414347620f, 129360420.5256031156f,
  0.6525652037f,         548.8972009954f,    0.2506918565f,
  0.2488349076f,         0.2501724146f,      0.2503008213f,
  113132974.7944754064f, 0.2479344278f,      0.2471446791f,
  0.2524478512f,         0.2524730419f,      91147.9854189453f,
  10.9642508460f,        0.8936554428f,      11.3877865621f,
  0.8307555282f,         752.7787491956f,    0.7243363939f,
  0.7198362119f,         0.7329432336f,      0.7245090283f,
};

static const float av1_op_svm_early_term_mean_32[FEATURE_SIZE] = {
  105111.0236438536f,   184296.0939716828f, 29117017.6751756854f,
  0.6402298612f,        140.2223339218f,    0.2495860872f,
  0.2496407600f,        0.2506238629f,      0.2501492900f,
  24480304.9390618578f, 0.2494442027f,      0.2496080963f,
  0.2504881563f,        0.2504595447f,      60297.6762059058f,
  9.4279752138f,        0.9287901132f,      9.6516813792f,
  0.9009173677f,        591.5406335030f,    0.6944486917f,
  0.6983941982f,        0.6927236901f,      0.6921613649f,
};

static const float av1_op_svm_early_term_mean_16[FEATURE_SIZE] = {
  34080.7994802934f, 44108.1176228864f,   7494288.4946180154f, 0.6240636218f,
  36.4539515827f,    0.2490867417f,       0.2499231014f,       0.2505361492f,
  0.2504540077f,     5913397.2957480755f, 0.2487482536f,       0.2495500728f,
  0.2503693302f,     0.2513323434f,       36574.9686737814f,   7.4345592768f,
  0.9592429205f,     7.6001764585f,       0.9459867777f,       490.4635033056f,
  0.6626215237f,     0.6580791886f,       0.6655481064f,       0.6589010119f,
};

static const float av1_op_svm_early_term_std_128[FEATURE_SIZE] = {
  2054266.2732957317f,    7550554.6241466375f, 1078688147.1656334400f,
  0.4939517611f,          1414.3139592985f,    0.1504634077f,
  0.1515907199f,          0.1590329744f,       0.1515653324f,
  1006422867.8989596367f, 0.1168668155f,       0.1195725959f,
  0.1195825693f,          0.1123065533f,       195261.0940245980f,
  4.5876675121f,          0.3773829648f,       4.8017339769f,
  0.4432700397f,          973.7532938848f,     0.4790027843f,
  0.5056275222f,          0.5262278749f,       0.4685586148f,
};

static const float av1_op_svm_early_term_std_64[FEATURE_SIZE] = {
  1093636.0522712648f,   1749863.5221569177f, 255168612.8025657237f,
  0.4761552884f,         1084.7927994662f,    0.1099344646f,
  0.1100619440f,         0.1090853225f,       0.1115303745f,
  232084513.1365262568f, 0.0759732385f,       0.0762942913f,
  0.0785624106f,         0.0779284747f,       185687.9441778057f,
  4.4371901245f,         0.3082781088f,       4.6670562831f,
  0.3749677061f,         854.3212307408f,     0.4920531348f,
  0.5073919158f,         0.5054698298f,       0.4904895620f,
};

static const float av1_op_svm_early_term_std_32[FEATURE_SIZE] = {
  238229.7484988807f,   400136.8703966461f, 60267828.4581554681f,
  0.4799328974f,        268.9377064297f,    0.1122938575f,
  0.1126479260f,        0.1137018559f,      0.1126389337f,
  52174139.1477040648f, 0.0715628767f,      0.0720997035f,
  0.0728961434f,        0.0732065300f,      147785.0049793872f,
  4.2092341484f,        0.2571751131f,      4.3893075417f,
  0.2987729310f,        769.0253148602f,    0.5027558039f,
  0.4982811444f,        0.5092312751f,      0.4991214994f,
};

static const float av1_op_svm_early_term_std_16[FEATURE_SIZE] = {
  64177.9527087587f,    103729.9987511119f, 16632490.8146969266f,
  0.4843637247f,        65.8114470725f,     0.0884226846f,
  0.0912638659f,        0.0914771167f,      0.0916078800f,
  13364581.3877149168f, 0.0677468925f,      0.0689631274f,
  0.0689915367f,        0.0702648469f,      111397.2620676765f,
  3.7858187888f,        0.1977269328f,      3.9420183951f,
  0.2260437881f,        717.5336868275f,    0.5017939514f,
  0.5066633533f,        0.5086806985f,      0.5085585987f,
};

#undef FEATURE_SIZE
#endif  // CONFIG_ONE_PASS_SVM

// Below are the models used for full_pixel_motion_search_based_split
static const float full_pixel_motion_search_based_split_thresh_128 = 2.0f;
static const float full_pixel_motion_search_based_split_thresh_64 = 2.0f;
static const float full_pixel_motion_search_based_split_thresh_32 = 2.0f;
static const float full_pixel_motion_search_based_split_thresh_16 = 2.0f;
static const float full_pixel_motion_search_based_split_thresh_8 = 2.0f;

// BLOCK_128X128
#define NUM_HIDDEN_LAYERS_128 1
#define NUM_FEATURES_128 6
#define NUM_LAYER_0_UNITS_128 16
#define NUM_LOGITS_128 1

static const float full_pixel_motion_search_based_split_layer_0_kernel_128[] = {
  -0.807346f,  0.242298f,   12.9862f,   -1.19161f,  5.21734f,    -1.1363f,
  -2.39127f,   0.930915f,   -2.44285f,  -2.42966f,  5.73476f,    0.0506879f,
  -0.234878f,  -0.317875f,  0.361322f,  0.431648f,  -0.39105f,   -0.110225f,
  -2.46236f,   0.979713f,   -10.5596f,  -7.76653f,  -3.06518f,   2.42554f,
  0.0492961f,  -0.467176f,  0.130746f,  0.494527f,  -0.0336645f, 0.501755f,
  0.176486f,   -0.869541f,  7.77757f,   6.81303f,   6.00771f,    7.35696f,
  0.150731f,   -0.307017f,  -0.437639f, -0.082924f, 0.379107f,   0.452278f,
  -0.0143836f, -0.183691f,  -0.604698f, -9.2681f,   -2.06087f,   11.0256f,
  0.0487599f,  -0.249168f,  -0.180407f, 0.304772f,  0.218642f,   -0.406073f,
  -0.0289919f, -0.794381f,  5.45092f,   5.38374f,   3.25745f,    5.32903f,
  1.12718f,    -0.0215478f, 2.78552f,   4.8951f,    -0.959671f,  0.694264f,
  -0.0611219f, -0.331937f,  0.258252f,  -0.495331f, -0.285923f,  0.294713f,
  -0.119947f,  0.0753204f,  10.2021f,   -5.82147f,  -12.0137f,   3.0365f,
  0.366697f,   0.142683f,   -3.29731f,  -5.76651f,  -5.62578f,   10.9462f,
  -0.325459f,  0.092602f,   -0.868027f, -0.691768f, -0.292017f,  -0.00841203f,
  0.702545f,   -0.612227f,  -7.68881f,  9.52225f,   -1.18581f,   -2.56762f
};

static const float full_pixel_motion_search_based_split_logits_kernel_128[] = {
  0.364895f,    0.577553f,  0.115758f,  -0.999496f, 0.124885f, 3.23193f,
  -0.00386642f, 0.970794f,  0.136637f,  -4.28052f,  -1.49234f, 0.370436f,
  0.576981f,    -0.469656f, -0.124071f, 1.07669f
};

static const float full_pixel_motion_search_based_split_layer_0_bias_128[] = {
  1.32916f,    0.817212f,  0.0f,       -0.921066f, 0.0f,      3.57649f,
  -0.0204517f, 2.97286f,   0.0f,       5.49957f,   -8.14518f, 0.0f,
  1.30826f,    -0.349536f, -0.638933f, 5.4496f
};

static const float full_pixel_motion_search_based_split_logits_bias_128[] = {
  0.683442f
};

static const NN_CONFIG full_pixel_motion_search_based_split_nn_config_128 = {
  NUM_FEATURES_128,
  NUM_LOGITS_128,
  NUM_HIDDEN_LAYERS_128,
  {
      NUM_LAYER_0_UNITS_128,
  },
  {
      full_pixel_motion_search_based_split_layer_0_kernel_128,
      full_pixel_motion_search_based_split_logits_kernel_128,
  },
  {
      full_pixel_motion_search_based_split_layer_0_bias_128,
      full_pixel_motion_search_based_split_logits_bias_128,
  },
};

#undef NUM_HIDDEN_LAYERS_128
#undef NUM_FEATURES_128
#undef NUM_LAYER_0_UNITS_128
#undef NUM_LOGITS_128

// BLOCK_64X64
#define NUM_HIDDEN_LAYERS_64 1
#define NUM_FEATURES_64 6
#define NUM_LAYER_0_UNITS_64 16
#define NUM_LOGITS_64 1

static const float full_pixel_motion_search_based_split_layer_0_kernel_64[] = {
  0.0345945f,  -0.394064f,  0.0919978f, 0.270358f,  -0.384502f, -0.504608f,
  -0.25759f,   0.155981f,   2.62567f,   -10.7204f,  -0.709802f, 8.15948f,
  0.589866f,   -0.445645f,  -1.68232f,  10.0061f,   -3.17671f,  4.87259f,
  -0.448886f,  -0.205568f,  -0.462388f, 0.385001f,  -0.451687f, 0.49602f,
  -0.256708f,  0.803322f,   3.25594f,   0.38541f,   -1.83867f,  -2.15132f,
  0.936059f,   -0.203056f,  -5.92959f,  -6.24554f,  -6.68631f,  -6.85977f,
  -0.0407565f, -0.258902f,  0.195053f,  -0.366515f, 0.339543f,  -0.433017f,
  -2.67026f,   0.385457f,   1.86683f,   1.9501f,    0.0381398f, 1.086f,
  -0.153729f,  0.173772f,   -42.9029f,  -36.8934f,  -2.892f,    -0.0540691f,
  0.77469f,    -0.380145f,  2.2689f,    -9.53332f,  1.15712f,   2.86601f,
  -0.437036f,  0.247132f,   -8.51058f,  -3.62972f,  -8.99449f,  -0.638738f,
  0.0609263f,  -0.0614603f, 5.42307f,   5.35926f,   5.27437f,   5.26599f,
  -0.0729677f, 0.0306104f,  -7.77867f,  5.03598f,   -8.17832f,  5.85461f,
  -0.253269f,  0.164582f,   -4.49713f,  3.83265f,   9.04851f,   -2.85668f,
  1.22618f,    0.166904f,   -1.51975f,  -4.01576f,  -1.44374f,  -2.22147f,
  -0.217072f,  -0.0984913f, -0.265515f, 0.360021f,  0.0779512f, 0.361516f
};

static const float full_pixel_motion_search_based_split_logits_kernel_64[] = {
  0.470821f, 0.474747f, -0.571292f, 0.403221f,  0.628966f,  -0.617029f,
  0.501105f, 0.499962f, -1.5451f,   -0.473518f, -0.730568f, -5.55817f,
  0.776761f, 0.42569f,  0.311925f,  0.469968f
};

static const float full_pixel_motion_search_based_split_layer_0_bias_64[] = {
  -0.134085f, 0.0758715f, 1.10419f,  0.0f,       -5.75737f, 1.65494f,
  0.0f,       3.44047f,   0.394852f, 3.43858f,   3.65871f,  -4.84987f,
  1.21207f,   -1.7705f,   -5.46469f, -0.0889634f
};

static const float full_pixel_motion_search_based_split_logits_bias_64[] = {
  -0.479491f
};

static const NN_CONFIG full_pixel_motion_search_based_split_nn_config_64 = {
  NUM_FEATURES_64,
  NUM_LOGITS_64,
  NUM_HIDDEN_LAYERS_64,
  {
      NUM_LAYER_0_UNITS_64,
  },
  {
      full_pixel_motion_search_based_split_layer_0_kernel_64,
      full_pixel_motion_search_based_split_logits_kernel_64,
  },
  {
      full_pixel_motion_search_based_split_layer_0_bias_64,
      full_pixel_motion_search_based_split_logits_bias_64,
  },
};

#undef NUM_HIDDEN_LAYERS_64
#undef NUM_FEATURES_64
#undef NUM_LAYER_0_UNITS_64
#undef NUM_LOGITS_64

// BLOCK_32X32
#define NUM_HIDDEN_LAYERS_32 1
#define NUM_FEATURES_32 6
#define NUM_LAYER_0_UNITS_32 16
#define NUM_LOGITS_32 1

static const float full_pixel_motion_search_based_split_layer_0_kernel_32[] = {
  -1.61796f,   0.0585128f,  1.57904f,   1.52703f,   0.367779f, 0.220434f,
  1.66652f,    -1.77782f,   6.41118f,   4.16976f,   4.97299f,  4.84111f,
  -0.0956536f, -0.163284f,  -0.143662f, 0.129329f,  0.449659f, -0.528844f,
  -1.00067f,   1.17203f,    -4.26777f,  -4.78521f,  8.45658f,  -3.49498f,
  -1.78386f,   0.111488f,   4.176f,     6.31911f,   -10.5369f, 6.26983f,
  -1.32233f,   1.22999f,    -4.1666f,   -10.0359f,  -4.14779f, -10.4695f,
  1.83011f,    -0.333152f,  -9.87986f,  -8.11992f,  -8.2775f,  -7.79918f,
  -0.101404f,  0.00401393f, 8.89046f,   -7.32186f,  -6.59597f, 9.66257f,
  -1.1492f,    1.23067f,    -3.6341f,   6.59275f,   -3.2373f,  -3.42564f,
  0.371736f,   -0.140902f,  -2.75715f,  5.92487f,   -7.9185f,  9.13743f,
  -3.52698f,   -0.191044f,  5.96691f,   6.26327f,   4.36378f,  5.69354f,
  -0.608845f,  -0.191236f,  -0.482191f, -0.180474f, -3.8838f,  -3.92934f,
  -1.03191f,   0.994568f,   7.95516f,   -4.0035f,   -2.86266f, -4.96105f,
  1.75022f,    0.125058f,   -1.52159f,  -3.59304f,  -2.82634f, -2.49556f,
  -2.05557f,   -0.222577f,  3.7608f,    5.50475f,   2.7046f,   5.25952f,
  -1.91327f,   -0.0356497f, 1.47611f,   1.27499f,   -1.76108f, -0.578954f
};

static const float full_pixel_motion_search_based_split_logits_kernel_32[] = {
  -0.220382f, -0.693902f, 0.424827f, 0.379952f, -0.413791f, -0.326785f,
  -0.455086f, 0.242402f,  0.307986f, 0.175746f, 0.498901f,  -0.628053f,
  0.285447f,  0.230052f,  0.415151f, -0.842946f
};

static const float full_pixel_motion_search_based_split_layer_0_bias_32[] = {
  -1.80751f, 6.40356f,   -0.0512058f, -4.59163f, -0.369933f, -0.195755f,
  -0.16648f, -0.599755f, -5.35975f,   -1.21349f, 2.48414f,   1.07096f,
  -3.66684f, -6.17761f,  4.2159f,     -1.05286f
};

static const float full_pixel_motion_search_based_split_logits_bias_32[] = {
  -2.58676f
};

static const NN_CONFIG full_pixel_motion_search_based_split_nn_config_32 = {
  NUM_FEATURES_32,
  NUM_LOGITS_32,
  NUM_HIDDEN_LAYERS_32,
  {
      NUM_LAYER_0_UNITS_32,
  },
  {
      full_pixel_motion_search_based_split_layer_0_kernel_32,
      full_pixel_motion_search_based_split_logits_kernel_32,
  },
  {
      full_pixel_motion_search_based_split_layer_0_bias_32,
      full_pixel_motion_search_based_split_logits_bias_32,
  },
};

#undef NUM_HIDDEN_LAYERS_32
#undef NUM_FEATURES_32
#undef NUM_LAYER_0_UNITS_32
#undef NUM_LOGITS_32

// BLOCK_16X16
#define NUM_HIDDEN_LAYERS_16 1
#define NUM_FEATURES_16 6
#define NUM_LAYER_0_UNITS_16 16
#define NUM_LOGITS_16 1

static const float full_pixel_motion_search_based_split_layer_0_kernel_16[] = {
  -0.611497f,  -0.0422086f, -0.555957f,   -0.632451f, -0.144179f, -0.152722f,
  -0.330265f,  -0.419866f,  0.287343f,    0.385295f,  -0.424486f, 0.424281f,
  2.27442f,    -2.47933f,   5.24731f,     4.33827f,   4.73215f,   3.41909f,
  1.16058f,    -0.364505f,  0.12207f,     -0.287749f, 0.0509783f, -0.0200119f,
  1.52907f,    -1.1905f,    -2.56978f,    -3.00186f,  -3.56084f,  -3.89276f,
  0.00365657f, 1.57125f,    -4.421f,      -2.48803f,  -2.51531f,  -4.28646f,
  2.52248f,    -1.03377f,   -1.09607f,    -1.44633f,  -1.58736f,  -1.25927f,
  -1.45841f,   -0.566619f,  -0.246166f,   -0.182289f, -0.238156f, 0.177991f,
  0.0112509f,  -0.17677f,   -0.485877f,   0.0812852f, 0.104975f,  0.222793f,
  -0.372858f,  -0.48624f,   -0.00870389f, -0.385019f, 0.405842f,  0.288523f,
  0.167374f,   -0.204208f,  -8.74148f,    -8.59267f,  -8.42492f,  -8.3778f,
  -5.57063f,   -0.406818f,  -0.873199f,   -0.896224f, -0.701479f, -0.985736f,
  -0.625956f,  -0.0446202f, -0.509987f,   -0.321804f, -0.470759f, -0.248556f,
  -0.369436f,  -0.160828f,  0.0591148f,   0.405218f,  0.142584f,  -0.130106f,
  0.125321f,   0.0888179f,  7.34822f,     -6.71488f,  -7.06592f,  6.33224f,
  0.0333619f,  -0.377782f,  0.160767f,    -0.128169f, -0.484818f, -0.311973f
};

static const float full_pixel_motion_search_based_split_logits_kernel_16[] = {
  -0.132207f,   0.15176f,   -0.680086f, 0.605921f, -0.43294f,  0.485811f,
  -0.306286f,   0.551368f,  0.413904f,  0.548748f, -0.437391f, 0.560778f,
  -0.00685266f, -0.558657f, 0.122127f,  0.260165f
};

static const float full_pixel_motion_search_based_split_layer_0_bias_16[] = {
  -0.200928f, -0.074132f, 8.69963f,    -9.00807f,  9.08983f, -6.83586f,
  -3.89329f,  10.4881f,   -0.0670618f, 0.0f,       9.21614f, 8.41773f,
  -0.145851f, 0.0f,       -1.43038f,   -0.0460311f
};

static const float full_pixel_motion_search_based_split_logits_bias_16[] = {
  -4.19885f
};

static const NN_CONFIG full_pixel_motion_search_based_split_nn_config_16 = {
  NUM_FEATURES_16,
  NUM_LOGITS_16,
  NUM_HIDDEN_LAYERS_16,
  {
      NUM_LAYER_0_UNITS_16,
  },
  {
      full_pixel_motion_search_based_split_layer_0_kernel_16,
      full_pixel_motion_search_based_split_logits_kernel_16,
  },
  {
      full_pixel_motion_search_based_split_layer_0_bias_16,
      full_pixel_motion_search_based_split_logits_bias_16,
  },
};

#undef NUM_HIDDEN_LAYERS_16
#undef NUM_FEATURES_16
#undef NUM_LAYER_0_UNITS_16
#undef NUM_LOGITS_16

#if !CONFIG_DISABLE_FULL_PIXEL_SPLIT_8X8
// BLOCK_8X8
#define NUM_HIDDEN_LAYERS_8 1
#define NUM_FEATURES_8 6
#define NUM_LAYER_0_UNITS_8 16
#define NUM_LOGITS_8 1

static const float full_pixel_motion_search_based_split_layer_0_kernel_8[] = {
  0.0370236f,   -0.580211f,  2.0134f,    1.69637f,    2.43181f,   -0.521648f,
  -0.00375187f, 0.122712f,   -4.74411f,  7.36187f,    5.42574f,   -5.53557f,
  0.0993344f,   -0.358843f,  0.0765453f, -0.615987f,  -0.754633f, -0.175846f,
  0.714976f,    0.492862f,   0.346604f,  -1.23922f,   -2.67031f,  2.12749f,
  1.71511f,     -1.4239f,    2.09396f,   2.42478f,    2.40151f,   2.90487f,
  0.540813f,    -0.0954257f, -4.57571f,  -4.88078f,   -4.62386f,  -5.75167f,
  1.35351f,     -1.08114f,   1.43744f,   1.44333f,    0.608153f,  0.193742f,
  -0.405512f,   -0.155164f,  0.0771456f, -0.473182f,  -0.057984f, 0.140435f,
  0.743021f,    -0.418589f,  -0.377622f, -0.531411f,  -0.668025f, -0.826607f,
  1.37834f,     -1.07753f,   0.870466f,  0.516756f,   0.708689f,  0.286795f,
  -3.97895f,    -0.338629f,  2.79427f,   1.80561f,    1.46275f,   1.50438f,
  0.0232533f,   -0.43174f,   -0.348251f, 0.0863006f,  0.0321103f, 0.129674f,
  -1.12024f,    -0.0990596f, -0.283472f, -0.238713f,  -0.239175f, -0.40816f,
  -0.00106566f, 0.0972736f,  5.19284f,   -3.70862f,   6.39657f,   -5.27588f,
  -2.08003f,    0.38825f,    2.38771f,   -1.27501f,   -2.45619f,  3.07324f,
  0.616966f,    -0.451472f,  -0.319365f, 0.00807278f, -0.303261f, -0.351679f
};

static const float full_pixel_motion_search_based_split_logits_kernel_8[] = {
  -0.625847f, 0.381323f, 0.342475f, 0.526161f,  -0.665965f, -0.515317f,
  -0.406218f, 0.568007f, 0.479397f, -0.426116f, 0.615638f,  0.338572f,
  0.185583f,  0.308031f, 0.260748f, 0.531619f
};

static const float full_pixel_motion_search_based_split_layer_0_bias_8[] = {
  4.73775f,  -1.12658f, -0.258038f, -6.06696f, 1.79131f, 2.49609f,
  4.28388f,  0.0f,      -4.63598f,  3.06034f,  5.31994f, -0.152142f,
  0.514738f, -1.30098f, 3.00296f,   -3.83481f
};

static const float full_pixel_motion_search_based_split_logits_bias_8[] = {
  -3.44508f
};

static const NN_CONFIG full_pixel_motion_search_based_split_nn_config_8 = {
  NUM_FEATURES_8,
  NUM_LOGITS_8,
  NUM_HIDDEN_LAYERS_8,
  {
      NUM_LAYER_0_UNITS_8,
  },
  {
      full_pixel_motion_search_based_split_layer_0_kernel_8,
      full_pixel_motion_search_based_split_logits_kernel_8,
  },
  {
      full_pixel_motion_search_based_split_layer_0_bias_8,
      full_pixel_motion_search_based_split_logits_bias_8,
  },
};

#endif

// Model based on simple_motion_search

// Thresholds for doing a single type of partition
// TODO(chiyotsai@google.com): Set the thresholds for PARTITION_SPLIT.
static const float simple_motion_search_prune_part_only_thresh_128[10] = {
  1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f
};
static const float simple_motion_search_prune_part_only_thresh_64[10] = {
  1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f
};
static const float simple_motion_search_prune_part_only_thresh_32[10] = {
  1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f
};
static const float simple_motion_search_prune_part_only_thresh_16[10] = {
  1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f
};
static const float simple_motion_search_prune_part_only_thresh_8[10] = {
  1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f
};

// Thresholds for pruning a partition type
// TODO(chiyotsai@google.com): Retune the thresholds for rectangular partition.
static const float simple_motion_search_prune_part_prune_thresh_128[10] = {
  0.0f, 0.0110f, 0.0110f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f
};
static const float simple_motion_search_prune_part_prune_thresh_64[10] = {
  0.0f, 0.0110f, 0.0110f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f
};
static const float simple_motion_search_prune_part_prune_thresh_32[10] = {
  0.0f, 0.0110f, 0.0110f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f
};
static const float simple_motion_search_prune_part_prune_thresh_16[10] = {
  0.0f, 0.0110f, 0.0110f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f
};
static const float simple_motion_search_prune_part_prune_thresh_8[10] = {
  0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f
};

// Mean and std
static const float simple_motion_search_prune_part_mean_128[19] = {
  11.561261f, 11.626691f, 10.820066f, 10.880652f, 11.193911f,
  11.269741f, 10.509796f, 10.584754f, 12.659430f, 12.724323f,
  12.254200f, 12.326454f, 12.632568f, 12.694887f, 11.814313f,
  11.872458f, 13.690346f, 13.753730f, 5.165726f,
};
static const float simple_motion_search_prune_part_std_128[19] = {
  2.434728f, 2.429037f, 3.701918f, 3.709713f, 3.288111f, 3.286657f, 4.174337f,
  4.185339f, 2.531916f, 2.540137f, 3.488878f, 3.496263f, 2.459336f, 2.460739f,
  3.919058f, 3.930766f, 2.511685f, 2.524923f, 2.257989f,
};
static const float simple_motion_search_prune_part_mean_64[19] = {
  10.073195f, 10.158249f, 9.627341f,  9.708094f,  9.002025f,
  9.076430f,  8.597153f,  8.668316f,  11.021699f, 11.097507f,
  9.852887f,  9.919513f,  11.007151f, 11.085718f, 10.525035f,
  10.599575f, 11.936800f, 12.007580f, 4.860905f,
};
static const float simple_motion_search_prune_part_std_64[19] = {
  2.272113f, 2.256767f, 3.023892f, 3.027094f, 3.794186f, 3.808349f, 4.143885f,
  4.164291f, 2.262401f, 2.249636f, 4.039632f, 4.053496f, 2.234799f, 2.219867f,
  3.136350f, 3.139975f, 2.199973f, 2.187191f, 2.185985f,
};
static const float simple_motion_search_prune_part_mean_32[19] = {
  8.499073f, 8.600074f, 8.508158f,  8.611221f,  8.498978f, 8.599821f, 8.506126f,
  8.609448f, 9.481358f, 9.569901f,  9.481697f,  9.569918f, 9.469805f, 9.557789f,
  9.483047f, 9.572816f, 10.416696f, 10.496502f, 4.413157f,
};
static const float simple_motion_search_prune_part_std_32[19] = {
  2.129560f, 2.117602f, 2.115962f, 2.104043f, 2.136564f, 2.125870f, 2.125247f,
  2.114250f, 2.146261f, 2.134374f, 2.160289f, 2.149360f, 2.116179f, 2.103744f,
  2.099453f, 2.087138f, 2.115011f, 2.101419f, 2.024279f,
};
static const float simple_motion_search_prune_part_mean_16[19] = {
  6.990048f, 7.116367f, 6.883459f, 7.007796f, 6.993151f, 7.119445f, 6.886147f,
  7.010345f, 7.994230f, 8.099907f, 7.998478f, 8.104088f, 7.988468f, 8.092865f,
  7.868373f, 7.971079f, 8.946122f, 9.037547f, 3.976610f,
};
static const float simple_motion_search_prune_part_std_16[19] = {
  1.963746f, 1.954729f, 2.127820f, 2.126451f, 1.963392f, 1.955016f, 2.126736f,
  2.126004f, 1.991209f, 1.981070f, 1.992683f, 1.983143f, 1.986913f, 1.977408f,
  2.200119f, 2.197786f, 1.997332f, 1.986091f, 1.829684f,
};
static const float simple_motion_search_prune_part_mean_8[19] = {
  5.362649f, 5.561670f, 5.362880f, 5.564151f, 5.365307f, 5.565139f, 5.365830f,
  5.567452f, 6.453082f, 6.598073f, 6.458814f, 6.604363f, 6.454421f, 6.599441f,
  6.458431f, 6.604804f, 7.469143f, 7.585015f, 3.625800f,
};
static const float simple_motion_search_prune_part_std_8[19] = {
  1.846273f, 1.835266f, 1.846272f, 1.834365f, 1.836967f, 1.826428f, 1.837247f,
  1.825985f, 1.886601f, 1.874138f, 1.874622f, 1.862656f, 1.877218f, 1.865398f,
  1.874494f, 1.862057f, 1.896421f, 1.883210f, 1.670200f,
};

// BLOCK_128X128
#define NUM_HIDDEN_LAYERS_128 1
#define NUM_FEATURES_128 19
#define NUM_LAYER_0_UNITS_128 24
#define NUM_LOGITS_128 4

static const float simple_motion_search_prune_part_logits_kernel_128[] = {
  -0.12815f,   -1.2107f,    0.525183f,  0.379155f,   -2.04966f,  -0.212818f,
  -0.0609484f, -0.119338f,  1.07054f,   -0.0304129f, 0.563817f,  -0.0204729f,
  0.757013f,   0.464791f,   0.191185f,  0.183903f,   -2.71738f,  1.41455f,
  -0.449089f,  -0.0344047f, 0.349133f,  -0.945292f,  0.63729f,   -0.973444f,
  -0.203447f,  -19.7875f,   -12.7536f,  -0.260806f,  0.934733f,  -3.17648f,
  -1.11806f,   -4.63145f,   -16.0947f,  -24.203f,    -2.94649f,  -8.34109f,
  -0.720804f,  -5.16623f,   -0.443715f, 0.510014f,   -4.2846f,   -11.2272f,
  0.187633f,   -10.0189f,   -0.915574f, -0.235434f,  -2.57912f,  0.151642f,
  -0.180428f,  -0.110439f,  0.349015f,  -1.83906f,   -3.38461f,  -0.309185f,
  -9.3706f,    -5.54824f,   0.45334f,   -8.48801f,   0.392325f,  -4.19948f,
  -0.535814f,  -4.92133f,   0.0159878f, 0.275078f,   -2.65358f,  1.32524f,
  -0.761795f,  -14.782f,    -4.15338f,  -0.177581f,  -0.158376f, -0.0832793f,
  0.226712f,   -0.349409f,  0.0529463f, -0.412873f,  -0.241807f, 0.19054f,
  0.79237f,    0.218937f,   -1.60466f,  0.845653f,   -0.287058f, 0.766271f,
  -0.455829f,  0.00261991f, 0.506805f,  -0.0593004f, 2.25348f,   -2.29282f,
  0.0491916f,  0.38261f,    -0.281848f, -0.17802f,   -0.472124f, 0.204326f
};

static const float simple_motion_search_prune_part_layer_0_kernel_128[] = {
  0.485797f,   -0.326149f,  0.238042f,     -1.41255f,     -0.00899515f,
  -0.715324f,  0.623049f,   0.502229f,     0.54064f,      -0.0667834f,
  0.0591777f,  -0.435869f,  0.221466f,     -0.222184f,    0.696493f,
  -0.514433f,  -0.771882f,  -0.080914f,    -1.58162f,     -0.214871f,
  -0.0141856f, -0.566004f,  -1.01071f,     -0.0400122f,   -0.212581f,
  0.144009f,   0.156065f,   0.419812f,     0.351579f,     -0.0363798f,
  0.272286f,   0.177348f,   0.643484f,     -0.686943f,    -1.5021f,
  -0.283203f,  -0.317958f,  0.834615f,     1.18195f,      0.704402f,
  0.723567f,   0.0765064f,  0.0998969f,    0.358114f,     -0.471958f,
  -0.33568f,   -0.0455057f, 0.0659417f,    0.717502f,     1.40203f,
  -1.78214f,   -1.00743f,   -0.217992f,    -0.244456f,    -0.681988f,
  0.199185f,   1.27797f,    0.744351f,     0.853728f,     0.976386f,
  1.5212f,     0.246886f,   0.458125f,     -0.278508f,    -0.601164f,
  -0.874409f,  -0.0882617f, -0.93093f,     -0.0279819f,   0.289613f,
  -0.795015f,  1.2224f,     0.464495f,     -0.996107f,    -1.05131f,
  0.780663f,   1.70779f,    -0.122481f,    2.64976f,      0.284897f,
  -0.129159f,  -0.0472128f, 0.190105f,     0.549306f,     -0.829239f,
  -2.87392f,   0.0735607f,  -1.00692f,     -0.0171315f,   0.217386f,
  0.715055f,   1.2976f,     -0.387801f,    -0.301424f,    -0.265159f,
  0.381381f,   -0.637641f,  0.424966f,     0.317794f,     1.99832f,
  0.604094f,   0.444838f,   0.354898f,     -0.2603f,      -0.625206f,
  1.37372f,    0.474128f,   1.47492f,      -0.318267f,    -0.32122f,
  -1.29434f,   0.426303f,   -0.604944f,    -2.33438f,     -1.33476f,
  -2.13254f,   2.28472f,    0.844804f,     0.366394f,     0.148218f,
  -0.0996413f, -0.665787f,  1.30951f,      0.447868f,     -0.160892f,
  0.336539f,   -0.461251f,  -0.940939f,    1.9886f,       0.774578f,
  -0.0274317f, -0.288034f,  -0.188082f,    0.296018f,     -0.171846f,
  0.245583f,   0.39913f,    -0.0544446f,   0.823534f,     0.215969f,
  -0.393239f,  -0.208693f,  -0.336752f,    0.258191f,     1.03315f,
  -0.0356378f, -0.35999f,   0.48529f,      1.09123f,      -0.243654f,
  0.131594f,   -2.5832f,    1.26485f,      -0.700618f,    0.466223f,
  -0.525984f,  2.19872f,    0.685663f,     1.40228f,      1.10528f,
  0.0451285f,  -0.39981f,   -0.644025f,    -1.31137f,     0.836056f,
  -0.884238f,  0.394441f,   -0.16017f,     -1.45246f,     -1.24252f,
  0.195623f,   0.716485f,   -0.0522381f,   0.271321f,     0.560211f,
  0.685537f,   -0.117774f,  -0.227596f,    0.346762f,     -0.402137f,
  0.00528979f, 0.756388f,   0.181091f,     -0.513235f,    -0.354307f,
  1.04355f,    -0.114563f,  0.457349f,     -0.525175f,    -1.306f,
  -1.57685f,   -1.69919f,   0.393799f,     1.35822f,      -0.496799f,
  0.102504f,   -0.0950497f, 0.518029f,     0.211844f,     0.385925f,
  0.366614f,   0.52377f,    -0.22419f,     -0.209355f,    0.343361f,
  0.0535484f,  0.320409f,   0.467987f,     -0.00542184f,  -1.02011f,
  0.488822f,   -0.248647f,  0.113298f,     -0.665206f,    0.374419f,
  0.731859f,   1.20004f,    -0.000319085f, -0.000491633f, -0.260543f,
  0.804927f,   -0.410925f,  0.960751f,     0.281493f,     0.607288f,
  -0.681745f,  -0.0925707f, -2.06876f,     -0.52926f,     0.864695f,
  -0.712922f,  0.706643f,   -0.651177f,    -0.231887f,    -0.318515f,
  0.0635488f,  -0.183294f,  -0.589271f,    0.288583f,     0.38702f,
  0.582912f,   0.225519f,   1.23027f,      0.108471f,     1.3328f,
  0.689896f,   -2.21988f,   -0.337789f,    -0.762238f,    1.79149f,
  0.840519f,   0.825442f,   0.460811f,     0.434437f,     2.13268f,
  -0.341805f,  -0.139746f,  -1.66773f,     -0.583511f,    -0.238547f,
  0.156871f,   0.719404f,   1.05882f,      -0.173445f,    -0.867368f,
  0.170469f,   1.57755f,    1.36095f,      -0.418987f,    -0.396689f,
  0.289496f,   -0.292606f,  0.688943f,     0.176553f,     0.853828f,
  1.19608f,    -0.557087f,  -0.58118f,     1.12805f,      0.232023f,
  -0.167864f,  -0.222265f,  -0.719284f,    -0.802184f,    -2.85383f,
  -1.01816f,   -1.344f,     -0.154875f,    0.308999f,     -0.62822f,
  0.389045f,   -0.498046f,  -0.0646747f,   0.056343f,     0.188288f,
  0.493475f,   0.241337f,   0.122423f,     -0.506522f,    0.0492923f,
  0.0642163f,  -0.508636f,  0.0328815f,    0.78567f,      0.224673f,
  0.627972f,   0.759423f,   1.16089f,      1.28274f,      1.19646f,
  1.63401f,    1.56657f,    -0.131442f,    -0.423053f,    -0.599536f,
  -1.20933f,   0.0438751f,  -0.538444f,    -0.749136f,    -0.769951f,
  -1.06683f,   -1.66474f,   0.136208f,     1.35745f,      -0.960854f,
  2.32612f,    0.349384f,   1.04506f,      -0.888194f,    1.28114f,
  0.579831f,   0.53927f,    -1.07214f,     0.456708f,     -0.884062f,
  0.789767f,   -0.776746f,  -0.0143946f,   -0.930974f,    -0.632568f,
  -1.487f,     0.0284456f,  -0.865849f,    -1.51263f,     0.117335f,
  -0.671304f,  -0.367558f,  -0.650224f,    1.09562f,      0.246097f,
  0.461775f,   -0.722606f,  0.0886829f,    -0.490978f,    1.92718f,
  0.864959f,   0.0705385f,  -0.543902f,    1.4704f,       -0.643494f,
  0.194486f,   0.890657f,   0.901154f,     -0.458931f,    0.209679f,
  0.303869f,   -0.167078f,  1.60197f,      1.05005f,      -0.499959f,
  0.930484f,   -0.555236f,  -0.778482f,    -0.772935f,    -0.590988f,
  -0.122397f,  -0.346605f,  0.100747f,     -0.237732f,    -0.180927f,
  0.136491f,   -0.230076f,  1.52049f,      1.70212f,      0.415758f,
  -0.811552f,  0.570249f,   1.73167f,      0.808393f,     -1.28608f,
  0.518307f,   0.601205f,   0.258751f,     -0.498631f,    -0.790802f,
  -0.465072f,  -0.507542f,  0.312956f,     -0.485421f,    -0.0525576f,
  0.24136f,    -0.201595f,  -0.721587f,    0.190955f,     -0.123108f,
  -0.263243f,  -0.36142f,   -0.105093f,    0.0651603f,    0.240065f,
  0.241104f,   -0.238277f,  -1.11714f,     1.50723f,      0.443715f,
  1.83051f,    1.29719f,    -0.0367089f,   1.57883f,      1.96011f,
  0.0373268f,  0.480469f,   0.497726f,     1.47078f,      -0.359254f,
  0.120578f,   -0.651964f,  -0.537215f,    -1.20527f,     -0.374681f,
  -0.443443f,  -0.39421f,   0.688228f,     0.0989643f,    -1.28785f,
  -1.24392f,   -0.165236f,  1.1812f,       -0.76329f,     1.44085f,
  -0.540544f,  0.0958765f,  -0.31224f,     0.471211f,     -0.997358f,
  1.16174f,    -0.948466f,  0.660749f,     -0.574517f,    1.42706f,
  -0.477758f,  0.509914f,   -0.930534f,    0.722869f,     -0.955477f,
  -0.383073f
};

static const float simple_motion_search_prune_part_logits_bias_128[] = {
  0.814703f, -1.18485f, -1.49788f, -0.0054509f
};

static const float simple_motion_search_prune_part_layer_0_bias_128[] = {
  -0.283185f, -2.5867f,  -2.07531f, -2.31513f,  -1.85869f,  -0.310685f,
  -0.802324f, 0.056964f, -1.43881f, 2.84016f,   -1.15494f,  -2.30652f,
  0.015622f,  0.303776f, 0.774322f, -1.25979f,  -2.37144f,  -1.35687f,
  0.743607f,  0.768569f, -1.09908f, -0.470101f, -0.615497f, 1.04214f
};

static const NN_CONFIG simple_motion_search_prune_part_nn_config_128 = {
  NUM_FEATURES_128,
  NUM_LOGITS_128,
  NUM_HIDDEN_LAYERS_128,
  {
      NUM_LAYER_0_UNITS_128,
  },
  {
      simple_motion_search_prune_part_layer_0_kernel_128,
      simple_motion_search_prune_part_logits_kernel_128,
  },
  {
      simple_motion_search_prune_part_layer_0_bias_128,
      simple_motion_search_prune_part_logits_bias_128,
  },
};

#undef NUM_HIDDEN_LAYERS_128
#undef NUM_FEATURES_128
#undef NUM_LAYER_0_UNITS_128
#undef NUM_LOGITS_128

// BLOCK_64X64
#define NUM_HIDDEN_LAYERS_64 1
#define NUM_FEATURES_64 19
#define NUM_LAYER_0_UNITS_64 24
#define NUM_LOGITS_64 10

static const float simple_motion_search_prune_part_logits_kernel_64[] = {
  -2.71432f,    0.853994f,   0.740156f,   -0.30982f,   -0.448512f,  0.0984177f,
  -0.664821f,   -0.150188f,  0.104798f,   1.27746f,    0.217043f,   -0.553914f,
  -0.985639f,   1.99904f,    -0.994877f,  0.0697683f,  0.64856f,    -0.412276f,
  -0.740292f,   0.93851f,    0.647461f,   0.874707f,   -1.06881f,   0.704589f,
  0.641148f,    -0.23997f,   -0.0955951f, 0.249869f,   -0.240726f,  0.420737f,
  -0.558423f,   -0.863005f,  0.981276f,   -0.520796f,  0.206416f,   -0.0512005f,
  -0.76665f,    -0.341038f,  -0.727661f,  0.348269f,   -0.0786858f, -0.370214f,
  -0.292226f,   -0.106107f,  0.262638f,   1.0065f,     0.558744f,   -0.0492801f,
  -1.22877f,    0.225909f,   0.485238f,   -0.009513f,  -0.299224f,  -0.405938f,
  -0.379131f,   0.0190173f,  -0.66387f,   0.846164f,   0.298606f,   -0.811507f,
  -0.0853147f,  -0.146277f,  0.0860954f,  0.151524f,   0.239613f,   -0.0141985f,
  0.684708f,    -0.0732401f, -0.709585f,  -1.86211f,   -0.622393f,  -0.503456f,
  0.482376f,    -0.10075f,   -0.449184f,  0.999368f,   0.442391f,   -0.60335f,
  0.631041f,    0.377315f,   -0.141438f,  -0.395021f,  -0.750439f,  0.79456f,
  0.29555f,     -1.51727f,   0.964882f,   -0.256708f,  -0.182677f,  0.727967f,
  0.411337f,    -0.252901f,  -0.546165f,  -0.620733f,  0.948828f,   0.187498f,
  -6.20879f,    0.1671f,     -0.131667f,  -0.0719152f, -0.101839f,  -0.326827f,
  0.00418824f,  -0.819253f,  -0.168854f,  -0.588437f,  -0.192699f,  0.126879f,
  -0.0287044f,  -0.686708f,  -0.445826f,  -0.0993483f, -0.682881f,  0.0685043f,
  -0.472371f,   -0.399788f,  0.170985f,   -0.164692f,  -0.380181f,  -0.268889f,
  -3.16193f,    -0.965943f,  -0.178737f,  -0.517274f,  -0.102274f,  -0.359742f,
  0.0117419f,   -0.0690246f, 0.206539f,   -1.29449f,   0.0976349f,  -0.188444f,
  0.160939f,    -0.387867f,  -0.34513f,   -0.221073f,  -0.326615f,  0.0302811f,
  0.245349f,    -0.381586f,  0.0414228f,  -0.414076f,  0.0232891f,  -0.118837f,
  -2.81659f,    -0.288328f,  -0.0328096f, -0.61535f,   -0.23593f,   -1.16019f,
  -0.0619081f,  0.0646133f,  -0.313036f,  -0.390373f,  -0.0481636f, 0.0450287f,
  0.196415f,    -0.717419f,  -0.0707908f, -0.2078f,    -0.459761f,  0.230835f,
  -0.0703036f,  -0.112402f,  -0.170908f,  0.0485359f,  -0.237293f,  -0.989058f,
  -2.05295f,    0.134268f,   -0.173105f,  -0.493955f,  -0.28408f,   -0.91465f,
  -0.00206022f, -0.297255f,  0.161636f,   -0.52414f,   -0.324677f,  -0.321039f,
  0.188412f,    -0.333399f,  -0.325067f,  -0.024484f,  0.128572f,   0.20541f,
  -0.0743476f,  0.0762302f,  -0.0370672f, -1.53757f,   -0.199054f,  -0.318512f,
  -3.41239f,    -0.50942f,   0.100088f,   0.395587f,   0.00633016f, 0.851201f,
  -0.0700995f,  -0.685436f,  0.0817234f,  -0.632139f,  -0.41931f,   0.15613f,
  -0.201166f,   -0.0721472f, -0.239791f,  0.656797f,   -0.501886f,  -0.160969f,
  -0.561536f,   -0.491154f,  -0.213447f,  0.21926f,    -0.542261f,  0.594975f,
  -1.75303f,    0.284615f,   -0.0128245f, -0.0316972f, -0.300138f,  -0.980628f,
  -0.332859f,   0.19298f,    -0.248332f,  0.445278f,   -0.470188f,  -0.483686f,
  0.361407f,    -0.363551f,  0.175335f,   -0.401025f,  0.494573f,   0.366983f,
  0.302351f,    -0.368503f,  -0.443071f,  -0.562775f,  -0.375816f,  -0.657459f
};

static const float simple_motion_search_prune_part_layer_0_kernel_64[] = {
  0.615272f,   -0.151592f,   0.346172f,   -0.0656032f,  0.212875f,
  0.0798838f,  -0.146093f,   -0.230484f,  -0.620322f,   0.0277852f,
  -0.400931f,  -0.777044f,   -0.0871401f, -0.248128f,   0.471518f,
  -0.34174f,   -0.149884f,   -0.0763207f, 0.900372f,    0.233323f,
  -0.788699f,  0.28221f,     0.327214f,   -0.244877f,   -0.414568f,
  0.0472988f,  0.168193f,    0.64126f,    0.56686f,     -0.318429f,
  0.530612f,   -0.750709f,   0.0400333f,  -0.023951f,   -0.0218727f,
  -0.0449836f, -0.0764245f,  -0.070088f,  -0.0427561f,  -0.0873884f,
  -0.216423f,  0.622787f,    0.0297492f,  -0.233673f,   0.510639f,
  0.481654f,   -0.234274f,   0.347734f,   -0.480302f,   0.832741f,
  0.228223f,   0.247019f,    -0.32416f,   0.352315f,    -1.1491f,
  0.00806435f, -0.439654f,   0.151723f,   -0.0719021f,  0.463499f,
  0.00134313f, 0.0553619f,   -0.582163f,  -0.215118f,   -0.291413f,
  0.889738f,   0.284575f,    0.00450409f, -0.896799f,   0.0303598f,
  0.187935f,   -0.160993f,   0.089854f,   0.0450689f,   -0.548899f,
  -0.10556f,   0.29384f,     -0.154158f,  0.423591f,    0.322065f,
  0.244633f,   -0.320866f,   0.739022f,   -0.500495f,   0.595557f,
  -0.62001f,   0.259688f,    0.114985f,   -0.13888f,    -0.0737616f,
  0.801863f,   -0.0606944f,  0.238712f,   -0.0636556f,  0.04317f,
  0.359843f,   -0.273265f,   0.782092f,   0.341857f,    0.884373f,
  0.378388f,   0.632049f,    0.633597f,   -0.32103f,    -1.1014f,
  -0.852525f,  -0.867999f,   0.228625f,   0.444601f,    0.246595f,
  0.386288f,   -0.341772f,   -0.335849f,  -0.482717f,   0.00928882f,
  -0.262618f,  0.497003f,    0.579316f,   0.371681f,    -0.440324f,
  0.115786f,   -0.112295f,   0.07564f,    -0.326419f,   -0.195152f,
  0.315485f,   -0.368989f,   0.281852f,   0.418865f,    0.807047f,
  0.293759f,   -0.129749f,   -1.26096f,   -0.0526466f,  -0.618876f,
  0.330563f,   0.26479f,     0.364751f,   0.68361f,     0.500237f,
  -0.564011f,  0.158277f,    -0.214105f,  0.50558f,     0.69422f,
  -0.172224f,  -0.280568f,   0.17241f,    -0.500658f,   -0.00418558f,
  -0.420356f,  0.0453594f,   0.00471851f, -0.273979f,   0.355633f,
  0.515393f,   0.0699701f,   -0.413576f,  0.487255f,    -0.388845f,
  -0.192441f,  -0.353274f,   -0.1773f,    0.256746f,    -0.380197f,
  0.023061f,   0.431125f,    1.0368f,     -0.0915799f,  -0.268898f,
  0.0408016f,  0.593356f,    0.308486f,   0.508452f,    -0.0623963f,
  0.307066f,   0.180916f,    0.326197f,   0.246641f,    0.270665f,
  -0.145655f,  -0.341277f,   0.0218018f,  -0.326939f,   -0.203528f,
  -0.25496f,   -0.772783f,   -0.306114f,  -0.79778f,    0.690016f,
  -0.183109f,  -0.076211f,   -0.474873f,  -0.0219729f,  -0.152253f,
  -0.0315833f, -0.134908f,   -0.111871f,  0.0409385f,   -0.282586f,
  -0.101171f,  0.351942f,    0.30023f,    0.369243f,    0.0619639f,
  -0.170842f,  -0.235501f,   -0.615927f,  0.883574f,    0.150949f,
  -0.338489f,  -0.213431f,   -0.6075f,    -0.107739f,   -0.251963f,
  0.143906f,   0.254205f,    -0.260084f,  0.224897f,    0.609902f,
  0.5606f,     0.795273f,    0.117204f,   0.345592f,    0.243912f,
  0.0626369f,  -0.166448f,   -0.886364f,  -0.280833f,   -0.0891074f,
  0.0372486f,  -0.138729f,   0.120189f,   0.345857f,    0.176341f,
  0.481862f,   -0.137464f,   -0.208001f,  0.621677f,    -0.121462f,
  0.00445475f, 0.159351f,    0.149918f,   0.198679f,    -0.489814f,
  -0.30931f,   -0.39161f,    0.268615f,   0.323864f,    0.770061f,
  0.27962f,    0.536173f,    0.122727f,   0.571712f,    0.48351f,
  -0.13558f,   -0.426532f,   -0.100426f,  -0.209695f,   0.470483f,
  -0.424789f,  0.0973791f,   -0.296483f,  -0.302057f,   -0.918591f,
  0.16328f,    0.0335916f,   0.415762f,   -0.235873f,   -0.00934998f,
  -0.0967718f, 0.616418f,    0.0931619f,  -0.447975f,   0.156388f,
  -0.40139f,   0.382807f,    -0.578455f,  1.01437f,     0.37469f,
  -0.986411f,  -0.827175f,   0.0344976f,  -0.00244486f, -0.142117f,
  -0.344406f,  -0.0124787f,  -0.226427f,  -0.301835f,   -0.705097f,
  0.214542f,   -0.0346878f,  -0.255193f,  0.552685f,    -0.104125f,
  0.77408f,    0.00984395f,  0.0476041f,  -0.244548f,   -0.35082f,
  -0.487322f,  0.700091f,    -0.138812f,  -0.0110718f,  -0.0400376f,
  0.254488f,   -0.0867923f,  -0.215463f,  1.03355f,     0.214947f,
  0.385536f,   0.140597f,    -0.234973f,  -0.0611124f,  1.0974f,
  0.463592f,   -0.393788f,   -0.428132f,  -0.14664f,    -0.156533f,
  -0.113426f,  -0.111081f,   -0.0228256f, 0.354909f,    -0.0232978f,
  0.177394f,   0.0503901f,   -0.220314f,  0.170207f,    0.236719f,
  0.681525f,   -0.245544f,   -0.119278f,  -0.258491f,   -0.285309f,
  0.186384f,   -0.119177f,   -0.279398f,  -0.097341f,   -0.324634f,
  -0.296797f,  -1.3325f,     0.147225f,   0.0158408f,   -0.0365257f,
  -0.166737f,  -0.159859f,   -0.0765398f, 0.0973026f,   0.294529f,
  -0.16425f,   0.241506f,    0.561487f,   0.799885f,    -0.565667f,
  -0.254387f,  -0.360831f,   -0.138432f,  0.406999f,    0.463259f,
  -0.497314f,  -0.00549591f, -0.0313973f, -0.386042f,   -0.364537f,
  -0.079987f,  0.148503f,    0.0532473f,  -0.0196838f,  0.232687f,
  0.212998f,   0.2142f,      0.409001f,   -0.104871f,   -0.217793f,
  0.0161162f,  -0.371663f,   0.887427f,   0.420187f,    -0.649711f,
  -0.398999f,  0.448972f,    -0.116108f,  0.0444676f,   -0.501289f,
  -0.0410878f, 0.00447241f,  -0.402102f,  -0.0926268f,  -0.254362f,
  -0.395526f,  0.165273f,    0.339347f,   0.91932f,     -0.280113f,
  0.320112f,   -0.102728f,   -0.131682f,  -0.566621f,   0.386611f,
  0.146975f,   0.333248f,    -0.179748f,  0.655328f,    0.222658f,
  0.349512f,   -0.135588f,   -0.22506f,   -0.353001f,   -0.400244f,
  -0.815125f,  0.72407f,     0.281178f,   -0.109426f,   -0.0977383f,
  -0.679406f,  -0.401318f,   0.308941f,   -0.594461f,   0.482289f,
  -0.168467f,  0.76529f,     -0.155056f,  0.0874018f,   0.266124f,
  -0.0808725f, 0.078792f,    -0.33271f,   -1.0637f,     -0.172125f,
  0.427025f,   0.332865f,    0.625523f,   0.264166f,    -0.843882f,
  -0.275777f,  -0.657372f,   0.172814f,   0.0490389f,   -0.561928f,
  0.0998399f,  0.106047f,    0.39061f,    0.422161f,    0.46369f,
  -0.364271f,  -0.326968f,   -0.527243f,  -0.618535f,   -0.287804f,
  -0.211365f,  0.349277f,    0.456535f,   -0.0815191f,  -0.156835f,
  0.57273f
};

static const float simple_motion_search_prune_part_logits_bias_64[] = {
  0.272852f,  -0.260088f, 0.11881f,   0.146764f,  0.00289019f,
  -0.559007f, -0.203668f, -0.268267f, -0.218921f, -0.260717f
};

static const float simple_motion_search_prune_part_layer_0_bias_64[] = {
  -2.12804f,   0.445147f,  -0.0210471f, 0.533662f,   0.662023f,  0.020519f,
  -0.0452071f, -0.343995f, 0.112379f,   -0.16776f,   0.112004f,  0.932147f,
  -1.22944f,   -0.822248f, 0.370083f,   -0.0951491f, 0.0631258f, -0.875801f,
  0.996276f,   0.116103f,  0.925914f,   0.054293f,   -1.02697f,  -0.359516f
};

static const NN_CONFIG simple_motion_search_prune_part_nn_config_64 = {
  NUM_FEATURES_64,
  NUM_LOGITS_64,
  NUM_HIDDEN_LAYERS_64,
  {
      NUM_LAYER_0_UNITS_64,
  },
  {
      simple_motion_search_prune_part_layer_0_kernel_64,
      simple_motion_search_prune_part_logits_kernel_64,
  },
  {
      simple_motion_search_prune_part_layer_0_bias_64,
      simple_motion_search_prune_part_logits_bias_64,
  },
};

#undef NUM_HIDDEN_LAYERS_64
#undef NUM_FEATURES_64
#undef NUM_LAYER_0_UNITS_64
#undef NUM_LOGITS_64

// BLOCK_32X32
#define NUM_HIDDEN_LAYERS_32 1
#define NUM_FEATURES_32 19
#define NUM_LAYER_0_UNITS_32 24
#define NUM_LOGITS_32 10

static const float simple_motion_search_prune_part_logits_kernel_32[] = {
  -1.22965f,   0.49978f,    -0.376271f,  0.0615445f,  -0.212491f,  0.58427f,
  0.142683f,   2.62142f,    -0.459751f,  -0.570143f,  0.72257f,    -0.64127f,
  0.266919f,   0.3235f,     0.64405f,    -0.0398269f, -1.82822f,   -0.366573f,
  0.753387f,   -0.274241f,  -0.484971f,  -0.503907f,  -0.911176f,  -0.455827f,
  -0.706345f,  0.0687611f,  -0.362788f,  -0.369416f,  -0.530408f,  0.0812615f,
  -0.863012f,  -0.613333f,  -0.268833f,  0.0982181f,  0.19374f,    -0.147078f,
  -0.0200551f, 0.363817f,   0.179229f,   0.429671f,   0.905826f,   -0.441191f,
  0.48874f,    0.539192f,   -0.418992f,  -0.468762f,  -0.482158f,  -0.770778f,
  -0.743739f,  0.0175955f,  -0.40662f,   0.0276107f,  0.0110658f,  -0.119298f,
  0.698777f,   -0.187602f,  -0.300483f,  -0.147972f,  0.324042f,   -0.0265165f,
  -0.375496f,  0.245762f,   -0.111271f,  -0.829879f,  -0.434606f,  -0.367099f,
  0.113229f,   -0.755101f,  -0.0623393f, -0.13764f,   -0.205864f,  -0.332027f,
  0.966638f,   0.477078f,   0.262501f,   -0.110232f,  0.141242f,   -0.699602f,
  -0.14943f,   -2.36868f,   0.556236f,   0.345883f,   -0.466765f,  0.279446f,
  -0.56809f,   -0.356351f,  -0.503855f,  -0.607959f,  -0.0328514f, 0.313352f,
  -0.644447f,  0.221808f,   0.254575f,   0.476802f,   1.40433f,    0.317169f,
  0.109761f,   -0.0105197f, -0.22896f,   -0.389234f,  0.423948f,   -0.272114f,
  -1.02704f,   -1.50706f,   0.0563541f,  -0.0371609f, -0.306187f,  0.0570354f,
  -0.367998f,  0.0949103f,  -0.254703f,  -0.0853516f, 1.56471f,    -0.594372f,
  -0.23582f,   0.267108f,   0.015297f,   -0.318317f,  0.287599f,   -0.687022f,
  0.360804f,   -0.177637f,  -0.118144f,  -0.418225f,  -0.985658f,  -0.391334f,
  -0.772539f,  -0.44002f,   0.0722112f,  -0.0825626f, 0.0466844f,  0.0525818f,
  -0.788047f,  0.120401f,   -0.785688f,  -0.346177f,  0.240363f,   0.0248826f,
  -0.0815654f, 0.39317f,    -0.122372f,  0.199969f,   0.202777f,   -0.1979f,
  0.313558f,   -0.180202f,  0.191204f,   -0.313598f,  0.155464f,   -0.600106f,
  0.0230461f,  -0.718126f,  0.266874f,   -0.313614f,  0.0352148f,  0.131058f,
  -0.221112f,  0.115419f,   -1.41928f,   -0.909453f,  0.341747f,   -0.25318f,
  -0.312476f,  -0.288919f,  -0.0135884f, -0.278496f,  0.381449f,   -0.0725586f,
  0.254479f,   -0.0658647f, -0.694657f,  -0.0653643f, -0.0233378f, -0.484902f,
  -0.104919f,  -1.52446f,   0.0140919f,  -0.142396f,  -0.11836f,   0.113235f,
  -1.21564f,   0.0618471f,  0.0421833f,  -0.883143f,  0.288008f,   -0.278322f,
  -0.185151f,  -0.616223f,  0.334549f,   0.370898f,   0.24646f,    -0.027439f,
  0.366905f,   -0.40628f,   0.0260464f,  -0.506151f,  0.0191214f,  -0.104617f,
  -0.848722f,  -1.66357f,   -0.194607f,  0.0346545f,  -0.412502f,  0.200471f,
  -0.285588f,  0.0309609f,  -0.150546f,  0.569096f,   0.210382f,   0.14322f,
  0.908182f,   1.23553f,    -0.432935f,  -0.0963189f, -0.610778f,  -0.532583f,
  -0.302028f,  -0.600906f,  -0.0777476f, 0.0230625f,  0.375802f,   -0.466292f,
  1.01104f,    -1.16706f,   0.0121855f,  0.0100479f,  -0.147181f,  0.255058f,
  -0.285898f,  -0.167804f,  -0.240171f,  -1.15287f,   -1.51181f,   0.0859809f,
  0.0811324f,  -0.829305f,  0.272793f,   0.407484f,   0.324943f,   0.230197f
};

static const float simple_motion_search_prune_part_layer_0_kernel_32[] = {
  -0.0711848f, 0.187893f,     -0.0532872f,  -0.0403218f, 0.132223f,
  0.0150309f,  0.132917f,     -0.00883543f, -0.0614934f, 0.207838f,
  -0.102772f,  0.127833f,     -0.332145f,   0.00237219f, -0.338402f,
  0.123288f,   -0.248341f,    -0.0182967f,  -1.16283f,   -0.166611f,
  -0.220962f,  -0.268939f,    -0.207455f,   -0.214904f,  -0.0639896f,
  -0.0729676f, -0.000552725f, 0.217902f,    0.350537f,   -0.0217492f,
  0.136239f,   0.0641448f,    0.515814f,    0.525507f,   0.240539f,
  0.109375f,   0.322722f,     -1.20791f,    0.323287f,   0.0231209f,
  -0.194629f,  0.143504f,     0.193943f,    -0.15059f,   -0.0156431f,
  -0.210354f,  0.13426f,      -0.379795f,   0.0585494f,  0.0947257f,
  0.948153f,   0.492681f,     -0.977907f,   -0.30367f,   0.216922f,
  -0.366185f,  0.00734769f,   0.528627f,    0.334327f,   0.0222445f,
  0.400606f,   -0.0313966f,   -0.047664f,   -0.512993f,  -0.433836f,
  0.340769f,   -0.131347f,    -0.518235f,   -0.220933f,  -0.379338f,
  -0.116978f,  0.143766f,     0.456281f,    -0.0921022f, -0.0109533f,
  -0.107467f,  0.335672f,     -0.313228f,   0.175586f,   0.108769f,
  0.129646f,   -0.053502f,    0.272574f,    0.220172f,   1.51046f,
  0.255032f,   -0.162058f,    -0.770721f,   0.238623f,   -0.65159f,
  -0.0354393f, -0.577323f,    0.0954972f,   -0.661719f,  0.227893f,
  -0.0584787f, 0.234849f,     -0.16515f,    -0.247194f,  0.12563f,
  0.39043f,    -0.178219f,    -0.0629665f,  0.395761f,   0.24224f,
  -0.336032f,  0.552893f,     -0.300073f,   -0.235499f,  -0.33557f,
  0.0398952f,  -0.853526f,    -0.550247f,   1.13965f,    0.197325f,
  -0.0750203f, 0.145096f,     0.128642f,    0.113606f,   0.0972738f,
  0.219874f,   0.252284f,     0.833398f,    0.398332f,   0.802753f,
  0.650573f,   -0.725374f,    -0.548798f,   -0.668723f,  -0.705524f,
  -0.929613f,  -0.138145f,    0.161306f,    0.578878f,   0.0605056f,
  0.720406f,   0.163571f,     0.707962f,    -0.0777347f, 0.52085f,
  0.279096f,   0.180012f,     -0.459535f,   0.219678f,   -0.273058f,
  -0.030387f,  -0.262664f,    0.367791f,    -0.899145f,  -1.07191f,
  -1.15497f,   0.460442f,     0.020009f,    -0.329794f,  0.846777f,
  0.287855f,   0.603544f,     0.645424f,    0.00753003f, -0.0666031f,
  -0.141114f,  -0.149588f,    -0.431897f,   -0.591811f,  0.134026f,
  0.0933469f,  -0.130808f,    -0.0335611f,  -0.488446f,  -0.275566f,
  -0.937488f,  0.245793f,     -0.548915f,   0.0108641f,  -0.216292f,
  0.00680863f, -0.113137f,    -0.137064f,   0.083321f,   0.689742f,
  -0.213193f,  0.172408f,     -0.123794f,   0.383401f,   -0.496176f,
  0.427836f,   -0.644447f,    0.967995f,    0.181371f,   0.301512f,
  -0.376098f,  -0.0571203f,   0.0012891f,   0.467542f,   -0.400791f,
  -0.204521f,  0.253847f,     0.107368f,    -0.434741f,  -0.389665f,
  0.30953f,    0.053949f,     -0.0415711f,  0.0432576f,  -0.319656f,
  -0.228939f,  -0.0928546f,   0.164408f,    1.26655f,    0.991928f,
  -0.0596439f, 0.0786943f,    0.001457f,    0.282831f,   0.0975484f,
  0.13724f,    0.0891527f,    -0.0471925f,  0.255467f,   -0.469073f,
  -0.0759757f, 0.331197f,     0.139434f,    -0.0118866f, 0.359463f,
  -0.774947f,  -0.474647f,    -1.36563f,    0.24901f,    0.776025f,
  0.150621f,   0.192407f,     0.752499f,    0.0435322f,  -0.0334263f,
  0.470741f,   -0.781907f,    -0.149471f,   -0.649484f,  -0.866079f,
  0.536967f,   0.541611f,     -0.00237101f, -0.119688f,  -0.594591f,
  -0.967503f,  0.545025f,     -0.335037f,   -0.172105f,  -0.532514f,
  -0.442211f,  -0.0864824f,   0.038418f,    -0.337492f,  -0.412653f,
  0.0778177f,  0.0824839f,    -0.232478f,   0.553077f,   0.179073f,
  0.222848f,   -0.261019f,    0.854277f,    -0.643185f,  0.476021f,
  -0.0174448f, 0.621669f,     -0.527978f,   0.45279f,    -0.286967f,
  0.328291f,   0.0627781f,    0.495794f,    0.0156424f,  -0.170515f,
  -0.435815f,  -0.264061f,    -0.964473f,   0.259361f,   -0.297514f,
  0.667044f,   0.719631f,     -0.812974f,   -0.350331f,  0.594795f,
  -0.106071f,  -0.409225f,    0.283481f,    0.5735f,     -0.231666f,
  -0.270059f,  0.687725f,     0.349693f,    0.0637911f,  0.208738f,
  0.299087f,   -0.249188f,    -0.426365f,   -1.01906f,   0.0919539f,
  -0.198362f,  0.256663f,     -0.302723f,   0.457283f,   0.433322f,
  0.242223f,   0.740515f,     0.247248f,    0.436274f,   0.588906f,
  0.852493f,   0.385838f,     0.243232f,    -0.501191f,  0.212121f,
  0.297253f,   -0.664029f,    -0.470196f,   0.0175681f,  -1.01849f,
  -0.619865f,  -1.26982f,     -0.088134f,   -0.29233f,   -0.196112f,
  -0.141886f,  0.0602684f,    0.469327f,    0.0227135f,  0.275863f,
  0.161156f,   -0.864189f,    -0.72576f,    0.62214f,    0.804845f,
  0.183776f,   -0.155777f,    -0.0826676f,  -0.23302f,   0.0845181f,
  -0.126365f,  0.0925764f,    0.889037f,    -0.208894f,  0.441273f,
  0.476529f,   0.510144f,     0.321464f,    0.764386f,   0.198938f,
  -0.669809f,  -0.13214f,     -0.426596f,   -0.547804f,  -0.0953238f,
  0.164997f,   0.275626f,     -0.0469242f,  -0.923263f,  -1.05855f,
  -0.487197f,  0.261922f,     -0.108634f,   0.409852f,   0.142348f,
  0.153656f,   -0.119714f,    0.490507f,    -0.26725f,   -0.0651784f,
  -0.962803f,  -0.596098f,    -0.686329f,   0.66723f,    0.290971f,
  0.692586f,   0.56926f,      -0.0494205f,  -0.498585f,  -0.1832f,
  -0.571507f,  -0.438308f,    0.607958f,    0.985154f,   0.131991f,
  0.0469712f,  0.415769f,     -0.518799f,   -0.353338f,  -0.219197f,
  -0.159141f,  0.085484f,     -0.405673f,   -0.222816f,  0.813276f,
  0.323344f,   -0.235178f,    -0.40799f,    -0.083177f,  0.514834f,
  0.177916f,   0.0197744f,    -0.523574f,   -0.445548f,  -0.21085f,
  0.760991f,   0.170654f,     -0.00312635f, -0.175464f,  0.665364f,
  -0.713881f,  -0.701069f,    -0.628863f,   1.03196f,    -0.0414137f,
  -0.0163186f, 0.16796f,      -0.0263498f,  0.484873f,   0.153922f,
  0.0593931f,  0.171615f,     0.330269f,    -0.0728948f, 0.42332f,
  0.294273f,   -0.0185935f,   -0.609248f,   -0.305841f,  -0.293534f,
  0.0766015f,  0.130506f,     0.16716f,     0.0168997f,  -0.429074f,
  -0.744995f,  -0.972633f,    0.50621f,     -0.275645f,  0.402252f,
  -0.0190824f, 0.637343f,     -0.410791f,   0.546844f,   -0.555088f,
  0.491182f,   -0.0369695f,   0.974657f,    -0.142378f,  -0.148588f,
  -0.217919f,  0.0146815f,    -0.419912f,   0.111356f,   -0.640505f,
  -0.352691f
};

static const float simple_motion_search_prune_part_logits_bias_32[] = {
  0.0868818f, 0.370904f,  0.126136f,  0.57768f,   -0.316245f,
  -0.526958f, -0.451775f, -0.595569f, -0.805166f, -0.592605f
};

static const float simple_motion_search_prune_part_layer_0_bias_32[] = {
  -1.85942f, 0.727049f,   -0.0421259f, 0.759194f,   0.241057f,  0.0752973f,
  0.321934f, -0.593116f,  -0.873202f,  -0.238779f,  0.851339f,  -0.536633f,
  -0.18552f, -0.0941714f, 0.0153855f,  -1.34736f,   -0.870722f, 0.0973251f,
  0.491483f, 0.650638f,   -0.205986f,  -0.0499654f, -1.00592f,  0.65992f
};

static const NN_CONFIG simple_motion_search_prune_part_nn_config_32 = {
  NUM_FEATURES_32,
  NUM_LOGITS_32,
  NUM_HIDDEN_LAYERS_32,
  {
      NUM_LAYER_0_UNITS_32,
  },
  {
      simple_motion_search_prune_part_layer_0_kernel_32,
      simple_motion_search_prune_part_logits_kernel_32,
  },
  {
      simple_motion_search_prune_part_layer_0_bias_32,
      simple_motion_search_prune_part_logits_bias_32,
  },
};

#undef NUM_HIDDEN_LAYERS_32
#undef NUM_FEATURES_32
#undef NUM_LAYER_0_UNITS_32
#undef NUM_LOGITS_32

// BLOCK_16X16
#define NUM_HIDDEN_LAYERS_16 1
#define NUM_FEATURES_16 19
#define NUM_LAYER_0_UNITS_16 16
#define NUM_LOGITS_16 10

static const float simple_motion_search_prune_part_logits_kernel_16[] = {
  0.274123f,   -0.551439f,  0.578938f,   -0.213001f,  -0.310021f,
  0.0301311f,  -0.377388f,  -3.16339f,   0.434616f,   0.264216f,
  0.320385f,   -1.41657f,   1.05919f,    -0.396075f,  -0.855458f,
  0.418105f,   -0.0769093f, -0.54773f,   -0.215041f,  -0.13885f,
  -0.209062f,  -0.526914f,  0.211082f,   -2.34741f,   -0.000587922f,
  -0.431294f,  0.757511f,   -0.184199f,  -0.623552f,  -0.221362f,
  -0.628871f,  0.646393f,   -0.192193f,  0.0166809f,  -0.061691f,
  -0.214283f,  -0.35264f,   0.361452f,   -0.0160958f, -0.0475499f,
  0.196822f,   0.44674f,    -0.408064f,  -0.559148f,  -0.67489f,
  -0.202201f,  -0.358012f,  -0.341735f,  -0.325682f,  0.220407f,
  -0.642416f,  0.350069f,   0.430505f,   -0.0997745f, -0.300435f,
  1.25364f,    -0.869717f,  -0.0728051f, -0.172433f,  0.385328f,
  -2.13737f,   0.673629f,   0.580102f,   -0.0745359f, -0.442542f,
  -0.208393f,  -0.44303f,   0.318855f,   0.0557663f,  0.268257f,
  -0.0941132f, -4.52876f,   -0.638897f,  -0.907808f,  0.28328f,
  0.619328f,   -1.64249f,   0.0241431f,  -0.0880383f, 0.299287f,
  -0.248316f,  0.039253f,   -0.544645f,  -0.141389f,  0.0185283f,
  -1.01973f,   -0.269349f,  -4.88803f,   -0.632892f,  0.181151f,
  0.193291f,   0.592713f,   -1.71466f,   0.398923f,   0.00355734f,
  0.212158f,   -0.949188f,  0.386679f,   -0.243317f,  -0.17458f,
  0.0576348f,  0.096034f,   -0.282317f,  -4.13556f,   -0.516689f,
  0.169427f,   -0.541422f,  0.529281f,   -1.45161f,   -0.0417835f,
  0.0174299f,  -0.26404f,   -0.105773f,  0.102701f,   -0.65039f,
  0.308121f,   -0.185395f,  0.273611f,   -0.408464f,  -6.09866f,
  -0.512249f,  0.0668662f,  -0.547454f,  0.62565f,    -1.63952f,
  0.510116f,   0.127461f,   -0.506263f,  0.113016f,   -0.258605f,
  -0.308066f,  0.0957733f,  0.059395f,   -0.915338f,  0.499407f,
  -10.3199f,   -0.32224f,   -0.677307f,  1.13218f,    -0.0888689f,
  -0.108029f,  -0.156533f,  -0.391431f,  0.576607f,   -0.0833897f,
  0.536752f,   -0.0832957f, -0.0957492f, -0.135149f,  0.423881f,
  0.317691f,   -7.29755f,   0.104775f,   0.534134f,   -0.797288f,
  -0.386335f,  -0.20785f,   -0.0507494f, -0.338127f,  -0.868801f
};

static const float simple_motion_search_prune_part_layer_0_kernel_16[] = {
  -0.244782f,   0.00425059f, -0.337534f,  -0.423125f,   -0.349549f,
  -0.00261207f, -0.0845866f, -0.259278f,  -0.375872f,   0.00052185f,
  -0.427483f,   0.175625f,   -0.357737f,  0.129946f,    0.97588f,
  1.19281f,     -0.51292f,   -0.100629f,  1.04044f,     0.197375f,
  -0.210977f,   -0.20334f,   0.173408f,   0.431999f,    0.083979f,
  -0.334416f,   -0.171408f,  0.160035f,   -0.0464933f,  0.164574f,
  -0.162781f,   1.01648f,    0.624844f,   -1.20372f,    -0.698742f,
  0.335747f,    -0.362217f,  -0.0817772f, -0.0366522f,  -0.249627f,
  -0.3135f,     0.256151f,   -0.257869f,  0.0816391f,   -0.256592f,
  0.071219f,    -0.295956f,  0.287213f,   -0.375107f,   -0.149275f,
  0.0449292f,   0.49489f,    -0.958944f,  0.386166f,    -0.76147f,
  -0.223786f,   1.91139f,    -0.0866129f, -0.516556f,   0.871813f,
  0.389086f,    0.3205f,     0.605997f,   -0.531384f,   -0.693121f,
  0.728219f,    0.223733f,   -0.58534f,   -0.410249f,   0.0271334f,
  -0.43904f,    0.325998f,   -0.123988f,  0.103988f,    -0.2227f,
  0.0779071f,   0.100073f,   -0.924956f,  -0.00472742f, -0.21932f,
  -0.220187f,   -0.719278f,  0.099118f,   -0.0891471f,  0.743678f,
  -0.173308f,   0.588225f,   -0.31524f,   1.1415f,      0.408762f,
  -0.213088f,   -0.291621f,  0.655754f,   0.531725f,    -0.013178f,
  -0.100753f,   -0.0775942f, -0.181806f,  -0.441297f,   -0.00589338f,
  0.14217f,     -0.0592671f, 0.10907f,    1.47619f,     0.813817f,
  0.1996f,      0.178263f,   -0.569958f,  -0.374858f,   -0.743922f,
  -0.269343f,   -0.118752f,  0.0797114f,  0.027829f,    -0.133402f,
  -0.164884f,   -0.42919f,   0.0682661f,  -0.206438f,   0.0184534f,
  -0.141316f,   -0.138817f,  0.0305671f,  0.295578f,    -0.236413f,
  0.172918f,    -0.35082f,   -0.0986917f, -0.650484f,   0.13655f,
  0.212195f,    0.549501f,   1.64941f,    0.152883f,    0.0117464f,
  -0.200688f,   -0.0412075f, -0.0296324f, 0.122624f,    0.1871f,
  -0.515693f,   0.20351f,    0.333617f,   0.254752f,    0.293802f,
  -0.428904f,   -0.0312053f, -0.879481f,  -0.516353f,   -0.417837f,
  -0.230442f,   0.229367f,   0.615339f,   0.327347f,    0.288747f,
  0.596166f,    0.497054f,   0.536953f,   0.462426f,    0.517022f,
  -0.287359f,   -0.162824f,  -0.249174f,  -0.364887f,   -0.538065f,
  -0.506783f,   -0.163213f,  -0.617007f,  -0.70433f,    -0.759151f,
  -0.235183f,   -0.196496f,  0.0925943f,  -0.0786896f,  0.135073f,
  -0.106243f,   -0.190647f,  -0.311848f,  -0.428009f,   0.467477f,
  0.259139f,    1.4948f,     0.986061f,   -0.534924f,   -0.193525f,
  -0.66125f,    -0.693799f,  -0.489594f,  0.238264f,    0.249978f,
  -0.365372f,   -0.197998f,  -0.664471f,  -0.0312145f,  -0.297293f,
  0.0278792f,   -0.877716f,  0.0473106f,  0.913044f,    0.815569f,
  0.789972f,    0.641374f,   -0.122848f,  -0.353137f,   -0.381102f,
  -0.960138f,   -0.166101f,  0.230364f,   0.534173f,    0.398882f,
  0.0599076f,   0.00176035f, 0.291062f,   0.021087f,    0.374562f,
  0.402516f,    0.144006f,   -0.149598f,  0.065063f,    -0.0774656f,
  -0.18804f,    -0.21123f,   0.0119723f,  -0.244286f,   0.109912f,
  -0.98136f,    -0.583136f,  -1.3897f,    0.33196f,     0.319226f,
  0.490015f,    0.316438f,   0.565049f,   0.163159f,    0.523771f,
  0.325115f,    -0.0515304f, -0.0827355f, 0.112763f,    -0.517608f,
  -0.161398f,   -0.124513f,  -0.0384277f, -0.49491f,    -1.53384f,
  -1.3086f,     1.20601f,    0.399591f,   0.233774f,    0.0154149f,
  -0.431196f,   0.187116f,   0.033398f,   0.655468f,    -0.390814f,
  0.418144f,    -0.572053f,  0.936493f,   -0.116933f,   -0.20803f,
  -0.908834f,   1.2524f,     -0.285888f,  0.227437f,    -0.317727f,
  -0.6331f,     0.159656f,   0.244652f,   0.169768f,    0.379279f,
  0.37089f,     0.118264f,   0.150946f,   0.536513f,    -0.261398f,
  -0.15329f,    -0.413112f,  -0.243792f,  -0.215096f,   0.288741f,
  -0.193763f,   -0.130652f,  -0.328159f,  -0.719996f,   -1.66213f,
  0.0815627f,   0.129643f,   -0.0974464f, -0.0660102f,  0.349602f,
  0.120356f,    -0.144144f,  -0.13641f,   -0.154818f,   -0.468552f,
  -0.442585f,   -0.312206f,  0.879662f,   0.846103f,    0.0485413f,
  0.18676f,     -0.477959f,  -0.112404f,  -0.366477f
};

static const float simple_motion_search_prune_part_logits_bias_16[] = {
  0.791815f,  0.888054f,  0.406071f, -0.217564f, -0.504713f,
  -0.514339f, -0.200842f, -1.09239f, -1.78297f,  -2.41754f
};

static const float simple_motion_search_prune_part_layer_0_bias_16[] = {
  0.89469f,   0.10871f,  0.664404f,  -0.00639695f, -0.745647f, 0.910444f,
  0.168436f,  -4.05854f, 1.00981f,   0.743352f,    -0.73947f,  -2.5654f,
  -0.654753f, 0.602252f, -0.973004f, 1.1113f
};

static const NN_CONFIG simple_motion_search_prune_part_nn_config_16 = {
  NUM_FEATURES_16,
  NUM_LOGITS_16,
  NUM_HIDDEN_LAYERS_16,
  {
      NUM_LAYER_0_UNITS_16,
  },
  {
      simple_motion_search_prune_part_layer_0_kernel_16,
      simple_motion_search_prune_part_logits_kernel_16,
  },
  {
      simple_motion_search_prune_part_layer_0_bias_16,
      simple_motion_search_prune_part_logits_bias_16,
  },
};

#undef NUM_HIDDEN_LAYERS_16
#undef NUM_FEATURES_16
#undef NUM_LAYER_0_UNITS_16
#undef NUM_LOGITS_16

// BLOCK_8X8
#define NUM_HIDDEN_LAYERS_8 1
#define NUM_FEATURES_8 19
#define NUM_LAYER_0_UNITS_8 24
#define NUM_LOGITS_8 4

static const float simple_motion_search_prune_part_logits_kernel_8[] = {
  -0.806717f,  0.0244927f,  -0.0280725f, 0.210426f,   0.0820434f,  -0.0222324f,
  -0.0728984f, -0.424785f,  -0.0568035f, -0.0744017f, 0.204282f,   0.43611f,
  0.319456f,   0.119903f,   -0.333224f,  -0.932499f,  0.105907f,   0.0905287f,
  -0.612538f,  0.0978191f,  -0.0858663f, 0.0468925f,  -0.312509f,  0.0527469f,
  0.308466f,   -0.139768f,  -0.468023f,  -0.069522f,  0.248949f,   0.0408582f,
  0.199935f,   -0.448705f,  0.242315f,   0.00472276f, -0.468445f,  -0.591226f,
  0.107975f,   0.261228f,   -0.10724f,   0.104639f,   -0.211234f,  -0.304658f,
  -0.261689f,  -0.259529f,  0.0331369f,  -0.468468f,  -0.0555605f, -0.0495414f,
  0.247612f,   -0.112518f,  -0.393122f,  0.302172f,   -0.252151f,  0.076605f,
  -0.34155f,   -0.182731f,  0.154079f,   -0.464538f,  -0.396327f,  -0.654858f,
  0.0921198f,  0.202867f,   -0.0712573f, 0.0349611f,  0.243043f,   -0.177452f,
  -0.205536f,  -0.268024f,  0.0358315f,  -0.560347f,  -0.204207f,  -0.0890628f,
  -1.013f,     -0.461748f,  -0.429801f,  -0.100352f,  -0.34369f,   0.115318f,
  -0.556285f,  -0.0751575f, 0.183418f,   -0.285223f,  0.197177f,   -0.825216f,
  -0.125709f,  -0.100452f,  0.180481f,   0.764462f,   0.136609f,   -0.660743f,
  0.212887f,   -0.410408f,  -0.330839f,  -0.714646f,  -0.115863f,  -0.389509f
};

static const float simple_motion_search_prune_part_layer_0_kernel_8[] = {
  0.0561017f,   0.530692f,    0.129047f,   0.296138f,   0.407593f,
  0.151159f,    0.180472f,    0.298995f,   -0.0265362f, -0.380313f,
  -0.136716f,   -0.0644648f,  0.00808564f, 0.0875876f,  -0.0719683f,
  -0.0996071f,  -1.49722f,    -1.31176f,   1.54169f,    -0.50717f,
  -0.0186767f,  -0.525924f,   0.0402954f,  -0.553913f,  0.139015f,
  0.171752f,    -0.376497f,   0.485084f,   0.182424f,   -0.0236465f,
  0.380048f,    -0.185493f,   0.554435f,   0.241565f,   -0.225917f,
  -1.08637f,    -0.305121f,   1.3603f,     0.0806333f,  -0.0697466f,
  0.216192f,    0.0493694f,   0.0620039f,  -0.0042489f, 0.0707283f,
  0.0998331f,   -0.0252022f,  0.342077f,   -0.200664f,  0.335261f,
  -0.100772f,   0.212881f,    -0.374258f,  0.310442f,   -1.95981f,
  -1.16615f,    1.88243f,     0.503536f,   -0.0919037f, 0.392323f,
  0.33149f,     0.563121f,    -0.0898854f, 0.130267f,   0.404959f,
  1.06767f,     0.75134f,     0.810919f,   0.865237f,   -1.08001f,
  -0.949809f,   -1.24941f,    -0.95081f,   -0.539575f,  -0.355324f,
  -0.110592f,   -0.311277f,   0.023022f,   -0.039287f,  0.491298f,
  -0.248853f,   -0.294741f,   0.288811f,   0.470638f,   0.330094f,
  0.146603f,    0.0958486f,   0.308326f,   -0.87134f,   -1.06074f,
  -0.315428f,   0.717577f,    -0.0174599f, -0.491904f,  0.977014f,
  0.922693f,    0.0265707f,   -0.743468f,  -0.273647f,  -0.430625f,
  -0.473789f,   0.119983f,    0.476441f,   0.639803f,   -0.0753475f,
  -0.0746323f,  -0.0422539f,  0.013454f,   -0.0174412f, -0.253015f,
  -0.279585f,   0.11562f,     -0.396919f,  0.306388f,   0.430346f,
  0.275945f,    -0.196508f,   0.00180146f, 0.396652f,   0.324022f,
  -0.142132f,   0.1768f,      -0.0746152f, 0.314189f,   -0.031924f,
  0.254196f,    -0.253449f,   0.1537f,     -0.98635f,   -0.850926f,
  0.0762147f,   -0.652507f,   1.16528f,    -0.122595f,  -0.00561333f,
  0.424954f,    -0.00258127f, -0.421957f,  -0.0714059f, 0.782031f,
  -0.0129133f,  -0.00544328f, -0.193527f,  -0.0936037f, -0.00490983f,
  -0.852396f,   -0.649662f,   0.820325f,   0.484966f,   0.265405f,
  -0.33032f,    0.104917f,    -0.364478f,  0.26858f,    0.068847f,
  -0.0751046f,  0.238931f,    -0.151554f,  0.0296385f,  -0.14869f,
  -0.173547f,   -0.397285f,   0.0561029f,  -0.0681254f, 0.222631f,
  -0.00800993f, 0.0686761f,   0.196754f,   0.249358f,   0.348125f,
  -2.22757f,    0.186675f,    -0.0426998f, 0.123301f,   -0.0196412f,
  0.104882f,    0.138482f,    0.340663f,   0.0684671f,  -1.22841f,
  -1.08539f,    -1.1055f,     -0.732678f,  0.766626f,   0.727742f,
  1.26906f,     0.812594f,    -0.446312f,  -0.166752f,  0.396628f,
  0.00141587f,  0.0137288f,   -0.0920456f, 0.123027f,   -0.118517f,
  -0.0412321f,  -0.124952f,   0.00875945f, 0.0149883f,  -0.0218859f,
  -0.233299f,   -0.0812722f,  0.269917f,   0.0246593f,  0.0915655f,
  -0.019122f,   0.706718f,    -0.172051f,  -1.85551f,   0.0578997f,
  0.100269f,    0.131412f,    -0.0952751f, 0.181419f,   -0.0106305f,
  0.106179f,    -0.142344f,   0.0916649f,  -0.41298f,   0.113846f,
  -0.322459f,   0.0415754f,   -0.2205f,    -0.224231f,  0.147907f,
  -0.135093f,   -0.398757f,   1.93381f,    0.20456f,    -0.205381f,
  -0.263999f,   0.364463f,    -0.424052f,  -0.0166924f, -0.319968f,
  0.0439144f,   -0.692733f,   0.678982f,   -0.445194f,  -0.527451f,
  0.383248f,    0.330927f,    -0.0367725f, 0.572847f,   -0.620804f,
  -0.286471f,   1.39367f,     0.470732f,   0.0751676f,  0.637958f,
  0.574865f,    0.411091f,    0.263806f,   0.555064f,   0.047788f,
  0.201792f,    -0.0821822f,  -0.0226181f, -0.176679f,  -0.612642f,
  -0.992254f,   -0.292099f,   -0.562201f,  -0.567948f,  -0.767681f,
  1.33645f,     0.0932564f,   -0.421675f,  0.198262f,   -0.401979f,
  0.244609f,    -0.261484f,   0.0304534f,  -0.200004f,  0.00951232f,
  -0.085364f,   0.555152f,    -0.243778f,  0.371369f,   0.152997f,
  0.154443f,    -0.281229f,   0.967176f,   1.0212f,     0.276169f,
  0.0962747f,   0.449737f,    0.300859f,   0.376659f,   0.165669f,
  0.332263f,    0.238315f,    0.376668f,   -0.139238f,  -0.0694765f,
  -0.256137f,   -0.262146f,   -0.246265f,  0.0261978f,  -0.118975f,
  -0.207184f,   -0.614041f,   -0.866987f,  -1.75604f,   -0.04917f,
  0.0794673f,   -0.355224f,   0.0035685f,  -0.340216f,  0.398567f,
  -0.314826f,   -0.12464f,    0.693428f,   0.701697f,   0.511653f,
  0.861303f,    -0.64449f,    -1.06257f,   -0.773944f,  -0.838084f,
  0.802429f,    -0.24573f,    0.720913f,   -0.31002f,   0.615694f,
  0.287994f,    0.18495f,     0.0188525f,  0.374338f,   -0.12243f,
  0.613532f,    0.132456f,    0.177285f,   -0.187238f,  0.0872563f,
  -0.425068f,   0.154711f,    -0.24283f,   -0.193267f,  -1.14008f,
  -1.17759f,    0.517845f,    0.458782f,   -0.161137f,  0.142772f,
  0.2811f,      0.171871f,    0.276129f,   0.018275f,   0.390464f,
  -0.156414f,   0.108248f,    -0.0909085f, -0.11346f,   0.0815138f,
  0.0729377f,   -0.0769677f,  0.0110251f,  -0.46098f,   -0.421538f,
  -2.18003f,    0.6639f,      0.541278f,   0.704337f,   0.480695f,
  0.727474f,    0.473937f,    0.770863f,   0.41774f,    -0.112943f,
  -0.107412f,   0.083639f,    -0.351127f,  -0.149221f,  0.0705735f,
  -0.0908294f,  -0.0789572f,  -1.62533f,   -2.14051f,   -0.188871f,
  0.796224f,    0.00144302f,  0.467569f,   -0.113915f,  0.660595f,
  0.101025f,    0.020895f,    0.604505f,   -0.26598f,   -0.149282f,
  -0.548818f,   -0.140463f,   0.13669f,    -0.0955724f, -0.694851f,
  -0.13438f,    -0.384164f,   -0.600513f,  1.48183f,    0.16481f,
  0.340894f,    -0.190813f,   0.487458f,   0.0769957f,  0.192901f,
  0.039483f,    0.213366f,    -0.508968f,  -0.494034f,  -0.987906f,
  -0.188502f,   -0.907188f,   0.0109838f,  -0.275008f,  -0.331017f,
  -0.447202f,   0.0521897f,   0.837215f,   0.344802f,   0.216526f,
  0.456105f,    0.139706f,    -0.373955f,  0.0232853f,  -0.365632f,
  -0.0586727f,  0.828841f,    0.737974f,   -0.933899f,  -0.0620807f,
  -0.262087f,   -0.0551274f,  -0.374378f,  0.118385f,   -0.0375933f,
  -0.39549f,    -0.0844191f,  0.274343f,   0.21814f,    0.52751f,
  0.449546f,    0.075518f,    0.369501f,   0.345248f,   0.403972f,
  -0.465168f,   -0.551238f,   -0.354305f,  -0.233872f,  0.664137f,
  -0.214848f,   -0.0363864f,  0.446154f,   -0.500073f,  -1.07883f,
  -1.07772f
};

static const float simple_motion_search_prune_part_logits_bias_8[] = {
  1.09425f, -0.345875f, -0.56098f, -1.84859f
};

static const float simple_motion_search_prune_part_layer_0_bias_8[] = {
  -1.75332f, 0.419404f,  -0.0423004f, 0.345601f, -2.40097f,  -0.574857f,
  -2.53366f, -0.207096f, -1.08866f,   0.801763f, -2.72428f,  -2.39884f,
  1.04072f,  -0.782749f, -1.47003f,   -2.98207f, 0.8829f,    1.81741f,
  -2.02369f, 0.241717f,  -0.178749f,  -3.00588f, -0.232007f, 0.21717f
};

static const NN_CONFIG simple_motion_search_prune_part_nn_config_8 = {
  NUM_FEATURES_8,
  NUM_LOGITS_8,
  NUM_HIDDEN_LAYERS_8,
  {
      NUM_LAYER_0_UNITS_8,
  },
  {
      simple_motion_search_prune_part_layer_0_kernel_8,
      simple_motion_search_prune_part_logits_kernel_8,
  },
  {
      simple_motion_search_prune_part_layer_0_bias_8,
      simple_motion_search_prune_part_logits_bias_8,
  },
};

#undef NUM_HIDDEN_LAYERS_8
#undef NUM_FEATURES_8
#undef NUM_LAYER_0_UNITS_8
#undef NUM_LOGITS_8

#define FEATURE_SIZE 19
static const float two_pass_split_partition_weights_128[FEATURE_SIZE + 1] = {
  2.683936f, -0.193620f, -4.106470f, -0.141320f, -0.282289f,
  0.125296f, -1.134961f, 0.862757f,  -0.418799f, -0.637666f,
  0.016232f, 0.345013f,  0.018823f,  -0.393394f, -1.130700f,
  0.695357f, 0.112569f,  -0.341975f, -0.513882f, 5.7488966f,
};

static const float two_pass_split_partition_weights_64[FEATURE_SIZE + 1] = {
  2.990993f,  0.423273f,  -0.926544f, 0.454646f,  -0.292698f,
  -1.311632f, -0.284432f, 0.717141f,  -0.419257f, -0.574760f,
  -0.674444f, 0.669047f,  -0.374255f, 0.380624f,  -0.804036f,
  0.264021f,  0.004163f,  1.896802f,  0.924287f,  0.13490619f,
};

static const float two_pass_split_partition_weights_32[FEATURE_SIZE + 1] = {
  2.795181f,  -0.136943f, -0.924842f, 0.405330f,  -0.463505f,
  -0.584076f, -0.831472f, 0.382985f,  -0.597544f, -0.138915f,
  -1.354350f, 0.466035f,  -0.553961f, 0.213202f,  -1.166429f,
  0.010776f,  -0.096236f, 2.335084f,  1.699857f,  -0.58178353f,
};

static const float two_pass_split_partition_weights_16[FEATURE_SIZE + 1] = {
  1.987888f,  -0.431100f, -1.687703f, 0.262602f,  -0.425298f,
  -0.463870f, -1.493457f, 0.470917f,  -0.528457f, -0.087700f,
  -1.815092f, 0.152883f,  -0.337908f, 0.093679f,  -1.548267f,
  -0.042387f, -0.000861f, 2.556746f,  1.619192f,  0.03643292f,
};

static const float two_pass_split_partition_weights_8[FEATURE_SIZE + 1] = {
  2.188344f,  -0.817528f, -2.119219f, 0.000000f,  -0.348167f,
  -0.658074f, -1.960362f, 0.000000f,  -0.403080f, 0.282699f,
  -2.061088f, 0.000000f,  -0.431919f, -0.127960f, -1.099550f,
  0.000000f,  0.121622f,  2.017455f,  2.058228f,  -0.15475988f,
};

static const float two_pass_none_partition_weights_128[FEATURE_SIZE + 1] = {
  -1.006689f, 0.777908f,  4.461072f,  -0.395782f, -0.014610f,
  -0.853863f, 0.729997f,  -0.420477f, 0.282429f,  -1.194595f,
  3.181220f,  -0.511416f, 0.117084f,  -1.149348f, 1.507990f,
  -0.477212f, 0.202963f,  -1.469581f, 0.624461f,  -0.89081228f,
};

static const float two_pass_none_partition_weights_64[FEATURE_SIZE + 1] = {
  -1.241117f, 0.844878f,  5.638803f,  -0.489780f, -0.108796f,
  -4.576821f, 1.540624f,  -0.477519f, 0.227791f,  -1.443968f,
  1.586911f,  -0.505125f, 0.140764f,  -0.464194f, 1.466658f,
  -0.641166f, 0.195412f,  1.427905f,  2.080007f,  -1.98272777f,
};

static const float two_pass_none_partition_weights_32[FEATURE_SIZE + 1] = {
  -2.130825f, 0.476023f,  5.907343f,  -0.516002f, -0.097471f,
  -2.662754f, 0.614858f,  -0.576728f, 0.085261f,  -0.031901f,
  0.727842f,  -0.600034f, 0.079326f,  0.324328f,  0.504502f,
  -0.547105f, -0.037670f, 0.304995f,  0.369018f,  -2.66299987f,
};

static const float two_pass_none_partition_weights_16[FEATURE_SIZE + 1] = {
  -1.626410f, 0.872047f,  5.414965f,  -0.554781f, -0.084514f,
  -3.020550f, 0.467632f,  -0.382280f, 0.199568f,  0.426220f,
  0.829426f,  -0.467100f, 0.153098f,  0.662994f,  0.327545f,
  -0.560106f, -0.141610f, 0.403372f,  0.523991f,  -3.02891231f,
};

static const float two_pass_none_partition_weights_8[FEATURE_SIZE + 1] = {
  -1.463349f, 0.375376f,  4.751430f, 0.000000f, -0.184451f,
  -1.655447f, 0.443214f,  0.000000f, 0.127961f, 0.152435f,
  0.083288f,  0.000000f,  0.143105f, 0.438012f, 0.073238f,
  0.000000f,  -0.278137f, 0.186134f, 0.073737f, -1.6494962f,
};

#ifdef __cplusplus
}  // extern "C"
#endif

#endif  // AOM_AV1_ENCODER_PARTITION_MODEL_WEIGHTS_H_
