// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is auto-generated from
// gpu/command_buffer/build_gles2_cmd_buffer.py
// It's formatted by clang-format using chromium coding style:
//    clang-format -i -style=chromium filename
// DO NOT EDIT!

#ifndef GPU_COMMAND_BUFFER_COMMON_GLES2_CMD_IDS_AUTOGEN_H_
#define GPU_COMMAND_BUFFER_COMMON_GLES2_CMD_IDS_AUTOGEN_H_

#define GLES2_COMMAND_LIST(OP)                                       \
  OP(ActiveTexture)                                        /* 256 */ \
  OP(AttachShader)                                         /* 257 */ \
  OP(BindAttribLocationBucket)                             /* 258 */ \
  OP(BindBuffer)                                           /* 259 */ \
  OP(BindBufferBase)                                       /* 260 */ \
  OP(BindBufferRange)                                      /* 261 */ \
  OP(BindFramebuffer)                                      /* 262 */ \
  OP(BindRenderbuffer)                                     /* 263 */ \
  OP(BindSampler)                                          /* 264 */ \
  OP(BindTexture)                                          /* 265 */ \
  OP(BindTransformFeedback)                                /* 266 */ \
  OP(BlendColor)                                           /* 267 */ \
  OP(BlendEquation)                                        /* 268 */ \
  OP(BlendEquationSeparate)                                /* 269 */ \
  OP(BlendFunc)                                            /* 270 */ \
  OP(BlendFuncSeparate)                                    /* 271 */ \
  OP(BufferData)                                           /* 272 */ \
  OP(BufferSubData)                                        /* 273 */ \
  OP(CheckFramebufferStatus)                               /* 274 */ \
  OP(Clear)                                                /* 275 */ \
  OP(ClearBufferfi)                                        /* 276 */ \
  OP(ClearBufferfvImmediate)                               /* 277 */ \
  OP(ClearBufferivImmediate)                               /* 278 */ \
  OP(ClearBufferuivImmediate)                              /* 279 */ \
  OP(ClearColor)                                           /* 280 */ \
  OP(ClearDepthf)                                          /* 281 */ \
  OP(ClearStencil)                                         /* 282 */ \
  OP(ClientWaitSync)                                       /* 283 */ \
  OP(ColorMask)                                            /* 284 */ \
  OP(CompileShader)                                        /* 285 */ \
  OP(CompressedTexImage2DBucket)                           /* 286 */ \
  OP(CompressedTexImage2D)                                 /* 287 */ \
  OP(CompressedTexSubImage2DBucket)                        /* 288 */ \
  OP(CompressedTexSubImage2D)                              /* 289 */ \
  OP(CompressedTexImage3DBucket)                           /* 290 */ \
  OP(CompressedTexImage3D)                                 /* 291 */ \
  OP(CompressedTexSubImage3DBucket)                        /* 292 */ \
  OP(CompressedTexSubImage3D)                              /* 293 */ \
  OP(CopyBufferSubData)                                    /* 294 */ \
  OP(CopyTexImage2D)                                       /* 295 */ \
  OP(CopyTexSubImage2D)                                    /* 296 */ \
  OP(CopyTexSubImage3D)                                    /* 297 */ \
  OP(CreateProgram)                                        /* 298 */ \
  OP(CreateShader)                                         /* 299 */ \
  OP(CullFace)                                             /* 300 */ \
  OP(DeleteBuffersImmediate)                               /* 301 */ \
  OP(DeleteFramebuffersImmediate)                          /* 302 */ \
  OP(DeleteProgram)                                        /* 303 */ \
  OP(DeleteRenderbuffersImmediate)                         /* 304 */ \
  OP(DeleteSamplersImmediate)                              /* 305 */ \
  OP(DeleteSync)                                           /* 306 */ \
  OP(DeleteShader)                                         /* 307 */ \
  OP(DeleteTexturesImmediate)                              /* 308 */ \
  OP(DeleteTransformFeedbacksImmediate)                    /* 309 */ \
  OP(DepthFunc)                                            /* 310 */ \
  OP(DepthMask)                                            /* 311 */ \
  OP(DepthRangef)                                          /* 312 */ \
  OP(DetachShader)                                         /* 313 */ \
  OP(Disable)                                              /* 314 */ \
  OP(DisableVertexAttribArray)                             /* 315 */ \
  OP(DrawArrays)                                           /* 316 */ \
  OP(DrawElements)                                         /* 317 */ \
  OP(Enable)                                               /* 318 */ \
  OP(EnableVertexAttribArray)                              /* 319 */ \
  OP(FenceSync)                                            /* 320 */ \
  OP(Finish)                                               /* 321 */ \
  OP(Flush)                                                /* 322 */ \
  OP(FramebufferRenderbuffer)                              /* 323 */ \
  OP(FramebufferTexture2D)                                 /* 324 */ \
  OP(FramebufferTextureLayer)                              /* 325 */ \
  OP(FrontFace)                                            /* 326 */ \
  OP(GenBuffersImmediate)                                  /* 327 */ \
  OP(GenerateMipmap)                                       /* 328 */ \
  OP(GenFramebuffersImmediate)                             /* 329 */ \
  OP(GenRenderbuffersImmediate)                            /* 330 */ \
  OP(GenSamplersImmediate)                                 /* 331 */ \
  OP(GenTexturesImmediate)                                 /* 332 */ \
  OP(GenTransformFeedbacksImmediate)                       /* 333 */ \
  OP(GetActiveAttrib)                                      /* 334 */ \
  OP(GetActiveUniform)                                     /* 335 */ \
  OP(GetActiveUniformBlockiv)                              /* 336 */ \
  OP(GetActiveUniformBlockName)                            /* 337 */ \
  OP(GetActiveUniformsiv)                                  /* 338 */ \
  OP(GetAttachedShaders)                                   /* 339 */ \
  OP(GetAttribLocation)                                    /* 340 */ \
  OP(GetBooleanv)                                          /* 341 */ \
  OP(GetBufferParameteri64v)                               /* 342 */ \
  OP(GetBufferParameteriv)                                 /* 343 */ \
  OP(GetError)                                             /* 344 */ \
  OP(GetFloatv)                                            /* 345 */ \
  OP(GetFragDataLocation)                                  /* 346 */ \
  OP(GetFramebufferAttachmentParameteriv)                  /* 347 */ \
  OP(GetInteger64v)                                        /* 348 */ \
  OP(GetIntegeri_v)                                        /* 349 */ \
  OP(GetInteger64i_v)                                      /* 350 */ \
  OP(GetIntegerv)                                          /* 351 */ \
  OP(GetInternalformativ)                                  /* 352 */ \
  OP(GetProgramiv)                                         /* 353 */ \
  OP(GetProgramInfoLog)                                    /* 354 */ \
  OP(GetRenderbufferParameteriv)                           /* 355 */ \
  OP(GetSamplerParameterfv)                                /* 356 */ \
  OP(GetSamplerParameteriv)                                /* 357 */ \
  OP(GetShaderiv)                                          /* 358 */ \
  OP(GetShaderInfoLog)                                     /* 359 */ \
  OP(GetShaderPrecisionFormat)                             /* 360 */ \
  OP(GetShaderSource)                                      /* 361 */ \
  OP(GetString)                                            /* 362 */ \
  OP(GetSynciv)                                            /* 363 */ \
  OP(GetTexParameterfv)                                    /* 364 */ \
  OP(GetTexParameteriv)                                    /* 365 */ \
  OP(GetTransformFeedbackVarying)                          /* 366 */ \
  OP(GetUniformBlockIndex)                                 /* 367 */ \
  OP(GetUniformfv)                                         /* 368 */ \
  OP(GetUniformiv)                                         /* 369 */ \
  OP(GetUniformuiv)                                        /* 370 */ \
  OP(GetUniformIndices)                                    /* 371 */ \
  OP(GetUniformLocation)                                   /* 372 */ \
  OP(GetVertexAttribfv)                                    /* 373 */ \
  OP(GetVertexAttribiv)                                    /* 374 */ \
  OP(GetVertexAttribIiv)                                   /* 375 */ \
  OP(GetVertexAttribIuiv)                                  /* 376 */ \
  OP(GetVertexAttribPointerv)                              /* 377 */ \
  OP(Hint)                                                 /* 378 */ \
  OP(InvalidateFramebufferImmediate)                       /* 379 */ \
  OP(InvalidateSubFramebufferImmediate)                    /* 380 */ \
  OP(IsBuffer)                                             /* 381 */ \
  OP(IsEnabled)                                            /* 382 */ \
  OP(IsFramebuffer)                                        /* 383 */ \
  OP(IsProgram)                                            /* 384 */ \
  OP(IsRenderbuffer)                                       /* 385 */ \
  OP(IsSampler)                                            /* 386 */ \
  OP(IsShader)                                             /* 387 */ \
  OP(IsSync)                                               /* 388 */ \
  OP(IsTexture)                                            /* 389 */ \
  OP(IsTransformFeedback)                                  /* 390 */ \
  OP(LineWidth)                                            /* 391 */ \
  OP(LinkProgram)                                          /* 392 */ \
  OP(PauseTransformFeedback)                               /* 393 */ \
  OP(PixelStorei)                                          /* 394 */ \
  OP(PolygonOffset)                                        /* 395 */ \
  OP(ReadBuffer)                                           /* 396 */ \
  OP(ReadPixels)                                           /* 397 */ \
  OP(ReleaseShaderCompiler)                                /* 398 */ \
  OP(RenderbufferStorage)                                  /* 399 */ \
  OP(ResumeTransformFeedback)                              /* 400 */ \
  OP(SampleCoverage)                                       /* 401 */ \
  OP(SamplerParameterf)                                    /* 402 */ \
  OP(SamplerParameterfvImmediate)                          /* 403 */ \
  OP(SamplerParameteri)                                    /* 404 */ \
  OP(SamplerParameterivImmediate)                          /* 405 */ \
  OP(Scissor)                                              /* 406 */ \
  OP(ShaderBinary)                                         /* 407 */ \
  OP(ShaderSourceBucket)                                   /* 408 */ \
  OP(MultiDrawBeginCHROMIUM)                               /* 409 */ \
  OP(MultiDrawEndCHROMIUM)                                 /* 410 */ \
  OP(MultiDrawArraysCHROMIUM)                              /* 411 */ \
  OP(MultiDrawArraysInstancedCHROMIUM)                     /* 412 */ \
  OP(MultiDrawElementsCHROMIUM)                            /* 413 */ \
  OP(MultiDrawElementsInstancedCHROMIUM)                   /* 414 */ \
  OP(StencilFunc)                                          /* 415 */ \
  OP(StencilFuncSeparate)                                  /* 416 */ \
  OP(StencilMask)                                          /* 417 */ \
  OP(StencilMaskSeparate)                                  /* 418 */ \
  OP(StencilOp)                                            /* 419 */ \
  OP(StencilOpSeparate)                                    /* 420 */ \
  OP(TexImage2D)                                           /* 421 */ \
  OP(TexImage3D)                                           /* 422 */ \
  OP(TexParameterf)                                        /* 423 */ \
  OP(TexParameterfvImmediate)                              /* 424 */ \
  OP(TexParameteri)                                        /* 425 */ \
  OP(TexParameterivImmediate)                              /* 426 */ \
  OP(TexStorage3D)                                         /* 427 */ \
  OP(TexSubImage2D)                                        /* 428 */ \
  OP(TexSubImage3D)                                        /* 429 */ \
  OP(TransformFeedbackVaryingsBucket)                      /* 430 */ \
  OP(Uniform1f)                                            /* 431 */ \
  OP(Uniform1fvImmediate)                                  /* 432 */ \
  OP(Uniform1i)                                            /* 433 */ \
  OP(Uniform1ivImmediate)                                  /* 434 */ \
  OP(Uniform1ui)                                           /* 435 */ \
  OP(Uniform1uivImmediate)                                 /* 436 */ \
  OP(Uniform2f)                                            /* 437 */ \
  OP(Uniform2fvImmediate)                                  /* 438 */ \
  OP(Uniform2i)                                            /* 439 */ \
  OP(Uniform2ivImmediate)                                  /* 440 */ \
  OP(Uniform2ui)                                           /* 441 */ \
  OP(Uniform2uivImmediate)                                 /* 442 */ \
  OP(Uniform3f)                                            /* 443 */ \
  OP(Uniform3fvImmediate)                                  /* 444 */ \
  OP(Uniform3i)                                            /* 445 */ \
  OP(Uniform3ivImmediate)                                  /* 446 */ \
  OP(Uniform3ui)                                           /* 447 */ \
  OP(Uniform3uivImmediate)                                 /* 448 */ \
  OP(Uniform4f)                                            /* 449 */ \
  OP(Uniform4fvImmediate)                                  /* 450 */ \
  OP(Uniform4i)                                            /* 451 */ \
  OP(Uniform4ivImmediate)                                  /* 452 */ \
  OP(Uniform4ui)                                           /* 453 */ \
  OP(Uniform4uivImmediate)                                 /* 454 */ \
  OP(UniformBlockBinding)                                  /* 455 */ \
  OP(UniformMatrix2fvImmediate)                            /* 456 */ \
  OP(UniformMatrix2x3fvImmediate)                          /* 457 */ \
  OP(UniformMatrix2x4fvImmediate)                          /* 458 */ \
  OP(UniformMatrix3fvImmediate)                            /* 459 */ \
  OP(UniformMatrix3x2fvImmediate)                          /* 460 */ \
  OP(UniformMatrix3x4fvImmediate)                          /* 461 */ \
  OP(UniformMatrix4fvImmediate)                            /* 462 */ \
  OP(UniformMatrix4x2fvImmediate)                          /* 463 */ \
  OP(UniformMatrix4x3fvImmediate)                          /* 464 */ \
  OP(UseProgram)                                           /* 465 */ \
  OP(ValidateProgram)                                      /* 466 */ \
  OP(VertexAttrib1f)                                       /* 467 */ \
  OP(VertexAttrib1fvImmediate)                             /* 468 */ \
  OP(VertexAttrib2f)                                       /* 469 */ \
  OP(VertexAttrib2fvImmediate)                             /* 470 */ \
  OP(VertexAttrib3f)                                       /* 471 */ \
  OP(VertexAttrib3fvImmediate)                             /* 472 */ \
  OP(VertexAttrib4f)                                       /* 473 */ \
  OP(VertexAttrib4fvImmediate)                             /* 474 */ \
  OP(VertexAttribI4i)                                      /* 475 */ \
  OP(VertexAttribI4ivImmediate)                            /* 476 */ \
  OP(VertexAttribI4ui)                                     /* 477 */ \
  OP(VertexAttribI4uivImmediate)                           /* 478 */ \
  OP(VertexAttribIPointer)                                 /* 479 */ \
  OP(VertexAttribPointer)                                  /* 480 */ \
  OP(Viewport)                                             /* 481 */ \
  OP(WaitSync)                                             /* 482 */ \
  OP(BlitFramebufferCHROMIUM)                              /* 483 */ \
  OP(RenderbufferStorageMultisampleCHROMIUM)               /* 484 */ \
  OP(RenderbufferStorageMultisampleAdvancedAMD)            /* 485 */ \
  OP(RenderbufferStorageMultisampleEXT)                    /* 486 */ \
  OP(FramebufferTexture2DMultisampleEXT)                   /* 487 */ \
  OP(TexStorage2DEXT)                                      /* 488 */ \
  OP(GenQueriesEXTImmediate)                               /* 489 */ \
  OP(DeleteQueriesEXTImmediate)                            /* 490 */ \
  OP(QueryCounterEXT)                                      /* 491 */ \
  OP(BeginQueryEXT)                                        /* 492 */ \
  OP(BeginTransformFeedback)                               /* 493 */ \
  OP(EndQueryEXT)                                          /* 494 */ \
  OP(EndTransformFeedback)                                 /* 495 */ \
  OP(SetDisjointValueSyncCHROMIUM)                         /* 496 */ \
  OP(InsertEventMarkerEXT)                                 /* 497 */ \
  OP(PushGroupMarkerEXT)                                   /* 498 */ \
  OP(PopGroupMarkerEXT)                                    /* 499 */ \
  OP(GenVertexArraysOESImmediate)                          /* 500 */ \
  OP(DeleteVertexArraysOESImmediate)                       /* 501 */ \
  OP(IsVertexArrayOES)                                     /* 502 */ \
  OP(BindVertexArrayOES)                                   /* 503 */ \
  OP(FramebufferParameteri)                                /* 504 */ \
  OP(BindImageTexture)                                     /* 505 */ \
  OP(DispatchCompute)                                      /* 506 */ \
  OP(DispatchComputeIndirect)                              /* 507 */ \
  OP(DrawArraysIndirect)                                   /* 508 */ \
  OP(DrawElementsIndirect)                                 /* 509 */ \
  OP(GetProgramInterfaceiv)                                /* 510 */ \
  OP(GetProgramResourceIndex)                              /* 511 */ \
  OP(GetProgramResourceName)                               /* 512 */ \
  OP(GetProgramResourceiv)                                 /* 513 */ \
  OP(GetProgramResourceLocation)                           /* 514 */ \
  OP(MemoryBarrierEXT)                                     /* 515 */ \
  OP(MemoryBarrierByRegion)                                /* 516 */ \
  OP(SwapBuffers)                                          /* 517 */ \
  OP(GetMaxValueInBufferCHROMIUM)                          /* 518 */ \
  OP(EnableFeatureCHROMIUM)                                /* 519 */ \
  OP(MapBufferRange)                                       /* 520 */ \
  OP(UnmapBuffer)                                          /* 521 */ \
  OP(FlushMappedBufferRange)                               /* 522 */ \
  OP(ResizeCHROMIUM)                                       /* 523 */ \
  OP(GetRequestableExtensionsCHROMIUM)                     /* 524 */ \
  OP(RequestExtensionCHROMIUM)                             /* 525 */ \
  OP(GetProgramInfoCHROMIUM)                               /* 526 */ \
  OP(GetUniformBlocksCHROMIUM)                             /* 527 */ \
  OP(GetTransformFeedbackVaryingsCHROMIUM)                 /* 528 */ \
  OP(GetUniformsES3CHROMIUM)                               /* 529 */ \
  OP(DescheduleUntilFinishedCHROMIUM)                      /* 530 */ \
  OP(GetTranslatedShaderSourceANGLE)                       /* 531 */ \
  OP(PostSubBufferCHROMIUM)                                /* 532 */ \
  OP(CopyTextureCHROMIUM)                                  /* 533 */ \
  OP(CopySubTextureCHROMIUM)                               /* 534 */ \
  OP(DrawArraysInstancedANGLE)                             /* 535 */ \
  OP(DrawElementsInstancedANGLE)                           /* 536 */ \
  OP(VertexAttribDivisorANGLE)                             /* 537 */ \
  OP(ProduceTextureDirectCHROMIUMImmediate)                /* 538 */ \
  OP(CreateAndConsumeTextureINTERNALImmediate)             /* 539 */ \
  OP(BindUniformLocationCHROMIUMBucket)                    /* 540 */ \
  OP(BindTexImage2DCHROMIUM)                               /* 541 */ \
  OP(BindTexImage2DWithInternalformatCHROMIUM)             /* 542 */ \
  OP(ReleaseTexImage2DCHROMIUM)                            /* 543 */ \
  OP(TraceBeginCHROMIUM)                                   /* 544 */ \
  OP(TraceEndCHROMIUM)                                     /* 545 */ \
  OP(DiscardFramebufferEXTImmediate)                       /* 546 */ \
  OP(LoseContextCHROMIUM)                                  /* 547 */ \
  OP(UnpremultiplyAndDitherCopyCHROMIUM)                   /* 548 */ \
  OP(DrawBuffersEXTImmediate)                              /* 549 */ \
  OP(DiscardBackbufferCHROMIUM)                            /* 550 */ \
  OP(ScheduleOverlayPlaneCHROMIUM)                         /* 551 */ \
  OP(ScheduleCALayerSharedStateCHROMIUM)                   /* 552 */ \
  OP(ScheduleCALayerCHROMIUM)                              /* 553 */ \
  OP(ScheduleCALayerInUseQueryCHROMIUMImmediate)           /* 554 */ \
  OP(CommitOverlayPlanesCHROMIUM)                          /* 555 */ \
  OP(FlushDriverCachesCHROMIUM)                            /* 556 */ \
  OP(ScheduleDCLayerCHROMIUM)                              /* 557 */ \
  OP(SetActiveURLCHROMIUM)                                 /* 558 */ \
  OP(MatrixLoadfCHROMIUMImmediate)                         /* 559 */ \
  OP(MatrixLoadIdentityCHROMIUM)                           /* 560 */ \
  OP(GenPathsCHROMIUM)                                     /* 561 */ \
  OP(DeletePathsCHROMIUM)                                  /* 562 */ \
  OP(IsPathCHROMIUM)                                       /* 563 */ \
  OP(PathCommandsCHROMIUM)                                 /* 564 */ \
  OP(PathParameterfCHROMIUM)                               /* 565 */ \
  OP(PathParameteriCHROMIUM)                               /* 566 */ \
  OP(PathStencilFuncCHROMIUM)                              /* 567 */ \
  OP(StencilFillPathCHROMIUM)                              /* 568 */ \
  OP(StencilStrokePathCHROMIUM)                            /* 569 */ \
  OP(CoverFillPathCHROMIUM)                                /* 570 */ \
  OP(CoverStrokePathCHROMIUM)                              /* 571 */ \
  OP(StencilThenCoverFillPathCHROMIUM)                     /* 572 */ \
  OP(StencilThenCoverStrokePathCHROMIUM)                   /* 573 */ \
  OP(StencilFillPathInstancedCHROMIUM)                     /* 574 */ \
  OP(StencilStrokePathInstancedCHROMIUM)                   /* 575 */ \
  OP(CoverFillPathInstancedCHROMIUM)                       /* 576 */ \
  OP(CoverStrokePathInstancedCHROMIUM)                     /* 577 */ \
  OP(StencilThenCoverFillPathInstancedCHROMIUM)            /* 578 */ \
  OP(StencilThenCoverStrokePathInstancedCHROMIUM)          /* 579 */ \
  OP(BindFragmentInputLocationCHROMIUMBucket)              /* 580 */ \
  OP(ProgramPathFragmentInputGenCHROMIUM)                  /* 581 */ \
  OP(ContextVisibilityHintCHROMIUM)                        /* 582 */ \
  OP(CoverageModulationCHROMIUM)                           /* 583 */ \
  OP(BlendBarrierKHR)                                      /* 584 */ \
  OP(ApplyScreenSpaceAntialiasingCHROMIUM)                 /* 585 */ \
  OP(BindFragDataLocationIndexedEXTBucket)                 /* 586 */ \
  OP(BindFragDataLocationEXTBucket)                        /* 587 */ \
  OP(GetFragDataIndexEXT)                                  /* 588 */ \
  OP(UniformMatrix4fvStreamTextureMatrixCHROMIUMImmediate) /* 589 */ \
  OP(OverlayPromotionHintCHROMIUM)                         /* 590 */ \
  OP(SwapBuffersWithBoundsCHROMIUMImmediate)               /* 591 */ \
  OP(SetDrawRectangleCHROMIUM)                             /* 592 */ \
  OP(SetEnableDCLayersCHROMIUM)                            /* 593 */ \
  OP(InitializeDiscardableTextureCHROMIUM)                 /* 594 */ \
  OP(UnlockDiscardableTextureCHROMIUM)                     /* 595 */ \
  OP(LockDiscardableTextureCHROMIUM)                       /* 596 */ \
  OP(TexStorage2DImageCHROMIUM)                            /* 597 */ \
  OP(SetColorSpaceMetadataCHROMIUM)                        /* 598 */ \
  OP(WindowRectanglesEXTImmediate)                         /* 599 */ \
  OP(CreateGpuFenceINTERNAL)                               /* 600 */ \
  OP(WaitGpuFenceCHROMIUM)                                 /* 601 */ \
  OP(DestroyGpuFenceCHROMIUM)                              /* 602 */ \
  OP(SetReadbackBufferShadowAllocationINTERNAL)            /* 603 */ \
  OP(FramebufferTextureMultiviewOVR)                       /* 604 */ \
  OP(MaxShaderCompilerThreadsKHR)                          /* 605 */ \
  OP(CreateAndTexStorage2DSharedImageINTERNALImmediate)    /* 606 */ \
  OP(BeginSharedImageAccessDirectCHROMIUM)                 /* 607 */ \
  OP(EndSharedImageAccessDirectCHROMIUM)                   /* 608 */

enum CommandId {
  kOneBeforeStartPoint =
      cmd::kLastCommonId,  // All GLES2 commands start after this.
#define GLES2_CMD_OP(name) k##name,
  GLES2_COMMAND_LIST(GLES2_CMD_OP)
#undef GLES2_CMD_OP
      kNumCommands,
  kFirstGLES2Command = kOneBeforeStartPoint + 1
};

#endif  // GPU_COMMAND_BUFFER_COMMON_GLES2_CMD_IDS_AUTOGEN_H_
