// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include <cstddef>
#include <cstdint>
#include <limits>

#include "net/third_party/quiche/src/quic/core/qpack/qpack_decoder.h"
#include "net/third_party/quiche/src/quic/core/qpack/qpack_decoder_test_utils.h"
#include "net/third_party/quiche/src/quic/core/qpack/qpack_utils.h"
#include "net/third_party/quiche/src/quic/platform/api/quic_fuzzed_data_provider.h"
#include "net/third_party/quiche/src/quic/platform/api/quic_string_piece.h"

namespace quic {
namespace test {

// This fuzzer exercises QpackDecoder.  It should be able to cover all possible
// code paths.  There is no point in encoding QpackDecoder's output to turn this
// into a roundtrip test, because the same header list can be encoded in many
// different ways, so the output could not be expected to match the original
// input.
extern "C" int LLVMFuzzerTestOneInput(const uint8_t* data, size_t size) {
  NoOpHeadersHandler handler;
  QuicFuzzedDataProvider provider(data, size);

  // Process up to 64 kB fragments at a time.  Too small upper bound might not
  // provide enough coverage, too large would make fuzzing less efficient.
  auto fragment_size_generator =
      std::bind(&QuicFuzzedDataProvider::ConsumeIntegralInRange<uint16_t>,
                &provider, 1, std::numeric_limits<uint16_t>::max());

  NoopEncoderStreamErrorDelegate encoder_stream_error_delegate;
  NoopQpackStreamSenderDelegate decoder_stream_sender_delegate;
  // TODO(b/112770235): Fuzz dynamic table and blocked streams.
  QpackDecode(
      /* maximum_dynamic_table_capacity = */ 0,
      /* maximum_blocked_streams = */ 0, &encoder_stream_error_delegate,
      &decoder_stream_sender_delegate, &handler, fragment_size_generator,
      provider.ConsumeRemainingBytesAsString());

  return 0;
}

}  // namespace test
}  // namespace quic
