# Translation Tools

This directory contains tools for Chrome's UI translations.

## upload_screenshots.py

This tool uploads translation screenshots to a content-addressed Google Cloud
Storage bucket.

Translation screenshots are .png files provided by Chrome Developers to give
translators more context about UI changes. Developers take screenshots of their
UI changes, add them under a specific directory derived from the path of the
.grd or .grdp file that contains the UI string and run this tool. The tool
uploads the images, generates SHA1 hashes of them, and asks the
developer if they want to add the hashes to the CL.

Example: For a file at `path/to/test.grd`, the screenshot directory will be
`path/to/test_grd`. In the upstream Chrome repository, this directory will only
contain `.png.sha1` files previously generated by this tool. In local working
repositories, it may contain `.png` files generated by Chrome developers, such as
`path/to/test_grd/IDS_MESSAGE.png`.

### Screenshots and the storage bucket are public, do not upload anything confidential.

For more information, see [https://g.co/chrome/translation](https://g.co/chrome/translation).

# Run the tests

The presubmit automatically runs all files named `*_unittest.py `:
```
git cl presubmit --force
```

python

# Run sanity checks

This will attempt to load all .grd and .grdp files in the Chrome repo.
Run once before uploading the CL to ensure everything works.
```
python helper/sanity_check.py
```
