// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/events/devices/gamepad_device.h"

namespace ui {

GamepadDevice::GamepadDevice(const InputDevice& input_device,
                             std::vector<GamepadDevice::Axis>&& axes)
    : InputDevice(input_device), axes(std::move(axes)) {}

GamepadDevice::GamepadDevice(const GamepadDevice& other) = default;

GamepadDevice::~GamepadDevice() = default;

}  // namespace ui
