// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROMEOS_COMPONENTS_CAMERA_APP_UI_CAMERA_APP_WINDOW_STATE_CONTROLLER_H_
#define CHROMEOS_COMPONENTS_CAMERA_APP_UI_CAMERA_APP_WINDOW_STATE_CONTROLLER_H_

#include <queue>
#include <vector>

#include "chromeos/components/camera_app_ui/camera_app_helper.mojom.h"
#include "mojo/public/cpp/bindings/pending_receiver.h"
#include "mojo/public/cpp/bindings/pending_remote.h"
#include "mojo/public/cpp/bindings/receiver_set.h"
#include "mojo/public/cpp/bindings/remote.h"
#include "ui/views/widget/widget.h"
#include "ui/views/widget/widget_observer.h"

namespace chromeos {

class CameraAppWindowStateController
    : public chromeos_camera::mojom::WindowStateController,
      public views::WidgetObserver {
 public:
  using WindowStateType = chromeos_camera::mojom::WindowStateType;
  using WindowStateMonitor = chromeos_camera::mojom::WindowStateMonitor;

  CameraAppWindowStateController(views::Widget* widget);
  CameraAppWindowStateController(const CameraAppWindowStateController&) =
      delete;
  CameraAppWindowStateController& operator=(
      const CameraAppWindowStateController&) = delete;
  ~CameraAppWindowStateController() override;

  void AddReceiver(
      mojo::PendingReceiver<chromeos_camera::mojom::WindowStateController>
          receiver);

  // chromeos_camera::mojom::WindowStateController implementations.
  void AddMonitor(
      mojo::PendingRemote<chromeos_camera::mojom::WindowStateMonitor> monitor,
      AddMonitorCallback callback) override;
  void GetWindowState(GetWindowStateCallback callback) override;
  void Minimize(MinimizeCallback callback) override;
  void Restore(RestoreCallback callback) override;
  void Maximize(MaximizeCallback callback) override;
  void Fullscreen(FullscreenCallback callback) override;
  void Focus(FocusCallback callback) override;

  // views::WidgetObserver implementations.
  void OnWidgetVisibilityChanged(views::Widget* widget, bool visible) override;
  void OnWidgetActivationChanged(views::Widget* widget, bool active) override;
  void OnWidgetBoundsChanged(views::Widget* widget,
                             const gfx::Rect& new_bounds) override;

 private:
  void OnWindowStateChanged();
  WindowStateType GetCurrentWindowState();

  views::Widget* widget_;
  WindowStateType window_state_;
  mojo::ReceiverSet<chromeos_camera::mojom::WindowStateController> receivers_;
  std::vector<mojo::Remote<WindowStateMonitor>> monitors_;
  std::queue<base::OnceClosure> minimize_callbacks_;
  std::queue<base::OnceClosure> restore_callbacks_;
  std::queue<base::OnceClosure> maximize_callbacks_;
  std::queue<base::OnceClosure> fullscreen_callbacks_;
  std::queue<base::OnceClosure> focus_callbacks_;
};

}  // namespace chromeos

#endif  // CHROMEOS_COMPONENTS_CAMERA_APP_UI_CAMERA_APP_WINDOW_STATE_CONTROLLER_H_
