// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROMEOS_UI_BASE_CHROMEOS_UI_CONSTANTS_H_
#define CHROMEOS_UI_BASE_CHROMEOS_UI_CONSTANTS_H_

#include "build/chromeos_buildflags.h"
#include "third_party/skia/include/core/SkColor.h"

namespace chromeos {

// Radius of the header's top corners when the window is restored.
constexpr int kTopCornerRadiusWhenRestored = 2;

// In the window corners, the resize areas don't actually expand bigger, but the
// 16 px at the end of each edge triggers diagonal resizing.
constexpr int kResizeAreaCornerSize = 16;

// Ash windows do not have a traditional visible window frame. Window content
// extends to the edge of the window. We consider a small region outside the
// window bounds and an even smaller region overlapping the window to be the
// "non-client" area and use it for resizing.
constexpr int kResizeOutsideBoundsSize = 6;
constexpr int kResizeOutsideBoundsScaleForTouch = 5;

#if BUILDFLAG(IS_CHROMEOS_ASH)
constexpr int kResizeInsideBoundsSize = 1;
#else
// TODO(https://crbug.com/1113900): Remove this if-check when resize-shadow
// works in lacros/chrome.
constexpr int kResizeInsideBoundsSize = 2;
#endif

// The default frame color.
constexpr SkColor kDefaultFrameColor = SkColorSetRGB(0xFD, 0xFE, 0xFF);

}  // namespace chromeos

#endif  // CHROMEOS_UI_BASE_CHROMEOS_UI_CONSTANTS_H_
