// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROMEOS_SERVICES_ASSISTANT_PUBLIC_CPP_CONVERSATION_OBSERVER_H_
#define CHROMEOS_SERVICES_ASSISTANT_PUBLIC_CPP_CONVERSATION_OBSERVER_H_

#include "base/component_export.h"
#include "chromeos/services/libassistant/public/mojom/conversation_observer.mojom.h"
#include "mojo/public/cpp/bindings/receiver.h"

namespace chromeos {
namespace assistant {

// Default implementation of |mojom::ConversationObserver|, which allow child
// child classes to only implement handlers they are interested in.
class COMPONENT_EXPORT(ASSISTANT_SERVICE_PUBLIC) ConversationObserver
    : public libassistant::mojom::ConversationObserver {
 public:
  // libassistant::mojom::ConversationObserver:
  void OnInteractionFinished(
      AssistantInteractionResolution resolution) override {}
  void OnTtsStarted(bool due_to_error) override {}

  mojo::PendingRemote<libassistant::mojom::ConversationObserver>
  BindNewPipeAndPassRemote();

 protected:
  ConversationObserver();
  ~ConversationObserver() override;

 private:
  mojo::Receiver<libassistant::mojom::ConversationObserver> remote_observer_{
      this};
};

}  // namespace assistant
}  // namespace chromeos

#endif  // CHROMEOS_SERVICES_ASSISTANT_PUBLIC_CPP_CONVERSATION_OBSERVER_H_
