// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * @fileoverview Test suite for chrome://eche-app.
 */

GEN('#include "ash/constants/ash_features.h"');
GEN('#include "content/public/test/browser_test.h"');

const HOST_ORIGIN = 'chrome://eche-app';

var EcheAppUIBrowserTest = class extends testing.Test {
  /** @override */
  get browsePreload() {
    return HOST_ORIGIN;
  }

  /** @override */
  get runAccessibilityChecks() {
    return false;
  }

  /** @override */
  get featureList() {
    return {enabled: ['chromeos::features::kEcheSWA']};
  }
};

// Tests that chrome://eche-app runs js file and that it goes
// somewhere instead of 404ing or crashing.
// Failing, see crbug.com/1185641
TEST_F('EcheAppUIBrowserTest', 'DISABLED_HasChromeSchemeURL', () => {
  const header = document.querySelector('header');

  assertEquals(header.innerText, 'Eche App');
  assertEquals(document.location.origin, HOST_ORIGIN);
});
