// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// TODO(b/172340451): Use the types generated by Mojo TypeScript binding
// generator once https://crbug.com/1002798 is finished.
type MojomNamespace = {
  mojom: any
};

declare var arc: MojomNamespace;
declare var chromeosCamera: MojomNamespace;
declare var cros: MojomNamespace;

declare namespace chromeosCamera.mojom {
  export type CameraAppHelperRemote = any;
  export type ScreenState = any;
  export type WindowStateControllerRemote = any;
  export type WindowStateType = any;
}

declare namespace cros.mojom {
  export type CameraAppDeviceProviderRemote = any;
  export type CameraAppDeviceRemote = any;
  export type CameraMetadata = any;
  export type CameraMetadataEntry = any;
  export type CameraMetadataTag = any;
  export type CaptureIntent = any;
  export type Effect = any;
  export type StreamType = any;
}

// TODO(b/172340451): Install @types/w3c-image-capture in third_party/node to
// get the correct types.
type PhotoSettings = any;
type MediaRecorder = any;
type ImageCapture = any;
type PhotoCapabilities = any;

// This is currently a Chrome only API, and the spec is still in working draft
// stage.
// https://developer.mozilla.org/en-US/docs/Web/API/UIEvent/sourceCapabilities

interface UIEvent extends Event {
  readonly sourceCapabilities: InputDeviceCapabilities|null;
}

interface InputDeviceCapabilities {
  readonly firesTouchEvents: boolean;
  readonly pointerMovementScrolls: boolean;
}

// The new "subtree" option is not published in the latest spec yet.
// Ref: https://github.com/w3c/csswg-drafts/pull/3902

interface GetAnimationsOptions {
  subtree: boolean;
}

interface Animatable {
  getAnimations(options?: GetAnimationsOptions): Animation[];
}

// File System Access API: This is currently a Chrome only API, and the spec is
// still in working draft stage.
// https://wicg.github.io/file-system-access/

// close() is only implemented in Chrome so it's not in upstream type
// definitions. Ref:
// https://github.com/microsoft/TypeScript-DOM-lib-generator/pull/827.
interface WritableStream {
  close(): Promise<void>;
}

interface FileSystemHandleBase {
  readonly name: string;
}

type FileSystemWriteChunkType = BufferSource|Blob|string;

interface FileSystemWritableFileStream extends WritableStream {
  seek(position: number): Promise<void>;
  truncate(size: number): Promise<void>;
  write(data: FileSystemWriteChunkType): Promise<void>;
}

interface FileSystemCreateWritableOptions {
  keepExistingData?: boolean;
}

interface FileSystemFileHandle extends FileSystemHandleBase {
  readonly kind: 'file';
  createWritable(options?: FileSystemCreateWritableOptions):
      Promise<FileSystemWritableFileStream>;
  getFile(): Promise<File>;
}

interface FileSystemGetDirectoryOptions {
  create?: boolean;
}

interface FileSystemGetFileOptions {
  create?: boolean;
}

interface FileSystemDirectoryHandle extends FileSystemHandleBase {
  readonly kind: 'directory';
  getDirectoryHandle(name: string, options?: FileSystemGetDirectoryOptions):
      Promise<FileSystemDirectoryHandle>;
  getFileHandle(name: string, options?: FileSystemGetFileOptions):
      Promise<FileSystemFileHandle>;
  values(): IterableIterator<FileSystemHandle>;
}

type FileSystemHandle = FileSystemFileHandle|FileSystemDirectoryHandle;

type VarFor<T> = {
  prototype: T;
  // clang-format parses "new" in a wrong way.
  // clang-format off
  new(): T;
  // clang-format on
};

declare var FileSystemDirectoryHandle: VarFor<FileSystemDirectoryHandle>;
declare var FileSystemFileHandle: VarFor<FileSystemFileHandle>;

interface StorageManager {
  getDirectory(): Promise<FileSystemDirectoryHandle>;
}

// Chrome WebUI specific helper.
// https://source.chromium.org/chromium/chromium/src/+/master:ui/webui/resources/js/load_time_data.js

declare var loadTimeData: {
  getString(id: string): string;
  getStringF(id: string, ...args: (number|string)[]): string;
}
