// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROMEOS_COMPONENTS_ECHE_APP_UI_SYSTEM_INFO_PROVIDER_H_
#define CHROMEOS_COMPONENTS_ECHE_APP_UI_SYSTEM_INFO_PROVIDER_H_

#include "chromeos/components/eche_app_ui/mojom/eche_app.mojom.h"
#include "mojo/public/cpp/bindings/receiver.h"

namespace chromeos {
namespace eche_app {

extern const char kJsonDeviceNameKey[];
extern const char kJsonBoardNameKey[];

class SystemInfo;

// Provides the system information likes board/device names for EcheApp and
// exposes the interface via mojoa.
class SystemInfoProvider : public mojom::SystemInfoProvider {
 public:
  explicit SystemInfoProvider(std::unique_ptr<SystemInfo> system_info);
  ~SystemInfoProvider() override;

  SystemInfoProvider(const SystemInfoProvider&) = delete;
  SystemInfoProvider& operator=(const SystemInfoProvider&) = delete;

  // mojom::SystemInfoProvider:
  void GetSystemInfo(
      base::OnceCallback<void(const std::string&)> callback) override;

  void Bind(mojo::PendingReceiver<mojom::SystemInfoProvider> receiver);

 private:
  mojo::Receiver<mojom::SystemInfoProvider> info_receiver_{this};
  std::unique_ptr<SystemInfo> system_info_;
};

}  // namespace eche_app
}  // namespace chromeos

#endif  // CHROMEOS_COMPONENTS_ECHE_APP_UI_SYSTEM_INFO_PROVIDER_H_
