// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_SYNC_TEST_INTEGRATION_COMMITTED_ALL_NUDGED_CHANGES_CHECKER_H_
#define CHROME_BROWSER_SYNC_TEST_INTEGRATION_COMMITTED_ALL_NUDGED_CHANGES_CHECKER_H_

#include "base/memory/weak_ptr.h"
#include "chrome/browser/sync/test/integration/single_client_status_change_checker.h"
#include "third_party/abseil-cpp/absl/types/optional.h"

namespace syncer {
class ProfileSyncService;
}  // namespace syncer

// Checker to block until all nudged changes have been committed to the server.
// It doesn't rely on self invalidations and it's safe to be used in tests which
// turn off self notifications.
class CommittedAllNudgedChangesChecker
    : public SingleClientStatusChangeChecker {
 public:
  explicit CommittedAllNudgedChangesChecker(
      syncer::ProfileSyncService* service);
  ~CommittedAllNudgedChangesChecker() override;

  // StatusChangeChecker implementation.
  bool IsExitConditionSatisfied(std::ostream* os) override;

  // syncer::SyncServiceObserver implementation.
  void OnSyncCycleCompleted(syncer::SyncService* sync) override;

 private:
  void GotHasUnsyncedItems(bool has_unsynced_items);

  absl::optional<bool> has_unsynced_items_;
  base::WeakPtrFactory<CommittedAllNudgedChangesChecker> weak_ptr_factory_{
      this};
};

#endif  // CHROME_BROWSER_SYNC_TEST_INTEGRATION_COMMITTED_ALL_NUDGED_CHANGES_CHECKER_H_
