// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_VIEWS_BOOKMARKS_BOOKMARK_BUBBLE_VIEW_H_
#define CHROME_BROWSER_UI_VIEWS_BOOKMARKS_BOOKMARK_BUBBLE_VIEW_H_

#include <memory>

#include "base/macros.h"
#include "chrome/browser/ui/sync/bubble_sync_promo_delegate.h"

class GURL;
class Profile;

namespace bookmarks {
class BookmarkBubbleObserver;
}

namespace views {
class BubbleDialogDelegate;
class Button;
class View;
}

// BookmarkBubbleView provides a dialog for unstarring and editing the bookmark
// it is created with. The dialog is created using the static ShowBubble method.
class BookmarkBubbleView {
 public:
  static void ShowBubble(views::View* anchor_view,
                         views::Button* highlighted_button,
                         bookmarks::BookmarkBubbleObserver* observer,
                         std::unique_ptr<BubbleSyncPromoDelegate> delegate,
                         Profile* profile,
                         const GURL& url,
                         bool already_bookmarked);

  static void Hide();

  static views::BubbleDialogDelegate* bookmark_bubble() {
    return bookmark_bubble_;
  }

 private:
  class BookmarkBubbleDelegate;
  // The bookmark bubble, if we're showing one.
  static views::BubbleDialogDelegate* bookmark_bubble_;

  DISALLOW_COPY_AND_ASSIGN(BookmarkBubbleView);
};

#endif  // CHROME_BROWSER_UI_VIEWS_BOOKMARKS_BOOKMARK_BUBBLE_VIEW_H_
