// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHROMEOS_DBUS_DLP_FILES_POLICY_SERVICE_PROVIDER_H_
#define CHROME_BROWSER_CHROMEOS_DBUS_DLP_FILES_POLICY_SERVICE_PROVIDER_H_

#include <string>

#include "base/memory/scoped_refptr.h"
#include "base/memory/weak_ptr.h"
#include "chromeos/dbus/services/cros_dbus_service.h"
#include "dbus/exported_object.h"

namespace dbus {
class MethodCall;
}  // namespace dbus

namespace chromeos {

class DlpFilesPolicyServiceProvider
    : public CrosDBusService::ServiceProviderInterface {
 public:
  DlpFilesPolicyServiceProvider();
  ~DlpFilesPolicyServiceProvider() override;
  DlpFilesPolicyServiceProvider(const DlpFilesPolicyServiceProvider&) = delete;
  DlpFilesPolicyServiceProvider& operator=(
      const DlpFilesPolicyServiceProvider&) = delete;

  // CrosDBusService::ServiceProviderInterface override:
  void Start(scoped_refptr<dbus::ExportedObject> exported_object) override;

 private:
  // Callback called when method is exported or failed to be exported.
  void OnExported(const std::string& interface_name,
                  const std::string& method_name,
                  bool success);

  // org.chromium.DlpFilesPolicyService.IsRestricted implementation.
  void IsRestricted(dbus::MethodCall* method_call,
                    dbus::ExportedObject::ResponseSender response_sender);

  // org.chromium.DlpFilesPolicyService.IsDlpPolicyMatched implementation.
  void IsDlpPolicyMatched(dbus::MethodCall* method_call,
                          dbus::ExportedObject::ResponseSender response_sender);

  base::WeakPtrFactory<DlpFilesPolicyServiceProvider> weak_ptr_factory_{this};
};

}  // namespace chromeos

#endif  // CHROME_BROWSER_CHROMEOS_DBUS_DLP_FILES_POLICY_SERVICE_PROVIDER_H_
