// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_VIEWS_PAGE_INFO_CHOSEN_OBJECT_VIEW_H_
#define CHROME_BROWSER_UI_VIEWS_PAGE_INFO_CHOSEN_OBJECT_VIEW_H_

#include <string>

#include "components/page_info/page_info_ui.h"
#include "ui/base/metadata/metadata_header_macros.h"
#include "ui/views/view.h"


class ChosenObjectViewObserver;
class PageInfoRowView;

// A ChosenObjectView is a row in the Page Info bubble that shows an individual
// object (e.g. a Bluetooth device, a USB device) that the current site has
// access to.
class ChosenObjectView : public views::View {
 public:
  METADATA_HEADER(ChosenObjectView);
  explicit ChosenObjectView(std::unique_ptr<PageInfoUI::ChosenObjectInfo> info,
                            std::u16string display_name);
  ChosenObjectView(const ChosenObjectView&) = delete;
  ChosenObjectView& operator=(const ChosenObjectView&) = delete;
  ~ChosenObjectView() override;

  void AddObserver(ChosenObjectViewObserver* observer);

 private:
  void UpdateIconImage(bool is_deleted) const;

  void ExecuteDeleteCommand();

  views::View* delete_button_ = nullptr;
  PageInfoRowView* row_view_ = nullptr;

  base::ObserverList<ChosenObjectViewObserver>::Unchecked observer_list_;
  std::unique_ptr<PageInfoUI::ChosenObjectInfo> info_;
};

#endif  // CHROME_BROWSER_UI_VIEWS_PAGE_INFO_CHOSEN_OBJECT_VIEW_H_
