# dPWA Integration Tests

The dPWA integration tests use a special framework. Each test is defined by a
series of "testing actions", and test cases are read from a csv file.

## Future work

* Integrate with the tests generated by the integration testing script. (https://crbug.com/1215791)
  * Create methods that match how the generated script tests use.
  * Abandon the CSV file.
  * Remove #if guards to have the generated tests compile & run.
* Update documentation to cover the new way tests are disabled & delete the TestExpectations file.

## Background

See this [design doc](https://docs.google.com/document/d/e/2PACX-1vTFI0sXhZMvvg1B3sctYVUe64WbLVNzuXFUa6f3XyYTzKs2JnuFR8qKNyXYZsxE-rPPvsq__4ZCyrcS/pub) for background information, and the testing script [README](../../../../test/webapps/README.md) for how integration tests are generated.

### Identifying and Diagnosing Failed Tests

Every test will log a message that will give:

 * the failing test case
 * the line to add to the TestExpectations file to disable the test
 * the command line argument to specify to run the given test locally

In addition to this, every testing action will be printed to console before it
is executed, giving insight into where test failures are occurring.

### Test Input Files

Test files live in //chrome/browser/test/data/web_apps/:
 * web_app_integration_browsertest_cases.csv
 * web_app_integration_browsertest_cases_sync.csv
 * TestExpectations

### Disabling a Test

To disable a failing / crashing test, add an entry to the TestExpectations
file mentioned above. The format is as follows:
```
crbug.com/id [ Platform ] [ Expectation ] list,of,actions,in,test
```

The list of supported platforms and expectations is maintained in the
TestExpectations file. This test suite requires adding an entry
per-platform that the test should be disabled on. Please create a bug for each
test case added to this file.

## How It Works

This testing framework uses a script to generate a minimal set of
test cases that produce the maximum amount of code coverage, and reading in that
script output in these test implementations.


This suite of tests has two main parts:
 1. A script that analyzes dPWA code ([See design
doc](https://docs.google.com/document/d/1YmeNZCpIwUbeV3K3HGUdXzJjZDKIDyKrGfyjnYaLR5k).
 2. The test implementations ([See design
doc](https://docs.google.com/document/d/1Gd14fjwA4VKoRzL2TAvi9paXwyh36ehlS4gbpUmUeeI).

### Script
See the [README](../../../../test/webapps/README.md) and [design doc](https://docs.google.com/document/d/e/2PACX-1vTFI0sXhZMvvg1B3sctYVUe64WbLVNzuXFUa6f3XyYTzKs2JnuFR8qKNyXYZsxE-rPPvsq__4ZCyrcS/pub).

### Test implementation
The high level flow of execution is as follows:
 * Read the input file which contains the test cases
 * Parse the test cases into an `std::vector<std::vector<std::string>>`
 * Pass the vector of test cases to a parameterized test using
   `testing::ValuesIn()`, which will run a test for each line in the input
   file
 * Each test will loop over the testing actions, calling
   `ExecuteAction(action_string)`
 * `ExecuteAction()` will switch on the string, and call the appropriate
   action implementation method
 * A state snapshot will be captured after non-inspection (state mutating)
   actions (so inspection actions can assert various state changes)


## Components
[Design
doc](https://docs.google.com/document/d/139ktCajbmbFKh4T-vEhipTxilyYrXf_rlCBHIvrdeSg).

### WebAppIntegrationBrowserTestBase
A helper class containing most of the test implementation, meant to be used
as a private member on the test-driving classes. Contains most of the test
implementation:
 * Input file parser
 * ExecuteAction()
 * Most action implementation methods
 * Capturing state snapshots

### WebAppIntegrationBrowserTestBase::TestDelegate
An abstract class that’s an application of the delegate interface pattern.
`WebAppIntegrationBrowserTestBase` stores an instance of this class as a
private member, `delegate_`, allowing the base class to call into protected
members of `InProcessBrowserTest` or `SyncTest`, such as
`InProcessBrowserTest::browser()` or `SyncTest::GetAllProfiles()`. This also
has pure virtual methods for sync functionality that needs to be implemented
in `TwoClientWebAppsSyncTest`, but called from the base class.

### WebAppIntegrationBrowserTest
Subclass of both `InProcessBrowserTest` and
`WebAppIntegrationBrowserTestBase::TestDelegate`. Drives the test by
calling `IN_PROC_BROWSER_TEST_P` and instantiating the parameterized
test as described above. Responsible for telling the base class where the test
input files live, handling test setup, and implementing `TestDelegate` methods
to expose protected members of `InProcessBrowserTest` to the base class. This
class owns the base class, and stores it as a private member, `helper_`, passing
it an instance of itself (as the TestDelegate) on construction.


### TwoClientWebAppsSyncTest
Similar to `WebAppIntegrationBrowserTest`, but inheriting from `SyncTest`
instead of from `InProcessBrowserTest`. In addition, some testing actions
related to profile sync are implemented in this class, and are exposed via
`TestDelegate` pure virtual method overrides.

