// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/enterprise/connectors/analysis/content_analysis_downloads_delegate.h"

namespace enterprise_connectors {

ContentAnalysisDownloadsDelegate::ContentAnalysisDownloadsDelegate(
    base::OnceCallback<void()> open_file_callback,
    base::OnceCallback<void()> discard_file_callback)
    : open_file_callback_(std::move(open_file_callback)),
      discard_file_callback_(std::move(discard_file_callback)) {}

ContentAnalysisDownloadsDelegate::~ContentAnalysisDownloadsDelegate() = default;

void ContentAnalysisDownloadsDelegate::BypassWarnings() {
  if (open_file_callback_)
    std::move(open_file_callback_).Run();
  ResetCallbacks();
}

void ContentAnalysisDownloadsDelegate::Cancel(bool warning) {
  if (discard_file_callback_)
    std::move(discard_file_callback_).Run();
  ResetCallbacks();
}

void ContentAnalysisDownloadsDelegate::ResetCallbacks() {
  discard_file_callback_.Reset();
  open_file_callback_.Reset();
}

absl::optional<std::u16string>
ContentAnalysisDownloadsDelegate::GetCustomMessage() const {
  return absl::nullopt;
}

absl::optional<GURL> ContentAnalysisDownloadsDelegate::GetCustomLearnMoreUrl()
    const {
  return absl::nullopt;
}

}  // namespace enterprise_connectors
