// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Declares functions that implement brand-specific behavior. The definitions
// reside in brand-specific files that are only compiled when their respective
// branding is in use at build time.

#ifndef CHROME_INSTALLER_SETUP_BRAND_BEHAVIORS_H_
#define CHROME_INSTALLER_SETUP_BRAND_BEHAVIORS_H_

#include <string>

#include "chrome/installer/util/util_constants.h"

namespace base {
class FilePath;
class Version;
}  // namespace base

namespace installer {

// Communicates a change in install status to the updater. |archive_type|, if
// not UNKNOWN_ARCHIVE_TYPE, indicates what type of install/update is being
// applied. |install_status|, if not UNKNOWN_STATUS, indicates the result of the
// install/update.
void UpdateInstallStatus(installer::ArchiveType archive_type,
                         installer::InstallStatus install_status);

// Returns an opaque string holding data relating to the browser being
// uninstalled. This function is called before the product's Clients key is
// deleted. This blob is later passed to DoPostUninstallOperations.
std::wstring GetDistributionData();

// Performs brand-specific operations following unintsallation of the browser.
// |version| is the version of the browser being uninstalled. |local_data_path|
// |is a backup of the Local State file of the user performing the uninstall
// |operation. |distribution_data| is the string generated by
// |GetDistributionData().
void DoPostUninstallOperations(const base::Version& version,
                               const base::FilePath& local_data_path,
                               const std::wstring& distribution_data);

}  // namespace installer

#endif  // CHROME_INSTALLER_SETUP_BRAND_BEHAVIORS_H_
