# Copyright 2017 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""Create function which removes the specified device policies
from ChromeDeviceSettingsProto.
This function is primarily intended to be used
for the implementation of the DeviceOffHours policy.
"""

from optparse import OptionParser
import sys


def main():
  parser = OptionParser(usage=__doc__)
  (opts, args) = parser.parse_args()
  off_hours_cleaner_path = args[0]
  descriptor_pool_path = args[1]
  symbol_database_path = args[2]
  chrome_device_policy_pb2_path = args[3]
  sys.path.insert(0, descriptor_pool_path)
  sys.path.append(symbol_database_path)
  sys.path.append(chrome_device_policy_pb2_path)
  # Make reload google library
  # which might be already loaded due to Google App Engine
  # TODO(crbug.com/764314): find better solution how to import protobuf.
  import google.protobuf
  # Python 3 doesn't expose a global `reload`.
  if sys.version_info.major == 2:
    reload(google)
    reload(google.protobuf)
  else:
    import importlib
    importlib.reload(google)
    importlib.reload(google.protobuf)
  from chrome_device_policy_pb2 import ChromeDeviceSettingsProto
  with open(off_hours_cleaner_path, 'wt') as file:
    file.write('//\n'
               '// DO NOT MODIFY THIS FILE DIRECTLY!\n'
               '// IT IS GENERATED BY generate_device_policy_remover.py\n'
               '// FROM chrome_device_policy_pb2.py\n'
               '//\n\n'
               '#include <algorithm>\n\n'
               '#include "chrome/browser/chromeos/policy/core/'
               'device_policy_remover.h"\n\n'
               'namespace policy {\n\n'
               'namespace em = enterprise_management;\n\n'
               'void RemovePolicies(\n'
               '    em::ChromeDeviceSettingsProto* policies,\n'
               '    const std::vector<int>& '
               'input_policy_proto_tags_to_remove) {\n'
               '  std::vector<int> policy_proto_tags_to_remove'
               '(input_policy_proto_tags_to_remove);\n'
               '  std::sort(policy_proto_tags_to_remove.begin(),'
               ' policy_proto_tags_to_remove.end());\n')
    for field in ChromeDeviceSettingsProto.DESCRIPTOR.fields:
      file.write('  if (std::binary_search('
                 'policy_proto_tags_to_remove.begin(),\n'
                 '                         '
                 'policy_proto_tags_to_remove.end(),\n'
                 '                         {proto_tag}))\n'
                 '    policies->clear_{name}();'
                 '\n'.format(proto_tag=field.number, name=field.name))
    file.write('}\n}\n')
  return 0

if __name__ == '__main__':
  sys.exit(main())
