// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_APP_LIST_SEARCH_COMMON_TYPES_UTIL_H_
#define CHROME_BROWSER_UI_APP_LIST_SEARCH_COMMON_TYPES_UTIL_H_

#include "ash/public/cpp/app_list/app_list_types.h"

namespace app_list {

// Converts result type to a debug string.
std::string ResultTypeToString(const ash::AppListSearchResultType result_type);

// Converts display type to a debug string.
std::string DisplayTypeToString(
    const ash::SearchResultDisplayType display_type);

}  // namespace app_list

#endif  // CHROME_BROWSER_UI_APP_LIST_SEARCH_COMMON_TYPES_UTIL_H_
