// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_ASH_SHARESHEET_SHARESHEET_UTIL_H_
#define CHROME_BROWSER_UI_ASH_SHARESHEET_SHARESHEET_UTIL_H_

#include <memory>
#include <string>

#include "ash/public/cpp/ash_typography.h"
#include "third_party/skia/include/core/SkColor.h"
#include "ui/gfx/text_constants.h"

namespace views {
class Label;
}  // namespace views

namespace ash {
namespace sharesheet {

std::unique_ptr<views::Label> CreateShareLabel(
    const std::u16string& text,
    const int text_context,
    const int line_height,
    const SkColor color,
    const gfx::HorizontalAlignment alignment,
    const int text_style = ash::STYLE_SHARESHEET);

}  // namespace sharesheet
}  // namespace ash

#endif  // CHROME_BROWSER_UI_ASH_SHARESHEET_SHARESHEET_UTIL_H_
