// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_VIEWS_FRAME_DESKTOP_BROWSER_FRAME_LACROS_H_
#define CHROME_BROWSER_UI_VIEWS_FRAME_DESKTOP_BROWSER_FRAME_LACROS_H_

#include "chrome/browser/ui/views/frame/desktop_browser_frame_aura.h"

class BrowserFrame;
class BrowserView;

// Provides the window frame for the Chrome browser window on Lacros.
class DesktopBrowserFrameLacros : public DesktopBrowserFrameAura {
 public:
  DesktopBrowserFrameLacros(BrowserFrame* browser_frame,
                            BrowserView* browser_view);

  DesktopBrowserFrameLacros(const DesktopBrowserFrameLacros&) = delete;
  DesktopBrowserFrameLacros& operator=(const DesktopBrowserFrameLacros&) =
      delete;

 protected:
  ~DesktopBrowserFrameLacros() override;

  // Overridden from NativeBrowserFrame:
  views::Widget::InitParams GetWidgetParams() override;
};

#endif  // CHROME_BROWSER_UI_VIEWS_FRAME_DESKTOP_BROWSER_FRAME_LACROS_H_
