// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CONTENT_CREATION_NOTES_INTERNAL_NOTE_SERVICE_FACTORY_H_
#define CHROME_BROWSER_CONTENT_CREATION_NOTES_INTERNAL_NOTE_SERVICE_FACTORY_H_

#include "base/macros.h"
#include "base/memory/singleton.h"
#include "components/keyed_service/content/browser_context_keyed_service_factory.h"

class KeyedService;
class Profile;

namespace content_creation {

class NoteService;

// Factory to create and retrieve a NoteService per profile.
class NoteServiceFactory : public BrowserContextKeyedServiceFactory {
 public:
  static NoteServiceFactory* GetInstance();
  static content_creation::NoteService* GetForProfile(Profile* profile);

 private:
  friend struct base::DefaultSingletonTraits<NoteServiceFactory>;

  NoteServiceFactory();
  ~NoteServiceFactory() override;

  // BrowserContextKeyedServiceFactory implementation:
  KeyedService* BuildServiceInstanceFor(
      content::BrowserContext* context) const override;
};

}  // namespace content_creation

#endif  // CHROME_BROWSER_CONTENT_CREATION_NOTES_INTERNAL_NOTE_SERVICE_FACTORY_H_
