// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UPDATES_ANNOUNCEMENT_NOTIFICATION_ANNOUNCEMENT_NOTIFICATION_DELEGATE_ANDROID_H_
#define CHROME_BROWSER_UPDATES_ANNOUNCEMENT_NOTIFICATION_ANNOUNCEMENT_NOTIFICATION_DELEGATE_ANDROID_H_

#include "base/macros.h"
#include "chrome/browser/updates/announcement_notification/announcement_notification_service.h"

class AnnouncementNotificationDelegateAndroid
    : public AnnouncementNotificationService::Delegate {
 public:
  AnnouncementNotificationDelegateAndroid();
  ~AnnouncementNotificationDelegateAndroid() override;

 private:
  // AnnouncementNotificationService::Delegate implementation.
  void ShowNotification() override;
  bool IsFirstRun() override;

  DISALLOW_COPY_AND_ASSIGN(AnnouncementNotificationDelegateAndroid);
};

#endif  // CHROME_BROWSER_UPDATES_ANNOUNCEMENT_NOTIFICATION_ANNOUNCEMENT_NOTIFICATION_DELEGATE_ANDROID_H_
