// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

GEN_INCLUDE(['../common/testing/e2e_test_base.js']);
GEN_INCLUDE(['mock_mojo_private.js']);

/**
 * Test fixture for Enhanced Network TTS E2E tests.
 */
EnhancedNetworkTE2ETestBase = class extends E2ETestBase {
  /** @override */
  constructor() {
    super();
    this.mockMojoPrivate = MockMojoPrivate;
    chrome.mojoPrivate = this.mockMojoPrivate;
  }

  /** @override */
  testGenCppIncludes() {
    super.testGenCppIncludes();
    GEN(`
#include "ash/shell.h"
#include "base/bind.h"
#include "base/callback.h"
#include "chrome/browser/ash/accessibility/accessibility_manager.h"
#include "chrome/common/extensions/extension_constants.h"
#include "content/public/test/browser_test.h"
    `);
  }

  /** @override */
  testGenPreamble() {
    // TODO(leileilei@google.com): Figure out a better way to test Enhanced
    // Network TTS. Currently, loads Select-to-Speak for quick testing purpose.
    // This enables us to load the EnhancedNetworkTts module.
    super.testGenPreamble();
    GEN(`
    base::OnceClosure load_cb =
        base::BindOnce(&ash::AccessibilityManager::SetSelectToSpeakEnabled,
            base::Unretained(ash::AccessibilityManager::Get()),
            true);
    `);
  }

  /** @override */
  setUp() {
    const runTest = this.deferRunTest(WhenTestDone.EXPECT);
    (async function() {
      await importModule(
          'EnhancedNetworkTts',
          '/enhanced_network_tts/enhanced_network_tts.js');
      runTest();
    })();
  }
};
