// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_VIEWS_SHARING_HUB_SCREENSHOT_SCREENSHOT_CAPTURED_BUBBLE_H_
#define CHROME_BROWSER_UI_VIEWS_SHARING_HUB_SCREENSHOT_SCREENSHOT_CAPTURED_BUBBLE_H_

#include "chrome/browser/ui/views/location_bar/location_bar_bubble_delegate_view.h"
#include "ui/base/metadata/metadata_header_macros.h"
#include "ui/views/controls/label.h"

namespace content {
class WebContents;
}  // namespace content

namespace views {
class ImageView;
class LabelButton;
class MdTextButton;
class View;
}  // namespace views

namespace sharing_hub {

// Dialog that displays a captured screenshot, and provides the option
// to edit, share, or download.
class ScreenshotCapturedBubble : public LocationBarBubbleDelegateView {
 public:
  METADATA_HEADER(ScreenshotCapturedBubble);
  ScreenshotCapturedBubble(views::View* anchor_view,
                           content::WebContents* web_contents,
                           const gfx::Image& image);
  ScreenshotCapturedBubble(const ScreenshotCapturedBubble&) = delete;
  ScreenshotCapturedBubble& operator=(const ScreenshotCapturedBubble&) = delete;
  ~ScreenshotCapturedBubble() override;

  void Show();

 private:
  // LocationBarBubbleDelegateView:
  View* GetInitiallyFocusedView() override;
  bool ShouldShowCloseButton() const override;
  void WindowClosing() override;

  static const std::u16string GetFilenameForURL(const GURL& url);

  // views::BubbleDialogDelegateView:
  void Init() override;

  void DownloadButtonPressed();

  void EditButtonPressed();

  const gfx::Image& image_;

  content::WebContents* web_contents_;

  // Pointers to view widgets; weak.
  views::ImageView* image_view_ = nullptr;
  views::MdTextButton* download_button_ = nullptr;
  views::LabelButton* edit_button_ = nullptr;
};

}  // namespace sharing_hub

#endif  // CHROME_BROWSER_UI_VIEWS_SHARING_HUB_SCREENSHOT_SCREENSHOT_CAPTURED_BUBBLE_H_
