// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {addSingletonGetter} from 'chrome://resources/js/cr.m.js';

/** @interface */
export class CfmNetworkSettingsBrowserProxy {
  /** @param {string} guid */
  showNetworkDetails(guid) {}

  /** @param {string} guid */
  showNetworkConfig(guid) {}

  showAddWifi() {}

  showManageCerts() {}
}

/** @implements {CfmNetworkSettingsBrowserProxy} */
export class CfmNetworkSettingsBrowserProxyImpl {
  /** @override */
  showNetworkDetails(guid) {
    chrome.send('showNetworkDetails', [guid]);
  }

  /** @override */
  showNetworkConfig(guid) {
    chrome.send('showNetworkConfig', [guid]);
  }

  /** @override */
  showAddWifi() {
    chrome.send('showAddWifi');
  }

  /** @override */
  showManageCerts() {
    chrome.send('showManageCerts');
  }
}

addSingletonGetter(CfmNetworkSettingsBrowserProxyImpl);
