// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * @fileoverview A helper object used from the "About" section to interact with
 * the browser.
 */

// clang-format off
import {addSingletonGetter, sendWithPromise} from 'chrome://resources/js/cr.m.js';
// clang-format on

/**
 * Enumeration of all possible update statuses. The string literals must match
 * the ones defined at |AboutHandler::UpdateStatusToString|.
 * @enum {string}
 */
export const UpdateStatus = {
  CHECKING: 'checking',
  UPDATING: 'updating',
  NEARLY_UPDATED: 'nearly_updated',
  UPDATED: 'updated',
  FAILED: 'failed',
  FAILED_HTTP: 'failed_http',
  FAILED_DOWNLOAD: 'failed_download',
  DISABLED: 'disabled',
  DISABLED_BY_ADMIN: 'disabled_by_admin',
  NEED_PERMISSION_TO_UPDATE: 'need_permission_to_update',
};

// Note: This typedef should only defined for _google_chrome and is_macosx,
// however, while the Polymer 3 version of this file is autogenerated, it is
// temporarily defined on all platforms.
// TODO (rbpotter): Make this platform/build specific again once the Polymer 3
// version of this file is checked in, and autogeneration is no longer
// necessary.
/**
 * @typedef {{
 *   hidden: boolean,
 *   disabled: boolean,
 *   actionable: boolean,
 *   text: (string|undefined)
 * }}
 */
export let PromoteUpdaterStatus;

/**
 * @typedef {{
 *   status: !UpdateStatus,
 *   progress: (number|undefined),
 *   message: (string|undefined),
 *   connectionTypes: (string|undefined),
 *   version: (string|undefined),
 *   size: (string|undefined),
 * }}
 */
export let UpdateStatusChangedEvent;


/** @interface */
export class AboutPageBrowserProxy {
  /**
   * Indicates to the browser that the page is ready.
   */
  pageReady() {}

  /**
   * Request update status from the browser. It results in one or more
   * 'update-status-changed' WebUI events.
   */
  refreshUpdateStatus() {}

  /** Opens the help page. */
  openHelpPage() {}

  // <if expr="_google_chrome">
  /**
   * Opens the feedback dialog.
   */
  openFeedbackDialog() {}

  // </if>

  // <if expr="_google_chrome and is_macosx">
  /**
   * Triggers setting up auto-updates for all users.
   */
  promoteUpdater() {}
  // </if>
}

/**
 * @implements {AboutPageBrowserProxy}
 */
export class AboutPageBrowserProxyImpl {
  /** @override */
  pageReady() {
    chrome.send('aboutPageReady');
  }

  /** @override */
  refreshUpdateStatus() {
    chrome.send('refreshUpdateStatus');
  }

  // <if expr="_google_chrome and is_macosx">
  /** @override */
  promoteUpdater() {
    chrome.send('promoteUpdater');
  }
  // </if>

  /** @override */
  openHelpPage() {
    chrome.send('openHelpPage');
  }

  // <if expr="_google_chrome">
  /** @override */
  openFeedbackDialog() {
    chrome.send('openFeedbackDialog');
  }
  // </if>
}

addSingletonGetter(AboutPageBrowserProxyImpl);
