// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "base/path_service.h"
#include "chrome/browser/ui/views/web_apps/web_app_integration_browsertest_base.h"
#include "chrome/browser/web_applications/os_integration_manager.h"
#include "chrome/test/base/in_process_browser_test.h"
#include "content/public/test/browser_test.h"
#include "services/network/public/cpp/network_switches.h"

namespace web_app {

class WebAppIntegrationBrowserTest
    : public InProcessBrowserTest,
      public WebAppIntegrationBrowserTestBase::TestDelegate,
      public testing::WithParamInterface<std::string> {
 public:
  WebAppIntegrationBrowserTest() : helper_(this) {}

  // InProcessBrowserTest
  void SetUp() override {
    helper_.SetUp(GetChromeTestDataDir());
    InProcessBrowserTest::SetUp();
  }

  // BrowserTestBase
  void SetUpOnMainThread() override { helper_.SetUpOnMainThread(); }
  void TearDownOnMainThread() override { helper_.TearDownOnMainThread(); }

  void SetUpCommandLine(base::CommandLine* command_line) override {
    ASSERT_TRUE(embedded_test_server()->Start());
    command_line->AppendSwitchASCII(
        network::switches::kUnsafelyTreatInsecureOriginAsSecure,
        helper_.GetInstallableAppURL("SiteA").GetOrigin().spec());
    command_line->AppendSwitchASCII(
        network::switches::kUnsafelyTreatInsecureOriginAsSecure,
        helper_.GetInstallableAppURL("SiteB").GetOrigin().spec());
    command_line->AppendSwitchASCII(
        network::switches::kUnsafelyTreatInsecureOriginAsSecure,
        helper_.GetInstallableAppURL("SiteC").GetOrigin().spec());
    command_line->AppendSwitchASCII(
        network::switches::kUnsafelyTreatInsecureOriginAsSecure,
        helper_.GetInstallableAppURL("SiteAFoo").GetOrigin().spec());
    command_line->AppendSwitchASCII(
        network::switches::kUnsafelyTreatInsecureOriginAsSecure,
        helper_.GetInstallableAppURL("SiteABar").GetOrigin().spec());
  }

  // WebAppIntegrationBrowserTestBase::TestDelegate
  Browser* CreateBrowser(Profile* profile) override {
    return InProcessBrowserTest::CreateBrowser(profile);
  }

  void AddBlankTabAndShow(Browser* browser) override {
    InProcessBrowserTest::AddBlankTabAndShow(browser);
  }

  net::EmbeddedTestServer* EmbeddedTestServer() override {
    return embedded_test_server();
  }

  std::vector<Profile*> GetAllProfiles() override {
    return std::vector<Profile*>{browser()->profile()};
  }

  bool IsSyncTest() override { return false; }

  void SyncTurnOff() override { NOTREACHED(); }
  void SyncTurnOn() override { NOTREACHED(); }

  WebAppIntegrationBrowserTestBase helper_;
};

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteA_WindowCreated_InstPlcyTabShctSiteA_NavSiteA_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteA_WindowCreated_InstPlcyTabShctSiteA_UninstallPlcySiteA)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.UninstallPolicyApp("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteA_WindowCreated_NavSiteA_InstIconNotShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteA_WindowCreated_ClosePWA_MnfstUpdateDsplMinimalSiteA) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.ClosePwa();
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.ManifestUpdateDisplayMinimal("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteA_WindowCreated_SetOpenTabSiteA_NavSiteA_InstIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.SetOpenInTab("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteA_WindowCreated_NavSiteAFoo_InstIconNotShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteA_WindowCreated_InstPlcyWinShctSiteA_UninstallPlcySiteA)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.UninstallPolicyApp("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstMenuOptionSiteA_WindowCreated_InstPlcyTabShctSiteA_NavSiteA_LaunchIconShown)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstMenuOptionSiteA_WindowCreated_InstPlcyTabShctSiteA_UninstallPlcySiteA)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.UninstallPolicyApp("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstMenuOptionSiteA_WindowCreated_NavSiteA_InstIconNotShown_LaunchIconShown)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstMenuOptionSiteA_WindowCreated_ClosePWA_MnfstUpdateDsplMinimalSiteA)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.ClosePwa();
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.ManifestUpdateDisplayMinimal("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstMenuOptionSiteA_WindowCreated_SetOpenTabSiteA_NavSiteA_InstIconShown)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.SetOpenInTab("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
  WebAppIntegration_InstMenuOptionSiteA_WindowCreated_NavSiteAFoo_InstIconNotShown_LaunchIconShown)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
  WebAppIntegrationBrowserTest,
  WebAppIntegration_InstMenuOptionSiteA_WindowCreated_InstPlcyWinShctSiteA_UninstallPlcySiteA)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.UninstallPolicyApp("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyWinShctSiteA_UninstallPlcySiteA_NotInListSiteA) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.UninstallPolicyApp("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckAppNotInList("SiteA");
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyWinShctSiteA_NavSiteA_InstIconNotShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(WebAppIntegrationBrowserTest,
                       WebAppIntegration_InstPlcyWinShctSiteA_SetOpenTabSiteA) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.SetOpenInTab("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyWinShctSiteA_NavSiteAFoo_InstIconNotShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyTabShctSiteA_UninstallPlcySiteA_NotInListSiteA_NavSiteA_InstIconShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.UninstallPolicyApp("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckAppNotInList("SiteA");
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconNotShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyTabShctSiteA_InstOmniboxSiteA_WindowCreated_UninstallPlcySiteA)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.UninstallPolicyApp("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyTabShctSiteA_InstMenuOptionSiteA_WindowCreated_UninstallPlcySiteA)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.UninstallPolicyApp("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyTabShctSiteA_NavSiteA_InstIconShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconNotShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyTabShctSiteA_SetOpenWindowSiteA) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.SetOpenInWindow("SiteA");
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyTabShctSiteC_NavSiteC_InstIconNotShown_LaunchIconShown)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppTabbedShortcut("SiteC");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteC");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyWinShctSiteC_NavSiteC_InstIconNotShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteC");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteC");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(WebAppIntegrationBrowserTest,
                       WebAppIntegration_InstOmniboxSiteAFoo_ClosePWA) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.ClosePwa();
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteAFoo_NavSiteABar_InstIconShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteABar");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconNotShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(WebAppIntegrationBrowserTest,
                       WebAppIntegration_InstMenuOptionSiteAFoo_ClosePWA) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.ClosePwa();
  helper_.AfterStateChangeAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstMenuOptionSiteAFoo_NavSiteABar_InstIconShown_LaunchIconShown)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteABar");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconNotShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyWinShctSiteAFoo_NavSiteABar_InstIconShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteABar");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconNotShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(WebAppIntegrationBrowserTest,
                       WebAppIntegration_NavSiteAFoo_InstIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteAFoo");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(WebAppIntegrationBrowserTest,
                       WebAppIntegration_NavSiteA_NotInListSiteA) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckAppNotInList("SiteA");
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_NavSiteC_NotInListSiteA_InstIconNotShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteC");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckAppNotInList("SiteA");
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconNotShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteA_WindowCreated_NavSiteB_InstIconShown_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteB");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconNotShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstMenuOptionSiteA_WindowCreated_NavSiteB_InstIconShown_LaunchIconShown)
{
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteA");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckWindowCreated();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteB");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckInstallIconShown();
  helper_.AfterStateCheckAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconNotShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstOmniboxSiteB_NavSiteB_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallOmniboxIcon("SiteB");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteB");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(
    WebAppIntegrationBrowserTest,
    WebAppIntegration_InstPlcyWinShctSiteB_NavSiteB_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallPolicyAppWindowedShortcut("SiteB");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteB");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

IN_PROC_BROWSER_TEST_F(WebAppIntegrationBrowserTest,
                       WebAppIntegration_InstMenuOptionSiteB_NavSiteB_LaunchIconShown) {
  // Test contents are generated by script. Please do not modify!
  // See `chrome/test/webapps/README.md` for more info.
  // Sheriffs: Disabling this test is supported.
  helper_.BeforeStateChangeAction();
  helper_.InstallMenuOption("SiteB");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateChangeAction();
  helper_.NavigateBrowser("SiteB");
  helper_.AfterStateChangeAction();

  helper_.BeforeStateCheckAction();
  helper_.CheckLaunchIconShown();
  helper_.AfterStateCheckAction();
}

}  // namespace web_app
