﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<Mvc2AppMitBereichen.Areas.Fakturierung.Models.Rechnung>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	Rechnung
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <h2>Rechnung</h2>
    <fieldset>
        <legend>Anschrift</legend>
        <div class="display-field"><%: Model.Name %></div>
        <div class="display-field"><%: Model.Strasse %></div>
        <div class="display-field"><%: Model.PLZ %>&nbsp;<%: Model.Ort %></div>
        <div class="display-field"><%: Model.Land %></div>
    </fieldset>
    <p>
        Rechnungsnr.: <%: Model.RechnungNr %><br />
        Datum: <%: String.Format("{0:D}", Model.Datum) %>
    </p>
    <table cellpadding="3">
        <tr>
            <th>
                Artikel-Nr.
            </th>
            <th>
                Anzahl
            </th>
            <th>
                Bezeichnung
            </th>
            <th>
                Einzel-Preis
            </th>
            <th>
                Rabatt
            </th>
            <th>
                Gesamt-Preis
            </th>
        </tr>

    <% foreach (var item in Model.Positionen) { %>
    
        <tr>
            <td>
                <%: item.ArtikelNr %>
            </td>
            <td>
                <%: item.Anzahl %>
            </td>
            <td>
                <%: item.ArtikelBezeichnung %>
            </td>
            <td align="right">
                <%: String.Format("{0:F}", item.EinzelPreis) %>
            </td>
            <td align="right">
                <%: item.Rabatt * 100 %>%
            </td>
            <td align="right">
                <%: String.Format("{0:F}", item.GesamtPreis) %>
            </td>
        </tr>
    
    <% } %>

    </table>
    <p>
        <div class="display-label">Gesamt-Betrag</div>
        <div class="display-field"><%: String.Format("{0:F}", Model.GesamtBetrag) %></div>
    </p>
    <p>
        <%: Html.ActionLink("Back to List", "Index") %>
    </p>
</asp:Content>

