﻿using System;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

namespace Mvc2ModelValidation.Models
{
    [MetadataType(typeof(Person_Validierung))]
    public partial class Person
    {
        // Teil-Klasse, welche die vom Entity Framework erzeuge Klasse erweitert.
    }

    [Bind(Exclude="ID")]
    public class Person_Validierung
    {
        [Required(ErrorMessage="Bitte geben Sie einen Vorname an.")]
        [StringLength(50, ErrorMessage="Der Vorname darf nicht länger als 50 Zeichen sein.")]
        public string Vorname { get; set; }

        [Required(ErrorMessage = "Bitte geben Sie einen Nachname an.")]
        [StringLength(50, ErrorMessage = "Der Nachname darf nicht länger als 50 Zeichen sein.")]
        public string Nachname { get; set; }
        
        [Required(ErrorMessage = "Bitte geben Sie ein Alter an.")]
        [Range(1, 120, ErrorMessage="Das Alter muss zwischen 1 und 120 liegen.")]
        public int Alter { get; set; }
        
        [Required(ErrorMessage = "Bitte geben Sie eine EMail Adresse an.")]
        [RegularExpression("^[a-z0-9_\\+-]+(\\.[a-z0-9_\\+-]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*\\.([a-z]{2,4})$"
            , ErrorMessage = "Die EMail Adresse ist nicht gültig.")]
        public string EMail { get; set; }
    }
}