/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.dependencies.linkagemonitor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class HttpUtil {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 3000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 3000;
    private static final String USER_AGENT = "linkage-monitor";

    HttpUtil() {
    }

    static int sendPost(String urlString, Map<String, String> parameters) throws IOException {
        String parametersString = HttpUtil.getParametersString(parameters);
        return HttpUtil.sendPost(urlString, parametersString, "application/x-www-form-urlencoded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int sendPost(String urlString, String body, String mediaType) throws IOException {
        byte[] bytesToWrite = body.getBytes(StandardCharsets.UTF_8);
        URL url = new URL(urlString);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Content-type", mediaType);
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.setFixedLengthStreamingMode(bytesToWrite.length);
            try (OutputStream out = connection.getOutputStream();){
                out.write(bytesToWrite);
                out.flush();
            }
            int n = connection.getResponseCode();
            return n;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @VisibleForTesting
    static String getParametersString(Map<String, String> parametersMap) {
        StringBuilder resultBuilder = new StringBuilder();
        boolean ampersandNeeded = false;
        for (Map.Entry<String, String> entry : parametersMap.entrySet()) {
            if (ampersandNeeded) {
                resultBuilder.append('&');
            } else {
                ampersandNeeded = true;
            }
            resultBuilder.append(entry.getKey());
            resultBuilder.append('=');
            resultBuilder.append(UrlEscapers.urlFormParameterEscaper().escape(entry.getValue()));
        }
        return resultBuilder.toString();
    }
}

