/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.dependencies.linkagemonitor;

import com.google.cloud.tools.dependencies.linkagemonitor.VersionSubstitutingModelResolver;
import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.LinkageChecker;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.Bom;
import com.google.cloud.tools.opensource.dependencies.MavenRepositoryException;
import com.google.cloud.tools.opensource.dependencies.RepositoryUtility;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractCollection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.project.ProjectModelResolver;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class LinkageMonitor {
    private static final Logger logger = Logger.getLogger(LinkageMonitor.class.getName());
    private static final DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
    private final RepositorySystem repositorySystem = RepositoryUtility.newRepositorySystem();
    private final RepositorySystemSession session = RepositoryUtility.newSession(this.repositorySystem);
    private final ImmutableMap<String, String> localArtifacts = LinkageMonitor.findLocalArtifacts(this.repositorySystem, this.session, Paths.get(".", new String[0]).toAbsolutePath());

    public static void main(String[] arguments) throws RepositoryException, IOException, MavenRepositoryException, ModelBuildingException {
        ImmutableSet<LinkageProblem> newLinkageProblems;
        int errorSize;
        CommandLine commandLine = LinkageMonitor.parseCommandLine(arguments);
        String bomCoordinates = commandLine.getArgList().get(0);
        List<String> coordinatesElements = Splitter.on(':').splitToList(bomCoordinates);
        if (coordinatesElements.size() != 2) {
            logger.severe("Please specify BOM coordinates without version. Example: com.google.cloud:libraries-bom");
            System.exit(1);
        }
        if ((errorSize = (newLinkageProblems = new LinkageMonitor().run(coordinatesElements.get(0), coordinatesElements.get(1))).size()) > 0) {
            logger.severe(String.format("Found %d new linkage error%s", errorSize, errorSize > 1 ? "s" : ""));
            logger.info("For the details of the linkage errors, see https://github.com/GoogleCloudPlatform/cloud-opensource-java/wiki/Linkage-Checker-Messages");
            System.exit(1);
        } else {
            logger.info("No new problem found");
        }
    }

    @VisibleForTesting
    static CommandLine parseCommandLine(String[] arguments) {
        Options options = new Options();
        options.addOption("sa", "send-analytics", false, "track results from each run");
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine commandLine = parser.parse(options, arguments);
            if (commandLine.getArgList().size() != 1) {
                LinkageMonitor.printUsageAndDie();
            }
            return commandLine;
        }
        catch (ParseException ex) {
            LinkageMonitor.printUsageAndDie();
            return null;
        }
    }

    private static void printUsageAndDie() {
        logger.severe("Usage: java com.google.cloud.tools.dependencies.linkagemonitor.LinkageMonitor [--send-analytics] com.google.cloud:libraries-bom");
        System.exit(1);
    }

    @VisibleForTesting
    static ImmutableMap<String, String> findLocalArtifacts(RepositorySystem repositorySystem, RepositorySystemSession session, Path projectDirectory) {
        ImmutableMap.Builder<String, String> artifactToVersion = ImmutableMap.builder();
        Iterable<Path> paths = MoreFiles.fileTraverser().breadthFirst(projectDirectory);
        for (Path path : paths) {
            Path relativePath;
            ImmutableSet<Path> elements;
            if (!path.getFileName().endsWith("pom.xml") || (elements = ImmutableSet.copyOf(relativePath = path.isAbsolute() ? projectDirectory.relativize(path) : path)).contains(Paths.get("build", new String[0])) || elements.contains(Paths.get("target", new String[0]))) continue;
            DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
            modelRequest.setValidationLevel(0);
            modelRequest.setProcessPlugins(false);
            modelRequest.setTwoPhaseBuilding(false);
            modelRequest.setPomFile(path.toFile());
            modelRequest.setModelResolver(new ProjectModelResolver(session, null, repositorySystem, new DefaultRemoteRepositoryManager(), ImmutableList.of(RepositoryUtility.CENTRAL), null, null));
            modelRequest.setSystemProperties(System.getProperties());
            try {
                ModelBuildingResult modelBuildingResult = modelBuilder.build(modelRequest);
                Model model = modelBuildingResult.getEffectiveModel();
                artifactToVersion.put(model.getGroupId() + ":" + model.getArtifactId(), model.getVersion());
            }
            catch (ModelBuildingException ex) {
                logger.info("Ignoring bad model: " + path + ": " + ex.getMessage());
            }
        }
        return artifactToVersion.build();
    }

    private ImmutableSet<LinkageProblem> run(String groupId, String artifactId) throws RepositoryException, IOException, MavenRepositoryException, ModelBuildingException {
        Sets.SetView<LinkageProblem> newProblems;
        List entryPointJars;
        String latestBomCoordinates = RepositoryUtility.findLatestCoordinates(this.repositorySystem, groupId, artifactId);
        logger.info("BOM Coordinates: " + latestBomCoordinates);
        Bom baseline = Bom.readBom(latestBomCoordinates);
        ImmutableSet<LinkageProblem> problemsInBaseline = LinkageChecker.create(baseline, null).findLinkageProblems();
        Bom snapshot = LinkageMonitor.copyWithSnapshot(this.repositorySystem, this.session, baseline, this.localArtifacts);
        ImmutableList<String> baselineCoordinates = LinkageMonitor.coordinatesList(baseline.getManagedDependencies());
        ImmutableList<String> snapshotCoordinates = LinkageMonitor.coordinatesList(snapshot.getManagedDependencies());
        if (baselineCoordinates.equals(snapshotCoordinates)) {
            logger.info("Snapshot is same as baseline. Not running comparison.");
            logger.info("Baseline coordinates: " + Joiner.on(";").join(baselineCoordinates));
            return ImmutableSet.of();
        }
        ImmutableList<Artifact> snapshotManagedDependencies = snapshot.getManagedDependencies();
        ClassPathResult classPathResult = new ClassPathBuilder().resolve(snapshotManagedDependencies, true);
        ImmutableList<ClassPathEntry> classpath = classPathResult.getClassPath();
        ImmutableSet<LinkageProblem> problemsInSnapshot = LinkageChecker.create(classpath, ImmutableSet.copyOf(entryPointJars = classpath.subList(0, snapshotManagedDependencies.size())), null).findLinkageProblems();
        if (problemsInBaseline.equals(problemsInSnapshot)) {
            logger.info("Snapshot versions have the same " + problemsInBaseline.size() + " errors as baseline");
            return ImmutableSet.of();
        }
        Sets.SetView<LinkageProblem> fixedProblems = Sets.difference(problemsInBaseline, problemsInSnapshot);
        if (!fixedProblems.isEmpty()) {
            logger.info(LinkageMonitor.messageForFixedErrors(fixedProblems));
        }
        if (!(newProblems = Sets.difference(problemsInSnapshot, problemsInBaseline)).isEmpty()) {
            logger.severe(LinkageMonitor.messageForNewErrors(problemsInSnapshot, problemsInBaseline, classPathResult));
        }
        return ImmutableSet.copyOf(newProblems);
    }

    private static ImmutableList<String> coordinatesList(List<Artifact> artifacts) {
        return artifacts.stream().map(Artifacts::toCoordinates).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    static String messageForNewErrors(Set<LinkageProblem> snapshotProblems, Set<LinkageProblem> baselineProblems, ClassPathResult classPathResult) {
        Sets.SetView<LinkageProblem> newProblems = Sets.difference(snapshotProblems, baselineProblems);
        ImmutableSet.Builder problematicJars = ImmutableSet.builder();
        ImmutableListMultimap groupedBySymbolProblem = Multimaps.index(newProblems, problem -> problem.formatSymbolProblem());
        StringBuilder message = new StringBuilder("Newly introduced problem" + (((AbstractCollection)((Object)groupedBySymbolProblem.keySet())).size() > 1 ? "s" : "") + ":\n");
        for (String problem2 : groupedBySymbolProblem.keySet()) {
            message.append(problem2 + "\n");
            for (LinkageProblem linkageProblem : groupedBySymbolProblem.get(problem2)) {
                if (linkageProblem.getTargetClass() != null) {
                    problematicJars.add(linkageProblem.getTargetClass().getClassPathEntry());
                }
                ClassFile sourceClass = linkageProblem.getSourceClass();
                message.append(String.format("  referenced from %s (%s)\n", sourceClass.getBinaryName(), sourceClass.getClassPathEntry()));
                problematicJars.add(sourceClass.getClassPathEntry());
            }
        }
        message.append("\n");
        message.append(classPathResult.formatDependencyPaths(problematicJars.build()));
        return message.toString();
    }

    @VisibleForTesting
    static String messageForFixedErrors(Set<LinkageProblem> fixedProblems) {
        int problemSize = fixedProblems.size();
        StringBuilder message = new StringBuilder("The following problem" + (problemSize > 1 ? "s" : "") + " in the baseline no longer appear in the snapshot:\n");
        for (LinkageProblem problem : fixedProblems) {
            message.append("  " + problem.formatSymbolProblem() + "\n");
        }
        return message.toString();
    }

    @VisibleForTesting
    static Model buildModelWithSnapshotBom(RepositorySystem repositorySystem, RepositorySystemSession session, String bomCoordinates, Map<String, String> localArtifacts) throws ModelBuildingException, ArtifactResolutionException {
        DefaultArtifact bom;
        String[] elements = bomCoordinates.split(":");
        if (elements.length >= 4) {
            bom = new DefaultArtifact(bomCoordinates);
        } else if (elements.length == 3) {
            bom = new DefaultArtifact(elements[0], elements[1], "pom", elements[2]);
        } else {
            throw new IllegalArgumentException("BOM coordinates do not have valid format: " + bomCoordinates);
        }
        ArtifactResult bomResult = repositorySystem.resolveArtifact(session, new ArtifactRequest(bom, ImmutableList.of(RepositoryUtility.CENTRAL), null));
        DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
        modelRequest.setValidationLevel(0);
        modelRequest.setProcessPlugins(false);
        modelRequest.setTwoPhaseBuilding(true);
        modelRequest.setPomFile(bomResult.getArtifact().getFile());
        modelRequest.setModelResolver(new VersionSubstitutingModelResolver(session, null, repositorySystem, new DefaultRemoteRepositoryManager(), ImmutableList.of(RepositoryUtility.CENTRAL), localArtifacts));
        modelRequest.setSystemProperties(System.getProperties());
        ModelBuildingResult resultPhase1 = modelBuilder.build(modelRequest);
        DependencyManagement dependencyManagement = resultPhase1.getEffectiveModel().getDependencyManagement();
        for (Dependency dependency : dependencyManagement.getDependencies()) {
            if (!"import".equals(dependency.getScope())) continue;
            String version = localArtifacts.getOrDefault(dependency.getGroupId() + ":" + dependency.getArtifactId(), dependency.getVersion());
            dependency.setVersion(version);
        }
        ModelBuildingResult resultPhase2 = modelBuilder.build(modelRequest, resultPhase1);
        return resultPhase2.getEffectiveModel();
    }

    @VisibleForTesting
    static Bom copyWithSnapshot(RepositorySystem repositorySystem, RepositorySystemSession session, Bom bom, Map<String, String> localArtifacts) throws ModelBuildingException, ArtifactResolutionException {
        ImmutableList.Builder managedDependencies = ImmutableList.builder();
        Model model = LinkageMonitor.buildModelWithSnapshotBom(repositorySystem, session, bom.getCoordinates(), localArtifacts);
        ArtifactTypeRegistry registry = session.getArtifactTypeRegistry();
        ImmutableList newManagedDependencies = model.getDependencyManagement().getDependencies().stream().map(dependency -> RepositoryUtils.toDependency(dependency, registry)).map(org.eclipse.aether.graph.Dependency::getArtifact).collect(ImmutableList.toImmutableList());
        for (Artifact managedDependency : newManagedDependencies) {
            if (Bom.shouldSkipBomMember(managedDependency)) continue;
            String version = localArtifacts.getOrDefault(managedDependency.getGroupId() + ":" + managedDependency.getArtifactId(), managedDependency.getVersion());
            managedDependencies.add(managedDependency.setVersion(version));
        }
        return new Bom(bom.getCoordinates() + "-SNAPSHOT", (ImmutableList<Artifact>)managedDependencies.build());
    }
}

