/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.dependencies.linkagemonitor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectModelResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

class VersionSubstitutingModelResolver
extends ProjectModelResolver {
    private final ImmutableMap<String, String> versionSubstitution;
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final RepositorySystem resolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final ImmutableList<RemoteRepository> repositories;

    VersionSubstitutingModelResolver(RepositorySystemSession session, RequestTrace trace, RepositorySystem resolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories, Map<String, String> versionSubstitution) {
        super(session, trace, resolver, remoteRepositoryManager, repositories, null, null);
        this.session = session;
        this.trace = trace;
        this.resolver = resolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.repositories = ImmutableList.copyOf(repositories);
        this.versionSubstitution = ImmutableMap.copyOf(versionSubstitution);
    }

    @Override
    public ModelSource2 resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        String versionlessCoordinates = groupId + ":" + artifactId;
        String versionToResolve = this.versionSubstitution.getOrDefault(versionlessCoordinates, version);
        return (ModelSource2)super.resolveModel(groupId, artifactId, versionToResolve);
    }

    @Override
    public ModelResolver newCopy() {
        return new VersionSubstitutingModelResolver(this.session, this.trace, this.resolver, this.remoteRepositoryManager, this.repositories, this.versionSubstitution);
    }
}

