/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.DependencyConflict;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.classpath.MethodSymbol;
import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import org.eclipse.aether.artifact.Artifact;

final class AbstractMethodProblem
extends LinkageProblem {
    private MethodSymbol methodSymbol;

    AbstractMethodProblem(ClassFile implementationClass, MethodSymbol methodSymbol, ClassFile supertype) {
        super(" does not exist in the implementing class", implementationClass, methodSymbol, supertype);
        this.methodSymbol = methodSymbol;
    }

    @Override
    public final String toString() {
        ClassFile implementationClass = this.getSourceClass();
        ClassPathEntry sourceClassPathEntry = implementationClass.getClassPathEntry();
        ClassFile supertype = this.getTargetClass();
        return String.format("%s (in %s) does not implement %s, required by %s (in %s)", implementationClass.getBinaryName(), sourceClassPathEntry, this.methodSymbol.getMethodNameWithSignature(), supertype.getBinaryName(), supertype.getClassPathEntry());
    }

    @Override
    String describe(DependencyConflict conflict) {
        DependencyPath pathToSelectedArtifact = conflict.getPathToSelectedArtifact();
        Artifact selected = pathToSelectedArtifact.getLeaf();
        String selectedCoordinates = Artifacts.toCoordinates(selected);
        DependencyPath pathToArtifactThruSource = conflict.getPathToArtifactThruSource();
        Artifact unselected = pathToArtifactThruSource.getLeaf();
        String unselectedCoordinates = Artifacts.toCoordinates(unselected);
        ClassFile supertype = this.getTargetClass();
        return "Dependency conflict: " + selectedCoordinates + " defines incompatible version of " + supertype.getBinaryName() + " but " + unselectedCoordinates + " defines compatible one.\n  selected: " + pathToSelectedArtifact + "\n  unselected: " + pathToArtifactThruSource;
    }
}

