/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ClassFile {
    private final ClassPathEntry classPathEntry;
    private final String binaryName;

    @VisibleForTesting
    public ClassFile(ClassPathEntry classPathEntry, String className) {
        this.classPathEntry = Preconditions.checkNotNull(classPathEntry);
        this.binaryName = Preconditions.checkNotNull(className);
    }

    public ClassPathEntry getClassPathEntry() {
        return this.classPathEntry;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    ClassFile topLevelClassFile() {
        return this.binaryName.contains("$") ? new ClassFile(this.classPathEntry, this.binaryName.split("\\$")[0]) : this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassFile that = (ClassFile)other;
        return Objects.equals(this.classPathEntry, that.classPathEntry) && Objects.equals(this.binaryName, that.binaryName);
    }

    public int hashCode() {
        return Objects.hash(this.classPathEntry, this.binaryName);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("location", this.classPathEntry).add("className", this.binaryName).toString();
    }
}

