/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.cloud.tools.opensource.dependencies.Artifacts;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.cloud.tools.opensource.dependencies.UnresolvableArtifactProblem;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import org.eclipse.aether.artifact.Artifact;

public final class ClassPathResult {
    private final ImmutableList<ClassPathEntry> classPath;
    private final ImmutableListMultimap<ClassPathEntry, DependencyPath> dependencyPaths;
    private final ImmutableList<UnresolvableArtifactProblem> artifactProblems;

    public ClassPathResult(ListMultimap<ClassPathEntry, DependencyPath> dependencyPaths, Iterable<UnresolvableArtifactProblem> artifactProblems) {
        this.dependencyPaths = ImmutableListMultimap.copyOf(dependencyPaths);
        this.classPath = ImmutableList.copyOf(dependencyPaths.keySet());
        this.artifactProblems = ImmutableList.copyOf(artifactProblems);
    }

    public ImmutableList<ClassPathEntry> getClassPath() {
        return this.classPath;
    }

    public ImmutableList<DependencyPath> getDependencyPaths(ClassPathEntry entry) {
        return this.dependencyPaths.get((Object)entry);
    }

    public ImmutableList<UnresolvableArtifactProblem> getArtifactProblems() {
        return this.artifactProblems;
    }

    public String formatDependencyPaths(Iterable<ClassPathEntry> entries) {
        StringBuilder message = new StringBuilder();
        for (ClassPathEntry entry : entries) {
            ImmutableList<DependencyPath> dependencyPaths = this.getDependencyPaths(entry);
            Preconditions.checkArgument(dependencyPaths.size() >= 1, "%s is not in the class path", (Object)entry);
            message.append(entry + " is at:\n");
            int otherCount = dependencyPaths.size() - 1;
            message.append("  " + dependencyPaths.get(0) + "\n");
            if (otherCount == 1) {
                message.append("  and 1 dependency path.\n");
                continue;
            }
            if (otherCount <= 1) continue;
            message.append("  and " + otherCount + " other dependency paths.\n");
        }
        return message.toString();
    }

    public ImmutableSet<ClassPathEntry> getClassPathEntries(String coordinates) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassPathEntry entry : this.classPath) {
            for (DependencyPath dependencyPath : this.dependencyPaths.get((Object)entry)) {
                Artifact artifact;
                if (dependencyPath.size() <= 1 || !Artifacts.toCoordinates(artifact = dependencyPath.get(1)).equals(coordinates)) continue;
                builder.add(entry);
            }
        }
        return builder.build();
    }

    ClassPathEntry findEntryById(String groupId, String artifactId) {
        for (ClassPathEntry entry : this.getClassPath()) {
            Artifact artifact = entry.getArtifact();
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return entry;
        }
        return null;
    }

    ClassPathEntry findEntryBySymbol(Symbol symbol) throws IOException {
        String className = symbol.getClassBinaryName();
        for (ClassPathEntry entry : this.getClassPath()) {
            if (!entry.getFileNames().contains(className)) continue;
            return entry;
        }
        return null;
    }
}

