/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.classpath.LinkageProblemCause;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.base.Preconditions;
import java.util.Objects;

final class DependencyConflict
extends LinkageProblemCause {
    private LinkageProblem linkageProblem;
    private DependencyPath pathToArtifactThruSource;
    private DependencyPath pathToSelectedArtifact;

    DependencyConflict(LinkageProblem linkageProblem, DependencyPath pathToSelectedArtifact, DependencyPath pathToArtifactThruSource) {
        this.linkageProblem = Preconditions.checkNotNull(linkageProblem);
        this.pathToArtifactThruSource = Preconditions.checkNotNull(pathToArtifactThruSource);
        this.pathToSelectedArtifact = Preconditions.checkNotNull(pathToSelectedArtifact);
    }

    public DependencyPath getPathToArtifactThruSource() {
        return this.pathToArtifactThruSource;
    }

    public DependencyPath getPathToSelectedArtifact() {
        return this.pathToSelectedArtifact;
    }

    public String toString() {
        return this.linkageProblem.describe(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DependencyConflict that = (DependencyConflict)other;
        return Objects.equals(this.linkageProblem, that.linkageProblem) && Objects.equals(this.pathToArtifactThruSource, that.pathToArtifactThruSource) && Objects.equals(this.pathToSelectedArtifact, that.pathToSelectedArtifact);
    }

    public int hashCode() {
        return Objects.hash(this.linkageProblem, this.pathToArtifactThruSource, this.pathToSelectedArtifact);
    }
}

