/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassMatcher;
import com.google.cloud.tools.opensource.classpath.FieldMatcher;
import com.google.cloud.tools.opensource.classpath.LinkageErrorMatcher;
import com.google.cloud.tools.opensource.classpath.LinkageProblemMatcher;
import com.google.cloud.tools.opensource.classpath.MethodMatcher;
import com.google.cloud.tools.opensource.classpath.PackageMatcher;
import com.google.cloud.tools.opensource.classpath.SourceMatcher;
import com.google.cloud.tools.opensource.classpath.TargetMatcher;
import com.google.common.collect.ImmutableList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ExclusionFileHandler
extends DefaultHandler {
    private ImmutableList.Builder<LinkageErrorMatcher> matchers;
    private LinkageErrorMatcher linkageErrorMatcher;
    private LinkageProblemMatcher linkageProblemMatcher;

    ExclusionFileHandler() {
    }

    ImmutableList<LinkageErrorMatcher> getMatchers() {
        return this.matchers.build();
    }

    @Override
    public void startDocument() {
        if (this.matchers != null) {
            throw new IllegalStateException("This handler started reading document already");
        }
        this.matchers = ImmutableList.builder();
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (!namespaceUri.isEmpty()) {
            throw new SAXException("unrecognized element: " + qualifiedName + " in namespace " + namespaceUri);
        }
        switch (localName) {
            case "LinkageCheckerFilter": {
                break;
            }
            case "LinkageError": {
                this.linkageErrorMatcher = new LinkageErrorMatcher();
                this.matchers.add((Object)this.linkageErrorMatcher);
                break;
            }
            case "Source": {
                SourceMatcher sourceMatcher = new SourceMatcher();
                this.linkageErrorMatcher.setSourceMatcher(sourceMatcher);
                this.linkageProblemMatcher = sourceMatcher;
                break;
            }
            case "Target": {
                TargetMatcher targetMatcher = new TargetMatcher();
                this.linkageErrorMatcher.setTargetMatcher(targetMatcher);
                this.linkageProblemMatcher = targetMatcher;
                break;
            }
            case "Package": {
                this.linkageProblemMatcher.addChild(new PackageMatcher(attributes.getValue("name")));
                break;
            }
            case "Class": {
                String classNameOnClass = attributes.getValue("name");
                this.linkageProblemMatcher.addChild(new ClassMatcher(classNameOnClass));
                break;
            }
            case "Method": {
                String classNameOnMethod = attributes.getValue("className");
                MethodMatcher methodMatcher = new MethodMatcher(classNameOnMethod, attributes.getValue("name"));
                this.linkageProblemMatcher.addChild(methodMatcher);
                break;
            }
            case "Field": {
                String classNameOnField = attributes.getValue("className");
                FieldMatcher fieldMatcher = new FieldMatcher(classNameOnField, attributes.getValue("name"));
                this.linkageProblemMatcher.addChild(fieldMatcher);
                break;
            }
        }
    }
}

