/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.Symbol;
import com.google.common.base.Preconditions;
import java.util.Objects;

final class FieldSymbol
extends Symbol {
    private final String name;
    private final String descriptor;

    FieldSymbol(String className, String name, String descriptor) {
        super(className);
        this.name = Preconditions.checkNotNull(name);
        this.descriptor = Preconditions.checkNotNull(descriptor);
    }

    String getName() {
        return this.name;
    }

    String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FieldSymbol that = (FieldSymbol)other;
        return this.name.equals(that.name) && this.descriptor.equals(that.descriptor) && this.getClassBinaryName().equals(that.getClassBinaryName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClassBinaryName(), this.name, this.descriptor);
    }

    @Override
    public String toString() {
        return this.getClassBinaryName() + "'s field " + this.name;
    }
}

