/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.AccessModifier;
import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassSymbol;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import javax.annotation.Nullable;

final class InaccessibleClassProblem
extends LinkageProblem {
    private AccessModifier modifier;

    InaccessibleClassProblem(ClassFile sourceClass, @Nullable ClassFile targetClass, ClassSymbol classSymbol, AccessModifier modifier) {
        super("is not accessible", sourceClass, classSymbol, targetClass);
        this.modifier = modifier;
    }

    @Override
    public final String toString() {
        StringBuilder message = new StringBuilder();
        message.append("Class " + this.getSymbol().getClassBinaryName());
        switch (this.modifier) {
            case PUBLIC: {
                message.append(" is public");
                break;
            }
            case PRIVATE: {
                message.append(" is private");
                break;
            }
            case PROTECTED: {
                message.append(" is protected");
                break;
            }
            case DEFAULT: {
                message.append(" has default access");
            }
        }
        message.append(" and is referenced by " + this.getSourceClass().getBinaryName());
        if (this.modifier == AccessModifier.DEFAULT) {
            message.append(" (different package)");
        }
        return message.toString();
    }

    @Override
    public String formatSymbolProblem() {
        String result = this.modifier.describe(this.getSymbol().toString());
        ClassFile targetClass = this.getTargetClass();
        if (targetClass != null) {
            String jarInfo = "(" + targetClass.getClassPathEntry() + ") ";
            result = jarInfo + result;
        }
        return result;
    }

    @Override
    protected String formatSymbolProblemWithReferenceCount(int referenceCount) {
        if (this.modifier == AccessModifier.DEFAULT) {
            return String.format("%s;\n  referenced by %d class file%s in a different package\n", this.formatSymbolProblem(), referenceCount, referenceCount > 1 ? "s" : "");
        }
        return super.formatSymbolProblemWithReferenceCount(referenceCount);
    }
}

