/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.bcel.util.ClassPath;

public class LinkageCheckClassPath
extends ClassPath {
    private final ClassLoader extensionClassLoader = ClassLoader.getSystemClassLoader().getParent();

    LinkageCheckClassPath(List<ClassPathEntry> entries) {
        super(entries.stream().map(ClassPathEntry::getJar).map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
    }

    @Override
    public InputStream getInputStream(String name, String suffix) throws IOException {
        InputStream inputStream = this.extensionClassLoader.getResourceAsStream(name + suffix);
        if (inputStream != null) {
            return inputStream;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }
}

