/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.ClassReferenceGraph;
import com.google.cloud.tools.opensource.classpath.ExclusionFiles;
import com.google.cloud.tools.opensource.classpath.LinkageCheckResultException;
import com.google.cloud.tools.opensource.classpath.LinkageChecker;
import com.google.cloud.tools.opensource.classpath.LinkageCheckerArguments;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.classpath.LinkageProblemCauseAnnotator;
import com.google.cloud.tools.opensource.dependencies.ArtifactProblem;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.UnresolvableArtifactProblem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.ParseException;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;

class LinkageCheckerMain {
    LinkageCheckerMain() {
    }

    public static void main(String[] arguments) throws IOException, RepositoryException, TransformerException, XMLStreamException, LinkageCheckResultException {
        try {
            LinkageCheckerArguments linkageCheckerArguments = LinkageCheckerArguments.readCommandLine(arguments);
            if (linkageCheckerArguments.needsHelp() || arguments.length == 0) {
                linkageCheckerArguments.printHelp();
            }
            if (linkageCheckerArguments.hasInput()) {
                ImmutableList<Artifact> artifacts = linkageCheckerArguments.getArtifacts();
                Problems problems = artifacts.isEmpty() ? LinkageCheckerMain.checkJarFiles(linkageCheckerArguments) : LinkageCheckerMain.checkArtifacts(linkageCheckerArguments);
                Path outputExclusionFile = linkageCheckerArguments.getOutputExclusionFile();
                if (!problems.linkageProblems.isEmpty()) {
                    if (outputExclusionFile == null) {
                        problems.print();
                        throw new LinkageCheckResultException(problems.linkageProblems.size());
                    }
                    problems.writeExclusionFile(outputExclusionFile);
                }
            }
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private static Problems checkJarFiles(LinkageCheckerArguments linkageCheckerArguments) throws IOException, TransformerException, XMLStreamException {
        ImmutableList<ClassPathEntry> inputClassPath = linkageCheckerArguments.getJarFiles();
        ImmutableSet<ClassPathEntry> entryPoints = ImmutableSet.copyOf(inputClassPath);
        LinkageChecker linkageChecker = LinkageChecker.create(inputClassPath, entryPoints, linkageCheckerArguments.getInputExclusionFile());
        ImmutableSet<LinkageProblem> linkageProblems = LinkageCheckerMain.findLinkageProblems(linkageChecker, linkageCheckerArguments.getReportOnlyReachable());
        return new Problems(linkageProblems);
    }

    private static Problems checkArtifacts(LinkageCheckerArguments linkageCheckerArguments) throws IOException, RepositoryException, TransformerException, XMLStreamException {
        ImmutableList<Artifact> artifacts = linkageCheckerArguments.getArtifacts();
        DependencyGraphBuilder dependencyGraphBuilder = new DependencyGraphBuilder(linkageCheckerArguments.getMavenRepositoryUrls());
        ClassPathBuilder classPathBuilder = new ClassPathBuilder(dependencyGraphBuilder);
        ClassPathResult classPathResult = classPathBuilder.resolve(artifacts, false);
        ImmutableList<ClassPathEntry> inputClassPath = classPathResult.getClassPath();
        ImmutableList<UnresolvableArtifactProblem> artifactProblems = ImmutableList.copyOf(classPathResult.getArtifactProblems());
        ImmutableSet<ClassPathEntry> entryPoints = ImmutableSet.copyOf(inputClassPath.subList(0, artifacts.size()));
        LinkageChecker linkageChecker = LinkageChecker.create(inputClassPath, entryPoints, linkageCheckerArguments.getInputExclusionFile());
        ImmutableSet<LinkageProblem> linkageProblems = LinkageCheckerMain.findLinkageProblems(linkageChecker, linkageCheckerArguments.getReportOnlyReachable());
        LinkageProblemCauseAnnotator.annotate(classPathBuilder, classPathResult, linkageProblems);
        return new Problems(linkageProblems, artifactProblems, classPathResult);
    }

    private static ImmutableSet<LinkageProblem> findLinkageProblems(LinkageChecker linkageChecker, boolean reportOnlyReachable) throws IOException, TransformerException, XMLStreamException {
        ImmutableSet<LinkageProblem> linkageProblems = linkageChecker.findLinkageProblems();
        if (reportOnlyReachable) {
            ClassReferenceGraph graph = linkageChecker.getClassReferenceGraph();
            linkageProblems = linkageProblems.stream().filter(problem -> graph.isReachable(problem.getSourceClass().getBinaryName())).collect(ImmutableSet.toImmutableSet());
        }
        return linkageProblems;
    }

    private static final class Problems {
        private final ImmutableList<ArtifactProblem> artifactProblems;
        private final ImmutableSet<LinkageProblem> linkageProblems;
        private final ClassPathResult classPathResult;

        private Problems(ImmutableSet<LinkageProblem> linkageProblems, ImmutableList<ArtifactProblem> artifactProblems, ClassPathResult classPathResult) {
            this.artifactProblems = artifactProblems;
            this.linkageProblems = linkageProblems;
            this.classPathResult = classPathResult;
        }

        private Problems(ImmutableSet<LinkageProblem> linkageProblems) {
            this.linkageProblems = linkageProblems;
            this.artifactProblems = ImmutableList.of();
            this.classPathResult = null;
        }

        void print() {
            System.out.println(LinkageProblem.formatLinkageProblems(this.linkageProblems, this.classPathResult));
            if (!this.artifactProblems.isEmpty()) {
                System.out.println("\n");
                System.out.println(ArtifactProblem.formatProblems(this.artifactProblems));
            }
            System.out.println("For the details of the linkage errors, see https://github.com/GoogleCloudPlatform/cloud-opensource-java/wiki/Linkage-Checker-Messages");
        }

        void writeExclusionFile(Path path) throws IOException, XMLStreamException, TransformerException {
            ExclusionFiles.write(path, this.linkageProblems);
            System.out.println("Wrote the linkage errors as exclusion file: " + path);
        }
    }
}

