/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.classpath;

import com.google.cloud.tools.opensource.classpath.LinkageProblemCause;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

class MissingDependency
extends LinkageProblemCause {
    protected DependencyPath pathToMissingArtifact;

    MissingDependency(DependencyPath pathToMissingArtifact) {
        this.pathToMissingArtifact = Preconditions.checkNotNull(pathToMissingArtifact);
    }

    DependencyPath getPathToMissingArtifact() {
        return this.pathToMissingArtifact;
    }

    public String toString() {
        String missingReason = "";
        for (int i = 0; i < this.pathToMissingArtifact.size() - 1; ++i) {
            Dependency dependency = this.pathToMissingArtifact.getDependency(i);
            if (dependency.isOptional()) {
                missingReason = " because the path contains an optional dependency";
                break;
            }
            if (!"provided".equals(dependency.getScope())) continue;
            missingReason = " because the path contains a provided-scope dependency";
            break;
        }
        Artifact artifactContainingValidSymbol = this.pathToMissingArtifact.getLeaf();
        return "The valid symbol is in " + artifactContainingValidSymbol + " at " + this.pathToMissingArtifact + " but it was not selected" + missingReason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MissingDependency that = (MissingDependency)other;
        return Objects.equals(this.pathToMissingArtifact, that.pathToMissingArtifact);
    }

    public int hashCode() {
        return Objects.hash(this.pathToMissingArtifact);
    }
}

