/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DependencyNode;

final class CycleBreakerGraphTransformer
implements DependencyGraphTransformer {
    private final Set<DependencyNode> visitedNodes = Collections.newSetFromMap(new IdentityHashMap());

    CycleBreakerGraphTransformer() {
    }

    @Override
    public DependencyNode transformGraph(DependencyNode dependencyNode, DependencyGraphTransformationContext context) throws RepositoryException {
        this.removeCycle(null, dependencyNode, new HashSet<Artifact>());
        return dependencyNode;
    }

    private void removeCycle(DependencyNode parent, DependencyNode node, Set<Artifact> ancestors) {
        Artifact artifact = node.getArtifact();
        if (ancestors.contains(artifact)) {
            CycleBreakerGraphTransformer.removeChildFromParent(node, parent);
            return;
        }
        if (this.shouldVisitChildren(node)) {
            ancestors.add(artifact);
            for (DependencyNode child : node.getChildren()) {
                this.removeCycle(node, child, ancestors);
            }
            ancestors.remove(artifact);
        }
    }

    @VisibleForTesting
    boolean shouldVisitChildren(DependencyNode node) {
        return this.visitedNodes.add(node);
    }

    private static void removeChildFromParent(DependencyNode child, DependencyNode parent) {
        ImmutableList<DependencyNode> children = parent.getChildren().stream().filter(node -> node != child).collect(ImmutableList.toImmutableList());
        parent.setChildren(children);
    }
}

