/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;

public class DependencyTreeFormatter {
    static String formatDependencyPaths(List<DependencyPath> dependencyPaths) {
        DependencyPath firstPath = dependencyPaths.get(0);
        Artifact rootArtifact = firstPath.get(0);
        Preconditions.checkArgument(dependencyPaths.stream().allMatch(path -> Objects.equals(path.get(0), rootArtifact)), "all dependency paths should have the same root");
        StringBuilder stringBuilder = new StringBuilder();
        ListMultimap<DependencyPath, DependencyPath> tree = DependencyTreeFormatter.buildDependencyPathTree(dependencyPaths);
        DependencyTreeFormatter.formatDependencyPathTree(stringBuilder, tree, new DependencyPath(rootArtifact), 1);
        return stringBuilder.toString();
    }

    private static void formatDependencyPathTree(StringBuilder stringBuilder, ListMultimap<DependencyPath, DependencyPath> tree, DependencyPath currentNode, int depth) {
        Artifact leaf = currentNode.getLeaf();
        if (leaf != null) {
            stringBuilder.append(Strings.repeat("  ", depth));
            stringBuilder.append(leaf);
            stringBuilder.append("\n");
            ++depth;
        }
        for (DependencyPath childPath : tree.get((Object)currentNode)) {
            if (currentNode.equals(childPath)) continue;
            DependencyTreeFormatter.formatDependencyPathTree(stringBuilder, tree, childPath, depth);
        }
    }

    public static ListMultimap<DependencyPath, DependencyPath> buildDependencyPathTree(Collection<DependencyPath> dependencyPaths) {
        LinkedListMultimap<DependencyPath, DependencyPath> tree = LinkedListMultimap.create();
        for (DependencyPath dependencyPath : dependencyPaths) {
            DependencyPath parentDependencyPath = dependencyPath.getParentPath();
            tree.put(parentDependencyPath, dependencyPath);
        }
        return tree;
    }
}

