/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.DependencyTreeFormatter;
import com.google.cloud.tools.opensource.dependencies.UnresolvableArtifactProblem;
import com.google.common.collect.ImmutableList;
import org.eclipse.aether.artifact.DefaultArtifact;

class DependencyTreePrinter {
    DependencyTreePrinter() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Maven coordinates not provided. E.g., 'io.grpc:grpc-auth:1.19.0'");
            return;
        }
        for (String coordinates : args) {
            DependencyTreePrinter.printDependencyTree(coordinates);
        }
    }

    private static void printDependencyTree(String coordinates) {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        DependencyGraphBuilder dependencyGraphBuilder = new DependencyGraphBuilder();
        DependencyGraph dependencyGraph = dependencyGraphBuilder.buildFullDependencyGraph(ImmutableList.of(rootArtifact));
        for (UnresolvableArtifactProblem problem : dependencyGraph.getUnresolvedArtifacts()) {
            System.out.println(problem);
        }
        System.out.println("Dependencies for " + coordinates);
        System.out.println(DependencyTreeFormatter.formatDependencyPaths(dependencyGraph.list()));
    }
}

