/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.dependencies.DependencyGraph;
import com.google.cloud.tools.opensource.dependencies.DependencyGraphBuilder;
import com.google.cloud.tools.opensource.dependencies.DependencyPath;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;

class DirectReport {
    DirectReport() {
    }

    public static void main(String[] args) {
        if (args.length != 1 || !args[0].contains(":")) {
            System.err.println("Usage: java " + DirectReport.class.getCanonicalName() + " groupdId:artifactId:version");
            return;
        }
        System.out.println("Dependencies of " + args[0] + ":");
        System.out.println();
        DefaultArtifact input = new DefaultArtifact(args[0]);
        DependencyGraphBuilder dependencyGraphBuilder = new DependencyGraphBuilder();
        DependencyGraph dependencyGraph = dependencyGraphBuilder.buildMavenDependencyGraph(new Dependency(input, ""));
        for (DependencyPath dependencyPath : dependencyGraph.list()) {
            if (dependencyPath.size() != 2) continue;
            Artifact artifact = dependencyPath.getLeaf();
            System.out.println("  <dependency>");
            System.out.println("    <groupId>" + artifact.getGroupId() + "</groupId>");
            System.out.println("    <artifactId>" + artifact.getArtifactId() + "</artifactId>");
            System.out.println("    <version>" + artifact.getVersion() + "</version>");
            System.out.println("  </dependency>");
        }
    }
}

