/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.cloud.tools.opensource.classpath.ClassFile;
import com.google.cloud.tools.opensource.classpath.ClassPathBuilder;
import com.google.cloud.tools.opensource.classpath.ClassPathEntry;
import com.google.cloud.tools.opensource.classpath.ClassPathResult;
import com.google.cloud.tools.opensource.classpath.LinkageChecker;
import com.google.cloud.tools.opensource.classpath.LinkageProblem;
import com.google.cloud.tools.opensource.dependencies.Bom;
import com.google.cloud.tools.opensource.dependencies.MavenRepositoryException;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.eclipse.aether.artifact.Artifact;

public class Java8IncompatibleReferenceCheck {
    private static final Logger logger = Logger.getLogger(Java8IncompatibleReferenceCheck.class.getName());

    public static void main(String[] arguments) throws MavenRepositoryException, IOException {
        if (arguments.length < 1) {
            System.err.println("Specify a path to the BOM file");
            System.exit(1);
        }
        String bomFileName = arguments[0];
        Path bomFile = Paths.get(bomFileName, new String[0]);
        Bom bom = Bom.readBom(bomFile);
        ImmutableList<Artifact> managedDependencies = bom.getManagedDependencies();
        int count = 1;
        ImmutableSetMultimap.Builder problematicDependencies = ImmutableSetMultimap.builder();
        for (Artifact managedDependency : managedDependencies) {
            logger.info("Checking " + managedDependency + " (" + count++ + "/" + managedDependencies.size() + ")");
            ClassPathBuilder classPathBuilder = new ClassPathBuilder();
            ClassPathResult result = classPathBuilder.resolve(ImmutableList.of(managedDependency), false);
            LinkageChecker linkageChecker = LinkageChecker.create(result.getClassPath());
            ImmutableSet<LinkageProblem> linkageProblems = linkageChecker.findLinkageProblems();
            ImmutableSet<LinkageProblem> invalidReferencesToJavaCoreLibrary = linkageProblems.stream().filter(problem -> problem.getSymbol().getClassBinaryName().startsWith("java.")).collect(ImmutableSet.toImmutableSet());
            if (invalidReferencesToJavaCoreLibrary.isEmpty()) continue;
            invalidReferencesToJavaCoreLibrary.stream().map(LinkageProblem::getSourceClass).map(ClassFile::getClassPathEntry).map(ClassPathEntry::getArtifact).forEach(artifact -> problematicDependencies.put(managedDependency, artifact));
            logger.severe(LinkageProblem.formatLinkageProblems(invalidReferencesToJavaCoreLibrary, null));
        }
        ImmutableMultimap bomMemberToProblematicDependencies = problematicDependencies.build();
        if (bomMemberToProblematicDependencies.isEmpty()) {
            logger.info("No problematic artifacts");
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("The following artifacts contain references to classes in the core library, which are not present in Java 8\n");
        for (Artifact artifact2 : ((ImmutableSetMultimap)bomMemberToProblematicDependencies).inverse().keySet()) {
            message.append("  " + artifact2 + "\n");
        }
        message.append("The following artifacts in the BOM contain the artifacts in their dependencies\n");
        for (Artifact bomMember : bomMemberToProblematicDependencies.keySet()) {
            ImmutableCollection dependencies = ((ImmutableSetMultimap)bomMemberToProblematicDependencies).get(bomMember);
            message.append("  " + bomMember + " due to " + dependencies + "\n");
        }
        logger.severe(message.toString());
        System.exit(1);
    }
}

