/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.opensource.dependencies;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;

public class OsProperties {
    private static final CharMatcher LOWER_ALPHA_NUMERIC = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('0', '9'));

    public static ImmutableMap<String, String> detectOsProperties() {
        return ImmutableMap.of("os.detected.name", OsProperties.osDetectedName(), "os.detected.arch", OsProperties.osDetectedArch(), "os.detected.classifier", OsProperties.osDetectedName() + "-" + OsProperties.osDetectedArch());
    }

    private static String osDetectedName() {
        String osNameNormalized = LOWER_ALPHA_NUMERIC.retainFrom(System.getProperty("os.name").toLowerCase(Locale.ENGLISH));
        if (osNameNormalized.startsWith("macosx") || osNameNormalized.startsWith("osx")) {
            return "osx";
        }
        if (osNameNormalized.startsWith("windows")) {
            return "windows";
        }
        return "linux";
    }

    private static String osDetectedArch() {
        String osArchNormalized;
        switch (osArchNormalized = LOWER_ALPHA_NUMERIC.retainFrom(System.getProperty("os.arch").toLowerCase(Locale.ENGLISH))) {
            case "x8664": 
            case "amd64": 
            case "ia32e": 
            case "em64t": 
            case "x64": {
                return "x86_64";
            }
        }
        return "x86_32";
    }
}

